/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.analyst.spatialstatistics;

import com.supermap.analyst.spatialstatistics.BShadeEstimateMethod;
import com.supermap.analyst.spatialstatistics.BShadeSampleNumberMethod;
import com.supermap.analyst.spatialstatistics.InternalResource;

public class BShadeSamplingParameter {
    private BShadeSampleNumberMethod m_SampleNumberMethod;
    private BShadeEstimateMethod m_EstimateMethod;
    private int m_nSelectSampleNum;
    private int m_nSelectSampleRangeL;
    private int m_nSelectSampleRangeU;
    private int m_nSelectSampleRangeStep;
    private double m_dInitT;
    private double m_dMinT;
    private double m_dMinE;
    private double m_dCoolRate;
    private int m_nMaxConsRej;
    private int m_nMaxTry;
    private int m_nMaxSuccess;
    private int m_nMaxFullCombn;

    public BShadeSamplingParameter() {
        this.m_SampleNumberMethod = BShadeSampleNumberMethod.FIXED;
        this.m_EstimateMethod = BShadeEstimateMethod.TOTAL;
        this.m_nSelectSampleNum = 5;
        this.m_nSelectSampleRangeL = 3;
        this.m_nSelectSampleRangeU = 5;
        this.m_nSelectSampleRangeStep = 2;
        this.m_dInitT = 1.0;
        this.m_dMinT = 1.0E-8;
        this.m_dMinE = -1.0E38;
        this.m_dCoolRate = 0.9;
        this.m_nMaxConsRej = 1000;
        this.m_nMaxTry = 300;
        this.m_nMaxSuccess = 20;
        this.m_nMaxFullCombn = 50000;
    }

    public BShadeSamplingParameter(BShadeSamplingParameter para) {
        this.m_SampleNumberMethod = para.m_SampleNumberMethod;
        this.m_EstimateMethod = para.m_EstimateMethod;
        this.m_nSelectSampleNum = para.m_nSelectSampleNum;
        this.m_nSelectSampleRangeL = para.m_nSelectSampleRangeL;
        this.m_nSelectSampleRangeU = para.m_nSelectSampleRangeU;
        this.m_nSelectSampleRangeStep = para.m_nSelectSampleRangeStep;
        this.m_dInitT = para.m_dInitT;
        this.m_dMinT = para.m_dMinT;
        this.m_dMinE = para.m_dMinE;
        this.m_dCoolRate = para.m_dCoolRate;
        this.m_nMaxConsRej = para.m_nMaxConsRej;
        this.m_nMaxTry = para.m_nMaxTry;
        this.m_nMaxSuccess = para.m_nMaxSuccess;
        this.m_nMaxFullCombn = para.m_nMaxFullCombn;
    }

    public BShadeSampleNumberMethod getBShadeSampleNumberMethod() {
        return this.m_SampleNumberMethod;
    }

    public void setBShadeSampleNumberMethod(BShadeSampleNumberMethod value) {
        this.m_SampleNumberMethod = value;
    }

    public BShadeEstimateMethod getBShadeEstimateMethod() {
        return this.m_EstimateMethod;
    }

    public void setBShadeEstimateMethod(BShadeEstimateMethod value) {
        this.m_EstimateMethod = value;
    }

    public int getSelectSampleNumber() {
        return this.m_nSelectSampleNum;
    }

    public void setSelectSampleNumber(int value) {
        if (value < 1) {
            String string = InternalResource.loadString("SelectSampleNumber", "Global_ShouldGreaterThanZero", "spatialstatistics_resources");
            throw new IllegalArgumentException(string);
        }
        this.m_nSelectSampleNum = value;
    }

    public int getSelectSampleRangeL() {
        return this.m_nSelectSampleRangeL;
    }

    public void setSelectSampleRangeL(int value) {
        if (value < 1) {
            String string = InternalResource.loadString("SelectSampleRangeL", "Global_ShouldGreaterThanZero", "spatialstatistics_resources");
            throw new IllegalArgumentException(string);
        }
        this.m_nSelectSampleRangeL = value;
    }

    public int getSelectSampleRangeU() {
        return this.m_nSelectSampleRangeU;
    }

    public void setSelectSampleRangeU(int value) {
        if (value < 1) {
            String string = InternalResource.loadString("SelectSampleRangeU", "Global_ShouldGreaterThanZero", "spatialstatistics_resources");
            throw new IllegalArgumentException(string);
        }
        this.m_nSelectSampleRangeU = value;
    }

    public int getSelectSampleRangeStep() {
        return this.m_nSelectSampleRangeStep;
    }

    public void setSelectSampleRangeStep(int value) {
        if (value < 1) {
            String string = InternalResource.loadString("SelectSampleRangeStep", "Global_ShouldGreaterThanZero", "spatialstatistics_resources");
            throw new IllegalArgumentException(string);
        }
        this.m_nSelectSampleRangeStep = value;
    }

    public double getInitialTemperature() {
        return this.m_dInitT;
    }

    public void setInitialTemperature(double value) {
        if (value <= 0.0) {
            String string = InternalResource.loadString("InitialTemperature", "Global_ShouldGreaterThanZero", "spatialstatistics_resources");
            throw new IllegalArgumentException(string);
        }
        this.m_dInitT = value;
    }

    public double getMinTemperature() {
        return this.m_dMinT;
    }

    public void setMinTemperature(double value) {
        if (value <= 0.0) {
            String string = InternalResource.loadString("MinTemperature", "Global_ShouldGreaterThanZero", "spatialstatistics_resources");
            throw new IllegalArgumentException(string);
        }
        this.m_dMinT = value;
    }

    public double getMinEnergy() {
        return this.m_dMinE;
    }

    public void setMinEnergy(double value) {
        this.m_dMinE = value;
    }

    public double getCoolRate() {
        return this.m_dCoolRate;
    }

    public void setCoolRate(double value) {
        if (value > 1.0 || value < 0.0) {
            String string = InternalResource.loadString("CoolRate", "ShouldBetweenZeroAndOne", "spatialstatistics_resources");
            throw new IllegalArgumentException(string);
        }
        this.m_dCoolRate = value;
    }

    public int getMaxConsecutiveRejection() {
        return this.m_nMaxConsRej;
    }

    public void setMaxConsecutiveRejection(int value) {
        if (value < 1) {
            String string = InternalResource.loadString("", "Global_ShouldGreaterThanZero", "spatialstatistics_resources");
            throw new IllegalArgumentException(string);
        }
        this.m_nMaxConsRej = value;
    }

    public int getMaxTry() {
        return this.m_nMaxTry;
    }

    public void setMaxTry(int value) {
        if (value < 1) {
            String string = InternalResource.loadString("MaxTry", "Global_ShouldGreaterThanZero", "spatialstatistics_resources");
            throw new IllegalArgumentException(string);
        }
        this.m_nMaxTry = value;
    }

    public int getMaxSuccess() {
        return this.m_nMaxSuccess;
    }

    public void setMaxSuccess(int value) {
        if (value < 1) {
            String string = InternalResource.loadString("MaxSuccess", "Global_ShouldGreaterThanZero", "spatialstatistics_resources");
            throw new IllegalArgumentException(string);
        }
        this.m_nMaxSuccess = value;
    }

    public int getMaxFullCombination() {
        return this.m_nMaxFullCombn;
    }

    public void setMaxFullCombination(int value) {
        if (value < 1) {
            String string = InternalResource.loadString("MaxFullCombination", "Global_ShouldGreaterThanZero", "spatialstatistics_resources");
            throw new IllegalArgumentException(string);
        }
        this.m_nMaxFullCombn = value;
    }
}

