/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.analyst.spatialanalyst;

import com.supermap.License;
import com.supermap.ProductType;
import com.supermap.analyst.spatialanalyst.CalculationTerrainNative;
import com.supermap.analyst.spatialanalyst.CutFillResult;
import com.supermap.analyst.spatialanalyst.ExtremumInfo;
import com.supermap.analyst.spatialanalyst.InternalDatasetGrid;
import com.supermap.analyst.spatialanalyst.InternalDatasetImage;
import com.supermap.analyst.spatialanalyst.InternalDatasets;
import com.supermap.analyst.spatialanalyst.InternalEnum;
import com.supermap.analyst.spatialanalyst.InternalGeometry;
import com.supermap.analyst.spatialanalyst.InternalHandle;
import com.supermap.analyst.spatialanalyst.InternalHandleDisposable;
import com.supermap.analyst.spatialanalyst.InternalResource;
import com.supermap.analyst.spatialanalyst.InternalToolkitSpatialAnalyst;
import com.supermap.analyst.spatialanalyst.ProfileResult;
import com.supermap.analyst.spatialanalyst.ShadowMode;
import com.supermap.analyst.spatialanalyst.SlopeType;
import com.supermap.analyst.spatialanalyst.TerrainAnalystSetting;
import com.supermap.data.ColorDictionary;
import com.supermap.data.Colors;
import com.supermap.data.Dataset;
import com.supermap.data.DatasetGrid;
import com.supermap.data.DatasetImage;
import com.supermap.data.Datasource;
import com.supermap.data.GeoLine;
import com.supermap.data.GeoLine3D;
import com.supermap.data.GeoRegion;
import com.supermap.data.GeoRegion3D;
import com.supermap.data.Geometry;
import com.supermap.data.Point2D;
import com.supermap.data.Point2Ds;
import com.supermap.data.SteppedEvent;
import com.supermap.data.SteppedListener;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Vector;

public class CalculationTerrain {
    private static License m_license;
    private static transient Vector m_steppedListeners;
    private static TerrainAnalystSetting m_terrainAnalystSetting;

    private CalculationTerrain() {
        m_terrainAnalystSetting = null;
    }

    public static TerrainAnalystSetting getAnalystSetting() {
        return m_terrainAnalystSetting;
    }

    public static void setAnalystSetting(TerrainAnalystSetting terrainAnalystSetting) {
        if (terrainAnalystSetting == null) {
            m_terrainAnalystSetting = null;
            return;
        }
        if (m_terrainAnalystSetting == null) {
            m_terrainAnalystSetting = new TerrainAnalystSetting();
        }
        m_terrainAnalystSetting.setBounds(terrainAnalystSetting.getBounds());
        m_terrainAnalystSetting.setBoundsType(terrainAnalystSetting.getBoundsType());
        m_terrainAnalystSetting.setCellSizeType(terrainAnalystSetting.getCellSizeType());
        m_terrainAnalystSetting.setCellSize(terrainAnalystSetting.getCellSize());
        m_terrainAnalystSetting.setOutputDatasource(terrainAnalystSetting.getOutputDatasource());
        m_terrainAnalystSetting.setGridOutputNamePrefix(terrainAnalystSetting.getGridOutputNamePrefix());
        m_terrainAnalystSetting.setVectorOutputNamePrefix(terrainAnalystSetting.getVectorOutputNamePrefix());
        m_terrainAnalystSetting.setValidRegion(terrainAnalystSetting.getValidRegion());
        m_terrainAnalystSetting.setShowProgress(terrainAnalystSetting.isShowProgress());
    }

    public static DatasetGrid calculateSlope(DatasetGrid sourceDatasetGrid, SlopeType slopeType, double zFactor, Datasource targetDatasource, String targetDatasetName) {
        CalculationTerrain.verifyLicense();
        if (sourceDatasetGrid == null || InternalHandle.getHandle((com.supermap.data.InternalHandle)sourceDatasetGrid) == 0L) {
            String string = InternalResource.loadString("sourceDatasetGrid", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new NullPointerException(string);
        }
        if (targetDatasource == null || InternalHandle.getHandle((com.supermap.data.InternalHandle)targetDatasource) == 0L) {
            targetDatasource = m_terrainAnalystSetting != null && m_terrainAnalystSetting.getOutputDatasource() != null ? m_terrainAnalystSetting.getOutputDatasource() : sourceDatasetGrid.getDatasource();
        }
        if (InternalHandle.getHandle((com.supermap.data.InternalHandle)targetDatasource) == 0L) {
            String string = InternalResource.loadString("targetDatasource", "Global_ArgumentObjectHasBeenDisposed", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        if (null == targetDatasetName) {
            String string = InternalResource.loadString("targetDatasetName", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        if (null != m_terrainAnalystSetting && null != m_terrainAnalystSetting.getGridOutputNamePrefix()) {
            targetDatasetName = m_terrainAnalystSetting.getGridOutputNamePrefix() + targetDatasetName;
        }
        if (!targetDatasource.getDatasets().isAvailableDatasetName(targetDatasetName)) {
            String string = InternalResource.loadString("targetDatasetName", "GlobalDatasetNameInvalid", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        boolean bl = false;
        if (null != m_terrainAnalystSetting) {
            bl = m_terrainAnalystSetting.isShowProgress();
        }
        long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)sourceDatasetGrid);
        long l2 = InternalHandle.getHandle((com.supermap.data.InternalHandle)targetDatasource);
        int n = InternalEnum.getUGCValue(slopeType);
        long l3 = CalculationTerrainNative.jni_CalculateSlope(l, n, zFactor, l2, targetDatasetName, bl);
        DatasetGrid datasetGrid = null;
        if (l3 != 0L) {
            datasetGrid = InternalDatasetGrid.createInstance(l3, targetDatasource);
            InternalDatasets.add(targetDatasource.getDatasets(), (Dataset)datasetGrid);
        }
        return datasetGrid;
    }

    public static DatasetGrid calculateAspect(DatasetGrid sourceDatasetGrid, Datasource targetDatasource, String targetDatasetName) {
        CalculationTerrain.verifyLicense();
        if (sourceDatasetGrid == null || InternalHandle.getHandle((com.supermap.data.InternalHandle)sourceDatasetGrid) == 0L) {
            String string = InternalResource.loadString("sourceDatasetGrid", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new NullPointerException(string);
        }
        if (targetDatasource == null || InternalHandle.getHandle((com.supermap.data.InternalHandle)targetDatasource) == 0L) {
            targetDatasource = m_terrainAnalystSetting != null && m_terrainAnalystSetting.getOutputDatasource() != null ? m_terrainAnalystSetting.getOutputDatasource() : sourceDatasetGrid.getDatasource();
        }
        if (InternalHandle.getHandle((com.supermap.data.InternalHandle)targetDatasource) == 0L) {
            String string = InternalResource.loadString("targetDatasource", "Global_ArgumentObjectHasBeenDisposed", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        if (null == targetDatasetName) {
            String string = InternalResource.loadString("targetDatasetName", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        if (null != m_terrainAnalystSetting && null != m_terrainAnalystSetting.getGridOutputNamePrefix()) {
            targetDatasetName = m_terrainAnalystSetting.getGridOutputNamePrefix() + targetDatasetName;
        }
        if (!targetDatasource.getDatasets().isAvailableDatasetName(targetDatasetName)) {
            String string = InternalResource.loadString("targetDatasetName", "GlobalDatasetNameInvalid", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        boolean bl = false;
        if (null != m_terrainAnalystSetting) {
            bl = m_terrainAnalystSetting.isShowProgress();
        }
        long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)sourceDatasetGrid);
        long l2 = InternalHandle.getHandle((com.supermap.data.InternalHandle)targetDatasource);
        long l3 = CalculationTerrainNative.jni_CalculateAspect(l, l2, targetDatasetName, bl);
        DatasetGrid datasetGrid = null;
        if (l3 != 0L) {
            datasetGrid = InternalDatasetGrid.createInstance(l3, targetDatasource);
            InternalDatasets.add(targetDatasource.getDatasets(), (Dataset)datasetGrid);
        }
        return datasetGrid;
    }

    public static DatasetGrid calculateHillShade(DatasetGrid sourceDatasetGrid, ShadowMode shadowMode, double azimuth, double altitudeAngle, double zFactor, Datasource targetDatasource, String targetDatasetName) {
        CalculationTerrain.verifyLicense();
        if (sourceDatasetGrid == null || InternalHandle.getHandle((com.supermap.data.InternalHandle)sourceDatasetGrid) == 0L) {
            String string = InternalResource.loadString("sourceDatasetGrid", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new NullPointerException(string);
        }
        if (targetDatasource == null || InternalHandle.getHandle((com.supermap.data.InternalHandle)targetDatasource) == 0L) {
            targetDatasource = m_terrainAnalystSetting != null && m_terrainAnalystSetting.getOutputDatasource() != null ? m_terrainAnalystSetting.getOutputDatasource() : sourceDatasetGrid.getDatasource();
        }
        if (InternalHandle.getHandle((com.supermap.data.InternalHandle)targetDatasource) == 0L) {
            String string = InternalResource.loadString("targetDatasource", "Global_ArgumentObjectHasBeenDisposed", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        if (null == targetDatasetName) {
            String string = InternalResource.loadString("targetDatasetName", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        if (null != m_terrainAnalystSetting && null != m_terrainAnalystSetting.getGridOutputNamePrefix()) {
            targetDatasetName = m_terrainAnalystSetting.getGridOutputNamePrefix() + targetDatasetName;
        }
        if (!targetDatasource.getDatasets().isAvailableDatasetName(targetDatasetName)) {
            String string = InternalResource.loadString("targetDatasetName", "GlobalDatasetNameInvalid", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        if (altitudeAngle > 90.0 || altitudeAngle < 0.0) {
            String string = InternalResource.loadString("altitude", "Value Should_Between_0_And_90", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        boolean bl = false;
        if (null != m_terrainAnalystSetting) {
            bl = m_terrainAnalystSetting.isShowProgress();
        }
        long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)sourceDatasetGrid);
        long l2 = InternalHandle.getHandle((com.supermap.data.InternalHandle)targetDatasource);
        int n = InternalEnum.getUGCValue(shadowMode);
        long l3 = CalculationTerrainNative.jni_CalculateHillShade(l, n, azimuth, altitudeAngle, zFactor, l2, targetDatasetName, bl);
        DatasetGrid datasetGrid = null;
        if (l3 != 0L) {
            datasetGrid = InternalDatasetGrid.createInstance(l3, targetDatasource);
            InternalDatasets.add(targetDatasource.getDatasets(), (Dataset)datasetGrid);
        }
        return datasetGrid;
    }

    @Deprecated
    public static DatasetImage calculateOrthoImage(DatasetGrid sourceDatasetGrid, Colors colors, double zFactor, Datasource targetDatasource, String targetDatasetName) {
        CalculationTerrain.verifyLicense();
        Datasource datasource = targetDatasource;
        String string = targetDatasetName;
        if (sourceDatasetGrid == null || InternalHandle.getHandle((com.supermap.data.InternalHandle)sourceDatasetGrid) == 0L) {
            String string2 = InternalResource.loadString("sourceDatasetGrid", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new NullPointerException(string2);
        }
        if (targetDatasource == null || InternalHandle.getHandle((com.supermap.data.InternalHandle)targetDatasource) == 0L) {
            if (m_terrainAnalystSetting == null || m_terrainAnalystSetting.getOutputDatasource() == null) {
                String string3 = InternalResource.loadString("targetDatasource", "Global_ArgumentNull", "spatialanalyst_resources");
                throw new NullPointerException(string3);
            }
            datasource = m_terrainAnalystSetting.getOutputDatasource();
        }
        if (string == null) {
            String string4 = InternalResource.loadString("targetDatasetName", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new NullPointerException(string4);
        }
        if (m_terrainAnalystSetting != null && m_terrainAnalystSetting.getGridOutputNamePrefix() != null) {
            string = m_terrainAnalystSetting.getGridOutputNamePrefix() + string;
        }
        if (!datasource.getDatasets().isAvailableDatasetName(string)) {
            String string5 = InternalResource.loadString("targetDatasetName", "GlobalDatasetNameInvalide", "spatialanalyst_resources");
            throw new IllegalArgumentException(string5);
        }
        long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)sourceDatasetGrid);
        long l2 = InternalHandle.getHandle((com.supermap.data.InternalHandle)colors);
        long l3 = InternalHandle.getHandle((com.supermap.data.InternalHandle)datasource);
        long l4 = CalculationTerrainNative.jni_CalculateOrthoImage(l, l2, 0L, l3, string, false);
        DatasetImage datasetImage = null;
        if (l4 != 0L) {
            datasetImage = InternalDatasetImage.createInstance(l4, datasource);
            InternalDatasets.add(datasource.getDatasets(), (Dataset)datasetImage);
        }
        return datasetImage;
    }

    @Deprecated
    public static DatasetImage calculateOrthoImage(DatasetGrid sourceDatasetGrid, Colors colors, Color noValueColor, double zFactor, Datasource targetDatasource, String targetDatasetName) {
        return CalculationTerrain.calculateOrthoImage(sourceDatasetGrid, colors, noValueColor, targetDatasource, targetDatasetName);
    }

    public static DatasetImage calculateOrthoImage(DatasetGrid sourceDatasetGrid, Colors colors, Color noValueColor, Datasource targetDatasource, String targetDatasetName) {
        CalculationTerrain.verifyLicense();
        if (sourceDatasetGrid == null || InternalHandle.getHandle((com.supermap.data.InternalHandle)sourceDatasetGrid) == 0L) {
            String string = InternalResource.loadString("sourceDatasetGrid", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new NullPointerException(string);
        }
        if (targetDatasource == null || InternalHandle.getHandle((com.supermap.data.InternalHandle)targetDatasource) == 0L) {
            targetDatasource = m_terrainAnalystSetting != null && m_terrainAnalystSetting.getOutputDatasource() != null ? m_terrainAnalystSetting.getOutputDatasource() : sourceDatasetGrid.getDatasource();
        }
        if (InternalHandle.getHandle((com.supermap.data.InternalHandle)targetDatasource) == 0L) {
            String string = InternalResource.loadString("targetDatasource", "Global_ArgumentObjectHasBeenDisposed", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        if (null == targetDatasetName) {
            String string = InternalResource.loadString("targetDatasetName", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        if (null != m_terrainAnalystSetting && null != m_terrainAnalystSetting.getGridOutputNamePrefix()) {
            targetDatasetName = m_terrainAnalystSetting.getGridOutputNamePrefix() + targetDatasetName;
        }
        if (!targetDatasource.getDatasets().isAvailableDatasetName(targetDatasetName)) {
            String string = InternalResource.loadString("targetDatasetName", "GlobalDatasetNameInvalid", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        boolean bl = false;
        if (null != m_terrainAnalystSetting) {
            bl = m_terrainAnalystSetting.isShowProgress();
        }
        long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)sourceDatasetGrid);
        long l2 = InternalHandle.getHandle((com.supermap.data.InternalHandle)colors);
        Colors colors2 = new Colors();
        colors2.add(noValueColor);
        long l3 = InternalHandle.getHandle((com.supermap.data.InternalHandle)colors2);
        long l4 = InternalHandle.getHandle((com.supermap.data.InternalHandle)targetDatasource);
        long l5 = CalculationTerrainNative.jni_CalculateOrthoImage(l, l2, l3, l4, targetDatasetName, bl);
        DatasetImage datasetImage = null;
        if (l5 != 0L) {
            datasetImage = InternalDatasetImage.createInstance(l5, targetDatasource);
            InternalDatasets.add(targetDatasource.getDatasets(), (Dataset)datasetImage);
        }
        InternalHandleDisposable.makeSureNativeObjectLive((Object)colors);
        InternalHandleDisposable.makeSureNativeObjectLive((Object)colors2);
        return datasetImage;
    }

    public static DatasetImage calculateOrthoImage(DatasetGrid sourceDatasetGrid, ColorDictionary colorDictionary, Color noValueColor, Datasource targetDatasource, String targetDatasetName) {
        CalculationTerrain.verifyLicense();
        if (sourceDatasetGrid == null || InternalHandle.getHandle((com.supermap.data.InternalHandle)sourceDatasetGrid) == 0L) {
            String string = InternalResource.loadString("sourceDatasetGrid", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new NullPointerException(string);
        }
        if (targetDatasource == null || InternalHandle.getHandle((com.supermap.data.InternalHandle)targetDatasource) == 0L) {
            targetDatasource = m_terrainAnalystSetting != null && m_terrainAnalystSetting.getOutputDatasource() != null ? m_terrainAnalystSetting.getOutputDatasource() : sourceDatasetGrid.getDatasource();
        }
        if (InternalHandle.getHandle((com.supermap.data.InternalHandle)targetDatasource) == 0L) {
            String string = InternalResource.loadString("targetDatasource", "Global_ArgumentObjectHasBeenDisposed", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        if (null == targetDatasetName) {
            String string = InternalResource.loadString("targetDatasetName", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        if (null != m_terrainAnalystSetting && null != m_terrainAnalystSetting.getGridOutputNamePrefix()) {
            targetDatasetName = m_terrainAnalystSetting.getGridOutputNamePrefix() + targetDatasetName;
        }
        if (!targetDatasource.getDatasets().isAvailableDatasetName(targetDatasetName)) {
            String string = InternalResource.loadString("targetDatasetName", "GlobalDatasetNameInvalid", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        boolean bl = false;
        if (null != m_terrainAnalystSetting) {
            bl = m_terrainAnalystSetting.isShowProgress();
        }
        long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)sourceDatasetGrid);
        long l2 = InternalHandle.getHandle((com.supermap.data.InternalHandle)colorDictionary);
        long l3 = InternalHandle.getHandle((com.supermap.data.InternalHandle)targetDatasource);
        long l4 = CalculationTerrainNative.jni_CalculateOrthoImageColorDictionary(l, l2, noValueColor.getRGB(), l3, targetDatasetName, bl);
        DatasetImage datasetImage = null;
        if (l4 != 0L) {
            datasetImage = InternalDatasetImage.createInstance(l4, targetDatasource);
            InternalDatasets.add(targetDatasource.getDatasets(), (Dataset)datasetImage);
        }
        InternalHandleDisposable.makeSureNativeObjectLive((Object)colorDictionary);
        return datasetImage;
    }

    @Deprecated
    public static ProfileResult calculateProfile(DatasetGrid sourceDatasetGrid, GeoLine line, double resampleTolerance) {
        return CalculationTerrain.calculateProfile(sourceDatasetGrid, line);
    }

    public static ProfileResult calculateProfile(DatasetGrid sourceDatasetGrid, GeoLine line) {
        CalculationTerrain.verifyLicense();
        if (sourceDatasetGrid == null || InternalHandle.getHandle((com.supermap.data.InternalHandle)sourceDatasetGrid) == 0L) {
            String string = InternalResource.loadString("sourceDatasetGrid", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new NullPointerException(string);
        }
        long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)sourceDatasetGrid);
        long l2 = InternalHandle.getHandle((com.supermap.data.InternalHandle)line);
        double d = 0.0;
        long[] lArray = CalculationTerrainNative.jni_CalculateProfile(l, l2, d);
        ProfileResult profileResult = null;
        if (lArray != null && lArray.length == 2) {
            Geometry geometry = null;
            geometry = InternalGeometry.createInstance(lArray[0]);
            Geometry geometry2 = null;
            geometry2 = InternalGeometry.createInstance(lArray[1]);
            profileResult = new ProfileResult((GeoLine)geometry, (GeoLine)geometry2);
        }
        InternalHandleDisposable.makeSureNativeObjectLive((Object)line);
        return profileResult;
    }

    public static ExtremumInfo findExtremum(DatasetGrid sourceDatasetGrid, GeoRegion region, long maxCount) {
        CalculationTerrain.verifyLicense();
        if (sourceDatasetGrid == null || InternalHandle.getHandle((com.supermap.data.InternalHandle)sourceDatasetGrid) == 0L) {
            String string = InternalResource.loadString("sourceDatasetGrid", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new NullPointerException(string);
        }
        long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)sourceDatasetGrid);
        long l2 = 0L;
        if (region != null) {
            l2 = InternalHandle.getHandle((com.supermap.data.InternalHandle)region);
        } else if (m_terrainAnalystSetting != null && m_terrainAnalystSetting.getValidRegion() != null) {
            l2 = InternalHandle.getHandle((com.supermap.data.InternalHandle)m_terrainAnalystSetting.getValidRegion());
        }
        double[] dArray = CalculationTerrainNative.jni_FindExtremum(l, l2, maxCount);
        boolean bl = false;
        if (dArray[0] == 1.0) {
            bl = true;
        }
        ExtremumInfo extremumInfo = null;
        if (bl) {
            int n;
            int n2 = (int)dArray[1];
            int n3 = (int)dArray[2];
            Point2D point2D = new Point2D();
            Point2Ds point2Ds = new Point2Ds();
            Point2Ds point2Ds2 = new Point2Ds();
            for (n = 0; n < n2; ++n) {
                point2D.setX(dArray[5 + 2 * n]);
                point2D.setY(dArray[5 + 2 * n + 1]);
                point2Ds.add(point2D);
            }
            n = 5 + n2 * 2;
            for (int i = 0; i < n3; ++i) {
                point2D.setX(dArray[n + 2 * i]);
                point2D.setY(dArray[n + 2 * i + 1]);
                point2Ds2.add(point2D);
            }
            extremumInfo = new ExtremumInfo(dArray[3], dArray[4], point2Ds, point2Ds2);
        }
        InternalHandleDisposable.makeSureNativeObjectLive((Object)region);
        return extremumInfo;
    }

    public static GeoRegion flood(DatasetGrid sourceDatasetGrid, double height, GeoRegion validRegion) {
        CalculationTerrain.verifyLicense();
        if (sourceDatasetGrid == null || InternalHandle.getHandle((com.supermap.data.InternalHandle)sourceDatasetGrid) == 0L) {
            String string = InternalResource.loadString("sourceDatasetGrid", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new NullPointerException(string);
        }
        long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)sourceDatasetGrid);
        boolean bl = false;
        if (null != m_terrainAnalystSetting) {
            bl = m_terrainAnalystSetting.isShowProgress();
        }
        long l2 = 0L;
        if (validRegion != null) {
            l2 = InternalHandle.getHandle((com.supermap.data.InternalHandle)validRegion);
        } else if (m_terrainAnalystSetting != null && m_terrainAnalystSetting.getValidRegion() != null) {
            l2 = InternalHandle.getHandle((com.supermap.data.InternalHandle)m_terrainAnalystSetting.getValidRegion());
        }
        long l3 = CalculationTerrainNative.jni_Flood(l, height, l2, bl);
        GeoRegion geoRegion = null;
        if (l3 != 0L) {
            geoRegion = (GeoRegion)InternalGeometry.createInstance(l3);
        }
        InternalHandleDisposable.makeSureNativeObjectLive((Object)validRegion);
        return geoRegion;
    }

    public static CutFillResult cutFill(DatasetGrid beforeCutFillDataGrid, DatasetGrid afterCutFillDataGrid, Datasource targetDatasource, String targetDatasetName) {
        CalculationTerrain.verifyLicense();
        if (beforeCutFillDataGrid == null || InternalHandle.getHandle((com.supermap.data.InternalHandle)beforeCutFillDataGrid) == 0L) {
            String string = InternalResource.loadString("preCutFillDataGrid", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new NullPointerException(string);
        }
        if (afterCutFillDataGrid == null || InternalHandle.getHandle((com.supermap.data.InternalHandle)afterCutFillDataGrid) == 0L) {
            String string = InternalResource.loadString("afterCutFillDataGrid", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new NullPointerException(string);
        }
        if (targetDatasource == null || InternalHandle.getHandle((com.supermap.data.InternalHandle)targetDatasource) == 0L) {
            targetDatasource = m_terrainAnalystSetting != null && m_terrainAnalystSetting.getOutputDatasource() != null ? m_terrainAnalystSetting.getOutputDatasource() : beforeCutFillDataGrid.getDatasource();
        }
        if (InternalHandle.getHandle((com.supermap.data.InternalHandle)targetDatasource) == 0L) {
            String string = InternalResource.loadString("targetDatasource", "Global_ArgumentObjectHasBeenDisposed", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        if (null == targetDatasetName) {
            String string = InternalResource.loadString("targetDatasetName", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        if (null != m_terrainAnalystSetting && null != m_terrainAnalystSetting.getGridOutputNamePrefix()) {
            targetDatasetName = m_terrainAnalystSetting.getGridOutputNamePrefix() + targetDatasetName;
        }
        if (!targetDatasource.getDatasets().isAvailableDatasetName(targetDatasetName)) {
            String string = InternalResource.loadString("targetDatasetName", "GlobalDatasetNameInvalid", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        boolean bl = false;
        if (null != m_terrainAnalystSetting) {
            bl = m_terrainAnalystSetting.isShowProgress();
        }
        long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)beforeCutFillDataGrid);
        long l2 = InternalHandle.getHandle((com.supermap.data.InternalHandle)afterCutFillDataGrid);
        long l3 = InternalHandle.getHandle((com.supermap.data.InternalHandle)targetDatasource);
        double[] dArray = new double[5];
        long l4 = CalculationTerrainNative.jni_CutFill(l, l2, l3, targetDatasetName, dArray, bl);
        CutFillResult cutFillResult = null;
        if (l4 != 0L) {
            DatasetGrid datasetGrid = InternalDatasetGrid.createInstance(l4, targetDatasource);
            InternalDatasets.add(targetDatasource.getDatasets(), (Dataset)datasetGrid);
            cutFillResult = new CutFillResult(dArray[0], dArray[1], dArray[2], dArray[3], dArray[4], datasetGrid);
        }
        return cutFillResult;
    }

    public static CutFillResult cutFill(DatasetGrid sourceDatasetGrid, GeoRegion region, double baseAltitude, Datasource targetDatasource, String targetDatasetName) {
        CalculationTerrain.verifyLicense();
        if (sourceDatasetGrid == null || InternalHandle.getHandle((com.supermap.data.InternalHandle)sourceDatasetGrid) == 0L) {
            String string = InternalResource.loadString("sourceDatasetGrid", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new NullPointerException(string);
        }
        if (targetDatasource == null || InternalHandle.getHandle((com.supermap.data.InternalHandle)targetDatasource) == 0L) {
            targetDatasource = m_terrainAnalystSetting != null && m_terrainAnalystSetting.getOutputDatasource() != null ? m_terrainAnalystSetting.getOutputDatasource() : sourceDatasetGrid.getDatasource();
        }
        if (InternalHandle.getHandle((com.supermap.data.InternalHandle)targetDatasource) == 0L) {
            String string = InternalResource.loadString("targetDatasource", "Global_ArgumentObjectHasBeenDisposed", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        if (null == targetDatasetName) {
            String string = InternalResource.loadString("targetDatasetName", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        if (null != m_terrainAnalystSetting && null != m_terrainAnalystSetting.getGridOutputNamePrefix()) {
            targetDatasetName = m_terrainAnalystSetting.getGridOutputNamePrefix() + targetDatasetName;
        }
        if (!targetDatasource.getDatasets().isAvailableDatasetName(targetDatasetName)) {
            String string = InternalResource.loadString("targetDatasetName", "GlobalDatasetNameInvalid", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        long l = 0L;
        if (region != null) {
            l = InternalHandle.getHandle((com.supermap.data.InternalHandle)region);
        } else if (m_terrainAnalystSetting != null && m_terrainAnalystSetting.getValidRegion() != null) {
            l = InternalHandle.getHandle((com.supermap.data.InternalHandle)m_terrainAnalystSetting.getValidRegion());
        }
        boolean bl = false;
        if (null != m_terrainAnalystSetting) {
            bl = m_terrainAnalystSetting.isShowProgress();
        }
        long l2 = InternalHandle.getHandle((com.supermap.data.InternalHandle)sourceDatasetGrid);
        long l3 = InternalHandle.getHandle((com.supermap.data.InternalHandle)targetDatasource);
        double[] dArray = new double[5];
        long l4 = CalculationTerrainNative.jni_CutFillSelect(l2, l, baseAltitude, l3, targetDatasetName, dArray, bl);
        CutFillResult cutFillResult = null;
        if (l4 != 0L) {
            DatasetGrid datasetGrid = InternalDatasetGrid.createInstance(l4, targetDatasource);
            InternalDatasets.add(targetDatasource.getDatasets(), (Dataset)datasetGrid);
            cutFillResult = new CutFillResult(dArray[0], dArray[1], dArray[2], dArray[3], dArray[4], datasetGrid);
        }
        InternalHandleDisposable.makeSureNativeObjectLive((Object)region);
        return cutFillResult;
    }

    public static CutFillResult cutFill(DatasetGrid sourceDatasetGrid, GeoRegion region, double baseAltitude) {
        CalculationTerrain.verifyLicense();
        if (sourceDatasetGrid == null || InternalHandle.getHandle((com.supermap.data.InternalHandle)sourceDatasetGrid) == 0L) {
            String string = InternalResource.loadString("sourceDatasetGrid", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new NullPointerException(string);
        }
        long l = 0L;
        if (region != null) {
            l = InternalHandle.getHandle((com.supermap.data.InternalHandle)region);
        } else if (m_terrainAnalystSetting != null && m_terrainAnalystSetting.getValidRegion() != null) {
            l = InternalHandle.getHandle((com.supermap.data.InternalHandle)m_terrainAnalystSetting.getValidRegion());
        }
        boolean bl = false;
        if (null != m_terrainAnalystSetting) {
            bl = m_terrainAnalystSetting.isShowProgress();
        }
        long l2 = InternalHandle.getHandle((com.supermap.data.InternalHandle)sourceDatasetGrid);
        double[] dArray = new double[5];
        boolean bl2 = CalculationTerrainNative.jni_CutFillSelectNoGridResult(l2, l, baseAltitude, dArray, bl);
        CutFillResult cutFillResult = null;
        if (bl2) {
            cutFillResult = new CutFillResult(dArray[0], dArray[1], dArray[2], dArray[3], dArray[4], null);
        }
        InternalHandleDisposable.makeSureNativeObjectLive((Object)region);
        return cutFillResult;
    }

    public static CutFillResult cutFill(DatasetGrid sourceDatasetGrid, GeoLine3D line3D, double bufferRadius, boolean isRoundHead, Datasource targetDatasource, String targetDatasetName) {
        CalculationTerrain.verifyLicense();
        if (sourceDatasetGrid == null || InternalHandle.getHandle((com.supermap.data.InternalHandle)sourceDatasetGrid) == 0L) {
            String string = InternalResource.loadString("sourceDatasetGrid", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new NullPointerException(string);
        }
        if (line3D == null || InternalHandle.getHandle((com.supermap.data.InternalHandle)line3D) == 0L) {
            String string = InternalResource.loadString("line3D", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new NullPointerException(string);
        }
        if (targetDatasource == null || InternalHandle.getHandle((com.supermap.data.InternalHandle)targetDatasource) == 0L) {
            targetDatasource = m_terrainAnalystSetting != null && m_terrainAnalystSetting.getOutputDatasource() != null ? m_terrainAnalystSetting.getOutputDatasource() : sourceDatasetGrid.getDatasource();
        }
        if (InternalHandle.getHandle((com.supermap.data.InternalHandle)targetDatasource) == 0L) {
            String string = InternalResource.loadString("targetDatasource", "Global_ArgumentObjectHasBeenDisposed", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        if (null == targetDatasetName) {
            String string = InternalResource.loadString("targetDatasetName", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        if (null != m_terrainAnalystSetting && null != m_terrainAnalystSetting.getGridOutputNamePrefix()) {
            targetDatasetName = m_terrainAnalystSetting.getGridOutputNamePrefix() + targetDatasetName;
        }
        if (!targetDatasource.getDatasets().isAvailableDatasetName(targetDatasetName)) {
            String string = InternalResource.loadString("targetDatasetName", "GlobalDatasetNameInvalid", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        boolean bl = false;
        if (null != m_terrainAnalystSetting) {
            bl = m_terrainAnalystSetting.isShowProgress();
        }
        long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)sourceDatasetGrid);
        long l2 = InternalHandle.getHandle((com.supermap.data.InternalHandle)line3D);
        long l3 = InternalHandle.getHandle((com.supermap.data.InternalHandle)targetDatasource);
        double[] dArray = new double[5];
        long l4 = CalculationTerrainNative.jni_CutFillIncline(l, l2, bufferRadius, isRoundHead, l3, targetDatasetName, dArray, bl);
        CutFillResult cutFillResult = null;
        if (l4 != 0L) {
            DatasetGrid datasetGrid = InternalDatasetGrid.createInstance(l4, targetDatasource);
            InternalDatasets.add(targetDatasource.getDatasets(), (Dataset)datasetGrid);
            cutFillResult = new CutFillResult(dArray[0], dArray[1], dArray[2], dArray[3], dArray[4], datasetGrid);
        }
        InternalHandleDisposable.makeSureNativeObjectLive((Object)line3D);
        return cutFillResult;
    }

    public static CutFillResult cutFill(DatasetGrid sourceDatasetGrid, GeoRegion3D region3D, Datasource targetDatasource, String targetDatasetName) {
        CalculationTerrain.verifyLicense();
        if (sourceDatasetGrid == null || InternalHandle.getHandle((com.supermap.data.InternalHandle)sourceDatasetGrid) == 0L) {
            String string = InternalResource.loadString("sourceDatasetGrid", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new NullPointerException(string);
        }
        if (region3D == null || InternalHandle.getHandle((com.supermap.data.InternalHandle)region3D) == 0L) {
            String string = InternalResource.loadString("region3D", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new NullPointerException(string);
        }
        if (targetDatasource == null || InternalHandle.getHandle((com.supermap.data.InternalHandle)targetDatasource) == 0L) {
            targetDatasource = m_terrainAnalystSetting != null && m_terrainAnalystSetting.getOutputDatasource() != null ? m_terrainAnalystSetting.getOutputDatasource() : sourceDatasetGrid.getDatasource();
        }
        if (InternalHandle.getHandle((com.supermap.data.InternalHandle)targetDatasource) == 0L) {
            String string = InternalResource.loadString("targetDatasource", "Global_ArgumentObjectHasBeenDisposed", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        if (null == targetDatasetName) {
            String string = InternalResource.loadString("targetDatasetName", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        if (null != m_terrainAnalystSetting && null != m_terrainAnalystSetting.getGridOutputNamePrefix()) {
            targetDatasetName = m_terrainAnalystSetting.getGridOutputNamePrefix() + targetDatasetName;
        }
        if (!targetDatasource.getDatasets().isAvailableDatasetName(targetDatasetName)) {
            String string = InternalResource.loadString("targetDatasetName", "GlobalDatasetNameInvalid", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        boolean bl = false;
        if (null != m_terrainAnalystSetting) {
            bl = m_terrainAnalystSetting.isShowProgress();
        }
        long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)sourceDatasetGrid);
        long l2 = InternalHandle.getHandle((com.supermap.data.InternalHandle)region3D);
        long l3 = InternalHandle.getHandle((com.supermap.data.InternalHandle)targetDatasource);
        double[] dArray = new double[5];
        long l4 = CalculationTerrainNative.jni_CutFillRegion3D(l, l2, l3, targetDatasetName, dArray, bl);
        CutFillResult cutFillResult = null;
        if (l4 != 0L) {
            DatasetGrid datasetGrid = InternalDatasetGrid.createInstance(l4, targetDatasource);
            InternalDatasets.add(targetDatasource.getDatasets(), (Dataset)datasetGrid);
            cutFillResult = new CutFillResult(dArray[0], dArray[1], dArray[2], dArray[3], dArray[4], datasetGrid);
        }
        InternalHandleDisposable.makeSureNativeObjectLive((Object)region3D);
        return cutFillResult;
    }

    public static double cutFill(DatasetGrid sourceDatasetGrid, double volume, boolean isFill) {
        return CalculationTerrain.cutFill(sourceDatasetGrid, volume, isFill, null);
    }

    public static double cutFill(DatasetGrid sourceDatasetGrid, double volume, boolean isFill, GeoRegion region) {
        CalculationTerrain.verifyLicense();
        if (sourceDatasetGrid == null || InternalHandle.getHandle((com.supermap.data.InternalHandle)sourceDatasetGrid) == 0L) {
            String string = InternalResource.loadString("sourceDatasetGrid", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new NullPointerException(string);
        }
        if (volume <= 0.0) {
            String string = InternalResource.loadString("volume", "Global_ShouldGreaterThanZero", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        long l = 0L;
        if (region != null) {
            l = InternalHandle.getHandle((com.supermap.data.InternalHandle)region);
        } else if (m_terrainAnalystSetting != null && m_terrainAnalystSetting.getValidRegion() != null) {
            l = InternalHandle.getHandle((com.supermap.data.InternalHandle)m_terrainAnalystSetting.getValidRegion());
        }
        long l2 = InternalHandle.getHandle((com.supermap.data.InternalHandle)sourceDatasetGrid);
        return CalculationTerrainNative.jni_CutFillByVolume(l2, volume, isFill, l);
    }

    public static double computeSurfaceDistance(DatasetGrid sourceDatasetGrid, GeoLine line) {
        CalculationTerrain.verifyLicense();
        if (sourceDatasetGrid == null || InternalHandle.getHandle((com.supermap.data.InternalHandle)sourceDatasetGrid) == 0L) {
            String string = InternalResource.loadString("sourceDatasetGrid", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new NullPointerException(string);
        }
        if (line == null || InternalHandle.getHandle((com.supermap.data.InternalHandle)line) == 0L) {
            String string = InternalResource.loadString("line", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new NullPointerException(string);
        }
        long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)sourceDatasetGrid);
        long l2 = InternalHandle.getHandle((com.supermap.data.InternalHandle)line);
        double d = CalculationTerrainNative.jni_ComputeSurfaceDistance(l, l2);
        InternalHandleDisposable.makeSureNativeObjectLive((Object)line);
        return d;
    }

    public static double computeSurfaceArea(DatasetGrid sourceDatasetGrid, GeoRegion region) {
        CalculationTerrain.verifyLicense();
        if (sourceDatasetGrid == null || InternalHandle.getHandle((com.supermap.data.InternalHandle)sourceDatasetGrid) == 0L) {
            String string = InternalResource.loadString("sourceDatasetGrid", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new NullPointerException(string);
        }
        long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)sourceDatasetGrid);
        long l2 = 0L;
        if (region != null) {
            l2 = InternalHandle.getHandle((com.supermap.data.InternalHandle)region);
        } else if (m_terrainAnalystSetting != null && m_terrainAnalystSetting.getValidRegion() != null) {
            l2 = InternalHandle.getHandle((com.supermap.data.InternalHandle)m_terrainAnalystSetting.getValidRegion());
        }
        double d = CalculationTerrainNative.jni_ComputeSurfaceArea(l, l2);
        InternalHandleDisposable.makeSureNativeObjectLive((Object)region);
        return d;
    }

    public static double computeSurfaceVolume(DatasetGrid sourceDatasetGrid, GeoRegion region, double baseValue) {
        CalculationTerrain.verifyLicense();
        if (sourceDatasetGrid == null || InternalHandle.getHandle((com.supermap.data.InternalHandle)sourceDatasetGrid) == 0L) {
            String string = InternalResource.loadString("sourceDatasetGrid", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new NullPointerException(string);
        }
        long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)sourceDatasetGrid);
        long l2 = 0L;
        if (region != null) {
            l2 = InternalHandle.getHandle((com.supermap.data.InternalHandle)region);
        } else if (m_terrainAnalystSetting != null && m_terrainAnalystSetting.getValidRegion() != null) {
            l2 = InternalHandle.getHandle((com.supermap.data.InternalHandle)m_terrainAnalystSetting.getValidRegion());
        }
        double d = CalculationTerrainNative.jni_ComputeSurfaceVolume(l, l2, baseValue);
        InternalHandleDisposable.makeSureNativeObjectLive((Object)region);
        return d;
    }

    public static double computePointSlope(DatasetGrid sourceDatasetGrid, Point2D specifiedPoint, SlopeType slopeType, double zFactor) {
        CalculationTerrain.verifyLicense();
        if (sourceDatasetGrid == null || InternalHandle.getHandle((com.supermap.data.InternalHandle)sourceDatasetGrid) == 0L) {
            String string = InternalResource.loadString("sourceDatasetGrid", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new NullPointerException(string);
        }
        long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)sourceDatasetGrid);
        int n = InternalEnum.getUGCValue(slopeType);
        return CalculationTerrainNative.jni_ComputePointSlope(l, specifiedPoint.getX(), specifiedPoint.getY(), n, zFactor);
    }

    public static double computePointAspect(DatasetGrid sourceDatasetGrid, Point2D specifiedPoint) {
        CalculationTerrain.verifyLicense();
        if (sourceDatasetGrid == null || InternalHandle.getHandle((com.supermap.data.InternalHandle)sourceDatasetGrid) == 0L) {
            String string = InternalResource.loadString("sourceDatasetGrid", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new NullPointerException(string);
        }
        long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)sourceDatasetGrid);
        return CalculationTerrainNative.jni_ComputePointAspect(l, specifiedPoint.getX(), specifiedPoint.getY());
    }

    public static DatasetGrid calculateCurvature(DatasetGrid sourceDatasetGrid, double zFactor, Datasource targetDatasource, String averageCurvatureName, String profileCurvatureName, String planCurvatureName) {
        CalculationTerrain.verifyLicense();
        if (sourceDatasetGrid == null || InternalHandle.getHandle((com.supermap.data.InternalHandle)sourceDatasetGrid) == 0L) {
            String string = InternalResource.loadString("sourceDatasetGrid", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new NullPointerException(string);
        }
        if (targetDatasource == null || InternalHandle.getHandle((com.supermap.data.InternalHandle)targetDatasource) == 0L) {
            targetDatasource = m_terrainAnalystSetting != null && m_terrainAnalystSetting.getOutputDatasource() != null ? m_terrainAnalystSetting.getOutputDatasource() : sourceDatasetGrid.getDatasource();
        }
        if (InternalHandle.getHandle((com.supermap.data.InternalHandle)targetDatasource) == 0L) {
            String string = InternalResource.loadString("targetDatasource", "Global_ArgumentObjectHasBeenDisposed", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        if (null == averageCurvatureName) {
            String string = InternalResource.loadString("curvatureGridName", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        if (null != m_terrainAnalystSetting && null != m_terrainAnalystSetting.getGridOutputNamePrefix()) {
            averageCurvatureName = m_terrainAnalystSetting.getGridOutputNamePrefix() + averageCurvatureName;
        }
        if (!targetDatasource.getDatasets().isAvailableDatasetName(averageCurvatureName)) {
            String string = InternalResource.loadString("averageCurvatureName", "GlobalDatasetNameInvalid", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        if (profileCurvatureName != null && !profileCurvatureName.isEmpty() && !targetDatasource.getDatasets().isAvailableDatasetName(profileCurvatureName)) {
            String string = InternalResource.loadString("profileCurvatureName", "GlobalDatasetNameInvalid", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        if (planCurvatureName != null && !planCurvatureName.isEmpty() && !targetDatasource.getDatasets().isAvailableDatasetName(planCurvatureName)) {
            String string = InternalResource.loadString("planCurvatureName", "GlobalDatasetNameInvalid", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        boolean bl = false;
        if (null != m_terrainAnalystSetting) {
            bl = m_terrainAnalystSetting.isShowProgress();
        }
        long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)sourceDatasetGrid);
        long l2 = InternalHandle.getHandle((com.supermap.data.InternalHandle)targetDatasource);
        long[] lArray = CalculationTerrainNative.jni_CalculateCurvature(l, zFactor, l2, averageCurvatureName, profileCurvatureName, planCurvatureName, bl);
        DatasetGrid datasetGrid = null;
        if (lArray != null && lArray.length == 3 && lArray[0] != 0L) {
            DatasetGrid datasetGrid2;
            datasetGrid = InternalDatasetGrid.createInstance(lArray[0], targetDatasource);
            InternalDatasets.add(targetDatasource.getDatasets(), (Dataset)datasetGrid);
            if (lArray[1] != 0L) {
                datasetGrid2 = InternalDatasetGrid.createInstance(lArray[1], targetDatasource);
                InternalDatasets.add(targetDatasource.getDatasets(), (Dataset)datasetGrid2);
            }
            if (lArray[2] != 0L) {
                datasetGrid2 = InternalDatasetGrid.createInstance(lArray[2], targetDatasource);
                InternalDatasets.add(targetDatasource.getDatasets(), (Dataset)datasetGrid2);
            }
        }
        return datasetGrid;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void verifyLicense() {
        int n = -1;
        Object object = m_license;
        synchronized (object) {
            n = m_license.verify();
        }
        if (n != 0) {
            object = License.getErrorMessage((int)n);
            throw new IllegalStateException((String)object);
        }
    }

    public static synchronized void addSteppedListener(SteppedListener l) {
        if (m_steppedListeners == null) {
            m_steppedListeners = new Vector();
        }
        if (!m_steppedListeners.contains(l)) {
            m_steppedListeners.add(l);
        }
    }

    public static synchronized void removeSteppedListener(SteppedListener l) {
        if (m_steppedListeners != null && m_steppedListeners.contains(l)) {
            m_steppedListeners.remove(l);
        }
    }

    protected static void fireStepped(SteppedEvent event) {
        if (m_steppedListeners != null) {
            Vector vector = m_steppedListeners;
            int n = vector.size();
            for (int i = 0; i < n; ++i) {
                ((SteppedListener)vector.elementAt(i)).stepped(event);
            }
        }
    }

    static void steppedCallBack(int percent, long remainTime, String title, String message, long cancelHandle) {
        String string = "CalculationTerrain";
        boolean bl = InternalToolkitSpatialAnalyst.getHandleBooleanValue(cancelHandle);
        Object object = new Object();
        SteppedEvent steppedEvent = new SteppedEvent(object, percent, remainTime, title, message, string);
        CalculationTerrain.fireStepped(steppedEvent);
        InternalToolkitSpatialAnalyst.setHandleBooleanValue(cancelHandle, steppedEvent.getCancel());
    }

    static {
        ArrayList<ProductType> arrayList = InternalToolkitSpatialAnalyst.managerProducts(InternalToolkitSpatialAnalyst.getSpatialAnalystProducts());
        m_license = InternalToolkitSpatialAnalyst.verifyLicense(arrayList);
    }
}

