/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.realspace;

import com.supermap.data.FieldInfos;
import com.supermap.data.FieldType;
import com.supermap.data.GeoModel;
import com.supermap.data.GeoPlacemark;
import com.supermap.data.GeoStyle3D;
import com.supermap.data.GeometryType;
import com.supermap.realspace.Feature3D;
import com.supermap.realspace.InternalEnum;
import com.supermap.realspace.InternalFieldInfos;
import com.supermap.realspace.InternalGeoStyle3D;
import com.supermap.realspace.InternalHandle;
import com.supermap.realspace.InternalHandleDisposable;
import com.supermap.realspace.InternalResource;
import com.supermap.realspace.Layer3D;
import com.supermap.realspace.Layer3DNative;
import com.supermap.realspace.Layer3DSetting;
import com.supermap.realspace.Layer3DSettingVector;
import com.supermap.realspace.Layer3DVectorFileDataType;
import com.supermap.realspace.Layer3DVectorNative;
import com.supermap.realspace.Layer3Ds;
import com.supermap.realspace.Volume3D;
import java.text.DateFormat;
import java.text.ParseException;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;

public class Layer3DVectorFile
extends Layer3D {
    private GeoStyle3D m_geoStyle3D;
    private FieldInfos m_fieldInfos;
    private int m_fieldCount;
    private Volume3D m_volume;
    private Layer3DSetting m_layer3DSetting;
    private boolean[] m_flag = new boolean[]{false};

    Layer3DVectorFile(long handle, Layer3Ds layer3Ds) {
        super(handle, layer3Ds);
        this.m_fieldInfos = InternalFieldInfos.createInstance(Layer3DVectorNative.jni_GetFieldInfos(this.getHandle()));
        this.m_fieldCount = this.m_fieldInfos.getCount();
    }

    @Override
    protected void clearHandle() {
        if (this.m_geoStyle3D != null) {
            InternalGeoStyle3D.clearHandle(this.m_geoStyle3D);
            this.m_geoStyle3D = null;
        }
        if (this.m_fieldInfos != null) {
            InternalFieldInfos.clearHandle(this.m_fieldInfos);
        }
        super.clearHandle();
    }

    private void checkExceptionForGetFieldValueByIndex(int index) {
        if (index < 0 || index >= this.m_fieldCount) {
            String string = InternalResource.loadString("" + index, "Global_IndexOutOfBounds", "realspace_resources");
            throw new IndexOutOfBoundsException(string);
        }
    }

    public GeoStyle3D getStyle() {
        long l;
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getStyle()", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_geoStyle3D == null && (l = Layer3DNative.jni_GetStyle(this.getHandle())) != 0L) {
            this.m_geoStyle3D = InternalGeoStyle3D.createInstance(l);
        }
        return this.m_geoStyle3D;
    }

    public void setStyle(GeoStyle3D geoStyle3D) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setStyle()", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        if (geoStyle3D == null) {
            String string = InternalResource.loadString("geoStyle3D", "Global_ArgumentNull", "realspace_resources");
            throw new NullPointerException(string);
        }
        long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)geoStyle3D);
        if (l == 0L) {
            String string = InternalResource.loadString("geoStyle3D", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalArgumentException(string);
        }
        long l2 = InternalHandle.getHandle((com.supermap.data.InternalHandle)geoStyle3D.clone());
        Layer3DNative.jni_SetStyle(this.getHandle(), l2);
        InternalHandleDisposable.makeSureNativeObjectLive((Object)geoStyle3D);
    }

    public Layer3DVectorFileDataType getDataType() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getDataType()", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        int n = Layer3DNative.jni_GetDataType(this.getHandle());
        return (Layer3DVectorFileDataType)InternalEnum.parseUGCValue(Layer3DVectorFileDataType.class, n);
    }

    public void addGeoModels(GeoModel[] geoModels) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("addModels(Feature3D[] features)", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        if (geoModels == null) {
            String string = InternalResource.loadString("geoModels", "Global_ArgumentNull", "realspace_resources");
            throw new NullPointerException(string);
        }
        int n = geoModels.length;
        long[] lArray = new long[n];
        for (int i = 0; i < n; ++i) {
            if (InternalHandle.getHandle((com.supermap.data.InternalHandle)geoModels[i]) == 0L) {
                String string = InternalResource.loadString("geoModels[" + i + "]", "Handle_ObjectHasBeenDisposed", "realspace_resources");
                throw new IllegalStateException(string);
            }
            lArray[i] = InternalHandle.getHandle((com.supermap.data.InternalHandle)geoModels[i]);
        }
        Layer3DVectorNative.jni_AddGeoModels(this.getHandle(), lArray);
        InternalHandleDisposable.makeSureNativeObjectLive((Object)geoModels);
    }

    public Feature3D[] getFeature3Ds(int[] ids) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getFeature3Ds()", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        if (ids == null) {
            String string = InternalResource.loadString("ids", "Global_ArgumentNull", "realspace_resources");
            throw new NullPointerException(string);
        }
        long[] lArray = Layer3DVectorNative.jni_GetFeature3Ds(this.getHandle(), ids);
        Feature3D[] feature3DArray = null;
        if (lArray != null && lArray.length > 0) {
            feature3DArray = new Feature3D[lArray.length];
            for (int i = 0; i < feature3DArray.length; ++i) {
                feature3DArray[i] = new Feature3D(lArray[i], null);
                InternalHandleDisposable.setIsDisposable(feature3DArray[i], true);
            }
        }
        return feature3DArray;
    }

    public FieldInfos getFieldInfos() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getFieldInfos", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        return new FieldInfos(this.m_fieldInfos);
    }

    public Object getFieldValueOfSelectedObject(int index) {
        FieldType fieldType = this.m_fieldInfos.get(index).getType();
        if (fieldType.equals((Object)FieldType.INT32)) {
            Integer n = this.getInt32(index);
            if (this.m_flag[0]) {
                return null;
            }
            return n;
        }
        if (fieldType.equals((Object)FieldType.INT16)) {
            Short s = this.getInt16(index);
            if (this.m_flag[0]) {
                return null;
            }
            return s;
        }
        if (fieldType.equals((Object)FieldType.BOOLEAN)) {
            Boolean bl = this.getBoolean(index);
            if (this.m_flag[0]) {
                return null;
            }
            return bl;
        }
        if (fieldType.equals((Object)FieldType.BYTE)) {
            Byte by = this.getByte(index);
            if (this.m_flag[0]) {
                return null;
            }
            return by;
        }
        if (fieldType.equals((Object)FieldType.CHAR)) {
            String string = this.getString(index);
            if (this.m_flag[0]) {
                return null;
            }
            return string;
        }
        if (fieldType.equals((Object)FieldType.DATETIME)) {
            Date date = this.getDateTime(index);
            if (this.m_flag[0]) {
                return null;
            }
            return date;
        }
        if (fieldType.equals((Object)FieldType.DOUBLE)) {
            Double d = this.getDouble(index);
            if (this.m_flag[0]) {
                return null;
            }
            return d;
        }
        if (fieldType.equals((Object)FieldType.LONGBINARY)) {
            byte[] byArray = this.getLongBinary(index);
            if (this.m_flag[0]) {
                return null;
            }
            return byArray;
        }
        if (fieldType.equals((Object)FieldType.SINGLE)) {
            Float f = Float.valueOf(this.getSingle(index));
            if (this.m_flag[0]) {
                return null;
            }
            return f;
        }
        if (fieldType.equals((Object)FieldType.TEXT)) {
            String string = this.getString(index);
            if (this.m_flag[0]) {
                return null;
            }
            return string;
        }
        return null;
    }

    @Deprecated
    public void modifyFeature3Ds(Feature3D[] features) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("modifyModels(Feature3D[] features)", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        if (features == null) {
            String string = InternalResource.loadString("features", "Global_ArgumentNull", "realspace_resources");
            throw new NullPointerException(string);
        }
        int n = features.length;
        long[] lArray = new long[n];
        for (int i = 0; i < n; ++i) {
            Object object;
            GeometryType geometryType = features[i].getGeometry().getType();
            if (geometryType.equals((Object)GeometryType.GEOPLACEMARK)) {
                object = (GeoPlacemark)features[i].getGeometry();
                if (!object.getGeometry().getType().equals((Object)GeometryType.GEOMODEL)) {
                    String string = InternalResource.loadString("features[" + i + "]", "Layer3DModel_FeatureGeometryTypeShouldBeGeoModel", "realspace_resources");
                    throw new IllegalArgumentException(string);
                }
            } else if (!geometryType.equals((Object)GeometryType.GEOMODEL)) {
                object = InternalResource.loadString("features[" + i + "]", "Layer3DModel_FeatureGeometryTypeShouldBeGeoModel", "realspace_resources");
                throw new IllegalArgumentException((String)object);
            }
            if (InternalHandle.getHandle((com.supermap.data.InternalHandle)features[i]) == 0L) {
                object = InternalResource.loadString("features[" + i + "]", "Handle_ObjectHasBeenDisposed", "realspace_resources");
                throw new IllegalStateException((String)object);
            }
            lArray[i] = InternalHandle.getHandle((com.supermap.data.InternalHandle)features[i]);
        }
        Layer3DVectorNative.jni_ModifyFeature3Ds(this.getHandle(), lArray);
    }

    private int getInt32(int index) {
        this.checkExceptionForGetFieldValueByIndex(index);
        int n = Layer3DVectorNative.jni_GetFieldValueIntByIndex(this.getHandle(), index, this.m_flag);
        return n;
    }

    private short getInt16(int index) {
        this.checkExceptionForGetFieldValueByIndex(index);
        short s = Layer3DVectorNative.jni_GetFieldValueShortByIndex(this.getHandle(), index, this.m_flag);
        return s;
    }

    private boolean getBoolean(int index) {
        this.checkExceptionForGetFieldValueByIndex(index);
        boolean bl = Layer3DVectorNative.jni_GetFieldValueBooleanByIndex(this.getHandle(), index, this.m_flag);
        return bl;
    }

    private String getString(int index) {
        this.checkExceptionForGetFieldValueByIndex(index);
        boolean[] blArray = new boolean[]{false};
        String string = Layer3DVectorNative.jni_GetFieldValueTextByIndex(this.getHandle(), index, blArray);
        return string;
    }

    private Date getDateTime(int index) {
        this.checkExceptionForGetFieldValueByIndex(index);
        boolean[] blArray = new boolean[]{false};
        Date date = this.getFieldValueDateTimeByIndex(index, blArray);
        return date;
    }

    private Date getFieldValueDateTimeByIndex(int index, boolean[] m_flag) {
        Pattern pattern = Pattern.compile("^((\\d{2}(([02468][048])|([13579][26]))[\\-\\/\\s]?((((0?[13578])|(1[02]))[\\-\\/\\s]?((0?[1-9])|([1-2][0-9])|(3[01])))|(((0?[469])|(11))[\\-\\/\\s]?((0?[1-9])|([1-2][0-9])|(30)))|(0?2[\\-\\/\\s]?((0?[1-9])|([1-2][0-9])))))|(\\d{2}(([02468][1235679])|([13579][01345789]))[\\-\\/\\s]?((((0?[13578])|(1[02]))[\\-\\/\\s]?((0?[1-9])|([1-2][0-9])|(3[01])))|(((0?[469])|(11))[\\-\\/\\s]?((0?[1-9])|([1-2][0-9])|(30)))|(0?2[\\-\\/\\s]?((0?[1-9])|(1[0-9])|(2[0-8]))))))(\\s(((0?[0-9])|([1-2][0-3]))\\:([0-5]?[0-9])((\\s)|(\\:([0-5]?[0-9])))))?$");
        String string = Layer3DVectorNative.jni_GetFieldValueDateByIndex(this.getHandle(), index, m_flag);
        Date date = null;
        if (pattern.matcher(string).matches()) {
            try {
                date = DateFormat.getDateTimeInstance().parse(string);
            }
            catch (ParseException parseException) {
                // empty catch block
            }
        }
        return date;
    }

    private double getDouble(int index) {
        this.checkExceptionForGetFieldValueByIndex(index);
        boolean[] blArray = new boolean[]{false};
        double d = Layer3DVectorNative.jni_GetFieldValueDoubleByIndex(this.getHandle(), index, blArray);
        return d;
    }

    private float getSingle(int index) {
        this.checkExceptionForGetFieldValueByIndex(index);
        boolean[] blArray = new boolean[]{false};
        float f = Layer3DVectorNative.jni_GetFieldValueFloatByIndex(this.getHandle(), index, blArray);
        return f;
    }

    private byte getByte(int index) {
        this.checkExceptionForGetFieldValueByIndex(index);
        boolean[] blArray = new boolean[]{false};
        byte by = Layer3DVectorNative.jni_GetFieldValueByteByIndex(this.getHandle(), index, blArray);
        return by;
    }

    private byte[] getLongBinary(int index) {
        this.checkExceptionForGetFieldValueByIndex(index);
        boolean[] blArray = new boolean[]{false};
        byte[] byArray = Layer3DVectorNative.jni_GetFieldValueLongBinaryByIndex(this.getHandle(), index, blArray);
        return byArray;
    }

    private void checkExceptionForGetFieldValueByName(String name) {
        if (name == null || name.trim().length() == 0) {
            String string = InternalResource.loadString("name", "Global_StringIsNullOrEmpty", "realspace_resources");
            throw new IllegalArgumentException(string);
        }
    }

    public Object getFieldValueOfSelectedObject(String name) {
        this.checkExceptionForGetFieldValueByName(name);
        int n = this.m_fieldInfos.indexOf(name);
        if (n < 0) {
            String string = InternalResource.loadString("" + n, "Global_IndexOutOfBounds", "realspace_resources");
            throw new IndexOutOfBoundsException(string);
        }
        return this.getFieldValueOfSelectedObject(n);
    }

    public boolean isQuickRender() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("isQuickRender()", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        return Layer3DVectorNative.jni_IsQuickRender(this.getHandle());
    }

    public void setQuickRender(boolean value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setQuickRender(boolean value)", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        Layer3DVectorNative.jni_SetQuickRender(this.getHandle(), value);
    }

    public double getLODDistance() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getLODDistance()", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        return Layer3DVectorNative.jni_GetLODDistance(this.getHandle());
    }

    public void setLODDistance(double value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setLODDistance(double value)", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        Layer3DVectorNative.jni_SetLODDistance(this.getHandle(), value);
    }

    public void setObjectsVisible(int[] nIds, boolean bVisible) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setObjectsVisible()", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        Layer3DVectorNative.jni_SetObjectsVisible(this.getHandle(), nIds, bVisible);
    }

    public boolean isLod() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("isLod()", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        return Layer3DVectorNative.jni_IsLod(this.getHandle());
    }

    public void setPreloadRange(double range) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setPreloadRange()", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        Layer3DVectorNative.jni_SetPreloadRange(this.getHandle(), range);
    }

    public double getPreloadRange() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getPreloadRange()", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        return Layer3DVectorNative.jni_GetPreloadRange(this.getHandle());
    }

    public double getTileWidth() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getTileWidth()", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        return Layer3DVectorNative.jni_GetTileWidth(this.getHandle());
    }

    public void setBestLOD(HashMap<Integer, Double> lodMap) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getTileWidth()", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        int n = lodMap.size();
        int[] nArray = new int[n];
        double[] dArray = new double[n];
        Set<Map.Entry<Integer, Double>> set = lodMap.entrySet();
        Iterator<Map.Entry<Integer, Double>> iterator = set.iterator();
        Map.Entry<Integer, Double> entry = null;
        for (int i = 0; i < n; ++i) {
            entry = iterator.next();
            nArray[i] = entry.getKey();
            dArray[i] = entry.getValue();
        }
        Layer3DVectorNative.jni_SetBestLOD(this.getHandle(), nArray, dArray);
    }

    public HashMap<Integer, Double> getBestLod() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getTileWidth()", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        HashMap<Integer, Double> hashMap = new HashMap<Integer, Double>();
        double[] dArray = Layer3DVectorNative.jni_GetBestLodValues(this.getHandle());
        hashMap.put(0, dArray[0]);
        hashMap.put(1, dArray[1]);
        return hashMap;
    }

    public Volume3D getVolume() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getVolume()", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_volume == null) {
            this.m_volume = new Volume3D(this);
        }
        return this.m_volume;
    }

    public Layer3DSetting getAdditionalSetting() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("Layer3DVectorFile", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_layer3DSetting == null) {
            this.m_layer3DSetting = new Layer3DSettingVector(this);
        }
        return this.m_layer3DSetting;
    }

    public void setAdditionalSetting(Layer3DSetting value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("Layer3DVectorFile", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        if (this.getAdditionalSetting() == null) {
            String string = InternalResource.loadString("Layer3DVectorFile", "Layer3DSettingDatasetVector_InvalidStyle", "realspace_resources");
            throw new IllegalStateException(string);
        }
        if (this.getAdditionalSetting().getType() != value.getType()) {
            String string = InternalResource.loadString("value", "Layer3D_InvalidAdditionalSettingType", "realspace_resources");
            throw new IllegalStateException(string);
        }
        this.m_layer3DSetting.reset(value);
    }
}

