/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.data.processing.cache;

import com.supermap.data.CoordSysTransMethod;
import com.supermap.data.CoordSysTransParameter;
import com.supermap.data.CoordSysTranslator;
import com.supermap.data.CursorType;
import com.supermap.data.DatasetType;
import com.supermap.data.DatasetVector;
import com.supermap.data.DatasetVectorInfo;
import com.supermap.data.Datasource;
import com.supermap.data.DatasourceConnectionInfo;
import com.supermap.data.EngineType;
import com.supermap.data.FieldInfo;
import com.supermap.data.FieldType;
import com.supermap.data.GeoLine;
import com.supermap.data.GeoRegion;
import com.supermap.data.Geometry;
import com.supermap.data.Point2D;
import com.supermap.data.Point2Ds;
import com.supermap.data.PrjCoordSys;
import com.supermap.data.PrjCoordSysType;
import com.supermap.data.ProjectionType;
import com.supermap.data.Recordset;
import com.supermap.data.Rectangle2D;
import com.supermap.data.Workspace;
import com.supermap.data.processing.CacheWriter;
import com.supermap.data.processing.MapCacheBuilder;
import com.supermap.data.processing.StorageType;
import com.supermap.data.processing.TileFormat;
import com.supermap.tilestorage.TileStorageConnection;
import com.supermap.tilestorage.TileStorageManager;
import com.supermap.tilestorage.TileStorageType;
import com.supermap.tilestorage.TileVersion;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;

public class TaskBuilder {
    public static final int BundleSize = 128;

    /*
     * Enabled aggressive block sorting
     */
    public static void main(String[] args) throws Exception {
        boolean bl;
        boolean bl2;
        File file;
        String string;
        Object object;
        Object object2;
        Object object3;
        Object object4;
        File file2;
        if (args.length < 2) {
            System.out.println("input style: sciFile targetFolder listCount(1) canudb(0) versionName");
            return;
        }
        String string2 = args[0];
        String string3 = args[1] + "/task";
        int n = 1;
        if (args.length > 2) {
            n = Integer.valueOf(args[2]);
        }
        int n2 = 0;
        if (args.length > 3) {
            n2 = Integer.valueOf(args[3]);
        }
        String string4 = "";
        if (args.length > 4) {
            string4 = args[4];
        }
        if (!(file2 = new File(string2)).exists()) {
            System.out.println(string2 + " not exist!");
            return;
        }
        Workspace workspace = null;
        Datasource datasource = null;
        if (n2 > 0) {
            object4 = "cache";
            object3 = args[1] + "/udb/" + (String)object4 + ".udb";
            object2 = new File((String)object3);
            if (((File)object2).exists()) {
                System.out.println((String)object3 + " is exists!");
                return;
            }
            ((File)object2).getParentFile().mkdirs();
            object = new DatasourceConnectionInfo();
            object.setServer((String)object3);
            object.setAlias((String)object4);
            object.setEngineType(EngineType.UDB);
            workspace = new Workspace();
            datasource = workspace.getDatasources().create((DatasourceConnectionInfo)object);
        }
        object4 = new CacheWriter();
        ((CacheWriter)object4).FromConfigFile(string2);
        if (((CacheWriter)object4).getStorageType() == StorageType.MongoDB) {
            object3 = new TileStorageConnection();
            object2 = ((CacheWriter)object4).getMongoConnectionInfo();
            object3.setStorageType(TileStorageType.MONGO);
            object3.setServer((String)object2[0]);
            object3.setDatabase((String)object2[1]);
            object3.setName((String)object2[2]);
            object = new TileStorageManager();
            if (!object.open((TileStorageConnection)object3) || !string4.isEmpty()) {
                Object object5;
                MapCacheBuilder mapCacheBuilder = new MapCacheBuilder();
                if (!mapCacheBuilder.fromConfigFile(string2)) {
                    System.out.println("open sci file filed!");
                    return;
                }
                if (!string4.isEmpty()) {
                    object5 = new TileVersion();
                    object5.setDesc(string4);
                    mapCacheBuilder.setVersionInfo((TileVersion)object5);
                }
                if (!mapCacheBuilder.createMongoDB()) {
                    System.out.println("create mongodb failed!");
                    return;
                }
                object5 = new File(string2);
                string = mapCacheBuilder.getCacheName() + "_mongo.sci";
                file = new File(((File)object5).getParent() + "/" + string);
                string2 = file.getAbsolutePath();
                ((CacheWriter)object4).FromConfigFile(string2);
                System.out.println("create mongodb success!");
                System.out.println(string + " created!");
            }
            object.close();
        }
        if (!((File)(object3 = new File(string3))).exists()) {
            ((File)object3).mkdirs();
        }
        object2 = string3 + "/allTask.list";
        object = new File((String)object2);
        Object var13_14 = null;
        if (!((File)object).exists() && !(bl2 = ((File)object).createNewFile())) {
            System.out.println("create all task file Failed!");
        }
        OutputStreamWriter outputStreamWriter = new OutputStreamWriter((OutputStream)new FileOutputStream((File)object), "UTF-8");
        OutputStreamWriter outputStreamWriter2 = null;
        string = string3 + "/allTaskSpiral.list";
        file = new File(string);
        if (!file.exists() && !(bl = file.createNewFile())) {
            System.out.println("create all task spiral file Failed!");
        }
        outputStreamWriter2 = new OutputStreamWriter((OutputStream)new FileOutputStream(file), "UTF-8");
        HashMap<Double, String> hashMap = new HashMap<Double, String>(((CacheWriter)object4).getCacheScaleCaptions());
        Rectangle2D rectangle2D = ((CacheWriter)object4).getCacheBounds();
        Rectangle2D rectangle2D2 = ((CacheWriter)object4).getIndexBounds();
        Set<Double> set = hashMap.keySet();
        ArrayList<Double> arrayList = new ArrayList<Double>();
        arrayList.addAll(set);
        if (((CacheWriter)object4).isbuildFromOriginalResolution().booleanValue()) {
            Collections.sort(arrayList, Collections.reverseOrder());
        } else {
            Collections.sort(arrayList);
        }
        Rectangle2D rectangle2D3 = rectangle2D2;
        if (((CacheWriter)object4).getTileFormat() == TileFormat.PBF) {
            // empty if block
        }
        Iterator iterator = arrayList.iterator();
        while (true) {
            double d;
            double d2;
            double d3;
            int n3;
            int n4;
            int n5;
            int n6;
            int n7;
            int n8;
            String string5;
            Recordset.BatchEditor batchEditor;
            Recordset recordset;
            String string6;
            if (iterator.hasNext()) {
                double d4;
                double d5;
                double d6 = (Double)iterator.next();
                double d7 = ((CacheWriter)object4).getTileResolustion(d6);
                HashMap<Double, String> hashMap2 = new HashMap<Double, String>();
                string6 = hashMap.get(d6);
                hashMap2.put(d6, string6);
                ((CacheWriter)object4).setCacheScaleCaptions(hashMap2);
                recordset = null;
                batchEditor = null;
                if (n2 > 0) {
                    string5 = "L" + string6 + "_S" + Math.round(1.0 / d6);
                    DatasetVectorInfo datasetVectorInfo = new DatasetVectorInfo(string5, DatasetType.REGION);
                    DatasetVector datasetVector = datasource.getDatasets().create(datasetVectorInfo);
                    FieldInfo fieldInfo = new FieldInfo("tiletype", FieldType.INT32);
                    FieldInfo fieldInfo2 = new FieldInfo("tilerow", FieldType.INT32);
                    FieldInfo fieldInfo3 = new FieldInfo("tilecol", FieldType.INT32);
                    FieldInfo fieldInfo4 = new FieldInfo("errortype", FieldType.INT32);
                    FieldInfo fieldInfo5 = new FieldInfo("errordesc", FieldType.TEXT);
                    datasetVector.getFieldInfos().add(fieldInfo);
                    datasetVector.getFieldInfos().add(fieldInfo2);
                    datasetVector.getFieldInfos().add(fieldInfo3);
                    datasetVector.getFieldInfos().add(fieldInfo4);
                    datasetVector.getFieldInfos().add(fieldInfo5);
                    recordset = datasetVector.getRecordset(false, CursorType.DYNAMIC);
                    batchEditor = recordset.getBatch();
                    batchEditor.setMaxRecordCount(10);
                    batchEditor.begin();
                }
                if (((CacheWriter)object4).getTileFormat() == TileFormat.PBF) {
                    int n9;
                    n8 = Integer.valueOf(string6);
                    n7 = 1;
                    d5 = rectangle2D3.getWidth() / (double)(n7 <<= n8);
                    d4 = rectangle2D3.getHeight() / (double)n7;
                    n6 = (int)Math.floor((rectangle2D.getLeft() - rectangle2D3.getLeft()) / d5);
                    n5 = (int)Math.floor((rectangle2D.getRight() - rectangle2D3.getLeft()) / d5);
                    n4 = (int)Math.floor(-(rectangle2D.getTop() - rectangle2D3.getTop()) / d4);
                    n3 = (int)Math.floor(-(rectangle2D.getBottom() - rectangle2D3.getTop()) / d4);
                    if (n6 < 0) {
                        n6 = 0;
                    }
                    if (n6 >= n7) {
                        n6 = n7 - 1;
                    }
                    if (n5 < 0) {
                        n5 = 0;
                    }
                    if (n5 >= n7) {
                        n5 = n7 - 1;
                    }
                    if (n4 < 0) {
                        n4 = 0;
                    }
                    if (n4 >= n7) {
                        n4 = n7 - 1;
                    }
                    if (n3 < 0) {
                        n3 = 0;
                    }
                    if (n3 >= n7) {
                        n3 = n7 - 1;
                    }
                    if (n6 > n5) {
                        n9 = n6;
                        n6 = n5;
                        n5 = n9;
                    }
                    if (n4 > n3) {
                        n9 = n4;
                        n4 = n3;
                        n3 = n9;
                    }
                    d3 = d5 / (double)((CacheWriter)object4).getTileSize().value();
                    string5 = rectangle2D3;
                    d2 = d5;
                    d = d4;
                } else {
                    double d8;
                    d3 = d7 / (double)((CacheWriter)object4).getTileSize().value();
                    double d9 = (rectangle2D.getLeft() - rectangle2D2.getLeft()) / d7 + 1.0E-8;
                    n6 = (int)Math.floor(d9);
                    d5 = -(rectangle2D.getTop() - rectangle2D2.getTop()) / d7 + 1.0E-8;
                    n4 = (int)Math.floor(d5);
                    d4 = (rectangle2D.getRight() - rectangle2D2.getLeft()) / d7 + 1.0E-8;
                    if ((d4 - (double)(n5 = (int)Math.floor(d4))) * d7 < d3) {
                        --n5;
                    }
                    if (((d8 = -(rectangle2D.getBottom() - rectangle2D2.getTop()) / d7 + 1.0E-8) - (double)(n3 = (int)Math.floor(d8))) * d7 < d3) {
                        --n3;
                    }
                    string5 = rectangle2D2;
                    d2 = d7;
                    d = d7;
                }
                n8 = n4;
            } else {
                outputStreamWriter.close();
                outputStreamWriter2.close();
                if (n2 > 0) {
                    datasource.close();
                    workspace.close();
                    workspace.dispose();
                }
                if (n2 < 2) {
                    TaskBuilder.splitList((String)object2, n);
                }
                return;
            }
            while (n8 <= n3) {
                n7 = n8 / 128;
                int n10 = Math.min(n3, (n7 + 1) * 128 - 1);
                int n11 = n6;
                while (n11 <= n5) {
                    int n12 = n11 / 128;
                    int n13 = Math.min(n5, (n12 + 1) * 128 - 1);
                    double d10 = string5.getLeft() + (double)n11 * d2;
                    double d11 = string5.getLeft() + (double)(n13 + 1) * d2;
                    double d12 = string5.getTop() - (double)n8 * d;
                    double d13 = string5.getTop() - (double)(n10 + 1) * d;
                    if (d11 - d10 > d3 && Math.abs(d13 - d12) > d3) {
                        String string7;
                        Point2Ds point2Ds;
                        if (n2 < 2) {
                            point2Ds = new Rectangle2D(d10, d13, d11, d12);
                            ((CacheWriter)object4).setCacheBounds((Rectangle2D)point2Ds);
                            string7 = String.format("%s/L%s_R%d_C%d.sci", string3, string6, n7, n12);
                            TaskBuilder.wirteOneSci((CacheWriter)object4, string7, outputStreamWriter);
                        }
                        if (n2 > 0) {
                            point2Ds = new Point2Ds();
                            point2Ds.add(new Point2D(d10, d13));
                            point2Ds.add(new Point2D(d10, d12));
                            point2Ds.add(new Point2D(d11, d12));
                            point2Ds.add(new Point2D(d11, d13));
                            string7 = new GeoRegion(point2Ds);
                            HashMap<String, Integer> hashMap3 = new HashMap<String, Integer>();
                            hashMap3.put("tiletype", 1);
                            hashMap3.put("tilerow", n7);
                            hashMap3.put("tilecol", n12);
                            recordset.addNew((Geometry)string7, hashMap3);
                        }
                    }
                    n11 = n13 + 1;
                }
                n8 = n10 + 1;
            }
            if (n2 > 0) {
                batchEditor.update();
                recordset.close();
                recordset.dispose();
            }
            if (n2 < 2) {
                Rectangle2D rectangle2D4 = new Rectangle2D((double)n6, (double)n3, (double)n5, (double)n4);
                TaskBuilder.buildSpiralTask(rectangle2D4, (Rectangle2D)string5, d2, d, d3, string6, outputStreamWriter2);
            }
            ((CacheWriter)object4).setCacheScaleCaptions(hashMap);
            ((CacheWriter)object4).setCacheBounds(rectangle2D);
        }
    }

    public static void splitList(String allListFileName, int splitCount) throws Exception {
        String string;
        if (splitCount < 2) {
            return;
        }
        File file = new File(allListFileName);
        ArrayList<String> arrayList = null;
        try (BufferedReader bufferedReader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), "UTF-8"));){
            arrayList = new ArrayList<String>();
            while ((string = bufferedReader.readLine()) != null) {
                arrayList.add(string);
            }
        }
        int n = arrayList.size() / splitCount;
        int n2 = 0;
        string = file.getParent() + "/" + file.getName().replaceAll(".list", "");
        for (int i = 0; i < splitCount; ++i) {
            File file2 = new File(string + "_" + i + ".list");
            try (OutputStreamWriter outputStreamWriter = new OutputStreamWriter((OutputStream)new FileOutputStream(file2), "UTF-8");){
                if ((double)(arrayList.size() - n2) * 1.0 / (double)n < 2.0) {
                    n = arrayList.size() - n2;
                }
                for (int j = 0; j < n; ++j) {
                    outputStreamWriter.write((String)arrayList.get(n2) + "\n");
                    ++n2;
                }
                continue;
            }
        }
    }

    public static void wirteOneSci(CacheWriter writer, String sciName, OutputStreamWriter listWriter) throws Exception {
        boolean bl = writer.ToConfigFile(sciName);
        if (bl) {
            listWriter.write(new File(sciName).getName() + "\n");
        }
    }

    private static Rectangle2D getBounds(PrjCoordSys desprj) {
        Rectangle2D rectangle2D = new Rectangle2D(-180.0, -90.0, 180.0, 90.0);
        if (desprj.getType() != PrjCoordSysType.PCS_EARTH_LONGITUDE_LATITUDE) {
            if (desprj.getProjection().getType() == ProjectionType.PRJ_MERCATOR || desprj.getProjection().getType() == ProjectionType.PRJ_SPHERE_MERCATOR) {
                rectangle2D.setLeft(-2.00489661040146E7);
                rectangle2D.setTop(2.00489661040146E7);
                rectangle2D.setRight(2.00489661040146E7);
                rectangle2D.setBottom(-2.00489661040146E7);
            } else {
                int n;
                Point2Ds point2Ds;
                int n2;
                PrjCoordSys prjCoordSys = new PrjCoordSys(PrjCoordSysType.PCS_EARTH_LONGITUDE_LATITUDE);
                GeoLine geoLine = new GeoLine();
                for (n2 = 90; n2 >= -90; n2 -= 2) {
                    point2Ds = new Point2Ds();
                    for (n = -180; n <= 180; n += 2) {
                        point2Ds.add(new Point2D((double)n, (double)n2));
                    }
                    geoLine.addPart(point2Ds);
                }
                for (n2 = -180; n2 <= 180; n2 += 2) {
                    point2Ds = new Point2Ds();
                    for (n = 90; n >= -90; n -= 2) {
                        point2Ds.add(new Point2D((double)n2, (double)n));
                    }
                    geoLine.addPart(point2Ds);
                }
                CoordSysTranslator.convert((Geometry)geoLine, (PrjCoordSys)prjCoordSys, (PrjCoordSys)desprj, (CoordSysTransParameter)new CoordSysTransParameter(), (CoordSysTransMethod)CoordSysTransMethod.MTH_GEOCENTRIC_TRANSLATION);
                rectangle2D = geoLine.getBounds();
            }
        }
        double d = Math.max(rectangle2D.getWidth(), Math.abs(rectangle2D.getHeight()));
        rectangle2D.setRight(rectangle2D.getRight() + (d - rectangle2D.getWidth()));
        rectangle2D.setBottom(rectangle2D.getBottom() - (d - Math.abs(rectangle2D.getHeight())));
        return rectangle2D;
    }

    private static void buildSpiralTask(Rectangle2D bbox, Rectangle2D baseBounds, double tileResolutionX, double tileResolutionY, double onePixelTolerance, String caption, OutputStreamWriter listWriter) {
        int n;
        double d;
        int n2;
        int n3;
        if (listWriter == null) {
            return;
        }
        int n4 = (int)bbox.getTop();
        int n5 = (int)bbox.getBottom();
        int n6 = (int)bbox.getLeft();
        int n7 = (int)bbox.getRight();
        int n8 = n4;
        int n9 = n8 / 128;
        int n10 = Math.min(n5, (n9 + 1) * 128 - 1);
        int n11 = n6;
        while (n11 <= n7) {
            n3 = n11 / 128;
            n2 = Math.min(n7, (n3 + 1) * 128 - 1);
            double d2 = baseBounds.getLeft() + (double)n11 * tileResolutionX;
            double d3 = baseBounds.getLeft() + (double)(n2 + 1) * tileResolutionX;
            double d4 = baseBounds.getTop() - (double)n8 * tileResolutionY;
            d = baseBounds.getTop() - (double)(n10 + 1) * tileResolutionY;
            if (d3 - d2 > onePixelTolerance && Math.abs(d - d4) > onePixelTolerance) {
                Rectangle2D rectangle2D = new Rectangle2D(d2, d, d3, d4);
                String string = String.format("L%s_R%d_C%d.sci\n", caption, n9, n3);
                try {
                    listWriter.write(string);
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
            }
            n11 = n2 + 1;
        }
        n11 = n5 / 128;
        n3 = n11 * 128;
        n8 = n10 + 1;
        if (n3 < n8) {
            return;
        }
        n2 = Math.min(n5, (n11 + 1) * 128 - 1);
        int n12 = n6;
        while (n12 <= n7) {
            n = n12 / 128;
            int n13 = Math.min(n7, (n + 1) * 128 - 1);
            double d5 = baseBounds.getLeft() + (double)n12 * tileResolutionX;
            double d6 = baseBounds.getLeft() + (double)(n13 + 1) * tileResolutionX;
            double d7 = baseBounds.getTop() - (double)n3 * tileResolutionY;
            double d8 = baseBounds.getTop() - (double)(n2 + 1) * tileResolutionY;
            if (d6 - d5 > onePixelTolerance && Math.abs(d8 - d7) > onePixelTolerance) {
                Rectangle2D rectangle2D = new Rectangle2D(d5, d8, d6, d7);
                String string = String.format("L%s_R%d_C%d.sci\n", caption, n11, n);
                try {
                    listWriter.write(string);
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
            }
            n12 = n13 + 1;
        }
        --n3;
        n12 = n6;
        n = n12 / 128;
        int n14 = Math.min(n7, (n + 1) * 128 - 1);
        int n15 = n8;
        while (n15 <= n3) {
            int n16 = n15 / 128;
            int n17 = Math.min(n3, (n16 + 1) * 128 - 1);
            d = baseBounds.getLeft() + (double)n12 * tileResolutionX;
            double d9 = baseBounds.getLeft() + (double)(n14 + 1) * tileResolutionX;
            double d10 = baseBounds.getTop() - (double)n15 * tileResolutionY;
            double d11 = baseBounds.getTop() - (double)(n17 + 1) * tileResolutionY;
            if (d9 - d > onePixelTolerance && Math.abs(d11 - d10) > onePixelTolerance) {
                Rectangle2D rectangle2D = new Rectangle2D(d, d11, d9, d10);
                String string = String.format("L%s_R%d_C%d.sci\n", caption, n16, n);
                try {
                    listWriter.write(string);
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
            }
            n15 = n17 + 1;
        }
        n15 = n7 / 128;
        int n18 = n15 * 128;
        n12 = n14 + 1;
        if (n18 < n12) {
            return;
        }
        int n19 = Math.min(n7, (n15 + 1) * 128 - 1);
        int n20 = n8;
        while (n20 <= n3) {
            int n21 = n20 / 128;
            int n22 = Math.min(n3, (n21 + 1) * 128 - 1);
            double d12 = baseBounds.getLeft() + (double)n18 * tileResolutionX;
            double d13 = baseBounds.getLeft() + (double)(n19 + 1) * tileResolutionX;
            double d14 = baseBounds.getTop() - (double)n20 * tileResolutionY;
            double d15 = baseBounds.getTop() - (double)(n22 + 1) * tileResolutionY;
            if (d13 - d12 > onePixelTolerance && Math.abs(d15 - d14) > onePixelTolerance) {
                Rectangle2D rectangle2D = new Rectangle2D(d12, d15, d13, d14);
                String string = String.format("L%s_R%d_C%d.sci\n", caption, n21, n15);
                try {
                    listWriter.write(string);
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
            }
            n20 = n22 + 1;
        }
        Rectangle2D rectangle2D = new Rectangle2D((double)n12, (double)n3, (double)(--n18), (double)n8);
        TaskBuilder.buildSpiralTask(rectangle2D, baseBounds, tileResolutionX, tileResolutionY, onePixelTolerance, caption, listWriter);
    }
}

