/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.data.processing;

import com.supermap.License;
import com.supermap.ProductType;
import com.supermap.data.DatasetGrid;
import com.supermap.data.EncodeType;
import com.supermap.data.Environment;
import com.supermap.data.PixelFormat;
import com.supermap.data.PrjCoordSys;
import com.supermap.data.Rectangle2D;
import com.supermap.data.SteppedEvent;
import com.supermap.data.SteppedListener;
import com.supermap.data.processing.CacheBuilderGridTerrainNative;
import com.supermap.data.processing.GridDataType;
import com.supermap.data.processing.GridTerrainCacheInfo;
import com.supermap.data.processing.InternalEnum;
import com.supermap.data.processing.InternalHandle;
import com.supermap.data.processing.InternalHandleDisposable;
import com.supermap.data.processing.InternalResource;
import com.supermap.data.processing.InternalToolkitProcessing;
import com.supermap.data.processing.StorageType;
import java.util.ArrayList;
import java.util.Vector;

public class CacheBuilderGridTerrain
extends InternalHandleDisposable {
    private static License m_license;
    private DatasetGrid m_dataset;
    private long m_selfEventHandle;
    private static String m_senderMethodName;
    transient Vector m_steppedListeners;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void verifyLicense() {
        int n = -1;
        Object object = m_license;
        synchronized (object) {
            n = m_license.verify();
        }
        if (n != 0) {
            object = License.getErrorMessage((int)n);
            throw new IllegalStateException((String)object);
        }
    }

    public CacheBuilderGridTerrain() {
        CacheBuilderGridTerrain.verifyLicense();
        long l = CacheBuilderGridTerrainNative.jni_New();
        this.setHandle(l, true);
        this.m_selfEventHandle = CacheBuilderGridTerrainNative.jni_NewSelfEventHandle(this);
        this.m_dataset = null;
    }

    public synchronized void addSteppedListener(SteppedListener l) {
        if (this.m_steppedListeners == null) {
            this.m_steppedListeners = new Vector();
        }
        if (!this.m_steppedListeners.contains(l)) {
            this.m_steppedListeners.add(l);
        }
    }

    public synchronized void removeSteppedListener(SteppedListener l) {
        if (this.m_steppedListeners != null && this.m_steppedListeners.contains(l)) {
            this.m_steppedListeners.remove(l);
        }
    }

    protected void fireStepped(SteppedEvent event) {
        if (this.m_steppedListeners != null) {
            Vector vector = this.m_steppedListeners;
            int n = vector.size();
            for (int i = 0; i < n; ++i) {
                ((SteppedListener)vector.elementAt(i)).stepped(event);
            }
        }
    }

    static void steppedCallBack(CacheBuilderGridTerrain source, int percent, long remainTime, String title, String message, long cancelHandle) {
        if (source != null) {
            m_senderMethodName = "build";
            boolean bl = InternalToolkitProcessing.getHandleBooleanValue(cancelHandle);
            SteppedEvent steppedEvent = new SteppedEvent((Object)source, percent, remainTime, title, message, m_senderMethodName, bl);
            source.fireStepped(steppedEvent);
            InternalToolkitProcessing.setHandleBooleanValue(cancelHandle, steppedEvent.getCancel());
        }
    }

    protected void clearHandle() {
        if (this.m_dataset != null) {
            this.m_dataset = null;
        }
        this.clearSelfEventHandle();
        this.setHandle(0L);
    }

    private void clearSelfEventHandle() {
        if (this.m_selfEventHandle != 0L) {
            CacheBuilderGridTerrainNative.jni_DeleteSelfEventHandle(this.m_selfEventHandle);
            this.m_selfEventHandle = 0L;
        }
    }

    public void dispose() {
        if (!this.getIsDisposable()) {
            String string = InternalResource.loadString("CacheBuilderGridTerrain", "Handle_UndisposableObject", "processing_resources");
            throw new UnsupportedOperationException(string);
        }
        if (this.getHandle() != 0L) {
            CacheBuilderGridTerrainNative.jni_Delete(this.getHandle());
            this.clearHandle();
        }
    }

    public boolean fromConfigFile(String configPath) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("fromConfigFile", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        return CacheBuilderGridTerrainNative.jni_FromConfigFile(this.getHandle(), configPath);
    }

    public void setBounds(Rectangle2D bounds) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("CacheBuilderGridTerrain", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        if (bounds == null) {
            String string = InternalResource.loadString("bounds", "Global_ArgumentNull", "processing_resources");
            throw new IllegalStateException(string);
        }
        double[] dArray = new double[]{bounds.getLeft(), bounds.getBottom(), bounds.getRight(), bounds.getTop()};
        CacheBuilderGridTerrainNative.jni_SetBounds(this.getHandle(), dArray);
    }

    public void setDataset(DatasetGrid dataset) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("CacheBuilderGridTerrain", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        if (dataset != null && InternalHandle.getHandle((com.supermap.data.InternalHandle)dataset) != 0L) {
            this.m_dataset = dataset;
            CacheBuilderGridTerrainNative.jni_SetDataset(this.getHandle(), InternalHandle.getHandle((com.supermap.data.InternalHandle)dataset));
        }
    }

    public void setOutputFolder(String path) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("CacheBuilderGridTerrain", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        CacheBuilderGridTerrainNative.jni_SetOutputFolder(this.getHandle(), path);
    }

    public void setCacheName(String name) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("CacheBuilderGridTerrain", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        CacheBuilderGridTerrainNative.jni_SetCacheName(this.getHandle(), name);
    }

    public void setBeginLevel(int level) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("CacheBuilderGridTerrain", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        CacheBuilderGridTerrainNative.jni_SetLevelBegin(this.getHandle(), level);
    }

    public void setEndLevel(int level) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("CacheBuilderGridTerrain", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        CacheBuilderGridTerrainNative.jni_SetLevelEnd(this.getHandle(), level);
    }

    public void setSampleSize(int size) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("CacheBuilderGridTerrain", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        CacheBuilderGridTerrainNative.jni_SetSampleSize(this.getHandle(), size);
    }

    public void setStorageType(StorageType type) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("CacheBuilderGridTerrain", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        CacheBuilderGridTerrainNative.jni_SetStorageType(this.getHandle(), type.value());
    }

    void setPixelFormat(PixelFormat pixelFormat) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("CacheBuilderGridTerrain", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        CacheBuilderGridTerrainNative.jni_SetPixelFormat(this.getHandle(), pixelFormat.value());
    }

    void setPrjCoordSys(PrjCoordSys coordSys) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("CacheBuilderGridTerrain", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        long l = InternalHandleDisposable.getHandle((com.supermap.data.InternalHandle)coordSys);
        CacheBuilderGridTerrainNative.jni_SetPrjCoordSys(this.getHandle(), l);
    }

    int[] getDefaultLevel(double resolution) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("CacheBuilderGridTerrain", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        int[] nArray = new int[2];
        CacheBuilderGridTerrainNative.jni_ComputeDefaultLevel(this.getHandle(), resolution, nArray);
        return nArray;
    }

    void setDatasetImage(int width, int height, Rectangle2D bounds, double[] dataArray) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("CacheBuilderGridTerrain", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        if (bounds == null) {
            String string = InternalResource.loadString("bounds", "Global_ArgumentNull", "processing_resources");
            throw new IllegalStateException(string);
        }
        double[] dArray = new double[]{bounds.getLeft(), bounds.getBottom(), bounds.getRight(), bounds.getTop()};
        CacheBuilderGridTerrainNative.jni_SetDatasetImage(this.getHandle(), width, height, dArray, dataArray);
    }

    boolean generateConfigFile() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("CacheBuilderGridTerrain", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        return CacheBuilderGridTerrainNative.jni_GenerateConfigFile(this.getHandle());
    }

    void buildTile(int level, int row, int column) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("CacheBuilderGridTerrain", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        CacheBuilderGridTerrainNative.jni_BuildTile(this.getHandle(), level, row, column);
    }

    public boolean combineTerrainConfigFile(String strOutConfigPathName, String[] arrInPathNames, boolean HasCacheFile) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("combineTerrainConfigFile", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        return CacheBuilderGridTerrainNative.jni_CombineTerrainConfigFile(this.getHandle(), strOutConfigPathName, arrInPathNames, HasCacheFile);
    }

    public byte[] combineTerrainTiles(GridTerrainCacheInfo info, int level, int row, int col) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("combineTerrainTiles", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)info);
        return CacheBuilderGridTerrainNative.jni_CombineTerrainTiles(this.getHandle(), l, level, row, col);
    }

    public void setGridDataType(GridDataType dataType) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("CacheBuilderGridTerrain", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        CacheBuilderGridTerrainNative.jni_SetGridDataType(this.getHandle(), dataType.value());
    }

    public GridDataType getGridDataType() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("CacheBuilderGridTerrain", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        int n = CacheBuilderGridTerrainNative.jni_GetGridDataType(this.getHandle());
        return (GridDataType)InternalEnum.parseUGCValue(GridDataType.class, n);
    }

    public boolean build() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("CacheBuilderGridTerrain", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_dataset == null) {
            String string = InternalResource.loadString("build()", "Global_ArgumentNull", "processing_resources");
            throw new NullPointerException(string);
        }
        if (this.getOutputFolder() == null || this.getOutputFolder().trim().length() == 0 || this.getCacheName() == null || this.getCacheName().trim().length() == 0) {
            String string = InternalResource.loadString("build()", "Global_ArgumentNull", "processing_resources");
            throw new NullPointerException(string);
        }
        return CacheBuilderGridTerrainNative.jni_Build(this.getHandle(), this.m_selfEventHandle);
    }

    public Rectangle2D getBounds() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getBounds", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        double[] dArray = CacheBuilderGridTerrainNative.jni_GetBounds(this.getHandle());
        Rectangle2D rectangle2D = new Rectangle2D(dArray[0], dArray[3], dArray[2], dArray[1]);
        return rectangle2D;
    }

    public DatasetGrid getDataset() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getDataset", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        return this.m_dataset;
    }

    public String getOutputFolder() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getOutputFolder", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        return CacheBuilderGridTerrainNative.jni_GetOutputFolder(this.getHandle());
    }

    public String getCacheName() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getCacheName", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        return CacheBuilderGridTerrainNative.jni_GetCacheName(this.getHandle());
    }

    public int getBeginLevel() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getBeginLevel", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        return CacheBuilderGridTerrainNative.jni_GetBeginLevel(this.getHandle());
    }

    public int getEndLevel() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getEndLevel", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        return CacheBuilderGridTerrainNative.jni_GetEndLevel(this.getHandle());
    }

    public int getSampleSize() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getSampleSize", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        return CacheBuilderGridTerrainNative.jni_GetSampleSize(this.getHandle());
    }

    public StorageType getStorageType() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getStorageType", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        int n = CacheBuilderGridTerrainNative.jni_GetStorageType(this.getHandle());
        switch (n) {
            case 0: {
                return StorageType.Original;
            }
            case 1: {
                return StorageType.Compact;
            }
            case 2: {
                return StorageType.Single;
            }
            case 3: {
                return StorageType.MongoDB;
            }
        }
        return StorageType.GPKG;
    }

    public EncodeType getEncodeType() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getEncodeType", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        int n = CacheBuilderGridTerrainNative.jni_GetEncodeType(this.getHandle());
        return (EncodeType)InternalEnum.parseUGCValue(EncodeType.class, n);
    }

    public void setEncodeType(EncodeType type) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setEncodeType", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        CacheBuilderGridTerrainNative.jni_SetEncodeType(this.getHandle(), type.value());
    }

    public boolean computeLevel() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("computeLevel()", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        return CacheBuilderGridTerrainNative.jni_ComputeLevel(this.getHandle());
    }

    public int getProcessThreadsCount() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getProcessThreadsCount()", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        return CacheBuilderGridTerrainNative.jni_GetProcessThreadsCount(this.getHandle());
    }

    public void setProcessThreadsCount(int threadCount) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setProcessThreadsCount()", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        CacheBuilderGridTerrainNative.jni_SetProcessThreadsCount(this.getHandle(), threadCount);
    }

    public int getBlockScale() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getBlockScale()", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        return CacheBuilderGridTerrainNative.jni_GetBlockScale(this.getHandle());
    }

    public void setBlockScale(int blockScale) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setBlockScale()", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        CacheBuilderGridTerrainNative.jni_SetBlockScale(this.getHandle(), blockScale);
    }

    static {
        Environment.LoadWrapJ();
        ArrayList<ProductType> arrayList = InternalToolkitProcessing.managerProducts(InternalToolkitProcessing.getRealspaceSpatialAnalystProducts());
        m_license = InternalToolkitProcessing.verifyLicense(arrayList);
    }
}

