/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.analyst.networkanalyst;

import com.supermap.analyst.networkanalyst.InternalHandle;
import com.supermap.analyst.networkanalyst.InternalHandleDisposable;
import com.supermap.analyst.networkanalyst.InternalResource;
import com.supermap.analyst.networkanalyst.LocationAnalystParameterNative;
import com.supermap.analyst.networkanalyst.SupplyCenters;

public class LocationAnalystParameter
extends InternalHandleDisposable {
    private SupplyCenters m_supplyCenters = null;
    private String m_nodeDemandField = "NodeDemand";
    private boolean m_isFromCenter;
    private String m_turnWeightField;
    private String m_weightName;
    private int m_expectedSupplyCenterCount;
    private boolean m_isDisposed = false;

    public LocationAnalystParameter() {
        long l = LocationAnalystParameterNative.jni_New();
        this.setHandle(l, true);
        this.reset();
    }

    public LocationAnalystParameter(LocationAnalystParameter parameter) {
        if (parameter == null) {
            String string = InternalResource.loadString("parameter", "Global_ArgumentNull", "networkanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)parameter);
        if (l == 0L) {
            String string = InternalResource.loadString("parameter", "Global_ArgumentObjectHasBeenDisposed", "networkanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        this.reset();
        this.copyFrom(parameter);
    }

    public void setSupplyCenters(SupplyCenters value) {
        if (this.m_isDisposed) {
            String string = InternalResource.loadString("setSupplyCenters(SupplyCenters value)", "Handle_ObjectHasBeenDisposed", "networkanalyst_resources");
            throw new IllegalStateException(string);
        }
        this.m_supplyCenters = new SupplyCenters(value);
    }

    public SupplyCenters getSupplyCenters() {
        if (this.m_isDisposed) {
            String string = InternalResource.loadString("getSupplyCenters()", "Handle_ObjectHasBeenDisposed", "networkanalyst_resources");
            throw new IllegalStateException(string);
        }
        return this.m_supplyCenters;
    }

    public String getNodeDemandField() {
        if (this.m_isDisposed) {
            String string = InternalResource.loadString("GetNodeDemandField()", "Handle_ObjectHasBeenDisposed", "networkanalyst_resources");
            throw new IllegalStateException(string);
        }
        return this.m_nodeDemandField;
    }

    public void setNodeDemandField(String value) {
        if (this.m_isDisposed) {
            String string = InternalResource.loadString("setNodeDemandField(String value)", "Handle_ObjectHasBeenDisposed", "networkanalyst_resources");
            throw new IllegalStateException(string);
        }
        this.m_nodeDemandField = value;
    }

    public int getExpectedSupplyCenterCount() {
        if (this.m_isDisposed) {
            String string = InternalResource.loadString("getExpectedSupplyCenterCount()", "Handle_ObjectHasBeenDisposed", "networkanalyst_resources");
            throw new IllegalStateException(string);
        }
        return this.m_expectedSupplyCenterCount;
    }

    public void setExpectedSupplyCenterCount(int value) {
        if (this.m_isDisposed) {
            String string = InternalResource.loadString("setExpectedSupplyCenterCount(int value)", "Handle_ObjectHasBeenDisposed", "networkanalyst_resources");
            throw new IllegalStateException(string);
        }
        if (value < 0) {
            String string = InternalResource.loadString("ExpectedSupplyCenterCount", "TransportationAnalyst_NodeCountOrPointCountShouldGreaterThanZero", "networkanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        this.m_expectedSupplyCenterCount = value;
    }

    public boolean isFromCenter() {
        if (this.m_isDisposed) {
            String string = InternalResource.loadString("isFromCenter()", "Handle_ObjectHasBeenDisposed", "networkanalyst_resources");
            throw new IllegalStateException(string);
        }
        return this.m_isFromCenter;
    }

    public void setFromCenter(boolean value) {
        if (this.m_isDisposed) {
            String string = InternalResource.loadString("setFromCenter(boolean value)", "Handle_ObjectHasBeenDisposed", "networkanalyst_resources");
            throw new IllegalStateException(string);
        }
        this.m_isFromCenter = value;
    }

    public void setTurnWeightField(String value) {
        if (this.m_isDisposed) {
            String string = InternalResource.loadString("setTurnWeightField(String value)", "Handle_ObjectHasBeenDisposed", "networkanalyst_resources");
            throw new IllegalStateException(string);
        }
        this.m_turnWeightField = value;
    }

    public String getTurnWeightField() {
        if (this.m_isDisposed) {
            String string = InternalResource.loadString("getTurnWeightField()", "Handle_ObjectHasBeenDisposed", "networkanalyst_resources");
            throw new IllegalStateException(string);
        }
        return this.m_turnWeightField;
    }

    public void setWeightName(String value) {
        if (this.m_isDisposed) {
            String string = InternalResource.loadString("setWeightName(String value)", "Handle_ObjectHasBeenDisposed", "networkanalyst_resources");
            throw new IllegalStateException(string);
        }
        this.m_weightName = value;
    }

    public String getWeightName() {
        if (this.m_isDisposed) {
            String string = InternalResource.loadString("getWeightName()", "Handle_ObjectHasBeenDisposed", "networkanalyst_resources");
            throw new IllegalStateException(string);
        }
        return this.m_weightName;
    }

    public void dispose() {
        if (!this.getIsDisposable()) {
            String string = InternalResource.loadString("dispose()", "Handle_UndisposableObject", "networkanalyst_resources");
            throw new UnsupportedOperationException(string);
        }
        if (this.getHandle() != 0L) {
            LocationAnalystParameterNative.jni_Delete(this.getHandle());
            this.setHandle(0L);
            this.m_isDisposed = true;
        }
    }

    void reset() {
        long l = super.getHandle();
        if (l != 0L) {
            LocationAnalystParameterNative.jni_Reset(l);
        }
        this.m_isFromCenter = false;
        this.m_expectedSupplyCenterCount = 0;
        this.m_weightName = "";
        this.m_turnWeightField = "";
        this.m_nodeDemandField = "";
        this.m_supplyCenters = new SupplyCenters();
    }

    void copyFrom(LocationAnalystParameter value) {
        if (value != null) {
            this.setExpectedSupplyCenterCount(value.getExpectedSupplyCenterCount());
            this.setNodeDemandField(value.getNodeDemandField());
            this.setTurnWeightField(value.getTurnWeightField());
            this.setWeightName(value.getWeightName());
            this.setFromCenter(value.isFromCenter());
            this.setSupplyCenters(new SupplyCenters(value.getSupplyCenters()));
        }
    }

    protected long getHandle() {
        long l = super.getHandle();
        if (l != 0L) {
            LocationAnalystParameterNative.jni_setExpectedSupplyCenterCount(l, this.m_expectedSupplyCenterCount);
            LocationAnalystParameterNative.jni_setFromCenter(l, this.m_isFromCenter);
            LocationAnalystParameterNative.jni_setTurnWeightField(l, this.m_turnWeightField);
            LocationAnalystParameterNative.jni_setWeightName(l, this.m_weightName);
        }
        return l;
    }
}

