/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.analyst.spatialanalyst;

import com.supermap.License;
import com.supermap.ProductType;
import com.supermap.analyst.spatialanalyst.GridAnalystSetting;
import com.supermap.analyst.spatialanalyst.InternalDatasetGrid;
import com.supermap.analyst.spatialanalyst.InternalDatasetVector;
import com.supermap.analyst.spatialanalyst.InternalDatasets;
import com.supermap.analyst.spatialanalyst.InternalGeometry;
import com.supermap.analyst.spatialanalyst.InternalHandle;
import com.supermap.analyst.spatialanalyst.InternalResource;
import com.supermap.analyst.spatialanalyst.InternalToolkitSpatialAnalyst;
import com.supermap.analyst.spatialanalyst.ViewShedType;
import com.supermap.analyst.spatialanalyst.VisibilityAnalystNative;
import com.supermap.analyst.spatialanalyst.VisibleResult;
import com.supermap.data.Dataset;
import com.supermap.data.DatasetGrid;
import com.supermap.data.DatasetVector;
import com.supermap.data.Datasource;
import com.supermap.data.GeoLine;
import com.supermap.data.Point3D;
import com.supermap.data.Point3Ds;
import com.supermap.data.SteppedEvent;
import com.supermap.data.SteppedListener;
import java.util.ArrayList;
import java.util.Vector;

public class VisibilityAnalyst {
    private static transient Vector m_steppedListeners;
    private static License m_license;
    private static GridAnalystSetting m_gridAnalystSetting;

    private VisibilityAnalyst() {
        m_gridAnalystSetting = null;
    }

    public static GridAnalystSetting getAnalystSetting() {
        return m_gridAnalystSetting;
    }

    public static void setAnalystSetting(GridAnalystSetting gridAnalystSetting) {
        if (gridAnalystSetting == null) {
            m_gridAnalystSetting = null;
            return;
        }
        if (m_gridAnalystSetting == null) {
            m_gridAnalystSetting = new GridAnalystSetting();
        }
        m_gridAnalystSetting.setBounds(gridAnalystSetting.getBounds());
        m_gridAnalystSetting.setBoundsType(gridAnalystSetting.getBoundsType());
        m_gridAnalystSetting.setCellSizeType(gridAnalystSetting.getCellSizeType());
        m_gridAnalystSetting.setCellSize(gridAnalystSetting.getCellSize());
        m_gridAnalystSetting.setOutputDatasource(gridAnalystSetting.getOutputDatasource());
        m_gridAnalystSetting.setGridOutputNamePrefix(gridAnalystSetting.getGridOutputNamePrefix());
        m_gridAnalystSetting.setVectorOutputNamePrefix(gridAnalystSetting.getVectorOutputNamePrefix());
        m_gridAnalystSetting.setValidRegion(gridAnalystSetting.getValidRegion());
        m_gridAnalystSetting.setShowProgress(gridAnalystSetting.isShowProgress());
    }

    public static VisibleResult isVisible(DatasetGrid sourceDataset, Point3D fromPoint, Point3D toPoint) {
        VisibilityAnalyst.verifyLicense();
        if (sourceDataset == null || InternalHandle.getHandle((com.supermap.data.InternalHandle)sourceDataset) == 0L) {
            String string = InternalResource.loadString("sourceDataset", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new NullPointerException(string);
        }
        long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)sourceDataset);
        double[] dArray = new double[3];
        double[] dArray2 = new double[3];
        dArray[0] = fromPoint.getX();
        dArray[1] = fromPoint.getY();
        dArray[2] = fromPoint.getZ();
        dArray2[0] = toPoint.getX();
        dArray2[1] = toPoint.getY();
        dArray2[2] = toPoint.getZ();
        boolean[] blArray = new boolean[1];
        int[] nArray = new int[2];
        double[] dArray3 = new double[3];
        double[] dArray4 = new double[1];
        VisibilityAnalystNative.jni_IsVisible(l, dArray, dArray2, blArray, nArray, dArray3, dArray4);
        Point3D point3D = new Point3D();
        point3D.setX(dArray3[0]);
        point3D.setY(dArray3[1]);
        point3D.setZ(dArray3[2]);
        VisibleResult visibleResult = new VisibleResult(blArray[0], nArray[0], nArray[1], point3D, dArray4[0]);
        return visibleResult;
    }

    private static DatasetVector lineOfSight(DatasetGrid sourceDataset, Point3D fromPoint, Point3D toPoint, Datasource targetDatasource, String targetDatasetName) {
        VisibilityAnalyst.verifyLicense();
        if (sourceDataset == null || InternalHandle.getHandle((com.supermap.data.InternalHandle)sourceDataset) == 0L) {
            String string = InternalResource.loadString("sourceDataset", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new NullPointerException(string);
        }
        if (targetDatasource == null || InternalHandle.getHandle((com.supermap.data.InternalHandle)targetDatasource) == 0L) {
            targetDatasource = m_gridAnalystSetting != null && m_gridAnalystSetting.getOutputDatasource() != null ? m_gridAnalystSetting.getOutputDatasource() : sourceDataset.getDatasource();
        }
        if (InternalHandle.getHandle((com.supermap.data.InternalHandle)targetDatasource) == 0L) {
            String string = InternalResource.loadString("targetDatasource", "Global_ArgumentObjectHasBeenDisposed", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        if (null == targetDatasetName) {
            String string = InternalResource.loadString("targetDatasetName", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        if (null != m_gridAnalystSetting && null != m_gridAnalystSetting.getVectorOutputNamePrefix()) {
            targetDatasetName = m_gridAnalystSetting.getVectorOutputNamePrefix() + targetDatasetName;
        }
        if (!targetDatasource.getDatasets().isAvailableDatasetName(targetDatasetName)) {
            String string = InternalResource.loadString("targetDatasetName", "GlobalDatasetNameInvalid", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)sourceDataset);
        long l2 = InternalHandle.getHandle((com.supermap.data.InternalHandle)targetDatasource);
        double[] dArray = new double[3];
        double[] dArray2 = new double[3];
        dArray[0] = fromPoint.getX();
        dArray[1] = fromPoint.getY();
        dArray[2] = fromPoint.getZ();
        dArray2[0] = toPoint.getX();
        dArray2[1] = toPoint.getY();
        dArray2[2] = toPoint.getZ();
        long l3 = VisibilityAnalystNative.jni_LineOfSight(l, dArray, dArray2, l2, targetDatasetName);
        DatasetVector datasetVector = null;
        if (l3 != 0L) {
            datasetVector = InternalDatasetVector.createInstance(l3, targetDatasource);
            InternalDatasets.add(targetDatasource.getDatasets(), (Dataset)datasetVector);
        }
        return datasetVector;
    }

    public static GeoLine[] lineOfSight(DatasetGrid sourceDataset, Point3D fromPoint, Point3D toPoint) {
        VisibilityAnalyst.verifyLicense();
        if (sourceDataset == null || InternalHandle.getHandle((com.supermap.data.InternalHandle)sourceDataset) == 0L) {
            String string = InternalResource.loadString("sourceDataset", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new NullPointerException(string);
        }
        double[] dArray = new double[3];
        double[] dArray2 = new double[3];
        dArray[0] = fromPoint.getX();
        dArray[1] = fromPoint.getY();
        dArray[2] = fromPoint.getZ();
        dArray2[0] = toPoint.getX();
        dArray2[1] = toPoint.getY();
        dArray2[2] = toPoint.getZ();
        long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)sourceDataset);
        long[] lArray = VisibilityAnalystNative.jni_LineOfSightGeoLine(l, dArray, dArray2);
        int n = lArray.length;
        GeoLine[] geoLineArray = new GeoLine[n];
        for (int i = 0; i < n; ++i) {
            geoLineArray[i] = (GeoLine)InternalGeometry.createInstance(lArray[i]);
        }
        return geoLineArray;
    }

    public static VisibleResult[] isVisible(DatasetGrid sourceDataset, Point3Ds fromPoints, Point3Ds toPoints) {
        int n;
        VisibilityAnalyst.verifyLicense();
        if (sourceDataset == null || InternalHandle.getHandle((com.supermap.data.InternalHandle)sourceDataset) == 0L) {
            String string = InternalResource.loadString("sourceDataset", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new NullPointerException(string);
        }
        long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)sourceDataset);
        double[] dArray = new double[fromPoints.getCount() * 3];
        double[] dArray2 = new double[toPoints.getCount() * 3];
        for (n = 0; n < fromPoints.getCount(); ++n) {
            dArray[3 * n] = fromPoints.getItem(n).getX();
            dArray[3 * n + 1] = fromPoints.getItem(n).getY();
            dArray[3 * n + 2] = fromPoints.getItem(n).getZ();
        }
        for (n = 0; n < toPoints.getCount(); ++n) {
            dArray2[3 * n] = toPoints.getItem(n).getX();
            dArray2[3 * n + 1] = toPoints.getItem(n).getY();
            dArray2[3 * n + 2] = toPoints.getItem(n).getZ();
        }
        n = fromPoints.getCount() * toPoints.getCount();
        boolean[] blArray = new boolean[n];
        int[] nArray = new int[n * 2];
        double[] dArray3 = new double[n * 3];
        double[] dArray4 = new double[n];
        VisibilityAnalystNative.jni_IsVisible(l, dArray, dArray2, blArray, nArray, dArray3, dArray4);
        VisibleResult[] visibleResultArray = new VisibleResult[n];
        for (int i = 0; i < n; ++i) {
            Point3D point3D = new Point3D();
            point3D.setX(dArray3[3 * i]);
            point3D.setY(dArray3[3 * i + 1]);
            point3D.setZ(dArray3[3 * i + 2]);
            visibleResultArray[i] = new VisibleResult(blArray[i], nArray[2 * i], nArray[2 * i + 1], point3D, dArray4[i]);
        }
        return visibleResultArray;
    }

    public static DatasetGrid calculateViewShed(DatasetGrid sourceDataset, Point3D viewPoint, double startAngle, double viewAngle, double viewRadius, Datasource targetDatasource, String targetDatasetName) {
        VisibilityAnalyst.verifyLicense();
        if (sourceDataset == null || InternalHandle.getHandle((com.supermap.data.InternalHandle)sourceDataset) == 0L) {
            String string = InternalResource.loadString("sourceDataset", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new NullPointerException(string);
        }
        if (targetDatasource == null || InternalHandle.getHandle((com.supermap.data.InternalHandle)targetDatasource) == 0L) {
            targetDatasource = m_gridAnalystSetting != null && m_gridAnalystSetting.getOutputDatasource() != null ? m_gridAnalystSetting.getOutputDatasource() : sourceDataset.getDatasource();
        }
        if (InternalHandle.getHandle((com.supermap.data.InternalHandle)targetDatasource) == 0L) {
            String string = InternalResource.loadString("targetDatasource", "Global_ArgumentObjectHasBeenDisposed", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        if (null == targetDatasetName) {
            String string = InternalResource.loadString("targetDatasetName", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        if (null != m_gridAnalystSetting && null != m_gridAnalystSetting.getGridOutputNamePrefix()) {
            targetDatasetName = m_gridAnalystSetting.getGridOutputNamePrefix() + targetDatasetName;
        }
        if (!targetDatasource.getDatasets().isAvailableDatasetName(targetDatasetName)) {
            String string = InternalResource.loadString("targetDatasetName", "GlobalDatasetNameInvalid", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        boolean bl = false;
        if (null != m_gridAnalystSetting) {
            bl = m_gridAnalystSetting.isShowProgress();
        }
        long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)sourceDataset);
        long l2 = InternalHandle.getHandle((com.supermap.data.InternalHandle)targetDatasource);
        double[] dArray = new double[]{viewPoint.getX(), viewPoint.getY(), viewPoint.getZ()};
        long l3 = VisibilityAnalystNative.jni_CalculateViewShed(l, dArray, startAngle, viewAngle, viewRadius, l2, targetDatasetName, bl);
        DatasetGrid datasetGrid = null;
        if (l3 != 0L) {
            datasetGrid = InternalDatasetGrid.createInstance(l3, targetDatasource);
            InternalDatasets.add(targetDatasource.getDatasets(), (Dataset)datasetGrid);
        }
        return datasetGrid;
    }

    public static DatasetGrid calculateViewShed(DatasetGrid sourceDataset, Point3Ds viewPoints, double[] startAngles, double[] viewAngles, double[] viewRadiuses, Datasource targetDatasource, String targetDatasetName, ViewShedType viewShedType) {
        VisibilityAnalyst.verifyLicense();
        if (sourceDataset == null || InternalHandle.getHandle((com.supermap.data.InternalHandle)sourceDataset) == 0L) {
            String string = InternalResource.loadString("sourceDataset", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new NullPointerException(string);
        }
        if (targetDatasource == null || InternalHandle.getHandle((com.supermap.data.InternalHandle)targetDatasource) == 0L) {
            targetDatasource = m_gridAnalystSetting != null && m_gridAnalystSetting.getOutputDatasource() != null ? m_gridAnalystSetting.getOutputDatasource() : sourceDataset.getDatasource();
        }
        if (InternalHandle.getHandle((com.supermap.data.InternalHandle)targetDatasource) == 0L) {
            String string = InternalResource.loadString("targetDatasource", "Global_ArgumentObjectHasBeenDisposed", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        if (null == targetDatasetName) {
            String string = InternalResource.loadString("targetDatasetName", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        if (null != m_gridAnalystSetting && null != m_gridAnalystSetting.getGridOutputNamePrefix()) {
            targetDatasetName = m_gridAnalystSetting.getGridOutputNamePrefix() + targetDatasetName;
        }
        if (!targetDatasource.getDatasets().isAvailableDatasetName(targetDatasetName)) {
            String string = InternalResource.loadString("targetDatasetName", "GlobalDatasetNameInvalid", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        boolean bl = false;
        if (null != m_gridAnalystSetting) {
            bl = m_gridAnalystSetting.isShowProgress();
        }
        long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)sourceDataset);
        long l2 = InternalHandle.getHandle((com.supermap.data.InternalHandle)targetDatasource);
        double[] dArray = new double[viewPoints.getCount() * 3];
        for (int i = 0; i < viewPoints.getCount(); ++i) {
            dArray[3 * i] = viewPoints.getItem(i).getX();
            dArray[3 * i + 1] = viewPoints.getItem(i).getY();
            dArray[3 * i + 2] = viewPoints.getItem(i).getZ();
        }
        long l3 = VisibilityAnalystNative.jni_CalculateViewShed2(l, dArray, startAngles, viewAngles, viewRadiuses, l2, targetDatasetName, viewShedType.value(), bl);
        DatasetGrid datasetGrid = null;
        if (l3 != 0L) {
            datasetGrid = InternalDatasetGrid.createInstance(l3, targetDatasource);
            InternalDatasets.add(targetDatasource.getDatasets(), (Dataset)datasetGrid);
        }
        return datasetGrid;
    }

    public static synchronized void addSteppedListener(SteppedListener l) {
        if (m_steppedListeners == null) {
            m_steppedListeners = new Vector();
        }
        if (!m_steppedListeners.contains(l)) {
            m_steppedListeners.add(l);
        }
    }

    public static synchronized void removeSteppedListener(SteppedListener l) {
        if (m_steppedListeners != null && m_steppedListeners.contains(l)) {
            m_steppedListeners.remove(l);
        }
    }

    protected static void fireStepped(SteppedEvent event) {
        if (m_steppedListeners != null) {
            Vector vector = m_steppedListeners;
            int n = vector.size();
            for (int i = 0; i < n; ++i) {
                ((SteppedListener)vector.elementAt(i)).stepped(event);
            }
        }
    }

    static void steppedCallBack(int percent, long remainTime, String title, String message, long cancelHandle) {
        String string = "VisibilityAnalyst";
        boolean bl = InternalToolkitSpatialAnalyst.getHandleBooleanValue(cancelHandle);
        Object object = new Object();
        SteppedEvent steppedEvent = new SteppedEvent(object, percent, remainTime, title, message, string);
        VisibilityAnalyst.fireStepped(steppedEvent);
        InternalToolkitSpatialAnalyst.setHandleBooleanValue(cancelHandle, steppedEvent.getCancel());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void verifyLicense() {
        int n = -1;
        Object object = m_license;
        synchronized (object) {
            n = m_license.verify();
        }
        if (n != 0) {
            object = License.getErrorMessage((int)n);
            throw new IllegalStateException((String)object);
        }
    }

    public static DatasetVector radarShieldAngle(DatasetGrid sourceDataset, Point3D viewPoint, double startAngle, double viewAngle, double viewRadius, Datasource targetDatasource, String targetDatasetName, double interval) {
        VisibilityAnalyst.verifyLicense();
        if (viewPoint.getZ() <= 0.0) {
            String string = InternalResource.loadString("viewPoint", "Global_ShouldGreaterThanZero", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        if (interval <= 0.0) {
            String string = InternalResource.loadString("interval", "Global_ShouldGreaterThanZero", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        if (sourceDataset == null || InternalHandle.getHandle((com.supermap.data.InternalHandle)sourceDataset) == 0L) {
            String string = InternalResource.loadString("sourceDataset", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new NullPointerException(string);
        }
        if (targetDatasource == null || InternalHandle.getHandle((com.supermap.data.InternalHandle)targetDatasource) == 0L) {
            targetDatasource = m_gridAnalystSetting != null && m_gridAnalystSetting.getOutputDatasource() != null ? m_gridAnalystSetting.getOutputDatasource() : sourceDataset.getDatasource();
        }
        if (InternalHandle.getHandle((com.supermap.data.InternalHandle)targetDatasource) == 0L) {
            String string = InternalResource.loadString("targetDatasource", "Global_ArgumentObjectHasBeenDisposed", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        if (null == targetDatasetName) {
            String string = InternalResource.loadString("targetDatasetName", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        if (null != m_gridAnalystSetting && null != m_gridAnalystSetting.getGridOutputNamePrefix()) {
            targetDatasetName = m_gridAnalystSetting.getGridOutputNamePrefix() + targetDatasetName;
        }
        if (!targetDatasource.getDatasets().isAvailableDatasetName(targetDatasetName)) {
            String string = InternalResource.loadString("targetDatasetName", "GlobalDatasetNameInvalid", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)sourceDataset);
        long l2 = InternalHandle.getHandle((com.supermap.data.InternalHandle)targetDatasource);
        double[] dArray = new double[]{viewPoint.getX(), viewPoint.getY(), viewPoint.getZ()};
        long l3 = VisibilityAnalystNative.jni_RadarShieldAngle(l, dArray, startAngle, viewAngle, viewRadius, l2, targetDatasetName, interval);
        DatasetVector datasetVector = null;
        if (l3 != 0L) {
            datasetVector = InternalDatasetVector.createInstance(l3, targetDatasource);
            InternalDatasets.add(targetDatasource.getDatasets(), (Dataset)datasetVector);
        }
        return datasetVector;
    }

    public static DatasetVector radarShieldAngle(DatasetGrid[] sourceDatasets, Point3D viewPoint, double startAngle, double viewAngle, double viewRadius, Datasource targetDatasource, String targetDatasetName, double interval) {
        VisibilityAnalyst.verifyLicense();
        if (viewPoint.getZ() <= 0.0) {
            String string = InternalResource.loadString("viewPoint", "Global_ShouldGreaterThanZero", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        if (interval <= 0.0) {
            String string = InternalResource.loadString("interval", "Global_ShouldGreaterThanZero", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        if (sourceDatasets == null) {
            String string = InternalResource.loadString("sourceDatasets", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new NullPointerException(string);
        }
        if (sourceDatasets.length < 2) {
            String string = InternalResource.loadString("sourceDatasets", "DatasetsCountLessThanTwo", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        long[] lArray = new long[sourceDatasets.length];
        for (int i = 0; i < sourceDatasets.length; ++i) {
            if (sourceDatasets[i] == null || InternalHandle.getHandle((com.supermap.data.InternalHandle)sourceDatasets[i]) == 0L) {
                String string = InternalResource.loadString("sourceDatasets", "Global_ArgumentNull", "spatialanalyst_resources");
                throw new NullPointerException(string);
            }
            lArray[i] = InternalHandle.getHandle((com.supermap.data.InternalHandle)sourceDatasets[i]);
        }
        if (targetDatasource == null || InternalHandle.getHandle((com.supermap.data.InternalHandle)targetDatasource) == 0L) {
            String string = InternalResource.loadString("targetDatasource", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new NullPointerException(string);
        }
        if (!targetDatasource.getDatasets().isAvailableDatasetName(targetDatasetName)) {
            String string = InternalResource.loadString("targetDatasetName", "GlobalDatasetNameInvalide", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        if (null == targetDatasetName) {
            String string = InternalResource.loadString("targetDatasetName", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        if (null != m_gridAnalystSetting && null != m_gridAnalystSetting.getGridOutputNamePrefix()) {
            targetDatasetName = m_gridAnalystSetting.getGridOutputNamePrefix() + targetDatasetName;
        }
        long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)targetDatasource);
        double[] dArray = new double[]{viewPoint.getX(), viewPoint.getY(), viewPoint.getZ()};
        long l2 = VisibilityAnalystNative.jni_RadarShieldAngleArr(lArray, dArray, startAngle, viewAngle, viewRadius, l, targetDatasetName, interval);
        DatasetVector datasetVector = null;
        if (l2 != 0L) {
            datasetVector = InternalDatasetVector.createInstance(l2, targetDatasource);
            InternalDatasets.add(targetDatasource.getDatasets(), (Dataset)datasetVector);
        }
        return datasetVector;
    }

    static {
        ArrayList<ProductType> arrayList = InternalToolkitSpatialAnalyst.managerProducts(InternalToolkitSpatialAnalyst.getSpatialAnalystProducts());
        m_license = InternalToolkitSpatialAnalyst.verifyLicense(arrayList);
    }
}

