/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.analyst.spatialanalyst;

import com.supermap.License;
import com.supermap.ProductType;
import com.supermap.analyst.spatialanalyst.InternalEnum;
import com.supermap.analyst.spatialanalyst.InternalGeometry;
import com.supermap.analyst.spatialanalyst.InternalHandle;
import com.supermap.analyst.spatialanalyst.InternalHandleDisposable;
import com.supermap.analyst.spatialanalyst.InternalResource;
import com.supermap.analyst.spatialanalyst.InternalToolkitSpatialAnalyst;
import com.supermap.analyst.spatialanalyst.OverlayAnalystNative;
import com.supermap.analyst.spatialanalyst.OverlayAnalystOutputType;
import com.supermap.analyst.spatialanalyst.OverlayAnalystParameter;
import com.supermap.analyst.spatialanalyst.OverlayResult;
import com.supermap.data.DatasetType;
import com.supermap.data.DatasetVector;
import com.supermap.data.Geometry;
import com.supermap.data.GeometryType;
import com.supermap.data.Recordset;
import com.supermap.data.SteppedEvent;
import com.supermap.data.SteppedListener;
import java.util.ArrayList;
import java.util.Vector;

public class OverlayAnalyst {
    private static License m_license;
    private static transient Vector m_steppedListeners;

    private OverlayAnalyst() {
    }

    public static boolean clip(DatasetVector dataset, DatasetVector clipDataset, DatasetVector resultDataset, OverlayAnalystParameter parameter) {
        OverlayAnalyst.verifyLicense();
        if (dataset == null || InternalHandle.getHandle((com.supermap.data.InternalHandle)dataset) == 0L) {
            String string = InternalResource.loadString("dataset", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new NullPointerException(string);
        }
        long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)dataset);
        if (clipDataset == null || InternalHandle.getHandle((com.supermap.data.InternalHandle)clipDataset) == 0L) {
            String string = InternalResource.loadString("clipDataset", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new NullPointerException(string);
        }
        long l2 = InternalHandle.getHandle((com.supermap.data.InternalHandle)clipDataset);
        if (resultDataset == null || InternalHandle.getHandle((com.supermap.data.InternalHandle)resultDataset) == 0L) {
            String string = InternalResource.loadString("resultDataset", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new NullPointerException(string);
        }
        long l3 = InternalHandle.getHandle((com.supermap.data.InternalHandle)resultDataset);
        if (clipDataset.getType() != DatasetType.REGION) {
            String string = InternalResource.loadString("clipDataset", "OverlayAnalyst_DatsetOrRecordsetTypeInvalidShouldBeRegion", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        if (dataset.getType() != DatasetType.POINT && dataset.getType() != DatasetType.LINE && dataset.getType() != DatasetType.REGION) {
            String string = InternalResource.loadString("dataset", "GlobalUnsportedType", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        if (resultDataset.getType() != dataset.getType()) {
            String string = InternalResource.loadString("", "OverlayAnalyst_ResultDatasetTypeInvalid", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        if (dataset.equals(clipDataset) || l == l2) {
            String string = InternalResource.loadString("", "OverlayAnalyst_SourceDatasetAndOperationDatasetShouldBeDifferent", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        String[] stringArray = null;
        String[] stringArray2 = null;
        double d = 1.0E-10;
        boolean bl = true;
        if (parameter != null) {
            stringArray = parameter.getSourceRetainedFields();
            stringArray2 = parameter.getOperationRetainedFields();
            d = parameter.getTolerance();
            bl = parameter.isSingleResult();
        }
        boolean bl2 = OverlayAnalystNative.jni_DatasetClip(l, l2, l3, stringArray, stringArray2, d, bl);
        InternalHandleDisposable.makeSureNativeObjectLive((Object)dataset);
        InternalHandleDisposable.makeSureNativeObjectLive((Object)clipDataset);
        InternalHandleDisposable.makeSureNativeObjectLive((Object)resultDataset);
        return bl2;
    }

    public static boolean clip(Recordset recordset, Recordset clipRecordset, DatasetVector resultDataset, OverlayAnalystParameter parameter) {
        OverlayAnalyst.verifyLicense();
        if (recordset == null || InternalHandle.getHandle((com.supermap.data.InternalHandle)recordset) == 0L) {
            String string = InternalResource.loadString("recordset", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new NullPointerException(string);
        }
        long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)recordset);
        if (clipRecordset == null || InternalHandle.getHandle((com.supermap.data.InternalHandle)clipRecordset) == 0L) {
            String string = InternalResource.loadString("clipRecordset", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new NullPointerException(string);
        }
        long l2 = InternalHandle.getHandle((com.supermap.data.InternalHandle)clipRecordset);
        if (resultDataset == null || InternalHandle.getHandle((com.supermap.data.InternalHandle)resultDataset) == 0L) {
            String string = InternalResource.loadString("resultDataset", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new NullPointerException(string);
        }
        long l3 = InternalHandle.getHandle((com.supermap.data.InternalHandle)resultDataset);
        if (clipRecordset.getDataset().getType() != DatasetType.REGION) {
            String string = InternalResource.loadString("clipRecordset", "OverlayAnalyst_DatsetOrRecordsetTypeInvalidShouldBeRegion", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        if (recordset.getDataset().getType() != DatasetType.POINT && recordset.getDataset().getType() != DatasetType.LINE && recordset.getDataset().getType() != DatasetType.REGION) {
            String string = InternalResource.loadString("recordset", "GlobalUnsportedType", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        if (resultDataset.getType() != recordset.getDataset().getType()) {
            String string = InternalResource.loadString("", "OverlayAnalyst_ResultDatasetTypeInvalid", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        String[] stringArray = null;
        String[] stringArray2 = null;
        double d = 1.0E-10;
        boolean bl = true;
        if (null != parameter) {
            stringArray = parameter.getSourceRetainedFields();
            stringArray2 = parameter.getOperationRetainedFields();
            d = parameter.getTolerance();
            bl = parameter.isSingleResult();
        }
        boolean bl2 = OverlayAnalystNative.jni_RecordsetClip(l, l2, l3, stringArray, stringArray2, d, bl);
        InternalHandleDisposable.makeSureNativeObjectLive((Object)recordset);
        InternalHandleDisposable.makeSureNativeObjectLive((Object)clipRecordset);
        InternalHandleDisposable.makeSureNativeObjectLive((Object)resultDataset);
        return bl2;
    }

    public static boolean clip(DatasetVector dataset, Geometry[] clipGeometries, DatasetVector resultDataset, OverlayAnalystParameter parameter) {
        OverlayAnalyst.verifyLicense();
        if (dataset == null || InternalHandle.getHandle((com.supermap.data.InternalHandle)dataset) == 0L) {
            String string = InternalResource.loadString("dataset", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new NullPointerException(string);
        }
        if (clipGeometries == null) {
            String string = InternalResource.loadString("clipGeometries", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new NullPointerException(string);
        }
        int n = clipGeometries.length;
        long[] lArray = new long[n];
        for (int i = 0; i < n; ++i) {
            if (clipGeometries[i].getType() != GeometryType.GEOREGION) {
                String string = InternalResource.loadString("clipGeometries", "OverlayAnalyst_GeometryTypeInvalidShouldBeRegion", "spatialanalyst_resources");
                throw new IllegalArgumentException(string);
            }
            long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)clipGeometries[i]);
            if (l == 0L) {
                String string = InternalResource.loadString("clipGeometries", "Global_ArgumentObjectHasBeenDisposed", "spatialanalyst_resources");
                throw new NullPointerException(string);
            }
            lArray[i] = l;
        }
        if (dataset.getType() != DatasetType.POINT && dataset.getType() != DatasetType.LINE && dataset.getType() != DatasetType.REGION) {
            String string = InternalResource.loadString("dataset", "GlobalUnsportedType", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        if (resultDataset == null || InternalHandle.getHandle((com.supermap.data.InternalHandle)resultDataset) == 0L) {
            String string = InternalResource.loadString("resultDataset", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new NullPointerException(string);
        }
        if (resultDataset.getType() != dataset.getType()) {
            String string = InternalResource.loadString("", "OverlayAnalyst_ResultDatasetTypeInvalid", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        String[] stringArray = null;
        String[] stringArray2 = null;
        double d = 1.0E-10;
        boolean bl = true;
        if (parameter != null) {
            stringArray = parameter.getSourceRetainedFields();
            stringArray2 = parameter.getOperationRetainedFields();
            d = parameter.getTolerance();
            bl = parameter.isSingleResult();
        }
        long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)dataset);
        long l2 = InternalHandle.getHandle((com.supermap.data.InternalHandle)resultDataset);
        boolean bl2 = OverlayAnalystNative.jni_GeometryClip(l, lArray, l2, stringArray, stringArray2, d, bl);
        InternalHandleDisposable.makeSureNativeObjectLive((Object)clipGeometries);
        InternalHandleDisposable.makeSureNativeObjectLive((Object)dataset);
        InternalHandleDisposable.makeSureNativeObjectLive((Object)resultDataset);
        return bl2;
    }

    public static OverlayResult[] clip(Geometry[] clipSourceGeometries, Geometry[] clipTargetGeometries, double tolerance) {
        OverlayResult[] overlayResultArray;
        OverlayAnalyst.verifyLicense();
        if (clipSourceGeometries == null) {
            String string = InternalResource.loadString("clipSourceGeometries", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        if (clipTargetGeometries == null) {
            String string = InternalResource.loadString("clipTargetGeometries", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        if (clipSourceGeometries.length == 0) {
            String string = InternalResource.loadString("clipSourceGeometries.length", "GlobalGreaterThanZero", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        if (clipTargetGeometries.length == 0) {
            String string = InternalResource.loadString("clipTargetGeometries.length", "GlobalGreaterThanZero", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        if (clipSourceGeometries[0] == null) {
            String string = InternalResource.loadString("clipSourceGeometries[0]", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        if (clipTargetGeometries[0] == null) {
            String string = InternalResource.loadString("clipTargetGeometries[0]", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        GeometryType geometryType = clipSourceGeometries[0].getType();
        if (geometryType != GeometryType.GEOREGION) {
            String string = InternalResource.loadString("clipSourceGeometries[0]", "OverlayAnalyst_GeometryTypeInvalidShouldBeRegion", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        GeometryType geometryType2 = clipTargetGeometries[0].getType();
        if (geometryType2 != GeometryType.GEOREGION) {
            String string = InternalResource.loadString("clipTargetGeometries[0]", "OverlayAnalyst_GeometryTypeInvalidShouldBeRegion", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        long[] lArray = new long[clipSourceGeometries.length];
        for (int i = 0; i < clipSourceGeometries.length; ++i) {
            Geometry geometry = clipSourceGeometries[i];
            if (geometry == null) {
                String string = InternalResource.loadString(String.format("clipSourceGeometries[%d]", i), "Global_ArgumentNull", "spatialanalyst_resources");
                throw new IllegalArgumentException(string);
            }
            if (geometry.getType() != geometryType) {
                String string = InternalResource.loadString(String.format("clipSourceGeometries[%d]", i), "OverlayAnalyst_GeometryTypeInvalidShouldBeRegion", "spatialanalyst_resources");
                throw new IllegalArgumentException(string);
            }
            lArray[i] = InternalHandle.getHandle((com.supermap.data.InternalHandle)geometry);
        }
        long[] lArray2 = new long[clipTargetGeometries.length];
        for (int i = 0; i < clipTargetGeometries.length; ++i) {
            overlayResultArray = clipTargetGeometries[i];
            if (overlayResultArray == null) {
                String string = InternalResource.loadString(String.format("clipTargetGeometries[%d]", i), "Global_ArgumentNull", "spatialanalyst_resources");
                throw new IllegalArgumentException(string);
            }
            if (overlayResultArray.getType() != geometryType2) {
                String string = InternalResource.loadString(String.format("clipTargetGeometries[%d]", i), "OverlayAnalyst_GeometryTypeInvalidShouldBeRegion", "spatialanalyst_resources");
                throw new IllegalArgumentException(string);
            }
            lArray2[i] = InternalHandle.getHandle((com.supermap.data.InternalHandle)overlayResultArray);
        }
        long[] lArray3 = OverlayAnalystNative.jni_GeometrysClip(lArray, lArray2, tolerance);
        InternalHandleDisposable.makeSureNativeObjectLive((Object)clipSourceGeometries);
        InternalHandleDisposable.makeSureNativeObjectLive((Object)clipTargetGeometries);
        overlayResultArray = null;
        if (lArray3 != null && lArray3.length > 0) {
            int n = lArray3.length / 3;
            int n2 = 0;
            overlayResultArray = new OverlayResult[n];
            for (int i = 0; i < n; ++i) {
                OverlayResult overlayResult;
                overlayResultArray[i] = overlayResult = new OverlayResult(InternalGeometry.createInstance(lArray3[n2++]), (int)lArray3[n2++], (int)lArray3[n2++]);
            }
        }
        return overlayResultArray;
    }

    public static boolean erase(DatasetVector dataset, DatasetVector eraseDataset, DatasetVector resultDataset, OverlayAnalystParameter parameter) {
        OverlayAnalyst.verifyLicense();
        if (dataset == null || InternalHandle.getHandle((com.supermap.data.InternalHandle)dataset) == 0L) {
            String string = InternalResource.loadString("dataset", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new NullPointerException(string);
        }
        long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)dataset);
        if (eraseDataset == null || InternalHandle.getHandle((com.supermap.data.InternalHandle)eraseDataset) == 0L) {
            String string = InternalResource.loadString("eraseDataset", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new NullPointerException(string);
        }
        long l2 = InternalHandle.getHandle((com.supermap.data.InternalHandle)eraseDataset);
        if (resultDataset == null || InternalHandle.getHandle((com.supermap.data.InternalHandle)resultDataset) == 0L) {
            String string = InternalResource.loadString("resultDataset", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new NullPointerException(string);
        }
        long l3 = InternalHandle.getHandle((com.supermap.data.InternalHandle)resultDataset);
        if (eraseDataset.getType() != DatasetType.REGION) {
            String string = InternalResource.loadString("eraseDataset", "OverlayAnalyst_DatsetOrRecordsetTypeInvalidShouldBeRegion", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        if (dataset.getType() != DatasetType.POINT && dataset.getType() != DatasetType.LINE && dataset.getType() != DatasetType.REGION) {
            String string = InternalResource.loadString("dataset", "GlobalUnsportedType", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        if (resultDataset.getType() != dataset.getType()) {
            String string = InternalResource.loadString("", "OverlayAnalyst_ResultDatasetTypeInvalid", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        if (dataset.equals(eraseDataset) || l == l2) {
            String string = InternalResource.loadString("", "OverlayAnalyst_SourceDatasetAndOperationDatasetShouldBeDifferent", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        String[] stringArray = null;
        String[] stringArray2 = null;
        double d = 1.0E-10;
        if (null != parameter) {
            stringArray = parameter.getSourceRetainedFields();
            stringArray2 = parameter.getOperationRetainedFields();
            d = parameter.getTolerance();
        }
        boolean bl = OverlayAnalystNative.jni_DatasetErase(l, l2, l3, stringArray, stringArray2, d);
        InternalHandleDisposable.makeSureNativeObjectLive((Object)dataset);
        InternalHandleDisposable.makeSureNativeObjectLive((Object)eraseDataset);
        InternalHandleDisposable.makeSureNativeObjectLive((Object)resultDataset);
        return bl;
    }

    public static boolean erase(Recordset recordset, Recordset eraseRecordset, DatasetVector resultDataset, OverlayAnalystParameter parameter) {
        OverlayAnalyst.verifyLicense();
        if (recordset == null || InternalHandle.getHandle((com.supermap.data.InternalHandle)recordset) == 0L) {
            String string = InternalResource.loadString("recordset", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new NullPointerException(string);
        }
        long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)recordset);
        if (eraseRecordset == null || InternalHandle.getHandle((com.supermap.data.InternalHandle)eraseRecordset) == 0L) {
            String string = InternalResource.loadString("eraseRecordset", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new NullPointerException(string);
        }
        long l2 = InternalHandle.getHandle((com.supermap.data.InternalHandle)eraseRecordset);
        if (resultDataset == null || InternalHandle.getHandle((com.supermap.data.InternalHandle)resultDataset) == 0L) {
            String string = InternalResource.loadString("resultDataset", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new NullPointerException(string);
        }
        long l3 = InternalHandle.getHandle((com.supermap.data.InternalHandle)resultDataset);
        if (eraseRecordset.getDataset().getType() != DatasetType.REGION) {
            String string = InternalResource.loadString("eraseRecordset", "OverlayAnalyst_DatsetOrRecordsetTypeInvalidShouldBeRegion", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        if (recordset.getDataset().getType() != DatasetType.POINT && recordset.getDataset().getType() != DatasetType.LINE && recordset.getDataset().getType() != DatasetType.REGION) {
            String string = InternalResource.loadString("recordset", "GlobalUnsportedType", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        if (resultDataset.getType() != recordset.getDataset().getType()) {
            String string = InternalResource.loadString("", "OverlayAnalyst_ResultDatasetTypeInvalid", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        String[] stringArray = null;
        String[] stringArray2 = null;
        double d = 1.0E-10;
        if (null != parameter) {
            stringArray = parameter.getSourceRetainedFields();
            stringArray2 = parameter.getOperationRetainedFields();
            d = parameter.getTolerance();
        }
        boolean bl = OverlayAnalystNative.jni_RecordsetErase(l, l2, l3, stringArray, stringArray2, d);
        InternalHandleDisposable.makeSureNativeObjectLive((Object)recordset);
        InternalHandleDisposable.makeSureNativeObjectLive((Object)eraseRecordset);
        InternalHandleDisposable.makeSureNativeObjectLive((Object)resultDataset);
        return bl;
    }

    public static boolean erase(DatasetVector dataset, Geometry[] eraseGeometries, DatasetVector resultDataset, OverlayAnalystParameter parameter) {
        OverlayAnalyst.verifyLicense();
        if (dataset == null || InternalHandle.getHandle((com.supermap.data.InternalHandle)dataset) == 0L) {
            String string = InternalResource.loadString("dataset", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new NullPointerException(string);
        }
        if (eraseGeometries == null) {
            String string = InternalResource.loadString("eraseGeometries", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new NullPointerException(string);
        }
        int n = eraseGeometries.length;
        long[] lArray = new long[n];
        for (int i = 0; i < n; ++i) {
            if (eraseGeometries[i].getType() != GeometryType.GEOREGION) {
                String string = InternalResource.loadString("eraseGeometries", "OverlayAnalyst_GeometryTypeInvalidShouldBeRegion", "spatialanalyst_resources");
                throw new IllegalArgumentException(string);
            }
            long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)eraseGeometries[i]);
            if (l == 0L) {
                String string = InternalResource.loadString("eraseGeometries", "Global_ArgumentObjectHasBeenDisposed", "spatialanalyst_resources");
                throw new NullPointerException(string);
            }
            lArray[i] = l;
        }
        if (dataset.getType() != DatasetType.POINT && dataset.getType() != DatasetType.LINE && dataset.getType() != DatasetType.REGION) {
            String string = InternalResource.loadString("dataset", "GlobalUnsportedType", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        if (resultDataset == null || InternalHandle.getHandle((com.supermap.data.InternalHandle)resultDataset) == 0L) {
            String string = InternalResource.loadString("resultDataset", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new NullPointerException(string);
        }
        if (resultDataset.getType() != dataset.getType()) {
            String string = InternalResource.loadString("resultDataset", "OverlayAnalyst_ResultDatasetTypeInvalid", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        String[] stringArray = null;
        String[] stringArray2 = null;
        double d = 1.0E-10;
        if (null != parameter) {
            stringArray = parameter.getSourceRetainedFields();
            stringArray2 = parameter.getOperationRetainedFields();
            d = parameter.getTolerance();
        }
        long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)dataset);
        long l2 = InternalHandle.getHandle((com.supermap.data.InternalHandle)resultDataset);
        boolean bl = OverlayAnalystNative.jni_GeometryErase(l, lArray, l2, stringArray, stringArray2, d);
        InternalHandleDisposable.makeSureNativeObjectLive((Object)eraseGeometries);
        InternalHandleDisposable.makeSureNativeObjectLive((Object)dataset);
        InternalHandleDisposable.makeSureNativeObjectLive((Object)resultDataset);
        return bl;
    }

    public static OverlayResult[] erase(Geometry[] eraseSourceGeometries, Geometry[] eraseTargetGeometries, double tolerance) {
        OverlayResult[] overlayResultArray;
        OverlayAnalyst.verifyLicense();
        if (eraseSourceGeometries == null) {
            String string = InternalResource.loadString("eraseSourceGeometries", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        if (eraseTargetGeometries == null) {
            String string = InternalResource.loadString("eraseTargetGeometries", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        if (eraseSourceGeometries.length == 0) {
            String string = InternalResource.loadString("eraseSourceGeometries.length", "GlobalGreaterThanZero", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        if (eraseTargetGeometries.length == 0) {
            String string = InternalResource.loadString("eraseTargetGeometries.length", "GlobalGreaterThanZero", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        if (eraseSourceGeometries[0] == null) {
            String string = InternalResource.loadString("eraseSourceGeometries[0]", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        if (eraseTargetGeometries[0] == null) {
            String string = InternalResource.loadString("eraseTargetGeometries[0]", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        GeometryType geometryType = eraseSourceGeometries[0].getType();
        if (geometryType != GeometryType.GEOREGION) {
            String string = InternalResource.loadString("eraseSourceGeometries[0]", "OverlayAnalyst_GeometryTypeInvalidShouldBeRegion", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        GeometryType geometryType2 = eraseTargetGeometries[0].getType();
        if (geometryType2 != GeometryType.GEOREGION) {
            String string = InternalResource.loadString("eraseTargetGeometries[0]", "OverlayAnalyst_GeometryTypeInvalidShouldBeRegion", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        long[] lArray = new long[eraseSourceGeometries.length];
        for (int i = 0; i < eraseSourceGeometries.length; ++i) {
            Geometry geometry = eraseSourceGeometries[i];
            if (geometry == null) {
                String string = InternalResource.loadString(String.format("eraseSourceGeometries[%d]", i), "Global_ArgumentNull", "spatialanalyst_resources");
                throw new IllegalArgumentException(string);
            }
            if (geometry.getType() != geometryType) {
                String string = InternalResource.loadString(String.format("eraseSourceGeometries[%d]", i), "OverlayAnalyst_GeometryTypeInvalidShouldBeRegion", "spatialanalyst_resources");
                throw new IllegalArgumentException(string);
            }
            lArray[i] = InternalHandle.getHandle((com.supermap.data.InternalHandle)geometry);
        }
        long[] lArray2 = new long[eraseTargetGeometries.length];
        for (int i = 0; i < eraseTargetGeometries.length; ++i) {
            overlayResultArray = eraseTargetGeometries[i];
            if (overlayResultArray == null) {
                String string = InternalResource.loadString(String.format("eraseTargetGeometries[%d]", i), "Global_ArgumentNull", "spatialanalyst_resources");
                throw new IllegalArgumentException(string);
            }
            if (overlayResultArray.getType() != geometryType2) {
                String string = InternalResource.loadString(String.format("eraseTargetGeometries[%d]", i), "OverlayAnalyst_GeometryTypeInvalidShouldBeRegion", "spatialanalyst_resources");
                throw new IllegalArgumentException(string);
            }
            lArray2[i] = InternalHandle.getHandle((com.supermap.data.InternalHandle)overlayResultArray);
        }
        long[] lArray3 = OverlayAnalystNative.jni_GeometrysErase(lArray, lArray2, tolerance);
        InternalHandleDisposable.makeSureNativeObjectLive((Object)eraseSourceGeometries);
        InternalHandleDisposable.makeSureNativeObjectLive((Object)eraseTargetGeometries);
        overlayResultArray = null;
        if (lArray3 != null && lArray3.length > 0) {
            int n = lArray3.length / 3;
            int n2 = 0;
            overlayResultArray = new OverlayResult[n];
            for (int i = 0; i < n; ++i) {
                OverlayResult overlayResult;
                overlayResultArray[i] = overlayResult = new OverlayResult(InternalGeometry.createInstance(lArray3[n2++]), (int)lArray3[n2++], (int)lArray3[n2++]);
            }
        }
        return overlayResultArray;
    }

    public static boolean identity(DatasetVector dataset, DatasetVector identityDataset, DatasetVector resultDataset, OverlayAnalystParameter parameter) {
        OverlayAnalyst.verifyLicense();
        if (dataset == null || InternalHandle.getHandle((com.supermap.data.InternalHandle)dataset) == 0L) {
            String string = InternalResource.loadString("dataset", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new NullPointerException(string);
        }
        long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)dataset);
        if (identityDataset == null || InternalHandle.getHandle((com.supermap.data.InternalHandle)identityDataset) == 0L) {
            String string = InternalResource.loadString("identityDataset", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new NullPointerException(string);
        }
        long l2 = InternalHandle.getHandle((com.supermap.data.InternalHandle)identityDataset);
        if (resultDataset == null || InternalHandle.getHandle((com.supermap.data.InternalHandle)resultDataset) == 0L) {
            String string = InternalResource.loadString("resultDataset", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new NullPointerException(string);
        }
        long l3 = InternalHandle.getHandle((com.supermap.data.InternalHandle)resultDataset);
        if (identityDataset.getType() != DatasetType.REGION) {
            String string = InternalResource.loadString("identityDataset", "OverlayAnalyst_DatsetOrRecordsetTypeInvalidShouldBeRegion", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        if (dataset.getType() != DatasetType.POINT && dataset.getType() != DatasetType.LINE && dataset.getType() != DatasetType.REGION) {
            String string = InternalResource.loadString("dataset", "GlobalUnsportedType", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        if (resultDataset.getType() != dataset.getType()) {
            String string = InternalResource.loadString("", "OverlayAnalyst_ResultDatasetTypeInvalid", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        if (dataset.equals(identityDataset) || l == l2) {
            String string = InternalResource.loadString("", "OverlayAnalyst_SourceDatasetAndOperationDatasetShouldBeDifferent", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        String[] stringArray = null;
        String[] stringArray2 = null;
        double d = 1.0E-10;
        boolean bl = true;
        if (null != parameter) {
            stringArray = parameter.getSourceRetainedFields();
            stringArray2 = parameter.getOperationRetainedFields();
            d = parameter.getTolerance();
            bl = parameter.isSingleResult();
        }
        boolean bl2 = OverlayAnalystNative.jni_DatasetIdentity(l, l2, l3, stringArray, stringArray2, d, bl);
        InternalHandleDisposable.makeSureNativeObjectLive((Object)dataset);
        InternalHandleDisposable.makeSureNativeObjectLive((Object)identityDataset);
        InternalHandleDisposable.makeSureNativeObjectLive((Object)resultDataset);
        return bl2;
    }

    public static boolean identity(Recordset recordset, Recordset identityRecordset, DatasetVector resultDataset, OverlayAnalystParameter parameter) {
        OverlayAnalyst.verifyLicense();
        if (recordset == null || InternalHandle.getHandle((com.supermap.data.InternalHandle)recordset) == 0L) {
            String string = InternalResource.loadString("recordset", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new NullPointerException(string);
        }
        long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)recordset);
        if (identityRecordset == null || InternalHandle.getHandle((com.supermap.data.InternalHandle)identityRecordset) == 0L) {
            String string = InternalResource.loadString("identityRecordset", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new NullPointerException(string);
        }
        long l2 = InternalHandle.getHandle((com.supermap.data.InternalHandle)identityRecordset);
        if (resultDataset == null || InternalHandle.getHandle((com.supermap.data.InternalHandle)resultDataset) == 0L) {
            String string = InternalResource.loadString("resultDataset", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new NullPointerException(string);
        }
        long l3 = InternalHandle.getHandle((com.supermap.data.InternalHandle)resultDataset);
        if (identityRecordset.getDataset().getType() != DatasetType.REGION) {
            String string = InternalResource.loadString("identityRecordset", "OverlayAnalyst_DatsetOrRecordsetTypeInvalidShouldBeRegion", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        if (recordset.getDataset().getType() != DatasetType.POINT && recordset.getDataset().getType() != DatasetType.LINE && recordset.getDataset().getType() != DatasetType.REGION) {
            String string = InternalResource.loadString("recordset", "GlobalUnsportedType", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        if (resultDataset.getType() != recordset.getDataset().getType()) {
            String string = InternalResource.loadString("", "OverlayAnalyst_ResultDatasetTypeInvalid", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        String[] stringArray = null;
        String[] stringArray2 = null;
        double d = 1.0E-10;
        boolean bl = true;
        if (null != parameter) {
            stringArray = parameter.getSourceRetainedFields();
            stringArray2 = parameter.getOperationRetainedFields();
            d = parameter.getTolerance();
            bl = parameter.isSingleResult();
        }
        boolean bl2 = OverlayAnalystNative.jni_RecordsetIdentity(l, l2, l3, stringArray, stringArray2, d, bl);
        InternalHandleDisposable.makeSureNativeObjectLive((Object)recordset);
        InternalHandleDisposable.makeSureNativeObjectLive((Object)identityRecordset);
        InternalHandleDisposable.makeSureNativeObjectLive((Object)resultDataset);
        return bl2;
    }

    public static boolean identity(DatasetVector dataset, Geometry[] identityGeometries, DatasetVector resultDataset, OverlayAnalystParameter parameter) {
        OverlayAnalyst.verifyLicense();
        if (dataset == null || InternalHandle.getHandle((com.supermap.data.InternalHandle)dataset) == 0L) {
            String string = InternalResource.loadString("dataset", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new NullPointerException(string);
        }
        if (identityGeometries == null) {
            String string = InternalResource.loadString("identityGeometries", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new NullPointerException(string);
        }
        int n = identityGeometries.length;
        long[] lArray = new long[n];
        for (int i = 0; i < n; ++i) {
            if (identityGeometries[i].getType() != GeometryType.GEOREGION) {
                String string = InternalResource.loadString("identityGeometries", "OverlayAnalyst_GeometryTypeInvalidShouldBeRegion", "spatialanalyst_resources");
                throw new IllegalArgumentException(string);
            }
            long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)identityGeometries[i]);
            if (l == 0L) {
                String string = InternalResource.loadString("identityGeometries", "Global_ArgumentObjectHasBeenDisposed", "spatialanalyst_resources");
                throw new NullPointerException(string);
            }
            lArray[i] = l;
        }
        if (dataset.getType() != DatasetType.POINT && dataset.getType() != DatasetType.LINE && dataset.getType() != DatasetType.REGION) {
            String string = InternalResource.loadString("dataset", "GlobalUnsportedType", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        if (resultDataset == null || InternalHandle.getHandle((com.supermap.data.InternalHandle)resultDataset) == 0L) {
            String string = InternalResource.loadString("resultDataset", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new NullPointerException(string);
        }
        if (resultDataset.getType() != dataset.getType()) {
            String string = InternalResource.loadString("resultDataset", "OverlayAnalyst_ResultDatasetTypeInvalid", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        String[] stringArray = null;
        String[] stringArray2 = null;
        double d = 1.0E-10;
        boolean bl = true;
        if (null != parameter) {
            stringArray = parameter.getSourceRetainedFields();
            stringArray2 = parameter.getOperationRetainedFields();
            d = parameter.getTolerance();
            bl = parameter.isSingleResult();
        }
        long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)dataset);
        long l2 = InternalHandle.getHandle((com.supermap.data.InternalHandle)resultDataset);
        boolean bl2 = OverlayAnalystNative.jni_GeometryIdentity(l, lArray, l2, stringArray, stringArray2, d, bl);
        InternalHandleDisposable.makeSureNativeObjectLive((Object)identityGeometries);
        InternalHandleDisposable.makeSureNativeObjectLive((Object)dataset);
        InternalHandleDisposable.makeSureNativeObjectLive((Object)resultDataset);
        return bl2;
    }

    public static OverlayResult[] identity(Geometry[] identitySourceGeometries, Geometry[] identityTargetGeometries, double tolerance) {
        OverlayResult[] overlayResultArray;
        OverlayAnalyst.verifyLicense();
        if (identitySourceGeometries == null) {
            String string = InternalResource.loadString("identitySourceGeometries", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        if (identityTargetGeometries == null) {
            String string = InternalResource.loadString("identityTargetGeometries", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        if (identitySourceGeometries.length == 0) {
            String string = InternalResource.loadString("identitySourceGeometries.length", "GlobalGreaterThanZero", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        if (identityTargetGeometries.length == 0) {
            String string = InternalResource.loadString("identityTargetGeometries.length", "GlobalGreaterThanZero", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        if (identitySourceGeometries[0] == null) {
            String string = InternalResource.loadString("identitySourceGeometries[0]", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        if (identityTargetGeometries[0] == null) {
            String string = InternalResource.loadString("identityTargetGeometries[0]", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        GeometryType geometryType = identitySourceGeometries[0].getType();
        if (geometryType != GeometryType.GEOREGION) {
            String string = InternalResource.loadString("identitySourceGeometries[0]", "OverlayAnalyst_GeometryTypeInvalidShouldBeRegion", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        GeometryType geometryType2 = identityTargetGeometries[0].getType();
        if (geometryType2 != GeometryType.GEOREGION) {
            String string = InternalResource.loadString("identityTargetGeometries[0]", "OverlayAnalyst_GeometryTypeInvalidShouldBeRegion", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        long[] lArray = new long[identitySourceGeometries.length];
        for (int i = 0; i < identitySourceGeometries.length; ++i) {
            Geometry geometry = identitySourceGeometries[i];
            if (geometry == null) {
                String string = InternalResource.loadString(String.format("identitySourceGeometries[%d]", i), "Global_ArgumentNull", "spatialanalyst_resources");
                throw new IllegalArgumentException(string);
            }
            if (geometry.getType() != geometryType) {
                String string = InternalResource.loadString(String.format("identitySourceGeometries[%d]", i), "OverlayAnalyst_GeometryTypeInvalidShouldBeRegion", "spatialanalyst_resources");
                throw new IllegalArgumentException(string);
            }
            lArray[i] = InternalHandle.getHandle((com.supermap.data.InternalHandle)geometry);
        }
        long[] lArray2 = new long[identityTargetGeometries.length];
        for (int i = 0; i < identityTargetGeometries.length; ++i) {
            overlayResultArray = identityTargetGeometries[i];
            if (overlayResultArray == null) {
                String string = InternalResource.loadString(String.format("identityTargetGeometries[%d]", i), "Global_ArgumentNull", "spatialanalyst_resources");
                throw new IllegalArgumentException(string);
            }
            if (overlayResultArray.getType() != geometryType2) {
                String string = InternalResource.loadString(String.format("identityTargetGeometries[%d]", i), "OverlayAnalyst_GeometryTypeInvalidShouldBeRegion", "spatialanalyst_resources");
                throw new IllegalArgumentException(string);
            }
            lArray2[i] = InternalHandle.getHandle((com.supermap.data.InternalHandle)overlayResultArray);
        }
        long[] lArray3 = OverlayAnalystNative.jni_GeometrysIdentity(lArray, lArray2, tolerance);
        InternalHandleDisposable.makeSureNativeObjectLive((Object)identitySourceGeometries);
        InternalHandleDisposable.makeSureNativeObjectLive((Object)identityTargetGeometries);
        overlayResultArray = null;
        if (lArray3 != null && lArray3.length > 0) {
            int n = lArray3.length / 3;
            int n2 = 0;
            overlayResultArray = new OverlayResult[n];
            for (int i = 0; i < n; ++i) {
                OverlayResult overlayResult;
                overlayResultArray[i] = overlayResult = new OverlayResult(InternalGeometry.createInstance(lArray3[n2++]), (int)lArray3[n2++], (int)lArray3[n2++]);
            }
        }
        return overlayResultArray;
    }

    public static boolean intersect(DatasetVector dataset, DatasetVector intersectDataset, DatasetVector resultDataset, OverlayAnalystParameter parameter) {
        OverlayAnalyst.verifyLicense();
        if (dataset == null || InternalHandle.getHandle((com.supermap.data.InternalHandle)dataset) == 0L) {
            String string = InternalResource.loadString("dataset", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new NullPointerException(string);
        }
        long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)dataset);
        if (intersectDataset == null || InternalHandle.getHandle((com.supermap.data.InternalHandle)intersectDataset) == 0L) {
            String string = InternalResource.loadString("intersectDataset", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new NullPointerException(string);
        }
        long l2 = InternalHandle.getHandle((com.supermap.data.InternalHandle)intersectDataset);
        if (resultDataset == null || InternalHandle.getHandle((com.supermap.data.InternalHandle)resultDataset) == 0L) {
            String string = InternalResource.loadString("resultDataset", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new NullPointerException(string);
        }
        long l3 = InternalHandle.getHandle((com.supermap.data.InternalHandle)resultDataset);
        if (intersectDataset.getType() != DatasetType.REGION) {
            String string = InternalResource.loadString("intersectDataset", "OverlayAnalyst_DatsetOrRecordsetTypeInvalidShouldBeRegion", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        if (dataset.getType() != DatasetType.POINT && dataset.getType() != DatasetType.LINE && dataset.getType() != DatasetType.REGION) {
            String string = InternalResource.loadString("dataset", "GlobalUnsportedType", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        if (parameter.getOutputType() == OverlayAnalystOutputType.POINT) {
            if (resultDataset.getType() != DatasetType.POINT) {
                String string = InternalResource.loadString("resultDataset", "OverlayAnalyst_ResultDatasetTypeInvalid", "spatialanalyst_resources");
                throw new IllegalArgumentException(string);
            }
        } else if (resultDataset.getType() != dataset.getType()) {
            String string = InternalResource.loadString("", "OverlayAnalyst_ResultDatasetTypeInvalid", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        if (dataset.equals(intersectDataset) || l == l2) {
            String string = InternalResource.loadString("", "OverlayAnalyst_SourceDatasetAndOperationDatasetShouldBeDifferent", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        String[] stringArray = null;
        String[] stringArray2 = null;
        double d = 1.0E-10;
        int n = 0;
        boolean bl = true;
        if (null != parameter) {
            stringArray = parameter.getSourceRetainedFields();
            stringArray2 = parameter.getOperationRetainedFields();
            d = parameter.getTolerance();
            n = InternalEnum.getUGCValue(parameter.getOutputType());
            bl = parameter.isSingleResult();
        }
        boolean bl2 = OverlayAnalystNative.jni_DatasetIntersect1(l, l2, l3, stringArray, stringArray2, d, n, bl);
        InternalHandleDisposable.makeSureNativeObjectLive((Object)dataset);
        InternalHandleDisposable.makeSureNativeObjectLive((Object)intersectDataset);
        InternalHandleDisposable.makeSureNativeObjectLive((Object)resultDataset);
        return bl2;
    }

    public static boolean intersect(Recordset recordset, Recordset intersectRecordset, DatasetVector resultDataset, OverlayAnalystParameter parameter) {
        OverlayAnalyst.verifyLicense();
        if (recordset == null || InternalHandle.getHandle((com.supermap.data.InternalHandle)recordset) == 0L) {
            String string = InternalResource.loadString("recordset", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new NullPointerException(string);
        }
        long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)recordset);
        if (intersectRecordset == null || InternalHandle.getHandle((com.supermap.data.InternalHandle)intersectRecordset) == 0L) {
            String string = InternalResource.loadString("intersectRecordset", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new NullPointerException(string);
        }
        long l2 = InternalHandle.getHandle((com.supermap.data.InternalHandle)intersectRecordset);
        if (resultDataset == null || InternalHandle.getHandle((com.supermap.data.InternalHandle)resultDataset) == 0L) {
            String string = InternalResource.loadString("resultDataset", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new NullPointerException(string);
        }
        long l3 = InternalHandle.getHandle((com.supermap.data.InternalHandle)resultDataset);
        if (intersectRecordset.getDataset().getType() != DatasetType.REGION) {
            String string = InternalResource.loadString("intersectRecordset", "OverlayAnalyst_DatsetOrRecordsetTypeInvalidShouldBeRegion", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        if (recordset.getDataset().getType() != DatasetType.POINT && recordset.getDataset().getType() != DatasetType.LINE && recordset.getDataset().getType() != DatasetType.REGION) {
            String string = InternalResource.loadString("recordset", "GlobalUnsportedType", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        if (resultDataset.getType() != recordset.getDataset().getType()) {
            String string = InternalResource.loadString("", "OverlayAnalyst_ResultDatasetTypeInvalid", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        String[] stringArray = null;
        String[] stringArray2 = null;
        double d = 1.0E-10;
        int n = 0;
        boolean bl = true;
        if (null != parameter) {
            stringArray = parameter.getSourceRetainedFields();
            stringArray2 = parameter.getOperationRetainedFields();
            d = parameter.getTolerance();
            n = InternalEnum.getUGCValue(parameter.getOutputType());
            bl = parameter.isSingleResult();
        }
        boolean bl2 = OverlayAnalystNative.jni_RecordsetIntersect(l, l2, l3, stringArray, stringArray2, d, n, bl);
        InternalHandleDisposable.makeSureNativeObjectLive((Object)intersectRecordset);
        InternalHandleDisposable.makeSureNativeObjectLive((Object)recordset);
        InternalHandleDisposable.makeSureNativeObjectLive((Object)resultDataset);
        return bl2;
    }

    public static boolean intersect(DatasetVector dataset, Geometry[] intersectGeometries, DatasetVector resultDataset, OverlayAnalystParameter parameter) {
        OverlayAnalyst.verifyLicense();
        if (dataset == null || InternalHandle.getHandle((com.supermap.data.InternalHandle)dataset) == 0L) {
            String string = InternalResource.loadString("dataset", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new NullPointerException(string);
        }
        if (intersectGeometries == null) {
            String string = InternalResource.loadString("intersectGeometries", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new NullPointerException(string);
        }
        int n = intersectGeometries.length;
        long[] lArray = new long[n];
        for (int i = 0; i < n; ++i) {
            if (intersectGeometries[i].getType() != GeometryType.GEOREGION) {
                String string = InternalResource.loadString("intersectGeometries", "OverlayAnalyst_GeometryTypeInvalidShouldBeRegion", "spatialanalyst_resources");
                throw new IllegalArgumentException(string);
            }
            long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)intersectGeometries[i]);
            if (l == 0L) {
                String string = InternalResource.loadString("intersectGeometries", "Global_ArgumentObjectHasBeenDisposed", "spatialanalyst_resources");
                throw new NullPointerException(string);
            }
            lArray[i] = l;
        }
        if (dataset.getType() != DatasetType.POINT && dataset.getType() != DatasetType.LINE && dataset.getType() != DatasetType.REGION) {
            String string = InternalResource.loadString("dataset", "GlobalUnsportedType", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        if (resultDataset == null || InternalHandle.getHandle((com.supermap.data.InternalHandle)resultDataset) == 0L) {
            String string = InternalResource.loadString("resultDataset", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new NullPointerException(string);
        }
        if (resultDataset.getType() != dataset.getType()) {
            String string = InternalResource.loadString("resultDataset", "OverlayAnalyst_ResultDatasetTypeInvalid", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        String[] stringArray = null;
        String[] stringArray2 = null;
        double d = 1.0E-10;
        int n2 = 0;
        boolean bl = true;
        if (parameter != null) {
            stringArray = parameter.getSourceRetainedFields();
            stringArray2 = parameter.getOperationRetainedFields();
            d = parameter.getTolerance();
            n2 = InternalEnum.getUGCValue(parameter.getOutputType());
            bl = parameter.isSingleResult();
        }
        long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)dataset);
        long l2 = InternalHandle.getHandle((com.supermap.data.InternalHandle)resultDataset);
        boolean bl2 = OverlayAnalystNative.jni_GeometryIntersect(l, lArray, l2, stringArray, stringArray2, d, n2, bl);
        InternalHandleDisposable.makeSureNativeObjectLive((Object)intersectGeometries);
        InternalHandleDisposable.makeSureNativeObjectLive((Object)dataset);
        InternalHandleDisposable.makeSureNativeObjectLive((Object)resultDataset);
        return bl2;
    }

    public static OverlayResult[] intersect(Geometry[] intersectSourceGeometries, Geometry[] intersectTargetGeometries, double tolerance) {
        OverlayResult[] overlayResultArray;
        OverlayAnalyst.verifyLicense();
        if (intersectSourceGeometries == null) {
            String string = InternalResource.loadString("intersectSourceGeometries", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        if (intersectTargetGeometries == null) {
            String string = InternalResource.loadString("intersectTargetGeometries", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        if (intersectSourceGeometries.length == 0) {
            String string = InternalResource.loadString("intersectSourceGeometries.length", "GlobalGreaterThanZero", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        if (intersectTargetGeometries.length == 0) {
            String string = InternalResource.loadString("intersectTargetGeometries.length", "GlobalGreaterThanZero", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        if (intersectSourceGeometries[0] == null) {
            String string = InternalResource.loadString("intersectSourceGeometries[0]", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        if (intersectTargetGeometries[0] == null) {
            String string = InternalResource.loadString("intersectTargetGeometries[0]", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        GeometryType geometryType = intersectSourceGeometries[0].getType();
        if (geometryType != GeometryType.GEOREGION) {
            String string = InternalResource.loadString("intersectSourceGeometries[0]", "OverlayAnalyst_GeometryTypeInvalidShouldBeRegion", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        GeometryType geometryType2 = intersectTargetGeometries[0].getType();
        if (geometryType2 != GeometryType.GEOREGION) {
            String string = InternalResource.loadString("intersectTargetGeometries[0]", "OverlayAnalyst_GeometryTypeInvalidShouldBeRegion", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        long[] lArray = new long[intersectSourceGeometries.length];
        for (int i = 0; i < intersectSourceGeometries.length; ++i) {
            Geometry geometry = intersectSourceGeometries[i];
            if (geometry == null) {
                String string = InternalResource.loadString(String.format("intersectSourceGeometries[%d]", i), "Global_ArgumentNull", "spatialanalyst_resources");
                throw new IllegalArgumentException(string);
            }
            if (geometry.getType() != geometryType) {
                String string = InternalResource.loadString(String.format("intersectSourceGeometries[%d]", i), "OverlayAnalyst_GeometryTypeInvalidShouldBeRegion", "spatialanalyst_resources");
                throw new IllegalArgumentException(string);
            }
            lArray[i] = InternalHandle.getHandle((com.supermap.data.InternalHandle)geometry);
        }
        long[] lArray2 = new long[intersectTargetGeometries.length];
        for (int i = 0; i < intersectTargetGeometries.length; ++i) {
            overlayResultArray = intersectTargetGeometries[i];
            if (overlayResultArray == null) {
                String string = InternalResource.loadString(String.format("intersectTargetGeometries[%d]", i), "Global_ArgumentNull", "spatialanalyst_resources");
                throw new IllegalArgumentException(string);
            }
            if (overlayResultArray.getType() != geometryType2) {
                String string = InternalResource.loadString(String.format("intersectTargetGeometries[%d]", i), "OverlayAnalyst_GeometryTypeInvalidShouldBeRegion", "spatialanalyst_resources");
                throw new IllegalArgumentException(string);
            }
            lArray2[i] = InternalHandle.getHandle((com.supermap.data.InternalHandle)overlayResultArray);
        }
        long[] lArray3 = OverlayAnalystNative.jni_GeometrysIntersect(lArray, lArray2, tolerance);
        InternalHandleDisposable.makeSureNativeObjectLive((Object)intersectSourceGeometries);
        InternalHandleDisposable.makeSureNativeObjectLive((Object)intersectTargetGeometries);
        overlayResultArray = null;
        if (lArray3 != null && lArray3.length > 0) {
            int n = lArray3.length / 3;
            int n2 = 0;
            overlayResultArray = new OverlayResult[n];
            for (int i = 0; i < n; ++i) {
                OverlayResult overlayResult;
                overlayResultArray[i] = overlayResult = new OverlayResult(InternalGeometry.createInstance(lArray3[n2++]), (int)lArray3[n2++], (int)lArray3[n2++]);
            }
        }
        return overlayResultArray;
    }

    public static boolean xOR(DatasetVector dataset, DatasetVector xORDataset, DatasetVector resultDataset, OverlayAnalystParameter parameter) {
        OverlayAnalyst.verifyLicense();
        if (dataset == null || InternalHandle.getHandle((com.supermap.data.InternalHandle)dataset) == 0L) {
            String string = InternalResource.loadString("dataset", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new NullPointerException(string);
        }
        long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)dataset);
        if (xORDataset == null || InternalHandle.getHandle((com.supermap.data.InternalHandle)xORDataset) == 0L) {
            String string = InternalResource.loadString("xORDataset", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new NullPointerException(string);
        }
        long l2 = InternalHandle.getHandle((com.supermap.data.InternalHandle)xORDataset);
        if (resultDataset == null || InternalHandle.getHandle((com.supermap.data.InternalHandle)resultDataset) == 0L) {
            String string = InternalResource.loadString("resultDataset", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new NullPointerException(string);
        }
        long l3 = InternalHandle.getHandle((com.supermap.data.InternalHandle)resultDataset);
        if (dataset.getType() != DatasetType.REGION) {
            String string = InternalResource.loadString("dataset", "OverlayAnalyst_DatsetOrRecordsetTypeInvalidShouldBeRegion", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        if (xORDataset.getType() != DatasetType.REGION) {
            String string = InternalResource.loadString("xORDataset", "OverlayAnalyst_DatsetOrRecordsetTypeInvalidShouldBeRegion", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        if (resultDataset.getType() != dataset.getType()) {
            String string = InternalResource.loadString("", "OverlayAnalyst_ResultDatasetTypeInvalid", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        if (dataset.equals(xORDataset) || l == l2) {
            String string = InternalResource.loadString("", "OverlayAnalyst_SourceDatasetAndOperationDatasetShouldBeDifferent", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        String[] stringArray = null;
        String[] stringArray2 = null;
        double d = 1.0E-10;
        if (null != parameter) {
            stringArray = parameter.getSourceRetainedFields();
            stringArray2 = parameter.getOperationRetainedFields();
            d = parameter.getTolerance();
        }
        boolean bl = OverlayAnalystNative.jni_DatasetXOR(l, l2, l3, stringArray, stringArray2, d);
        InternalHandleDisposable.makeSureNativeObjectLive((Object)dataset);
        InternalHandleDisposable.makeSureNativeObjectLive((Object)xORDataset);
        InternalHandleDisposable.makeSureNativeObjectLive((Object)resultDataset);
        return bl;
    }

    public static boolean xOR(Recordset recordset, Recordset xORRecordset, DatasetVector resultDataset, OverlayAnalystParameter parameter) {
        OverlayAnalyst.verifyLicense();
        if (recordset == null || InternalHandle.getHandle((com.supermap.data.InternalHandle)recordset) == 0L) {
            String string = InternalResource.loadString("recordset", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new NullPointerException(string);
        }
        long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)recordset);
        if (xORRecordset == null || InternalHandle.getHandle((com.supermap.data.InternalHandle)xORRecordset) == 0L) {
            String string = InternalResource.loadString("xORRecordset", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new NullPointerException(string);
        }
        long l2 = InternalHandle.getHandle((com.supermap.data.InternalHandle)xORRecordset);
        if (resultDataset == null || InternalHandle.getHandle((com.supermap.data.InternalHandle)resultDataset) == 0L) {
            String string = InternalResource.loadString("resultDataset", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new NullPointerException(string);
        }
        long l3 = InternalHandle.getHandle((com.supermap.data.InternalHandle)resultDataset);
        if (recordset.getDataset().getType() != DatasetType.REGION) {
            String string = InternalResource.loadString("dataset", "OverlayAnalyst_DatsetOrRecordsetTypeInvalidShouldBeRegion", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        if (xORRecordset.getDataset().getType() != DatasetType.REGION) {
            String string = InternalResource.loadString("xORRecordset", "OverlayAnalyst_DatsetOrRecordsetTypeInvalidShouldBeRegion", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        if (resultDataset.getType() != recordset.getDataset().getType()) {
            String string = InternalResource.loadString("", "OverlayAnalyst_ResultDatasetTypeInvalid", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        String[] stringArray = null;
        String[] stringArray2 = null;
        double d = 1.0E-10;
        if (parameter != null) {
            stringArray = parameter.getSourceRetainedFields();
            stringArray2 = parameter.getOperationRetainedFields();
            d = parameter.getTolerance();
        }
        boolean bl = OverlayAnalystNative.jni_RecordsetXOR(l, l2, l3, stringArray, stringArray2, d);
        InternalHandleDisposable.makeSureNativeObjectLive((Object)recordset);
        InternalHandleDisposable.makeSureNativeObjectLive((Object)xORRecordset);
        InternalHandleDisposable.makeSureNativeObjectLive((Object)resultDataset);
        return bl;
    }

    public static boolean xOR(DatasetVector dataset, Geometry[] xorGeometries, DatasetVector resultDataset, OverlayAnalystParameter parameter) {
        OverlayAnalyst.verifyLicense();
        if (dataset == null || InternalHandle.getHandle((com.supermap.data.InternalHandle)dataset) == 0L) {
            String string = InternalResource.loadString("dataset", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new NullPointerException(string);
        }
        if (xorGeometries == null) {
            String string = InternalResource.loadString("xorGeometries", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new NullPointerException(string);
        }
        int n = xorGeometries.length;
        long[] lArray = new long[n];
        for (int i = 0; i < n; ++i) {
            if (xorGeometries[i].getType() != GeometryType.GEOREGION) {
                String string = InternalResource.loadString("xorGeometries", "OverlayAnalyst_GeometryTypeInvalidShouldBeRegion", "spatialanalyst_resources");
                throw new IllegalArgumentException(string);
            }
            long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)xorGeometries[i]);
            if (l == 0L) {
                String string = InternalResource.loadString("xorGeometries", "Global_ArgumentObjectHasBeenDisposed", "spatialanalyst_resources");
                throw new NullPointerException(string);
            }
            lArray[i] = l;
        }
        if (dataset.getType() != DatasetType.REGION) {
            String string = InternalResource.loadString("dataset", "OverlayAnalyst_DatsetOrRecordsetTypeInvalidShouldBeRegion", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        if (resultDataset == null || InternalHandle.getHandle((com.supermap.data.InternalHandle)resultDataset) == 0L) {
            String string = InternalResource.loadString("resultDataset", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new NullPointerException(string);
        }
        if (resultDataset.getType() != dataset.getType()) {
            String string = InternalResource.loadString("resultDataset", "OverlayAnalyst_ResultDatasetTypeInvalid", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        String[] stringArray = null;
        String[] stringArray2 = null;
        double d = 1.0E-10;
        if (parameter != null) {
            stringArray = parameter.getSourceRetainedFields();
            stringArray2 = parameter.getOperationRetainedFields();
            d = parameter.getTolerance();
        }
        long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)dataset);
        long l2 = InternalHandle.getHandle((com.supermap.data.InternalHandle)resultDataset);
        boolean bl = OverlayAnalystNative.jni_GeometryXOR(l, lArray, l2, stringArray, stringArray2, d);
        InternalHandleDisposable.makeSureNativeObjectLive((Object)xorGeometries);
        InternalHandleDisposable.makeSureNativeObjectLive((Object)dataset);
        InternalHandleDisposable.makeSureNativeObjectLive((Object)resultDataset);
        return bl;
    }

    public static OverlayResult[] xOR(Geometry[] xORSourceGeometries, Geometry[] xORTargetGeometries, double tolerance) {
        OverlayResult[] overlayResultArray;
        OverlayAnalyst.verifyLicense();
        if (xORSourceGeometries == null) {
            String string = InternalResource.loadString("xORSourceGeometries", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        if (xORTargetGeometries == null) {
            String string = InternalResource.loadString("xORTargetGeometries", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        if (xORSourceGeometries.length == 0) {
            String string = InternalResource.loadString("xORSourceGeometries.length", "GlobalGreaterThanZero", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        if (xORTargetGeometries.length == 0) {
            String string = InternalResource.loadString("xORTargetGeometries.length", "GlobalGreaterThanZero", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        if (xORSourceGeometries[0] == null) {
            String string = InternalResource.loadString("xORSourceGeometries[0]", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        if (xORTargetGeometries[0] == null) {
            String string = InternalResource.loadString("xORTargetGeometries[0]", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        GeometryType geometryType = xORSourceGeometries[0].getType();
        if (geometryType != GeometryType.GEOREGION) {
            String string = InternalResource.loadString("xORSourceGeometries[0]", "OverlayAnalyst_GeometryTypeInvalidShouldBeRegion", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        GeometryType geometryType2 = xORTargetGeometries[0].getType();
        if (geometryType2 != GeometryType.GEOREGION) {
            String string = InternalResource.loadString("xORTargetGeometries[0]", "OverlayAnalyst_GeometryTypeInvalidShouldBeRegion", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        long[] lArray = new long[xORSourceGeometries.length];
        for (int i = 0; i < xORSourceGeometries.length; ++i) {
            Geometry geometry = xORSourceGeometries[i];
            if (geometry == null) {
                String string = InternalResource.loadString(String.format("xORSourceGeometries[%d]", i), "Global_ArgumentNull", "spatialanalyst_resources");
                throw new IllegalArgumentException(string);
            }
            if (geometry.getType() != geometryType) {
                String string = InternalResource.loadString(String.format("xORSourceGeometries[%d]", i), "OverlayAnalyst_GeometryTypeInvalidShouldBeRegion", "spatialanalyst_resources");
                throw new IllegalArgumentException(string);
            }
            lArray[i] = InternalHandle.getHandle((com.supermap.data.InternalHandle)geometry);
        }
        long[] lArray2 = new long[xORTargetGeometries.length];
        for (int i = 0; i < xORTargetGeometries.length; ++i) {
            overlayResultArray = xORTargetGeometries[i];
            if (overlayResultArray == null) {
                String string = InternalResource.loadString(String.format("xORTargetGeometries[%d]", i), "Global_ArgumentNull", "spatialanalyst_resources");
                throw new IllegalArgumentException(string);
            }
            if (overlayResultArray.getType() != geometryType2) {
                String string = InternalResource.loadString(String.format("xORTargetGeometries[%d]", i), "OverlayAnalyst_GeometryTypeInvalidShouldBeRegion", "spatialanalyst_resources");
                throw new IllegalArgumentException(string);
            }
            lArray2[i] = InternalHandle.getHandle((com.supermap.data.InternalHandle)overlayResultArray);
        }
        long[] lArray3 = OverlayAnalystNative.jni_GeometrysXOR(lArray, lArray2, tolerance);
        InternalHandleDisposable.makeSureNativeObjectLive((Object)xORSourceGeometries);
        InternalHandleDisposable.makeSureNativeObjectLive((Object)xORTargetGeometries);
        overlayResultArray = null;
        if (lArray3 != null && lArray3.length > 0) {
            int n = lArray3.length / 3;
            int n2 = 0;
            overlayResultArray = new OverlayResult[n];
            for (int i = 0; i < n; ++i) {
                OverlayResult overlayResult;
                overlayResultArray[i] = overlayResult = new OverlayResult(InternalGeometry.createInstance(lArray3[n2++]), (int)lArray3[n2++], (int)lArray3[n2++]);
            }
        }
        return overlayResultArray;
    }

    public static boolean union(DatasetVector dataset, DatasetVector unionDataset, DatasetVector resultDataset, OverlayAnalystParameter parameter) {
        OverlayAnalyst.verifyLicense();
        if (dataset == null || InternalHandle.getHandle((com.supermap.data.InternalHandle)dataset) == 0L) {
            String string = InternalResource.loadString("dataset", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new NullPointerException(string);
        }
        long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)dataset);
        if (unionDataset == null || InternalHandle.getHandle((com.supermap.data.InternalHandle)unionDataset) == 0L) {
            String string = InternalResource.loadString("unionDataset", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new NullPointerException(string);
        }
        long l2 = InternalHandle.getHandle((com.supermap.data.InternalHandle)unionDataset);
        if (resultDataset == null || InternalHandle.getHandle((com.supermap.data.InternalHandle)resultDataset) == 0L) {
            String string = InternalResource.loadString("resultDataset", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new NullPointerException(string);
        }
        long l3 = InternalHandle.getHandle((com.supermap.data.InternalHandle)resultDataset);
        if (dataset.getType() != DatasetType.REGION) {
            String string = InternalResource.loadString("dataset", "OverlayAnalyst_DatsetOrRecordsetTypeInvalidShouldBeRegion", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        if (unionDataset.getType() != DatasetType.REGION) {
            String string = InternalResource.loadString("unionDataset", "OverlayAnalyst_DatsetOrRecordsetTypeInvalidShouldBeRegion", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        if (resultDataset.getType() != dataset.getType()) {
            String string = InternalResource.loadString("", "OverlayAnalyst_ResultDatasetTypeInvalid", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        if (dataset.equals(unionDataset) || l == l2) {
            String string = InternalResource.loadString("", "OverlayAnalyst_SourceDatasetAndOperationDatasetShouldBeDifferent", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        String[] stringArray = null;
        String[] stringArray2 = null;
        double d = 1.0E-10;
        if (null != parameter) {
            stringArray = parameter.getSourceRetainedFields();
            stringArray2 = parameter.getOperationRetainedFields();
            d = parameter.getTolerance();
        }
        boolean bl = OverlayAnalystNative.jni_DatasetUnion(l, l2, l3, stringArray, stringArray2, d);
        InternalHandleDisposable.makeSureNativeObjectLive((Object)dataset);
        InternalHandleDisposable.makeSureNativeObjectLive((Object)unionDataset);
        InternalHandleDisposable.makeSureNativeObjectLive((Object)resultDataset);
        return bl;
    }

    public static boolean union(Recordset recordset, Recordset unionRecordset, DatasetVector resultDataset, OverlayAnalystParameter parameter) {
        OverlayAnalyst.verifyLicense();
        if (recordset == null || InternalHandle.getHandle((com.supermap.data.InternalHandle)recordset) == 0L) {
            String string = InternalResource.loadString("recordset", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new NullPointerException(string);
        }
        long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)recordset);
        if (unionRecordset == null || InternalHandle.getHandle((com.supermap.data.InternalHandle)unionRecordset) == 0L) {
            String string = InternalResource.loadString("unionRecordset", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new NullPointerException(string);
        }
        long l2 = InternalHandle.getHandle((com.supermap.data.InternalHandle)unionRecordset);
        if (resultDataset == null || InternalHandle.getHandle((com.supermap.data.InternalHandle)resultDataset) == 0L) {
            String string = InternalResource.loadString("resultDataset", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new NullPointerException(string);
        }
        long l3 = InternalHandle.getHandle((com.supermap.data.InternalHandle)resultDataset);
        if (recordset.getDataset().getType() != DatasetType.REGION) {
            String string = InternalResource.loadString("dataset", "OverlayAnalyst_DatsetOrRecordsetTypeInvalidShouldBeRegion", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        if (unionRecordset.getDataset().getType() != DatasetType.REGION) {
            String string = InternalResource.loadString("unionRecordset", "OverlayAnalyst_DatsetOrRecordsetTypeInvalidShouldBeRegion", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        if (resultDataset.getType() != recordset.getDataset().getType()) {
            String string = InternalResource.loadString("", "OverlayAnalyst_ResultDatasetTypeInvalid", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        String[] stringArray = null;
        String[] stringArray2 = null;
        double d = 1.0E-10;
        if (null != parameter) {
            stringArray = parameter.getSourceRetainedFields();
            stringArray2 = parameter.getOperationRetainedFields();
            d = parameter.getTolerance();
        }
        boolean bl = OverlayAnalystNative.jni_RecordsetUnion(l, l2, l3, stringArray, stringArray2, d);
        InternalHandleDisposable.makeSureNativeObjectLive((Object)recordset);
        InternalHandleDisposable.makeSureNativeObjectLive((Object)unionRecordset);
        InternalHandleDisposable.makeSureNativeObjectLive((Object)resultDataset);
        return bl;
    }

    public static boolean union(DatasetVector dataset, Geometry[] unionGeometries, DatasetVector resultDataset, OverlayAnalystParameter parameter) {
        OverlayAnalyst.verifyLicense();
        if (dataset == null || InternalHandle.getHandle((com.supermap.data.InternalHandle)dataset) == 0L) {
            String string = InternalResource.loadString("dataset", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new NullPointerException(string);
        }
        if (unionGeometries == null) {
            String string = InternalResource.loadString("unionGeometries", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new NullPointerException(string);
        }
        int n = unionGeometries.length;
        long[] lArray = new long[n];
        for (int i = 0; i < n; ++i) {
            if (unionGeometries[i].getType() != GeometryType.GEOREGION) {
                String string = InternalResource.loadString("unionGeometries", "OverlayAnalyst_GeometryTypeInvalidShouldBeRegion", "spatialanalyst_resources");
                throw new IllegalArgumentException(string);
            }
            long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)unionGeometries[i]);
            if (l == 0L) {
                String string = InternalResource.loadString("unionGeometries", "Global_ArgumentObjectHasBeenDisposed", "spatialanalyst_resources");
                throw new NullPointerException(string);
            }
            lArray[i] = l;
        }
        if (dataset.getType() != DatasetType.REGION) {
            String string = InternalResource.loadString("dataset", "OverlayAnalyst_DatsetOrRecordsetTypeInvalidShouldBeRegion", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        if (resultDataset == null || InternalHandle.getHandle((com.supermap.data.InternalHandle)resultDataset) == 0L) {
            String string = InternalResource.loadString("resultDataset", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new NullPointerException(string);
        }
        if (resultDataset.getType() != dataset.getType()) {
            String string = InternalResource.loadString("resultDataset", "OverlayAnalyst_ResultDatasetTypeInvalid", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        String[] stringArray = null;
        String[] stringArray2 = null;
        double d = 1.0E-10;
        if (parameter != null) {
            stringArray = parameter.getSourceRetainedFields();
            stringArray2 = parameter.getOperationRetainedFields();
            d = parameter.getTolerance();
        }
        long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)dataset);
        long l2 = InternalHandle.getHandle((com.supermap.data.InternalHandle)resultDataset);
        boolean bl = OverlayAnalystNative.jni_GeometryUnion(l, lArray, l2, stringArray, stringArray2, d);
        InternalHandleDisposable.makeSureNativeObjectLive((Object)unionGeometries);
        return bl;
    }

    public static OverlayResult[] union(Geometry[] unionSourceGeometries, Geometry[] unionTargetGeometries, double tolerance) {
        OverlayResult[] overlayResultArray;
        OverlayAnalyst.verifyLicense();
        if (unionSourceGeometries == null) {
            String string = InternalResource.loadString("unionSourceGeometries", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        if (unionTargetGeometries == null) {
            String string = InternalResource.loadString("unionTargetGeometries", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        if (unionSourceGeometries.length == 0) {
            String string = InternalResource.loadString("unionSourceGeometries.length", "GlobalGreaterThanZero", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        if (unionTargetGeometries.length == 0) {
            String string = InternalResource.loadString("unionTargetGeometries.length", "GlobalGreaterThanZero", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        if (unionSourceGeometries[0] == null) {
            String string = InternalResource.loadString("unionSourceGeometries[0]", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        if (unionTargetGeometries[0] == null) {
            String string = InternalResource.loadString("unionTargetGeometries[0]", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        GeometryType geometryType = unionSourceGeometries[0].getType();
        if (geometryType != GeometryType.GEOREGION) {
            String string = InternalResource.loadString("unionSourceGeometries[0]", "OverlayAnalyst_GeometryTypeInvalidShouldBeRegion", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        GeometryType geometryType2 = unionTargetGeometries[0].getType();
        if (geometryType2 != GeometryType.GEOREGION) {
            String string = InternalResource.loadString("unionTargetGeometries[0]", "OverlayAnalyst_GeometryTypeInvalidShouldBeRegion", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        long[] lArray = new long[unionSourceGeometries.length];
        for (int i = 0; i < unionSourceGeometries.length; ++i) {
            Geometry geometry = unionSourceGeometries[i];
            if (geometry == null) {
                String string = InternalResource.loadString(String.format("unionSourceGeometries[%d]", i), "Global_ArgumentNull", "spatialanalyst_resources");
                throw new IllegalArgumentException(string);
            }
            if (geometry.getType() != geometryType) {
                String string = InternalResource.loadString(String.format("unionSourceGeometries[%d]", i), "OverlayAnalyst_GeometryTypeInvalidShouldBeRegion", "spatialanalyst_resources");
                throw new IllegalArgumentException(string);
            }
            lArray[i] = InternalHandle.getHandle((com.supermap.data.InternalHandle)geometry);
        }
        long[] lArray2 = new long[unionTargetGeometries.length];
        for (int i = 0; i < unionTargetGeometries.length; ++i) {
            overlayResultArray = unionTargetGeometries[i];
            if (overlayResultArray == null) {
                String string = InternalResource.loadString(String.format("unionTargetGeometries[%d]", i), "Global_ArgumentNull", "spatialanalyst_resources");
                throw new IllegalArgumentException(string);
            }
            if (overlayResultArray.getType() != geometryType2) {
                String string = InternalResource.loadString(String.format("unionTargetGeometries[%d]", i), "OverlayAnalyst_GeometryTypeInvalidShouldBeRegion", "spatialanalyst_resources");
                throw new IllegalArgumentException(string);
            }
            lArray2[i] = InternalHandle.getHandle((com.supermap.data.InternalHandle)overlayResultArray);
        }
        long[] lArray3 = OverlayAnalystNative.jni_GeometrysUnion(lArray, lArray2, tolerance);
        InternalHandleDisposable.makeSureNativeObjectLive((Object)unionSourceGeometries);
        InternalHandleDisposable.makeSureNativeObjectLive((Object)unionTargetGeometries);
        overlayResultArray = null;
        if (lArray3 != null && lArray3.length > 0) {
            int n = lArray3.length / 3;
            int n2 = 0;
            overlayResultArray = new OverlayResult[n];
            for (int i = 0; i < n; ++i) {
                OverlayResult overlayResult;
                overlayResultArray[i] = overlayResult = new OverlayResult(InternalGeometry.createInstance(lArray3[n2++]), (int)lArray3[n2++], (int)lArray3[n2++]);
            }
        }
        return overlayResultArray;
    }

    public static boolean update(DatasetVector dataset, DatasetVector updateDataset, DatasetVector resultDataset, OverlayAnalystParameter parameter) {
        OverlayAnalyst.verifyLicense();
        if (dataset == null || InternalHandle.getHandle((com.supermap.data.InternalHandle)dataset) == 0L) {
            String string = InternalResource.loadString("dataset", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new NullPointerException(string);
        }
        long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)dataset);
        if (updateDataset == null || InternalHandle.getHandle((com.supermap.data.InternalHandle)updateDataset) == 0L) {
            String string = InternalResource.loadString("updateDataset", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new NullPointerException(string);
        }
        long l2 = InternalHandle.getHandle((com.supermap.data.InternalHandle)updateDataset);
        if (resultDataset == null || InternalHandle.getHandle((com.supermap.data.InternalHandle)resultDataset) == 0L) {
            String string = InternalResource.loadString("resultDataset", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new NullPointerException(string);
        }
        long l3 = InternalHandle.getHandle((com.supermap.data.InternalHandle)resultDataset);
        if (dataset.getType() != DatasetType.REGION) {
            String string = InternalResource.loadString("dataset", "OverlayAnalyst_DatsetOrRecordsetTypeInvalidShouldBeRegion", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        if (updateDataset.getType() != DatasetType.REGION) {
            String string = InternalResource.loadString("updateDataset", "OverlayAnalyst_DatsetOrRecordsetTypeInvalidShouldBeRegion", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        if (resultDataset.getType() != dataset.getType()) {
            String string = InternalResource.loadString("", "OverlayAnalyst_ResultDatasetTypeInvalid", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        if (dataset.equals(updateDataset) || l == l2) {
            String string = InternalResource.loadString("", "OverlayAnalyst_SourceDatasetAndOperationDatasetShouldBeDifferent", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        String[] stringArray = null;
        String[] stringArray2 = null;
        double d = 1.0E-10;
        if (null != parameter) {
            stringArray = parameter.getSourceRetainedFields();
            stringArray2 = parameter.getOperationRetainedFields();
            d = parameter.getTolerance();
        }
        boolean bl = OverlayAnalystNative.jni_DatasetUpdate(l, l2, l3, stringArray, stringArray2, d);
        InternalHandleDisposable.makeSureNativeObjectLive((Object)dataset);
        InternalHandleDisposable.makeSureNativeObjectLive((Object)updateDataset);
        InternalHandleDisposable.makeSureNativeObjectLive((Object)resultDataset);
        return bl;
    }

    public static boolean update(Recordset recordset, Recordset updateRecordset, DatasetVector resultDataset, OverlayAnalystParameter parameter) {
        OverlayAnalyst.verifyLicense();
        if (recordset == null || InternalHandle.getHandle((com.supermap.data.InternalHandle)recordset) == 0L) {
            String string = InternalResource.loadString("recordset", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new NullPointerException(string);
        }
        long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)recordset);
        if (recordset == null || InternalHandle.getHandle((com.supermap.data.InternalHandle)updateRecordset) == 0L) {
            String string = InternalResource.loadString("recordset", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new NullPointerException(string);
        }
        long l2 = InternalHandle.getHandle((com.supermap.data.InternalHandle)updateRecordset);
        if (resultDataset == null || InternalHandle.getHandle((com.supermap.data.InternalHandle)resultDataset) == 0L) {
            String string = InternalResource.loadString("resultDataset", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new NullPointerException(string);
        }
        long l3 = InternalHandle.getHandle((com.supermap.data.InternalHandle)resultDataset);
        if (recordset.getDataset().getType() != DatasetType.REGION) {
            String string = InternalResource.loadString("dataset", "OverlayAnalyst_DatsetOrRecordsetTypeInvalidShouldBeRegion", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        if (updateRecordset.getDataset().getType() != DatasetType.REGION) {
            String string = InternalResource.loadString("updateRecordset", "OverlayAnalyst_DatsetOrRecordsetTypeInvalidShouldBeRegion", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        if (resultDataset.getType() != recordset.getDataset().getType()) {
            String string = InternalResource.loadString("", "OverlayAnalyst_ResultDatasetTypeInvalid", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        String[] stringArray = null;
        String[] stringArray2 = null;
        double d = 1.0E-10;
        if (null != parameter) {
            stringArray = parameter.getSourceRetainedFields();
            stringArray2 = parameter.getOperationRetainedFields();
            d = parameter.getTolerance();
        }
        boolean bl = OverlayAnalystNative.jni_RecordsetUpdate(l, l2, l3, stringArray, stringArray2, d);
        InternalHandleDisposable.makeSureNativeObjectLive((Object)recordset);
        InternalHandleDisposable.makeSureNativeObjectLive((Object)updateRecordset);
        InternalHandleDisposable.makeSureNativeObjectLive((Object)resultDataset);
        return bl;
    }

    public static boolean update(DatasetVector dataset, Geometry[] updateGeometries, DatasetVector resultDataset, OverlayAnalystParameter parameter) {
        OverlayAnalyst.verifyLicense();
        if (dataset == null || InternalHandle.getHandle((com.supermap.data.InternalHandle)dataset) == 0L) {
            String string = InternalResource.loadString("dataset", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new NullPointerException(string);
        }
        if (updateGeometries == null) {
            String string = InternalResource.loadString("updateGeometries", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new NullPointerException(string);
        }
        int n = updateGeometries.length;
        long[] lArray = new long[n];
        for (int i = 0; i < n; ++i) {
            if (updateGeometries[i].getType() != GeometryType.GEOREGION) {
                String string = InternalResource.loadString("updateGeometries", "OverlayAnalyst_GeometryTypeInvalidShouldBeRegion", "spatialanalyst_resources");
                throw new IllegalArgumentException(string);
            }
            long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)updateGeometries[i]);
            if (l == 0L) {
                String string = InternalResource.loadString("updateGeometries", "Global_ArgumentObjectHasBeenDisposed", "spatialanalyst_resources");
                throw new NullPointerException(string);
            }
            lArray[i] = l;
        }
        if (dataset.getType() != DatasetType.REGION) {
            String string = InternalResource.loadString("dataset", "OverlayAnalyst_DatsetOrRecordsetTypeInvalidShouldBeRegion", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        if (resultDataset == null || InternalHandle.getHandle((com.supermap.data.InternalHandle)resultDataset) == 0L) {
            String string = InternalResource.loadString("resultDataset", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new NullPointerException(string);
        }
        if (resultDataset.getType() != dataset.getType()) {
            String string = InternalResource.loadString("resultDataset", "OverlayAnalyst_ResultDatasetTypeInvalid", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        String[] stringArray = null;
        String[] stringArray2 = null;
        double d = 1.0E-10;
        if (parameter != null) {
            stringArray = parameter.getSourceRetainedFields();
            stringArray2 = parameter.getOperationRetainedFields();
            d = parameter.getTolerance();
        }
        long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)dataset);
        long l2 = InternalHandle.getHandle((com.supermap.data.InternalHandle)resultDataset);
        boolean bl = OverlayAnalystNative.jni_GeometryUpdate(l, lArray, l2, stringArray, stringArray2, d);
        InternalHandleDisposable.makeSureNativeObjectLive((Object)updateGeometries);
        InternalHandleDisposable.makeSureNativeObjectLive((Object)dataset);
        InternalHandleDisposable.makeSureNativeObjectLive((Object)resultDataset);
        return bl;
    }

    public static OverlayResult[] update(Geometry[] updateSourceGeometries, Geometry[] updateTargetGeometries, double tolerance) {
        OverlayResult[] overlayResultArray;
        OverlayAnalyst.verifyLicense();
        if (updateSourceGeometries == null) {
            String string = InternalResource.loadString("updateSourceGeometries", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        if (updateTargetGeometries == null) {
            String string = InternalResource.loadString("updateTargetGeometries", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        if (updateSourceGeometries.length == 0) {
            String string = InternalResource.loadString("updateSourceGeometries.length", "GlobalGreaterThanZero", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        if (updateTargetGeometries.length == 0) {
            String string = InternalResource.loadString("updateTargetGeometries.length", "GlobalGreaterThanZero", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        if (updateSourceGeometries[0] == null) {
            String string = InternalResource.loadString("updateSourceGeometries[0]", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        if (updateTargetGeometries[0] == null) {
            String string = InternalResource.loadString("updateTargetGeometries[0]", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        GeometryType geometryType = updateSourceGeometries[0].getType();
        if (geometryType != GeometryType.GEOREGION) {
            String string = InternalResource.loadString("updateSourceGeometries[0]", "OverlayAnalyst_GeometryTypeInvalidShouldBeRegion", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        GeometryType geometryType2 = updateTargetGeometries[0].getType();
        if (geometryType2 != GeometryType.GEOREGION) {
            String string = InternalResource.loadString("updateTargetGeometries[0]", "OverlayAnalyst_GeometryTypeInvalidShouldBeRegion", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        long[] lArray = new long[updateSourceGeometries.length];
        for (int i = 0; i < updateSourceGeometries.length; ++i) {
            Geometry geometry = updateSourceGeometries[i];
            if (geometry == null) {
                String string = InternalResource.loadString(String.format("updateSourceGeometries[%d]", i), "Global_ArgumentNull", "spatialanalyst_resources");
                throw new IllegalArgumentException(string);
            }
            if (geometry.getType() != geometryType) {
                String string = InternalResource.loadString(String.format("updateSourceGeometries[%d]", i), "OverlayAnalyst_GeometryTypeInvalidShouldBeRegion", "spatialanalyst_resources");
                throw new IllegalArgumentException(string);
            }
            lArray[i] = InternalHandle.getHandle((com.supermap.data.InternalHandle)geometry);
        }
        long[] lArray2 = new long[updateTargetGeometries.length];
        for (int i = 0; i < updateTargetGeometries.length; ++i) {
            overlayResultArray = updateTargetGeometries[i];
            if (overlayResultArray == null) {
                String string = InternalResource.loadString(String.format("updateTargetGeometries[%d]", i), "Global_ArgumentNull", "spatialanalyst_resources");
                throw new IllegalArgumentException(string);
            }
            if (overlayResultArray.getType() != geometryType2) {
                String string = InternalResource.loadString(String.format("updateTargetGeometries[%d]", i), "OverlayAnalyst_GeometryTypeInvalidShouldBeRegion", "spatialanalyst_resources");
                throw new IllegalArgumentException(string);
            }
            lArray2[i] = InternalHandle.getHandle((com.supermap.data.InternalHandle)overlayResultArray);
        }
        long[] lArray3 = OverlayAnalystNative.jni_GeometrysUpdate(lArray, lArray2, tolerance);
        InternalHandleDisposable.makeSureNativeObjectLive((Object)updateSourceGeometries);
        InternalHandleDisposable.makeSureNativeObjectLive((Object)updateTargetGeometries);
        overlayResultArray = null;
        if (lArray3 != null && lArray3.length > 0) {
            int n = lArray3.length / 3;
            int n2 = 0;
            overlayResultArray = new OverlayResult[n];
            for (int i = 0; i < n; ++i) {
                OverlayResult overlayResult;
                overlayResultArray[i] = overlayResult = new OverlayResult(InternalGeometry.createInstance(lArray3[n2++]), (int)lArray3[n2++], (int)lArray3[n2++]);
            }
        }
        return overlayResultArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void verifyLicense() {
        int n = -1;
        Object object = m_license;
        synchronized (object) {
            n = m_license.verify();
        }
        if (n != 0) {
            object = License.getErrorMessage((int)n);
            throw new IllegalStateException((String)object);
        }
    }

    public static synchronized void addSteppedListener(SteppedListener l) {
        if (m_steppedListeners == null) {
            m_steppedListeners = new Vector();
        }
        if (!m_steppedListeners.contains(l)) {
            m_steppedListeners.add(l);
        }
    }

    public static synchronized void removeSteppedListener(SteppedListener l) {
        if (m_steppedListeners != null && m_steppedListeners.contains(l)) {
            m_steppedListeners.remove(l);
        }
    }

    protected static void fireStepped(SteppedEvent event) {
        if (m_steppedListeners != null) {
            Vector vector = m_steppedListeners;
            int n = vector.size();
            for (int i = 0; i < n; ++i) {
                ((SteppedListener)vector.elementAt(i)).stepped(event);
            }
        }
    }

    static void steppedCallBack(int percent, long remainTime, String title, String message, long cancelHandle) {
        String string = "OverlayAnalyst";
        boolean bl = InternalToolkitSpatialAnalyst.getHandleBooleanValue(cancelHandle);
        Object object = new Object();
        SteppedEvent steppedEvent = new SteppedEvent(object, percent, remainTime, title, message, string);
        OverlayAnalyst.fireStepped(steppedEvent);
        InternalToolkitSpatialAnalyst.setHandleBooleanValue(cancelHandle, steppedEvent.getCancel());
    }

    static {
        ArrayList<ProductType> arrayList = InternalToolkitSpatialAnalyst.managerProducts(InternalToolkitSpatialAnalyst.getSpatialAnalystProducts());
        m_license = InternalToolkitSpatialAnalyst.verifyLicense(arrayList);
    }
}

