/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.analyst.trafficanalyst;

import com.supermap.analyst.trafficanalyst.InternalResource;
import com.supermap.analyst.trafficanalyst.TransferGuideItem;
import com.supermap.analyst.trafficanalyst.TransferGuideNative;

public class TransferGuide {
    private int m_count = 0;
    private int m_transferTime = 0;
    private TransferGuideItem[] m_items = null;
    private double m_totalWeight = 0.0;
    private double m_totalDistance = 0.0;
    private double m_totalFare = 0.0;
    private double m_totalTime = 0.0;

    TransferGuide(long handle) {
        this.getFromUGC(handle);
    }

    public int getCount() {
        return this.m_count;
    }

    public TransferGuideItem get(int index) {
        if (index < 0 || index >= this.getCount()) {
            String string = InternalResource.loadString("index", "Global_IndexOutOfBounds", "trafficanalyst_resources");
            throw new IndexOutOfBoundsException(string);
        }
        return this.m_items[index];
    }

    public double getTotalFare() {
        return this.m_totalFare;
    }

    public double getTotalTime() {
        return this.m_totalTime;
    }

    public double getTotalDistance() {
        return this.m_totalDistance;
    }

    public int getTransferCount() {
        return this.m_transferTime - 1;
    }

    private void getFromUGC(long handle) {
        this.m_count = TransferGuideNative.jni_GetItemCount(handle);
        this.m_items = new TransferGuideItem[this.m_count];
        for (int i = 0; i < this.m_count; ++i) {
            long l = TransferGuideNative.jni_GetItemHandle(handle, i);
            this.m_items[i] = new TransferGuideItem(l);
        }
        this.m_totalTime = TransferGuideNative.jni_GetTotalTime(handle);
        this.m_totalFare = TransferGuideNative.jni_GetTotalFare(handle);
        this.m_totalDistance = TransferGuideNative.jni_GetTotalDistance(handle);
        this.m_transferTime = TransferGuideNative.jni_GetTransferCount(handle);
    }
}

