/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.realspace;

import com.supermap.data.GeoBox;
import com.supermap.data.Geometry;
import com.supermap.data.Rectangle2D;
import com.supermap.realspace.BoxClipPart;
import com.supermap.realspace.InternalEnum;
import com.supermap.realspace.InternalGeometry;
import com.supermap.realspace.InternalHandle;
import com.supermap.realspace.InternalHandleDisposable;
import com.supermap.realspace.InternalResource;
import com.supermap.realspace.Scene;
import com.supermap.realspace.SceneNative;
import java.awt.Color;

public class GlobalImage
extends InternalHandle {
    private Scene m_scene;

    GlobalImage(Scene scene) {
        this.m_scene = scene;
    }

    private void checkIndex(int value) {
        int n = this.getExcavationRegionCount();
        if (value < 0 || value > n - 1) {
            String string = InternalResource.loadString("value", "Global_IndexOutOfBounds", "realspace_resources");
            throw new IllegalArgumentException(string);
        }
    }

    private void checkTag(String value) {
        if (null == value) {
            String string = InternalResource.loadString("value", "Global_StringIsNullOrEmpty", "realspace_resources");
            throw new IllegalArgumentException(string);
        }
        int n = value.trim().length();
        if (n == 0) {
            String string = InternalResource.loadString("value", "Global_StringIsNullOrEmpty", "realspace_resources");
            throw new IllegalArgumentException(string);
        }
    }

    public boolean isVisible() {
        long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)this.m_scene);
        if (l == 0L) {
            String string = InternalResource.loadString("sceneHandle", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        return SceneNative.jni_IsGlobalImageVisible(l);
    }

    public void setVisible(boolean value) {
        long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)this.m_scene);
        if (l == 0L) {
            String string = InternalResource.loadString("sceneHandle", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        SceneNative.jni_SetGlobalImageVisible(l, value);
    }

    public int getTransparency() {
        long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)this.m_scene);
        if (l == 0L) {
            String string = InternalResource.loadString("sceneHandle", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        return SceneNative.jni_GetTransparency(l);
    }

    public void setTransparency(int value) {
        long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)this.m_scene);
        if (l == 0L) {
            String string = InternalResource.loadString("sceneHandle", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        if (value < 0 || value > 100) {
            String string = InternalResource.loadString("value", "GlobalImage_Transparency_OutOfRange", "realspace_resources");
            throw new IllegalArgumentException(string);
        }
        SceneNative.jni_SetTransparency(l, value);
    }

    public int getExcavationRegionCount() {
        long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)this.m_scene);
        if (l == 0L) {
            String string = InternalResource.loadString("sceneHandle", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        return SceneNative.jni_GetExcavationRegionCount(l);
    }

    public int addExcavationRegion(Geometry geometry, String value) {
        long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)this.m_scene);
        if (l == 0L) {
            String string = InternalResource.loadString("sceneHandle", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        if (null == geometry) {
            String string = InternalResource.loadString("geometry", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalArgumentException(string);
        }
        long l2 = InternalHandle.getHandle((com.supermap.data.InternalHandle)geometry);
        if (l2 == 0L) {
            String string = InternalResource.loadString("geometry", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalArgumentException(string);
        }
        this.checkTag(value);
        Geometry geometry2 = geometry.clone();
        InternalHandleDisposable.setIsDisposable((com.supermap.data.InternalHandleDisposable)geometry2, false);
        long l3 = InternalHandle.getHandle((com.supermap.data.InternalHandle)geometry2);
        InternalHandleDisposable.makeSureNativeObjectLive((Object)geometry);
        return SceneNative.jni_AddExcavationRegion(l, l3, value);
    }

    public void clearExcavationRegions() {
        long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)this.m_scene);
        if (l == 0L) {
            String string = InternalResource.loadString("sceneHandle", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        SceneNative.jni_ClearExcavationRegions(l);
    }

    public Geometry getExcavationRegion(int value) {
        long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)this.m_scene);
        if (l == 0L) {
            String string = InternalResource.loadString("sceneHandle", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        this.checkIndex(value);
        Geometry geometry = null;
        long l2 = SceneNative.jni_GetExcavationRegion(l, value);
        if (l2 != 0L) {
            geometry = InternalGeometry.createInstance(l2);
            InternalHandleDisposable.setIsDisposable((com.supermap.data.InternalHandleDisposable)geometry, true);
        }
        return geometry;
    }

    public String getExcavationRegionTag(int value) {
        long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)this.m_scene);
        if (l == 0L) {
            String string = InternalResource.loadString("sceneHandle", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        this.checkIndex(value);
        return SceneNative.jni_GetExcavationRegionTag(l, value);
    }

    public int indexOfExcavationRegion(String value) {
        long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)this.m_scene);
        if (l == 0L) {
            String string = InternalResource.loadString("sceneHandle", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        this.checkTag(value);
        return SceneNative.jni_IndexOfExcavationRegion(l, value);
    }

    public boolean removeExcavationRegion(int value) {
        long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)this.m_scene);
        if (l == 0L) {
            String string = InternalResource.loadString("sceneHandle", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        this.checkIndex(value);
        return SceneNative.jni_RemoveExcavationRegion(l, value);
    }

    public boolean setExcavationRegionTag(int index, String tag) {
        long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)this.m_scene);
        if (l == 0L) {
            String string = InternalResource.loadString("sceneHandle", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        this.checkIndex(index);
        this.checkTag(tag);
        return SceneNative.jni_SetExcavationRegionTag(l, index, tag);
    }

    public void setSwipeEnable(boolean enable) {
        long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)this.m_scene);
        if (l == 0L) {
            String string = InternalResource.loadString("sceneHandle", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        SceneNative.jni_SetGlobalImageSwipeEnable(l, enable);
    }

    public boolean isSwipeEnable() {
        long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)this.m_scene);
        if (l == 0L) {
            String string = InternalResource.loadString("sceneHandle", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        return SceneNative.jni_IsGlobalImageSwipeEnable(l);
    }

    public Rectangle2D getSwipeRegion() {
        long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)this.m_scene);
        if (l == 0L) {
            String string = InternalResource.loadString("sceneHandle", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        double[] dArray = new double[4];
        SceneNative.jni_GetGlobalImageSwipeRegion(l, dArray);
        Rectangle2D rectangle2D = new Rectangle2D(dArray[0], dArray[1], dArray[2], dArray[3]);
        return rectangle2D;
    }

    public void setSwipeRegion(Rectangle2D rec) {
        long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)this.m_scene);
        if (l == 0L) {
            String string = InternalResource.loadString("sceneHandle", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        SceneNative.jni_SetGlobalImageSwipeRegion(l, rec.getLeft(), rec.getBottom(), rec.getRight(), rec.getTop());
    }

    public Color getUndergroundBackColor() {
        long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)this.m_scene);
        if (l == 0L) {
            String string = InternalResource.loadString("sceneHandle", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        int[] nArray = SceneNative.jni_GetUndergroundBackColor(l);
        Color color = new Color(nArray[1], nArray[2], nArray[3], nArray[0]);
        nArray = null;
        return color;
    }

    public void setUndergroundBackColor(Color value) {
        long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)this.m_scene);
        if (l == 0L) {
            String string = InternalResource.loadString("sceneHandle", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        SceneNative.jni_SetUndergroundBackColor(l, value.getAlpha(), value.getRed(), value.getGreen(), value.getBlue());
    }

    public float[] getDepthBias() {
        long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)this.m_scene);
        if (l == 0L) {
            String string = InternalResource.loadString("sceneHandle", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        return SceneNative.jni_GetDepthBias(l);
    }

    public void setDepthBias(float fConstant, float fScale) {
        long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)this.m_scene);
        if (l == 0L) {
            String string = InternalResource.loadString("sceneHandle", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        SceneNative.jni_SetDepthBias(l, fConstant, fScale);
    }

    public GeoBox getClipBox() {
        long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)this.m_scene);
        if (l == 0L) {
            String string = InternalResource.loadString("sceneHandle", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        long l2 = SceneNative.jni_GetClipBox(l);
        GeoBox geoBox = null;
        if (l2 != 0L) {
            geoBox = (GeoBox)InternalGeometry.createInstance(l2);
        }
        return geoBox;
    }

    public BoxClipPart getBoxClipPart() {
        long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)this.m_scene);
        if (l == 0L) {
            String string = InternalResource.loadString("sceneHandle", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        int n = SceneNative.jni_GetBoxClipPart(l);
        return (BoxClipPart)InternalEnum.parseUGCValue(BoxClipPart.class, n);
    }

    public Color getClipLineColor() {
        long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)this.m_scene);
        if (l == 0L) {
            String string = InternalResource.loadString("GlobalImage", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        int[] nArray = SceneNative.jni_GetClipLineColor(l);
        Color color = new Color(nArray[0], nArray[1], nArray[2], nArray[3]);
        return color;
    }

    public void setClipLineColor(Color value) {
        long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)this.m_scene);
        if (l == 0L) {
            String string = InternalResource.loadString("GlobalImage", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        SceneNative.jni_SetClipLineColor(l, value.getRed(), value.getGreen(), value.getBlue(), value.getAlpha());
    }

    public void clearCustomClipPlane() {
        long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)this.m_scene);
        if (l == 0L) {
            String string = InternalResource.loadString("GlobalImage", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        SceneNative.jni_ClearCustomClipPlane(l);
    }

    public void clipByBox(GeoBox box, BoxClipPart part) {
        long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)this.m_scene);
        if (l == 0L) {
            String string = InternalResource.loadString("GlobalImage", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        if (box == null) {
            String string = InternalResource.loadString("box", "Global_ArgumentNull", "realspace_resources");
            throw new IllegalArgumentException(string);
        }
        long l2 = InternalHandle.getHandle((com.supermap.data.InternalHandle)box);
        if (l2 == 0L) {
            String string = InternalResource.loadString("box", "GlobalArgument_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalArgumentException(string);
        }
        SceneNative.jni_ClipByBox(l, l2, part.value());
    }
}

