/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.realspace;

import com.supermap.data.AltitudeMode;
import com.supermap.data.Enum;
import com.supermap.data.GeoPlacemark;
import com.supermap.data.Geometry;
import com.supermap.data.Geometry3D;
import com.supermap.data.GeometryType;
import com.supermap.realspace.Camera;
import com.supermap.realspace.Feature3DNative;
import com.supermap.realspace.Feature3Ds;
import com.supermap.realspace.InternalEnum;
import com.supermap.realspace.InternalGeometry;
import com.supermap.realspace.InternalHandle;
import com.supermap.realspace.InternalHandleDisposable;
import com.supermap.realspace.InternalResource;
import java.io.File;

public class Feature3D
extends InternalHandleDisposable {
    private Feature3Ds m_parent;
    private Geometry3D m_geometry3D;
    private static final double DTOR = Math.PI / 180;
    private static final double RTOD = 57.29577951308232;

    public Feature3D() {
        long l = Feature3DNative.jni_New();
        this.setHandle(l, true);
        this.setName("UntitledFeature3D");
    }

    public Feature3D(Feature3D feature3D) {
        if (feature3D == null) {
            String string = InternalResource.loadString("feature3D", "Global_ArgumentNull", "realspace_resources");
            throw new NullPointerException(string);
        }
        long l = feature3D.getHandle();
        if (l == 0L) {
            String string = InternalResource.loadString("feature3D", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalArgumentException(string);
        }
        long l2 = Feature3DNative.jni_Clone(l);
        this.setHandle(l2, true);
        InternalHandleDisposable.makeSureNativeObjectLive((Object)((Object)feature3D));
    }

    Feature3D(long handle, Feature3Ds parent) {
        this.setHandle(handle, false);
        this.m_parent = parent;
    }

    public int getID() {
        int n;
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getID()", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_parent != null && (n = this.m_parent.getFeature3DList().indexOf((Object)this)) == -1) {
            String string = InternalResource.loadString("getID()", "Global_OwnerHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        return Feature3DNative.jni_GetID(this.getHandle());
    }

    public String getName() {
        int n;
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getName()", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_parent != null && (n = this.m_parent.getFeature3DList().indexOf((Object)this)) == -1) {
            String string = InternalResource.loadString("getName()", "Global_OwnerHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        return Feature3DNative.jni_GetName(this.getHandle());
    }

    public void setName(String value) {
        int n;
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setName(String value)", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_parent != null && (n = this.m_parent.getFeature3DList().indexOf((Object)this)) == -1) {
            String string = InternalResource.loadString("setName(String value)", "Global_OwnerHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        Feature3DNative.jni_SetName(this.getHandle(), value);
        if (this.getGeometry() != null && this.getGeometry().getType().equals((Object)GeometryType.GEOPLACEMARK)) {
            ((GeoPlacemark)this.getGeometry()).setName(value);
        }
    }

    public String getDescription() {
        int n;
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getDescription()", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_parent != null && (n = this.m_parent.getFeature3DList().indexOf((Object)this)) == -1) {
            String string = InternalResource.loadString("getDescription()", "Global_OwnerHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        return Feature3DNative.jni_GetDescription(this.getHandle());
    }

    public void setDescription(String value) {
        int n;
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setDescription(String value)", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_parent != null && (n = this.m_parent.getFeature3DList().indexOf((Object)this)) == -1) {
            String string = InternalResource.loadString("setDescription(String value)", "Global_OwnerHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        Feature3DNative.jni_SetDescription(this.getHandle(), value);
    }

    public Geometry3D getGeometry() {
        long l;
        int n;
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getGeometry()", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_parent != null && (n = this.m_parent.getFeature3DList().indexOf((Object)this)) == -1) {
            String string = InternalResource.loadString("getGeometry()", "Global_OwnerHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_geometry3D == null && (l = Feature3DNative.jni_GetGeometry3D(this.getHandle())) != 0L) {
            this.m_geometry3D = (Geometry3D)InternalGeometry.createInstance(l);
            InternalHandleDisposable.setIsDisposable((com.supermap.data.InternalHandleDisposable)this.m_geometry3D, false);
        }
        return this.m_geometry3D;
    }

    public void setGeometry(Geometry3D geometry3D) {
        int n;
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setGeometry(Geometry3D geometry3D)", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_parent != null && (n = this.m_parent.getFeature3DList().indexOf((Object)this)) == -1) {
            String string = InternalResource.loadString("setGeometry(Geometry3D geometry3D)", "Global_OwnerHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        if (geometry3D == null) {
            String string = InternalResource.loadString("geometry", "Global_ArgumentNull", "realspace_resources");
            throw new NullPointerException(string);
        }
        if (InternalHandle.getHandle((com.supermap.data.InternalHandle)geometry3D) == 0L) {
            String string = InternalResource.loadString("geometry3D", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalArgumentException(string);
        }
        Geometry3D geometry3D2 = (Geometry3D)geometry3D.clone();
        long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)geometry3D2);
        InternalHandleDisposable.setIsDisposable((com.supermap.data.InternalHandleDisposable)geometry3D2, false);
        if (this.m_geometry3D == null) {
            Feature3DNative.jni_SetGeometry3D1(this.getHandle(), l);
        } else {
            if (geometry3D.getType() != this.m_geometry3D.getType()) {
                String string = InternalResource.loadString("setGeometry()", "Global_ArgumentTypeInvalid", "realspace_resources");
                throw new IllegalArgumentException(string);
            }
            long l2 = InternalHandle.getHandle((com.supermap.data.InternalHandle)this.m_geometry3D);
            Feature3DNative.jni_SetGeometry3D2(this.getHandle(), l, l2);
        }
        InternalHandleDisposable.makeSureNativeObjectLive((Object)geometry3D);
    }

    public Feature3Ds getParent() {
        int n;
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getParent()", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_parent != null && (n = this.m_parent.getFeature3DList().indexOf((Object)this)) == -1) {
            String string = InternalResource.loadString("getParent()", "Global_OwnerHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        return this.m_parent;
    }

    public boolean isVisible() {
        int n;
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("isVisible()", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_parent != null && (n = this.m_parent.getFeature3DList().indexOf((Object)this)) == -1) {
            String string = InternalResource.loadString("isVisible()", "Global_OwnerHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        return Feature3DNative.jni_GetIsVisible(this.getHandle());
    }

    public void setVisible(boolean value) {
        int n;
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setVisible(boolean value)", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_parent != null && (n = this.m_parent.getFeature3DList().indexOf((Object)this)) == -1) {
            String string = InternalResource.loadString("setVisible(boolean value)", "Global_OwnerHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        Feature3DNative.jni_SetIsVisible(this.getHandle(), value);
    }

    @Deprecated
    public double getVisibleDistance() {
        int n;
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getVisibleDistance()", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_parent != null && (n = this.m_parent.getFeature3DList().indexOf((Object)this)) == -1) {
            String string = InternalResource.loadString("getVisibleDistance()", "Global_OwnerHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        return Feature3DNative.jni_GetVisibleDistance(this.getHandle());
    }

    @Deprecated
    public void setVisibleDistance(double value) {
        int n;
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setVisibleDistance(double value)", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_parent != null && (n = this.m_parent.getFeature3DList().indexOf((Object)this)) == -1) {
            String string = InternalResource.loadString("setVisibleDistance(double value)", "Global_OwnerHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        Feature3DNative.jni_SetVisibleDistance(this.getHandle(), value);
    }

    public Camera getCamera() {
        int n;
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getCamera()", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_parent != null && (n = this.m_parent.getFeature3DList().indexOf((Object)this)) == -1) {
            String string = InternalResource.loadString("getCamera()", "Global_OwnerHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        double[] dArray = new double[6];
        long l = Feature3DNative.jni_GetCamera(this.getHandle(), dArray);
        Camera camera = null;
        if (l != 0L) {
            camera = new Camera(dArray[0] * 57.29577951308232, dArray[1] * 57.29577951308232, Camera.computeAltitude(dArray[2], dArray[5] * 57.29577951308232), (AltitudeMode)InternalEnum.parse(AltitudeMode.class, (int)((int)dArray[3])), dArray[4] * 57.29577951308232, dArray[5] * 57.29577951308232);
        }
        return camera;
    }

    public void setCamera(Camera value) {
        int n;
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setCamera(Camera value)", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_parent != null && (n = this.m_parent.getFeature3DList().indexOf((Object)this)) == -1) {
            String string = InternalResource.loadString("setCamera(Camera value)", "Global_OwnerHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        if (value == null) {
            Feature3DNative.jni_SetCamera(this.getHandle(), 0L);
        } else {
            Feature3DNative.jni_SetCameraValue(this.getHandle(), value.getLongitude() * (Math.PI / 180), value.getLatitude() * (Math.PI / 180), Camera.computeDistance(value.getAltitude(), value.getTilt()), InternalEnum.getUGCValue((Enum)value.getAltitudeMode()), value.getHeading() * (Math.PI / 180), value.getTilt() * (Math.PI / 180));
        }
    }

    public String toKML() {
        int n;
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("toKML()", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_parent != null && (n = this.m_parent.getFeature3DList().indexOf((Object)this)) == -1) {
            String string = InternalResource.loadString("toKML()", "Global_OwnerHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        return Feature3DNative.jni_ToKML(this.getHandle());
    }

    public boolean fromKML(String kml) {
        int n;
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("fromKML(String kml)", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_parent != null && (n = this.m_parent.getFeature3DList().indexOf((Object)this)) == -1) {
            String string = InternalResource.loadString("fromKML(String kml)", "Global_OwnerHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        n = 0;
        if (kml != null && kml.trim().length() != 0 && (n = (int)(Feature3DNative.jni_FromKML(this.getHandle(), kml) ? 1 : 0)) != 0 && this.m_geometry3D != null) {
            InternalGeometry.clearHandle((Geometry)this.m_geometry3D);
            this.m_geometry3D = null;
        }
        return n != 0;
    }

    public void toKMLFile(String kmlFile) {
        int n;
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("fromKML(String kml)", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_parent != null && (n = this.m_parent.getFeature3DList().indexOf((Object)this)) == -1) {
            String string = InternalResource.loadString("fromKML(String kml)", "Global_OwnerHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        String string = ".kml";
        String string2 = ".kmz";
        if (kmlFile.endsWith(string2)) {
            Feature3DNative.jni_ToKMZFile(this.getHandle(), kmlFile);
        } else {
            if (!kmlFile.endsWith(string)) {
                kmlFile = kmlFile + string;
            }
            Feature3DNative.jni_ToKMLFile(this.getHandle(), kmlFile);
        }
    }

    public boolean fromKMLFile(String kmlFile) {
        int n;
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("fromKML(String kml)", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_parent != null && (n = this.m_parent.getFeature3DList().indexOf((Object)this)) == -1) {
            String string = InternalResource.loadString("fromKML(String kml)", "Global_OwnerHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        File file = new File(kmlFile);
        if (!file.exists()) {
            String string = InternalResource.loadString("fromKML()", "Feature3D_SpecifiedNameNotExists", "realspace_resources");
            throw new IllegalArgumentException(string);
        }
        boolean bl = false;
        bl = Feature3DNative.jni_FromKMLFile(this.getHandle(), kmlFile);
        if (bl && this.m_geometry3D != null) {
            InternalGeometry.clearHandle((Geometry)this.m_geometry3D);
            this.m_geometry3D = null;
        }
        return bl;
    }

    public void updateData() {
        int n;
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("updateData()", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_parent != null && (n = this.m_parent.getFeature3DList().indexOf((Object)this)) == -1) {
            String string = InternalResource.loadString("fromKML(String kml)", "Global_OwnerHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        Geometry3D geometry3D = this.getGeometry();
        if (geometry3D == null || geometry3D.getType() == GeometryType.GEOPLACEMARK && ((GeoPlacemark)geometry3D).getGeometry().getType() != GeometryType.GEOMODEL || geometry3D.getType() != GeometryType.GEOPLACEMARK && geometry3D.getType() != GeometryType.GEOMODEL) {
            Feature3DNative.jni_UpdateData(this.getHandle());
        }
    }

    public void dispose() {
        if (!this.getIsDisposable()) {
            String string = InternalResource.loadString("dispose()", "Handle_UndisposableObject", "realspace_resources");
            throw new UnsupportedOperationException(string);
        }
        if (this.getHandle() != 0L) {
            Feature3DNative.jni_Delete(this.getHandle());
            this.clearHandle();
        }
    }

    protected boolean isAvailableName(String name) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("isNameAvailable(String name)", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        return Feature3DNative.jni_IsAvailableName(this.getHandle(), name);
    }

    protected void clearHandle() {
        if (this.m_geometry3D != null) {
            InternalGeometry.clearHandle((Geometry)this.m_geometry3D);
            this.m_geometry3D = null;
        }
        if (this.m_parent != null) {
            this.m_parent = null;
        }
        this.setHandle(0L);
    }
}

