/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.jsuperpy.callpy;

import com.supermap.jsuperpy.callpy.RedirectThread;
import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.util.ArrayList;
import java.util.Map;

public final class Utils {
    public static final int FINISHED_AND_EXIT = -1;
    public static final int PROCESS_NO_VALUE_RETURN = 0;
    public static final int PROCESSING = 2;
    public static final int END_PROCESSING = 3;
    public static final int FETCH_FINAL_RESULTS = 4;
    public static final int PROCESS_UPDATE_INFO = 5;
    public static final int PRE_PROCESSING = 6;
    public static final int PROCESS_SET_PARAMETERS = 7;
    public static final int EXECUTE_PROCESS_GT = 10;
    public static final int EXECUTE_PROCESS_PIPE = 20;
    public static final int EXECUTE_PROCESS_TILES = 30;
    public static final int PROCESSING_TILE = 31;
    public static final int PROCESSING_TILES = 32;

    public static ServerSocket startPythonProcess() throws IOException {
        ServerSocket serverSocket = new ServerSocket(0, 1, InetAddress.getByAddress(new byte[]{127, 0, 0, 1}));
        ArrayList<String> processParameters = new ArrayList<String>();
        String pythonExe = System.getProperty("SUPERMAP_PYTHON");
        if (pythonExe == null || pythonExe.isEmpty()) {
            pythonExe = System.getenv("SUPERMAP_PYTHON");
        }
        if (pythonExe == null || pythonExe.isEmpty()) {
            pythonExe = "python";
        }
        processParameters.add(pythonExe);
        processParameters.add("-m");
        processParameters.add("iobjectspy.rpc.worker");
        processParameters.add(String.valueOf(serverSocket.getLocalPort()));
        ProcessBuilder pb = new ProcessBuilder(processParameters);
        Map<String, String> workerEnv = pb.environment();
        workerEnv.put("PYTHONUNBUFFERED", "YES");
        String pythonPathLib = null;
        pythonPathLib = System.getProperty("PYTHONPATH");
        if (pythonPathLib == null || pythonPathLib.isEmpty()) {
            pythonPathLib = System.getenv("PYTHONPATH");
        }
        if (pythonPathLib != null && !pythonPathLib.isEmpty()) {
            workerEnv.put("PYTHONPATH", pythonPathLib);
        }
        StringBuilder argbuilder = new StringBuilder();
        for (String arg : processParameters) {
            argbuilder.append(arg + " ");
        }
        System.out.println("python process:" + argbuilder);
        Process worker = pb.start();
        new RedirectThread(worker.getInputStream(), System.out, "stdout reader for python", true).start();
        new RedirectThread(worker.getErrorStream(), System.out, "stderr reader for python", true).start();
        return serverSocket;
    }

    public static byte[] readBytesAndLength(DataInputStream in) throws IOException {
        int len = in.readInt();
        if (len > 0) {
            byte[] bys = new byte[len];
            in.readFully(bys);
            return bys;
        }
        return new byte[0];
    }

    public static void writeBytesAndLength(byte[] bys, DataOutputStream out) throws IOException {
        out.writeInt(bys.length);
        out.flush();
        out.write(bys);
        out.flush();
    }

    public static String readPyFile(File pyFile) throws IOException {
        String line;
        BufferedReader reader = new BufferedReader(new InputStreamReader(new FileInputStream(pyFile)));
        StringBuilder builder = new StringBuilder();
        while ((line = reader.readLine()) != null) {
            builder.append(line + "\n");
        }
        return builder.toString();
    }
}

