/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.iobjects.process.ml.inference;

import com.supermap.data.Dataset;
import com.supermap.data.DatasetImage;
import com.supermap.data.Datasource;
import com.supermap.data.DatasourceConnectionInfo;
import com.supermap.data.EngineType;
import com.supermap.iobjects.process.ml.inference.MLToolkits;
import com.supermap.jsuperpy.TileMeta;
import com.supermap.jsuperpy.callpy.Processes;
import com.supermap.jsuperpy.callpy.Utils;
import java.io.File;
import java.io.FileReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.yaml.snakeyaml.Yaml;

public class SceneClassification {
    public static String processSceneClassificationTile(String inDataPath, String inDatasetName, String modelFile, String outDataPath, String outDatasetName) throws Exception {
        String outName;
        boolean isSuccessful = false;
        int numRows = 0;
        int numCols = 0;
        FileReader inputStream = null;
        String[] inDataPathSplit = inDataPath.split("\\.");
        String inDataFormat = inDataPathSplit[inDataPathSplit.length - 1].toUpperCase();
        EngineType inEngineType = (EngineType)EngineType.parse(EngineType.class, (String)inDataFormat);
        Datasource inDatasource = new Datasource(inEngineType);
        DatasourceConnectionInfo inConn = new DatasourceConnectionInfo();
        inConn.setServer(inDataPath);
        inConn.setEngineType(inEngineType);
        inDatasource.open(inConn);
        Datasource outDatasource = null;
        DatasetImage inDataset = (DatasetImage)inDatasource.getDatasets().get(inDatasetName);
        if (inDataPath.equals(outDataPath)) {
            outName = inDatasource.getDatasets().getAvailableDatasetName(outDatasetName);
            outDatasource = inDatasource;
        } else {
            String[] outDataPathSplit = outDataPath.split("\\.");
            String outDataFormat = outDataPathSplit[outDataPathSplit.length - 1].toUpperCase();
            EngineType outEngineType = (EngineType)EngineType.parse(EngineType.class, (String)outDataFormat);
            outDatasource = new Datasource(outEngineType);
            DatasourceConnectionInfo outConn = new DatasourceConnectionInfo();
            outConn.setServer(outDataPath);
            outConn.setEngineType(outEngineType);
            outDatasource.open(outConn);
            outName = outDatasource.getDatasets().getAvailableDatasetName(outDatasetName);
        }
        inputStream = new FileReader(new File(modelFile));
        Yaml configYaml = new Yaml();
        Map configMap = (Map)configYaml.loadAs((Reader)inputStream, Map.class);
        String modelType = (String)configMap.get("model_type");
        String modelTag = (String)configMap.get("model_tag");
        ArrayList modelInput = (ArrayList)configMap.get("model_input");
        Map shapeMap = (Map)modelInput.get(0);
        ArrayList shapeList = (ArrayList)shapeMap.get("shape");
        if (modelType == null || modelTag == null) {
            System.err.println("ModelType or ModelTag is null, please check your sdm file!");
            return null;
        }
        if (shapeList.size() != 3) {
            System.err.println("ModelInput's Shape don't fit this feature, please check your sdm file!");
            return null;
        }
        numRows = (Integer)shapeList.get(0);
        numCols = (Integer)shapeList.get(1);
        String pyFileName = "process_" + modelType + "_" + modelTag;
        String pyClassName = MLToolkits.getPyClassName(pyFileName);
        File pyFile = MLToolkits.getOperatorPyFile(pyFileName);
        HashMap<String, Object> processArgs = new HashMap<String, Object>();
        processArgs.put("ModelPath", modelFile);
        TileMeta tileMeta = Processes.getDatasetInfo((Dataset)inDataset);
        processArgs.put("PixelFormat", tileMeta.getPixelFormat());
        processArgs.put("Bands", tileMeta.getBands());
        processArgs.put("NoValue", tileMeta.getNoValue());
        String pyText = Utils.readPyFile((File)pyFile);
        processArgs.put("names", "mytest");
        processArgs.put("count", 123);
        Processes.processTilesGetFeature((Dataset)inDataset, (String)pyText, (String)pyClassName, (int)numRows, (int)numCols, (int)0, (Datasource)outDatasource, (String)outName, processArgs);
        return outName;
    }

    public static boolean processSceneClassification(String inDataPath, String inDatasetName, String modelFile, String outDataPath, String outDatasetName) throws Exception {
        FileReader inputStream = new FileReader(new File(modelFile));
        Yaml configYaml = new Yaml();
        Map configMap = (Map)configYaml.loadAs((Reader)inputStream, Map.class);
        String modelType = (String)configMap.get("model_type");
        String modelTag = (String)configMap.get("model_tag");
        ArrayList modelInput = (ArrayList)configMap.get("model_input");
        Map shapeMap = (Map)modelInput.get(0);
        ArrayList shapeList = (ArrayList)shapeMap.get("shape");
        if (modelType == null || modelTag == null) {
            System.err.println("ModelType or ModelTag is null, please check your sdm file!");
            return false;
        }
        if (shapeList.size() != 3) {
            System.err.println("ModelInput's Shape don't fit this feature, please check your sdm file!");
            return false;
        }
        String pyFileName = "process_scene_classification";
        String pyClassName = MLToolkits.getPyClassName(pyFileName);
        File pyFile = MLToolkits.getOperatorPyFile(pyFileName);
        HashMap<String, String> processArgs = new HashMap<String, String>();
        processArgs.put("ModelPath", modelFile);
        processArgs.put("InputData", MLToolkits.getStrInputData(inDataPath, inDatasetName));
        processArgs.put("OutData", outDataPath);
        processArgs.put("OutDatasetName", outDatasetName);
        processArgs.put("ResultType", "region");
        String pyText = Utils.readPyFile((File)pyFile);
        Map result = Processes.process((String)pyText, (String)pyClassName, processArgs);
        MLToolkits.getPythonError(result);
        return Boolean.parseBoolean(result.get("result").toString());
    }
}

