/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.data.conversion;

import com.supermap.data.Charset;
import com.supermap.data.Dataset;
import com.supermap.data.InternalHandle;
import com.supermap.data.conversion.DataExportNative;
import com.supermap.data.conversion.ExportFieldModifyInfo;
import com.supermap.data.conversion.FileType;
import com.supermap.data.conversion.InternalEnum;
import com.supermap.data.conversion.InternalResource;
import java.io.File;
import java.util.ArrayList;

public class ExportSetting {
    String m_targetFilePath;
    String[] m_arrIgnoreFieldNames;
    boolean m_overwrite;
    FileType m_type;
    Object m_sourceData;
    Charset m_targetCharset;
    String m_filter;
    ExportFieldModifyInfo[] m_arrModifyFieldInfos;

    public ExportSetting() {
        this.m_targetFilePath = "";
        this.m_overwrite = false;
        this.m_type = FileType.NONE;
        this.m_sourceData = null;
        this.m_targetCharset = Charset.DEFAULT;
        this.m_arrIgnoreFieldNames = null;
        this.m_filter = "";
        this.m_arrModifyFieldInfos = null;
    }

    public ExportSetting(ExportSetting exportSetting) {
        if (exportSetting == null) {
            String string = InternalResource.loadString("exportSetting", "Global_ArgumentNull", "conversion_resources");
            throw new NullPointerException(string);
        }
        this.setSourceData(exportSetting.getSourceData());
        this.setTargetFilePath(exportSetting.getTargetFilePath());
        this.setTargetFileType(exportSetting.getTargetFileType());
        this.setOverwrite(exportSetting.isOverwrite());
        this.setTargetFileCharset(exportSetting.getTargetFileCharset());
        this.setFilter(exportSetting.getFilter());
        this.setModifyFieldInfos(exportSetting.getModifyFieldInfos());
    }

    public ExportSetting(Object sourceData, String targetFilePath, FileType targetFileType) {
        this();
        this.setSourceData(sourceData);
        this.setTargetFilePath(targetFilePath);
        this.setTargetFileType(targetFileType);
        this.setTargetFileCharset(Charset.DEFAULT);
        this.m_arrModifyFieldInfos = null;
    }

    public String getTargetFilePath() {
        return this.m_targetFilePath;
    }

    public void setTargetFilePath(String filePath) {
        if (!this.isDirectoryExisted(filePath)) {
            String string = InternalResource.loadString("filePath:" + filePath, "Global_PathIsNotValid", "conversion_resources");
            throw new IllegalArgumentException(string);
        }
        this.m_targetFilePath = filePath;
    }

    public boolean isOverwrite() {
        return this.m_overwrite;
    }

    public void setOverwrite(boolean value) {
        this.m_overwrite = value;
    }

    public FileType getTargetFileType() {
        return this.m_type;
    }

    public void setTargetFileType(FileType type) {
        this.m_type = type;
    }

    public Charset getTargetFileCharset() {
        return this.m_targetCharset;
    }

    public void setTargetFileCharset(Charset charset) {
        this.m_targetCharset = charset;
    }

    public Object getSourceData() {
        return this.m_sourceData;
    }

    public void setSourceData(Object value) {
        if (value != null && !(value instanceof Dataset)) {
            String string = InternalResource.loadString("value", "Global_ArgumentTypeInvalid", "conversion_resources");
            throw new IllegalArgumentException(string);
        }
        this.m_sourceData = value;
    }

    @Deprecated
    public String toXML() {
        return "";
    }

    @Deprecated
    public boolean fromXML(String xml) {
        return false;
    }

    public FileType[] getSupportedFileType() {
        Dataset dataset = (Dataset)this.getSourceData();
        Object var2_2 = null;
        ArrayList<FileType> arrayList = new ArrayList<FileType>();
        if (dataset != null) {
            long l = com.supermap.data.conversion.InternalHandle.getHandle((InternalHandle)dataset);
            int[] nArray = DataExportNative.jni_GetSupportedFileType(l);
            for (int i = 0; i < nArray.length; ++i) {
                try {
                    arrayList.add((FileType)InternalEnum.parseUGCValue(FileType.class, nArray[i]));
                    continue;
                }
                catch (RuntimeException runtimeException) {
                    // empty catch block
                }
            }
        }
        return arrayList.toArray(new FileType[arrayList.size()]);
    }

    private boolean isDirectoryExisted(String fileName) {
        File file = new File(fileName);
        boolean bl = false;
        if (file.getParent() == null) {
            bl = true;
        } else {
            File file2 = new File(file.getParent());
            if (file2.exists()) {
                bl = true;
            }
        }
        return bl;
    }

    public String[] getIgnoreFieldNames() {
        return this.m_arrIgnoreFieldNames;
    }

    public void setIgnoreFieldNames(String[] ignoreFields) {
        this.m_arrIgnoreFieldNames = ignoreFields;
    }

    public String getFilter() {
        return this.m_filter;
    }

    public void setFilter(String strfilter) {
        this.m_filter = strfilter;
    }

    public void setModifyFieldInfos(ExportFieldModifyInfo[] fieldInfos) {
        this.m_arrModifyFieldInfos = fieldInfos;
    }

    public ExportFieldModifyInfo[] getModifyFieldInfos() {
        return this.m_arrModifyFieldInfos;
    }

    boolean check() {
        boolean bl = true;
        if (this.m_targetFilePath.length() == 0 || this.m_type.equals((Object)FileType.NONE) || this.m_sourceData == null) {
            bl = false;
        }
        return bl;
    }
}

