/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.realspace.threeddesigner;

import com.supermap.data.Point3D;
import com.supermap.realspace.threeddesigner.FileType;
import com.supermap.realspace.threeddesigner.ImportSetting3D;
import com.supermap.realspace.threeddesigner.ImportSettingIFCNative;
import com.supermap.realspace.threeddesigner.InternalResource;

public class ImportSettingIFC
extends ImportSetting3D {
    public ImportSettingIFC() {
        long l = ImportSettingIFCNative.jni_New();
        this.setHandle(l, true);
    }

    @Override
    protected FileType getFileType() {
        return FileType.ModelIFC;
    }

    public Point3D getPosition() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getPosition)", "Handle_ObjectHasBeenDisposed", "ThreeDDesigner_resources");
            throw new IllegalStateException(string);
        }
        double[] dArray = ImportSettingIFCNative.jni_GetPosition(this.getHandle());
        Point3D point3D = new Point3D(dArray[0], dArray[1], dArray[2]);
        return point3D;
    }

    public void setPosition(Point3D point3d) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setPosition)", "Handle_ObjectHasBeenDisposed", "ThreeDDesigner_resources");
            throw new IllegalStateException(string);
        }
        ImportSettingIFCNative.jni_SetPosition(this.getHandle(), point3d.getX(), point3d.getY(), point3d.getZ());
    }

    public void dispose() {
        if (!this.getIsDisposable()) {
            String string = InternalResource.loadString("dispose()", "Handle_UndisposableObject", "ThreeDDesigner_resources");
            throw new UnsupportedOperationException(string);
        }
        if (this.getHandle() != 0L) {
            ImportSettingIFCNative.jni_Delete(this.getHandle());
            this.clearHandle();
        }
    }
}

