/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.mapping.benchmark;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.lang.management.ManagementFactory;
import java.text.SimpleDateFormat;
import java.util.Date;

class LogWriter {
    private File logFile;
    private OutputStreamWriter writer;
    private SimpleDateFormat dFormat = new SimpleDateFormat("yyyy-MM-dd_HH:mm:ss");
    private static LogWriter gInstance;
    private static boolean m_writeToFile;

    public static String getPID() {
        return ManagementFactory.getRuntimeMXBean().getName().split("@")[0];
    }

    public static LogWriter getInstance() {
        if (gInstance == null) {
            gInstance = new LogWriter();
        }
        return gInstance;
    }

    private LogWriter() {
        if (LogWriter.isWriteToFile()) {
            if (this.logFile == null) {
                String string = "./temp_log/";
                File file = new File(string);
                if (!file.exists()) {
                    file.mkdir();
                }
                String string2 = new SimpleDateFormat("yyyy-MM-dd_HH_mm_ss").format(new Date()) + "_" + LogWriter.getPID() + ".log";
                this.logFile = new File(string + string2);
            }
            try {
                if (!this.logFile.exists()) {
                    this.logFile.createNewFile();
                }
                this.writer = new OutputStreamWriter((OutputStream)new FileOutputStream(this.logFile), "UTF-8");
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writelog(String line) {
        LogWriter logWriter = this;
        synchronized (logWriter) {
            line = this.dFormat.format(new Date()) + "," + line + "\n";
            try {
                if (this.writer != null) {
                    this.writer.write(line);
                }
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flush() {
        LogWriter logWriter = this;
        synchronized (logWriter) {
            try {
                if (this.writer != null) {
                    this.writer.flush();
                }
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
    }

    public void closs() {
        try {
            if (this.writer != null) {
                this.writer.close();
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public static boolean isWriteToFile() {
        return m_writeToFile;
    }

    public static void setWriteToFile(boolean writeToFile) {
        m_writeToFile = writeToFile;
    }

    static {
        m_writeToFile = false;
    }
}

