/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.mapping;

import com.supermap.data.TextStyle;
import com.supermap.data.Toolkit;
import com.supermap.mapping.InternalHandle;
import com.supermap.mapping.InternalHandleDisposable;
import com.supermap.mapping.InternalResource;
import com.supermap.mapping.ThemeLabel;
import com.supermap.mapping.ThemeLabelNative;
import com.supermap.mapping.ThemeLabelRangeItem;
import java.util.ArrayList;
import java.util.concurrent.locks.ReentrantLock;

public class ThemeLabelRangeItems
extends InternalHandle {
    private ArrayList<ThemeLabelRangeItem> m_ThemeLabelRangeItems = null;
    private ThemeLabel m_ThemeLabel = null;
    ReentrantLock m_lock;

    protected ThemeLabelRangeItems(ThemeLabel themeLabel) {
        if (themeLabel == null) {
            String string = InternalResource.loadString("themeUnique", "Global_ArgumentNull", "mapping_resources");
            throw new IllegalArgumentException(string);
        }
        if (InternalHandle.getHandle((com.supermap.data.InternalHandle)themeLabel) == 0L) {
            String string = InternalResource.loadString("themeUnique", "Global_ArgumentObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalArgumentException(string);
        }
        this.m_ThemeLabel = themeLabel;
        this.m_ThemeLabelRangeItems = new ArrayList();
        int n = ThemeLabelNative.jni_GetValueCount(InternalHandle.getHandle((com.supermap.data.InternalHandle)themeLabel));
        int n2 = n - 1;
        for (int i = 0; i < n2; ++i) {
            ThemeLabelRangeItem themeLabelRangeItem = new ThemeLabelRangeItem(this);
            this.m_ThemeLabelRangeItems.add(themeLabelRangeItem);
        }
        this.m_lock = new ReentrantLock();
    }

    public ThemeLabelRangeItem getItem(int index) {
        if (InternalHandle.getHandle((com.supermap.data.InternalHandle)this.getThemeLabel()) == 0L) {
            String string = InternalResource.loadString("getItem(int index)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        int n = this.getCount();
        if (index < 0 || index >= n) {
            String string = InternalResource.loadString("index", "Global_IndexOutOfBounds", "mapping_resources");
            throw new IllegalArgumentException(string);
        }
        return this.m_ThemeLabelRangeItems.get(index);
    }

    public boolean addToHead(ThemeLabelRangeItem item, boolean normalize) {
        int n;
        if (InternalHandle.getHandle((com.supermap.data.InternalHandle)this.getThemeLabel()) == 0L) {
            String string = InternalResource.loadString("addToHead(ThemeLabelItem item)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        if (item.getStart() >= item.getEnd()) {
            if (normalize) {
                if (Toolkit.isZero((double)(item.getStart() - item.getEnd()))) {
                    return false;
                }
                Double d = item.getStart();
                item.setStart(item.getEnd());
                item.setEnd(d);
            } else {
                String string = InternalResource.loadString("item", "ThemeLabel_TheEndShouldBeBiggerTheStart", "mapping_resources");
                throw new IllegalArgumentException(string);
            }
        }
        if ((n = this.getCount()) > 0) {
            double d;
            double d2 = ThemeLabelNative.jni_GetValueAt(InternalHandle.getHandle((com.supermap.data.InternalHandle)this.getThemeLabel()), 0);
            double d3 = item.getEnd();
            double d4 = d3 - d2;
            boolean bl = Toolkit.isZero((double)d4);
            if (!bl) {
                if (normalize) {
                    item.setEnd(d2);
                } else {
                    String string = InternalResource.loadString("item.getEnd()", "ThemeLabel_InvalidEndOfItem", "mapping_resources");
                    throw new IllegalArgumentException(string);
                }
            }
            if ((bl = Toolkit.isZero((double)(d4 = (d = item.getStart()) - d2))) || d > d2) {
                return false;
            }
        }
        this.m_lock.lock();
        ThemeLabelRangeItem themeLabelRangeItem = new ThemeLabelRangeItem(item);
        long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)themeLabelRangeItem.getStyle());
        boolean bl = ThemeLabelNative.jni_AddToHead(InternalHandle.getHandle((com.supermap.data.InternalHandle)this.getThemeLabel()), themeLabelRangeItem.getCaption(), themeLabelRangeItem.isVisible(), l, themeLabelRangeItem.getStart(), themeLabelRangeItem.getEnd(), themeLabelRangeItem.getOffsetX(), themeLabelRangeItem.getOffsetY());
        if (bl) {
            ThemeLabelRangeItem themeLabelRangeItem2 = new ThemeLabelRangeItem(this);
            this.m_ThemeLabelRangeItems.add(0, themeLabelRangeItem2);
            this.refreshLabelItemStyle();
        }
        this.m_lock.unlock();
        return bl;
    }

    public boolean addToTail(ThemeLabelRangeItem item, boolean normalize) {
        int n;
        if (InternalHandle.getHandle((com.supermap.data.InternalHandle)this.getThemeLabel()) == 0L) {
            String string = InternalResource.loadString("addToTail(ThemeLabelItem item)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        if (item.getStart() >= item.getEnd()) {
            if (normalize) {
                if (Toolkit.isZero((double)(item.getStart() - item.getEnd()))) {
                    return false;
                }
                Double d = item.getStart();
                item.setStart(item.getEnd());
                item.setEnd(d);
            } else {
                String string = InternalResource.loadString("item", "ThemeLabel_TheEndShouldBeBiggerTheStart", "mapping_resources");
                throw new IllegalArgumentException(string);
            }
        }
        if ((n = this.getCount()) > 0) {
            double d;
            double d2 = ThemeLabelNative.jni_GetValueAt(InternalHandle.getHandle((com.supermap.data.InternalHandle)this.getThemeLabel()), n);
            double d3 = item.getStart();
            double d4 = d3 - d2;
            boolean bl = Toolkit.isZero((double)d4);
            if (!bl) {
                if (normalize) {
                    item.setStart(d2);
                } else {
                    String string = InternalResource.loadString("item.getStart()", "ThemeLabel_InavlidStartOfItem", "mapping_resources");
                    throw new IllegalArgumentException(string);
                }
            }
            if ((bl = Toolkit.isZero((double)(d4 = d2 - (d = item.getEnd())))) || d < d2) {
                return false;
            }
        }
        this.m_lock.lock();
        ThemeLabelRangeItem themeLabelRangeItem = new ThemeLabelRangeItem(item);
        long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)themeLabelRangeItem.getStyle());
        boolean bl = ThemeLabelNative.jni_AddToTail(InternalHandle.getHandle((com.supermap.data.InternalHandle)this.getThemeLabel()), themeLabelRangeItem.getCaption(), themeLabelRangeItem.isVisible(), l, themeLabelRangeItem.getStart(), themeLabelRangeItem.getEnd(), themeLabelRangeItem.getOffsetX(), themeLabelRangeItem.getOffsetY());
        if (bl) {
            ThemeLabelRangeItem themeLabelRangeItem2 = new ThemeLabelRangeItem(this);
            this.m_ThemeLabelRangeItems.add(themeLabelRangeItem2);
            this.refreshLabelItemStyle();
        }
        this.m_lock.unlock();
        return bl;
    }

    public boolean split(int index, double splitValue, TextStyle style1, String caption1, TextStyle style2, String caption2) {
        if (InternalHandle.getHandle((com.supermap.data.InternalHandle)this.getThemeLabel()) == 0L) {
            String string = InternalResource.loadString("split(int index, double splitValue, TextStyle style1, String caption1, TextStyle style2, String caption2)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        int n = this.getCount();
        if (index < 0 || index >= n) {
            String string = InternalResource.loadString("index", "Global_IndexOutOfBounds", "mapping_resources");
            throw new IndexOutOfBoundsException(string);
        }
        if (style1 == null) {
            String string = InternalResource.loadString("style1", "Global_ArgumentNull", "mapping_resources");
            throw new IllegalArgumentException(string);
        }
        long l = com.supermap.data.InternalHandle.getHandle((com.supermap.data.InternalHandle)style1);
        if (l == 0L) {
            String string = InternalResource.loadString("style1", "Global_ArgumentObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalArgumentException(string);
        }
        if (style2 == null) {
            String string = InternalResource.loadString("style2", "Global_ArgumentNull", "mapping_resources");
            throw new IllegalArgumentException(string);
        }
        long l2 = com.supermap.data.InternalHandle.getHandle((com.supermap.data.InternalHandle)style2);
        if (l2 == 0L) {
            String string = InternalResource.loadString("style2", "Global_ArgumentObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalArgumentException(string);
        }
        double d = ThemeLabelNative.jni_GetValueAt(InternalHandle.getHandle((com.supermap.data.InternalHandle)this.getThemeLabel()), index);
        double d2 = ThemeLabelNative.jni_GetValueAt(InternalHandle.getHandle((com.supermap.data.InternalHandle)this.getThemeLabel()), index + 1);
        if (splitValue <= d || splitValue >= d2) {
            String string = InternalResource.loadString("splitValue", "ThemeLabel_InvalidSplitValue", "mapping_resources");
            throw new IllegalArgumentException(string);
        }
        TextStyle textStyle = style1.clone();
        TextStyle textStyle2 = style2.clone();
        long l3 = com.supermap.data.InternalHandle.getHandle((com.supermap.data.InternalHandle)textStyle);
        long l4 = com.supermap.data.InternalHandle.getHandle((com.supermap.data.InternalHandle)textStyle2);
        if (caption1 == null || caption1.trim().length() == 0) {
            String string = InternalResource.loadString("caption1", "Global_StringIsNullOrEmpty", "mapping_resources");
            throw new IllegalArgumentException(string);
        }
        if (caption2 == null || caption2.trim().length() == 0) {
            String string = InternalResource.loadString("caption2", "Global_StringIsNullOrEmpty", "mapping_resources");
            throw new IllegalArgumentException(string);
        }
        this.m_lock.lock();
        boolean bl = ThemeLabelNative.jni_Split(InternalHandle.getHandle((com.supermap.data.InternalHandle)this.getThemeLabel()), index, splitValue, l3, caption1, l4, caption2);
        InternalHandleDisposable.makeSureNativeObjectLive((Object)textStyle);
        InternalHandleDisposable.makeSureNativeObjectLive((Object)textStyle2);
        if (bl) {
            ThemeLabelRangeItem themeLabelRangeItem = new ThemeLabelRangeItem(this);
            this.m_ThemeLabelRangeItems.add(index + 1, themeLabelRangeItem);
            this.refreshLabelItemStyle();
        }
        this.m_lock.unlock();
        return bl;
    }

    public boolean merge(int index, int count, TextStyle style, String caption) {
        if (InternalHandle.getHandle((com.supermap.data.InternalHandle)this.getThemeLabel()) == 0L) {
            String string = InternalResource.loadString("merge(int index, int count, TextStyle style, String caption)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        int n = this.getCount();
        if (index < 0 || index >= n) {
            String string = InternalResource.loadString("index", "Global_IndexOutOfBounds", "mapping_resources");
            throw new IndexOutOfBoundsException(string);
        }
        if (index + count < index || index + count > n) {
            String string = InternalResource.loadString("count", "ThemeLabel_TheCountIsInvalid", "mapping_resources");
            throw new IllegalArgumentException(string);
        }
        if (caption == null || caption.trim().length() == 0) {
            String string = InternalResource.loadString("caption", "Global_StringIsNullOrEmpty", "mapping_resources");
            throw new IllegalArgumentException(string);
        }
        if (style == null) {
            String string = InternalResource.loadString("style", "Global_ArgumentNull", "mapping_resources");
            throw new IllegalArgumentException(string);
        }
        long l = com.supermap.data.InternalHandle.getHandle((com.supermap.data.InternalHandle)style);
        if (l == 0L) {
            String string = InternalResource.loadString("style", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalArgumentException(string);
        }
        if (count == 0) {
            return true;
        }
        this.m_lock.lock();
        TextStyle textStyle = style.clone();
        long l2 = com.supermap.data.InternalHandle.getHandle((com.supermap.data.InternalHandle)textStyle);
        boolean bl = ThemeLabelNative.jni_Merge(InternalHandle.getHandle((com.supermap.data.InternalHandle)this.getThemeLabel()), index, count, l2, caption);
        InternalHandleDisposable.makeSureNativeObjectLive((Object)textStyle);
        if (bl) {
            ThemeLabelRangeItem themeLabelRangeItem = this.m_ThemeLabelRangeItems.get(index);
            double d = ThemeLabelNative.jni_GetValueAt(InternalHandle.getHandle((com.supermap.data.InternalHandle)this.getThemeLabel()), index + 1);
            themeLabelRangeItem.setEnd(d);
            themeLabelRangeItem.setCaption(caption);
            themeLabelRangeItem.setStyle(style.clone());
            for (int i = 0; i < count - 1; ++i) {
                ThemeLabelRangeItem themeLabelRangeItem2 = this.m_ThemeLabelRangeItems.get(index + 1);
                themeLabelRangeItem2.clearHandle();
                this.m_ThemeLabelRangeItems.remove(index + 1);
            }
            this.refreshLabelItemStyle();
        }
        this.m_lock.unlock();
        return bl;
    }

    public int getCount() {
        if (com.supermap.data.InternalHandle.getHandle((com.supermap.data.InternalHandle)this.m_ThemeLabel) == 0L) {
            String string = InternalResource.loadString("getCount()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        int n = ThemeLabelNative.jni_GetValueCount(com.supermap.data.InternalHandle.getHandle((com.supermap.data.InternalHandle)this.m_ThemeLabel));
        int n2 = 0;
        n2 = n == 0 || n == 1 ? 0 : n - 1;
        return n2;
    }

    ArrayList<ThemeLabelRangeItem> getLabelItemsList() {
        return this.m_ThemeLabelRangeItems;
    }

    private void refreshLabelItemStyle() {
        int n = this.getCount();
        long[] lArray = new long[n];
        ThemeLabelNative.jni_GetStylesHandle(com.supermap.data.InternalHandle.getHandle((com.supermap.data.InternalHandle)this.m_ThemeLabel), lArray);
        for (int i = 0; i < n; ++i) {
            ThemeLabelRangeItem themeLabelRangeItem = this.getItem(i);
            themeLabelRangeItem.refreshStyle(lArray[i]);
        }
    }

    public void reverseStyle() {
        if (com.supermap.data.InternalHandle.getHandle((com.supermap.data.InternalHandle)this.m_ThemeLabel) == 0L) {
            String string = InternalResource.loadString("reverseStyle()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        this.m_lock.lock();
        ThemeLabelNative.jni_ReverseStyle(com.supermap.data.InternalHandle.getHandle((com.supermap.data.InternalHandle)this.m_ThemeLabel));
        this.m_lock.unlock();
    }

    protected ThemeLabel getThemeLabel() {
        if (this.m_ThemeLabel == null) {
            String string = InternalResource.loadString("getThemeLabel()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        if (InternalHandle.getHandle((com.supermap.data.InternalHandle)this.m_ThemeLabel) == 0L) {
            String string = InternalResource.loadString("ThemeLabel", "Global_ArgumentObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalArgumentException(string);
        }
        return this.m_ThemeLabel;
    }

    private void clearLabelItemsList() {
        int n = this.m_ThemeLabelRangeItems.size();
        for (int i = 0; i < n; ++i) {
            ThemeLabelRangeItem themeLabelRangeItem = this.m_ThemeLabelRangeItems.get(i);
            themeLabelRangeItem.clearHandle();
        }
        this.m_ThemeLabelRangeItems.clear();
    }

    protected void refreshLabelItemsList() {
        if (this.m_ThemeLabelRangeItems != null) {
            this.clearLabelItemsList();
        }
        int n = this.getCount();
        for (int i = 0; i < n; ++i) {
            ThemeLabelRangeItem themeLabelRangeItem = new ThemeLabelRangeItem(this);
            this.m_ThemeLabelRangeItems.add(themeLabelRangeItem);
        }
    }

    public void clear() {
        if (this.m_ThemeLabel == null) {
            String string = InternalResource.loadString("clear()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)this.m_ThemeLabel);
        if (InternalHandle.getHandle((com.supermap.data.InternalHandle)this.m_ThemeLabel) == 0L) {
            String string = InternalResource.loadString("ThemeLabel", "Global_ArgumentObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalArgumentException(string);
        }
        this.m_lock.lock();
        ThemeLabelNative.jni_Clear(l);
        this.m_lock.unlock();
        this.clearHandle();
    }

    protected void clearHandle() {
        int n = this.m_ThemeLabelRangeItems.size();
        for (int i = 0; i < n; ++i) {
            ThemeLabelRangeItem themeLabelRangeItem = this.m_ThemeLabelRangeItems.get(i);
            themeLabelRangeItem.clearHandle();
        }
        this.m_ThemeLabelRangeItems.clear();
    }
}

