/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.mapping;

import com.supermap.mapping.InternalHandle;
import com.supermap.mapping.InternalResource;
import com.supermap.mapping.ThemeGridUnique;
import com.supermap.mapping.ThemeGridUniqueNative;
import java.awt.Color;

public class ThemeGridUniqueItem {
    private boolean m_isVisible = true;
    private String m_caption = "UntitledThemeGridUniqueItem";
    private Color m_color = Color.BLACK;
    private double m_unique = 0.0;
    private ThemeGridUnique m_themeGridUnique = null;
    private boolean isUserThemeGridUnique = false;

    public ThemeGridUniqueItem() {
        this.isUserThemeGridUnique = false;
    }

    public ThemeGridUniqueItem(double unique, Color color) {
        this.m_unique = unique;
        this.m_color = color;
        this.isUserThemeGridUnique = false;
    }

    public ThemeGridUniqueItem(double unique, Color color, String caption) {
        if (caption == null || caption.trim().length() == 0) {
            String string = InternalResource.loadString("caption", "Global_StringIsNullOrEmpty", "mapping_resources");
            throw new IllegalArgumentException(string);
        }
        this.m_unique = unique;
        this.m_color = color;
        this.m_caption = caption;
        this.isUserThemeGridUnique = false;
    }

    public ThemeGridUniqueItem(ThemeGridUniqueItem themeGridUniqueItem) {
        if (themeGridUniqueItem == null) {
            String string = InternalResource.loadString("themeGridUniqueItem", "Global_ArgumentNull", "mapping_resources");
            throw new IllegalArgumentException(string);
        }
        if (themeGridUniqueItem.isUserThemeGridUnique) {
            long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)themeGridUniqueItem.m_themeGridUnique);
            if (l == 0L) {
                String string = InternalResource.loadString("themeGridRengeItem", "Handle_ObjectHasBeenDisposed", "mapping_resources");
                throw new IllegalArgumentException(string);
            }
            int n = themeGridUniqueItem.m_themeGridUnique.getGridUniqueItemsList().indexOf(themeGridUniqueItem);
            if (n == -1) {
                String string = InternalResource.loadString("themeGridRangeItem", "Handle_ObjectHasBeenDisposed", "mapping_resources");
                throw new IllegalArgumentException(string);
            }
        }
        this.m_unique = themeGridUniqueItem.getUnique();
        this.m_color = themeGridUniqueItem.getColor();
        this.m_caption = themeGridUniqueItem.getCaption();
        this.m_isVisible = themeGridUniqueItem.isVisible();
        this.isUserThemeGridUnique = false;
    }

    ThemeGridUniqueItem(ThemeGridUnique themeGridUnique) {
        this.m_themeGridUnique = themeGridUnique;
        this.isUserThemeGridUnique = true;
    }

    public double getUnique() {
        double d = 0.0;
        if (this.isUserThemeGridUnique) {
            int n = this.m_themeGridUnique.getGridUniqueItemsList().indexOf(this);
            if (n == -1) {
                String string = InternalResource.loadString("getUnique()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
                throw new IllegalStateException(string);
            }
            long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)this.m_themeGridUnique);
            if (l == 0L) {
                String string = InternalResource.loadString("getUnique()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
                throw new IllegalStateException(string);
            }
            d = ThemeGridUniqueNative.jni_GetUniqueAt(l, n);
        } else {
            d = this.m_unique;
        }
        return d;
    }

    public void setUnique(double value) {
        int n = -1;
        long l = 0L;
        if (this.isUserThemeGridUnique) {
            n = this.m_themeGridUnique.getGridUniqueItemsList().indexOf(this);
            if (n == -1) {
                String string = InternalResource.loadString("setUnique(double value)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
                throw new IllegalStateException(string);
            }
            l = InternalHandle.getHandle((com.supermap.data.InternalHandle)this.m_themeGridUnique);
            if (l == 0L) {
                String string = InternalResource.loadString("setUnique(double value)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
                throw new IllegalStateException(string);
            }
        }
        if (this.isUserThemeGridUnique) {
            ThemeGridUniqueNative.jni_SetUniqueAt(l, n, value);
        }
        this.m_unique = value;
    }

    public Color getColor() {
        Color color = null;
        if (this.isUserThemeGridUnique) {
            int n = this.m_themeGridUnique.getGridUniqueItemsList().indexOf(this);
            if (n == -1) {
                String string = InternalResource.loadString("getColor()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
                throw new IllegalStateException(string);
            }
            long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)this.m_themeGridUnique);
            if (l == 0L) {
                String string = InternalResource.loadString("getColor()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
                throw new IllegalStateException(string);
            }
            int n2 = ThemeGridUniqueNative.jni_GetColorAt(l, n);
            color = new Color(n2, true);
        } else {
            color = this.m_color;
        }
        return color;
    }

    public void setColor(Color color) {
        int n = -1;
        long l = 0L;
        if (this.isUserThemeGridUnique) {
            n = this.m_themeGridUnique.getGridUniqueItemsList().indexOf(this);
            if (n == -1) {
                String string = InternalResource.loadString("setColor(Color color)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
                throw new IllegalStateException(string);
            }
            l = InternalHandle.getHandle((com.supermap.data.InternalHandle)this.m_themeGridUnique);
            if (l == 0L) {
                String string = InternalResource.loadString("setColor(Color color)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
                throw new IllegalStateException(string);
            }
        }
        if (color == null) {
            String string = InternalResource.loadString("color", "Global_ArgumentNull", "mapping_resources");
            throw new IllegalArgumentException(string);
        }
        if (this.isUserThemeGridUnique) {
            int n2 = color.getRGB();
            ThemeGridUniqueNative.jni_SetColorAt(l, n, n2);
        }
        this.m_color = color;
    }

    public boolean isVisible() {
        boolean bl = false;
        if (this.isUserThemeGridUnique) {
            int n = this.m_themeGridUnique.getGridUniqueItemsList().indexOf(this);
            if (n == -1) {
                String string = InternalResource.loadString("getIsVisible()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
                throw new IllegalStateException(string);
            }
            long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)this.m_themeGridUnique);
            if (l == 0L) {
                String string = InternalResource.loadString("getIsVisible()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
                throw new IllegalStateException(string);
            }
            bl = ThemeGridUniqueNative.jni_GetIsVisible(l, n);
        } else {
            bl = this.m_isVisible;
        }
        return bl;
    }

    public void setVisible(boolean value) {
        if (this.isUserThemeGridUnique) {
            int n = this.m_themeGridUnique.getGridUniqueItemsList().indexOf(this);
            if (n == -1) {
                String string = InternalResource.loadString("setIsVisible(boolean value)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
                throw new IllegalStateException(string);
            }
            long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)this.m_themeGridUnique);
            if (l == 0L) {
                String string = InternalResource.loadString("setIsVisible(boolean value)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
                throw new IllegalStateException(string);
            }
            ThemeGridUniqueNative.jni_SetIsVisible(l, n, value);
        }
        this.m_isVisible = value;
    }

    public String getCaption() {
        String string = null;
        if (this.isUserThemeGridUnique) {
            int n = this.m_themeGridUnique.getGridUniqueItemsList().indexOf(this);
            if (n == -1) {
                String string2 = InternalResource.loadString("getCaption()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
                throw new IllegalStateException(string2);
            }
            long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)this.m_themeGridUnique);
            if (l == 0L) {
                String string3 = InternalResource.loadString("getCaption()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
                throw new IllegalStateException(string3);
            }
            string = ThemeGridUniqueNative.jni_GetCaptionAt(l, n);
        } else {
            string = this.m_caption == null ? "" : this.m_caption;
        }
        return string;
    }

    public void setCaption(String caption) {
        if (caption == null || caption.trim().length() == 0) {
            String string = InternalResource.loadString("caption", "Global_StringIsNullOrEmpty", "mapping_resources");
            throw new IllegalArgumentException(string);
        }
        if (this.isUserThemeGridUnique) {
            int n = this.m_themeGridUnique.getGridUniqueItemsList().indexOf(this);
            if (n == -1) {
                String string = InternalResource.loadString("setCaption(String caption)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
                throw new IllegalStateException(string);
            }
            long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)this.m_themeGridUnique);
            if (l == 0L) {
                String string = InternalResource.loadString("setCaption(String caption)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
                throw new IllegalStateException(string);
            }
            ThemeGridUniqueNative.jni_SetCaptionAt(l, n, caption);
        }
        this.m_caption = caption;
    }

    public String toString() {
        if (this.isUserThemeGridUnique) {
            int n = this.m_themeGridUnique.getGridUniqueItemsList().indexOf(this);
            if (n == -1) {
                String string = InternalResource.loadString("toString()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
                throw new IllegalStateException(string);
            }
            long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)this.m_themeGridUnique);
            if (l == 0L) {
                String string = InternalResource.loadString("toString()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
                throw new IllegalStateException(string);
            }
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("{Caption = ");
        stringBuffer.append(this.getCaption());
        stringBuffer.append(",Unique = ");
        stringBuffer.append(this.getUnique());
        stringBuffer.append(",Visible = ");
        stringBuffer.append(this.isVisible());
        stringBuffer.append(",Color = ");
        stringBuffer.append(this.getColor().toString());
        stringBuffer.append("}\n");
        return stringBuffer.toString();
    }
}

