/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.mapping;

import com.supermap.data.Size2D;
import com.supermap.mapping.InternalHandleDisposable;
import com.supermap.mapping.InternalResource;
import com.supermap.mapping.MapOverlapDisplayedOptionsNative;

public class MapOverlapDisplayedOptions
extends InternalHandleDisposable {
    MapOverlapDisplayedOptions(long handle, boolean disposable) {
        this.setHandle(handle, disposable);
    }

    public MapOverlapDisplayedOptions() {
        long l = MapOverlapDisplayedOptionsNative.jni_New();
        this.setHandle(l, true);
    }

    public void dispose() {
        if (!this.getIsDisposable()) {
            String string = InternalResource.loadString("dispose()", "Handle_UndisposableObject", "mapping_resources");
            throw new UnsupportedOperationException(string);
        }
        if (this.getHandle() != 0L) {
            MapOverlapDisplayedOptionsNative.jni_Delete(this.getHandle());
            this.setHandle(0L);
            this.clearHandle();
        }
    }

    protected void clearHandle() {
        this.setHandle(0L);
    }

    public boolean getAllowTextOverlap() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getAllowTextOverlap()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        return MapOverlapDisplayedOptionsNative.jni_GetAllowTextOverlap(this.getHandle());
    }

    public void setAllowTextOverlap(boolean value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setAllowTextOverlap(boolean value)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        MapOverlapDisplayedOptionsNative.jni_SetAllowTextOverlap(this.getHandle(), value);
    }

    public boolean getAllowPointOverlap() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getAllowPointOverlap()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        return MapOverlapDisplayedOptionsNative.jni_GetAllowPointOverlap(this.getHandle());
    }

    public void setAllowPointOverlap(boolean value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setAllowPointOverlap(boolean value)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        MapOverlapDisplayedOptionsNative.jni_SetAllowPointOverlap(this.getHandle(), value);
    }

    public boolean getAllowTextAndPointOverlap() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getAllowTextAndPointOverlap()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        return MapOverlapDisplayedOptionsNative.jni_GetAllowTextAndPointOverlap(this.getHandle());
    }

    public void setAllowTextAndPointOverlap(boolean value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setAllowTextAndPointOverlap(boolean value)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        MapOverlapDisplayedOptionsNative.jni_SetAllowTextAndPointOverlap(this.getHandle(), value);
    }

    public boolean getAllowPointWithTextDisplay() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getAllowPointWithTextDisplay()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        return MapOverlapDisplayedOptionsNative.jni_GetAllowPointWithTextDisplay(this.getHandle());
    }

    public void setAllowPointWithTextDisplay(boolean value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setAllowPointWithTextDisplay(boolean value)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        MapOverlapDisplayedOptionsNative.jni_SetAllowPointWithTextDisplay(this.getHandle(), value);
    }

    public boolean getAllowThemeGraduatedSymbolOverlap() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getAllowThemeGraduatedSymbolOverlap()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        return MapOverlapDisplayedOptionsNative.jni_GetAllowThemeGraduatedSymbolOverlap(this.getHandle());
    }

    public void setAllowThemeGraduatedSymbolOverlap(boolean value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setAllowThemeGraduatedSymbolOverlap(boolean value)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        MapOverlapDisplayedOptionsNative.jni_SetAllowThemeGraduatedSymbolOverlap(this.getHandle(), value);
    }

    public boolean getAllowThemeGraphOverlap() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getAllowThemeGraphOverlap()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        return MapOverlapDisplayedOptionsNative.jni_GetAllowThemeGraphOverlap(this.getHandle());
    }

    public void setAllowThemeGraphOverlap(boolean value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setAllowThemeGraphOverlap(boolean value)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        MapOverlapDisplayedOptionsNative.jni_SetAllowThemeGraphOverlap(this.getHandle(), value);
    }

    public Size2D getOverlappedSpaceSize() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getOverlappedSpaceSize()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        double[] dArray = new double[2];
        MapOverlapDisplayedOptionsNative.jni_GetOverlappedSpaceSize(this.getHandle(), dArray);
        Size2D size2D = new Size2D(dArray[0], dArray[1]);
        return size2D;
    }

    public void setOverlappedSpaceSize(Size2D value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setOverlappedSpaceSize(double value)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        MapOverlapDisplayedOptionsNative.jni_SetOverlappedSpaceSize(this.getHandle(), value.getWidth(), value.getHeight());
    }
}

