/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.mapping;

import com.supermap.data.GeoRegion;
import com.supermap.data.GeoText;
import com.supermap.data.Geometry;
import com.supermap.data.IDisposable;
import com.supermap.data.Point2D;
import com.supermap.data.Rectangle2D;
import com.supermap.data.WorkspaceVersion;
import com.supermap.mapping.InternalEnum;
import com.supermap.mapping.InternalGeometry;
import com.supermap.mapping.InternalHandle;
import com.supermap.mapping.InternalHandleDisposable;
import com.supermap.mapping.InternalResource;
import com.supermap.mapping.InternalToolkitMapping;
import com.supermap.mapping.Layer;
import com.supermap.mapping.LayerExtensionBaseCreatedEvent;
import com.supermap.mapping.LayerExtensionBaseCreatedListener;
import com.supermap.mapping.LayerExtensionBaseNative;
import com.supermap.mapping.LayerExtensionPluginFactory;
import com.supermap.mapping.LayerNative;
import com.supermap.mapping.Layers;
import com.supermap.mapping.Map;
import com.supermap.mapping.MapPainter;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Vector;

public class LayerExtensionBase
extends Layer
implements IDisposable {
    private boolean m_disposable = true;
    static transient Vector g_layerExtensionBaseCreatedListeners;

    public LayerExtensionBase(long handle) {
        long l = LayerExtensionBaseNative.jni_New(handle);
        this.setHandle(l);
        LayerExtensionBaseNative.jni_SetEventHandle(this.getHandle(), this.m_selfEventHandle);
        this.m_disposable = true;
    }

    protected LayerExtensionBase(long handle, Layers layers, Map map) {
        super(handle, layers, map);
        LayerExtensionBaseNative.jni_New(handle);
        LayerExtensionBaseNative.jni_SetEventHandle(this.getHandle(), this.m_selfEventHandle);
        this.m_disposable = false;
    }

    static LayerExtensionBase createUGCInstance(long handle, Layers layers, Map map) {
        Object object;
        int n = LayerExtensionBaseNative.jni_GetExtensionType(handle);
        LayerExtensionBaseCreatedEvent layerExtensionBaseCreatedEvent = new LayerExtensionBaseCreatedEvent(handle, n);
        LayerExtensionBase.fireLayerExtensionBaseCreated(layerExtensionBaseCreatedEvent);
        LayerExtensionBase layerExtensionBase = layerExtensionBaseCreatedEvent.getLayerExtensionBase();
        if (layerExtensionBase == null) {
            HashMap<String, Serializable> hashMap;
            object = null;
            String string = LayerNative.jni_GetExtensionPluginName(handle);
            if (!string.isEmpty()) {
                hashMap = new HashMap<String, String>();
                hashMap.put(LayerExtensionPluginFactory.PLUGIN_NAME.name, (Serializable)((Object)string));
                try {
                    object = LayerExtensionPluginFactory.getPlugin(hashMap);
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
            }
            if (object != null && (hashMap = object.createExtensionLayer(handle, n)) != null && hashMap instanceof LayerExtensionBase) {
                layerExtensionBase = (LayerExtensionBase)((Object)hashMap);
            }
        }
        if (layerExtensionBase == null) {
            layerExtensionBase = new LayerExtensionBase(handle, layers, map);
        } else {
            layerExtensionBase.m_layers = layers;
            layerExtensionBase.setMap(map);
        }
        object = LayerExtensionBaseNative.jni_GetExtensionXml(handle);
        layerExtensionBase.FromXML((String)object);
        return layerExtensionBase;
    }

    public void OnDraw(MapPainter painter) {
        String string = "LayerExtensionBase Unkown Drawing";
        throw new UnsupportedOperationException(string);
    }

    public String ToXML(WorkspaceVersion version) {
        return "";
    }

    String toXMLCallBack(int version) {
        return this.ToXML((WorkspaceVersion)InternalEnum.parseUGCValue(WorkspaceVersion.class, version));
    }

    public void FromXML(String xml) {
    }

    static void fromXMLCallBack(LayerExtensionBase layer, String xml) {
        layer.FromXML(xml);
    }

    @Override
    public Rectangle2D getBounds() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getBounds()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        double[] dArray = new double[4];
        LayerExtensionBaseNative.jni_GetBounds(this.getHandle(), dArray);
        Rectangle2D rectangle2D = new Rectangle2D(dArray[0], dArray[1], dArray[2], dArray[3]);
        return rectangle2D;
    }

    public void setBounds(Rectangle2D bounds) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setBounds()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        if (bounds == null) {
            String string = InternalResource.loadString("bounds", "Global_ArgumentNull", "mapping_resources");
            throw new IllegalStateException(string);
        }
        LayerExtensionBaseNative.jni_SetBounds(this.getHandle(), bounds.getLeft(), bounds.getTop(), bounds.getRight(), bounds.getBottom());
    }

    public int getExtensionType() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getExtensionType()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        return LayerExtensionBaseNative.jni_GetExtensionType(this.getHandle());
    }

    public void setExtensionType(int type) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setExtensionType()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        LayerExtensionBaseNative.jni_SetExtensionType(this.getHandle(), type);
    }

    static void layerDrawCallBack(LayerExtensionBase layer, long graphicsHandle, long drawingHandle) {
        MapPainter mapPainter = new MapPainter(drawingHandle, graphicsHandle);
        layer.OnDraw(mapPainter);
        mapPainter.copyBufferImageToUGC();
        mapPainter.realeaseGraphics();
        mapPainter = null;
    }

    public void dispose() {
        if (!this.getIsDisposable()) {
            String string = InternalResource.loadString("dispose()", "Handle_UndisposableObject", "mapping_resources");
            throw new UnsupportedOperationException(string);
        }
        if (this.getHandle() != 0L && this.m_map == null) {
            LayerExtensionBaseNative.jni_Delete(this.getHandle());
            this.clearHandle();
        }
    }

    private void makeSureNativeObjectLive(InternalHandleDisposable obj) {
        InternalHandle.getHandle((com.supermap.data.InternalHandle)obj);
    }

    protected void setHandle(long handle, boolean disposable) {
        if (this.getIsDisposable() && this.getHandle() != 0L) {
            String string = InternalResource.loadString("setHandle()", "Handle_OriginalObjectHasNotBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        this.setIsDisposable(disposable);
        super.setHandle(handle);
    }

    protected boolean getIsDisposable() {
        return this.m_disposable;
    }

    protected void finalize() {
        if (this.getIsDisposable() && this.getHandle() != 0L) {
            this.dispose();
        }
    }

    protected void setIsDisposable(boolean disposable) {
        this.m_disposable = disposable;
    }

    public static synchronized void addLayerExtensionBaseCreatedListener(LayerExtensionBaseCreatedListener l) {
        if (g_layerExtensionBaseCreatedListeners == null) {
            g_layerExtensionBaseCreatedListeners = new Vector();
        }
        if (!g_layerExtensionBaseCreatedListeners.contains(l)) {
            g_layerExtensionBaseCreatedListeners.insertElementAt(l, 0);
        }
    }

    public static synchronized void removeLayerExtensionBaseCreatedListener(LayerExtensionBaseCreatedListener l) {
        if (g_layerExtensionBaseCreatedListeners != null && g_layerExtensionBaseCreatedListeners.contains(l)) {
            g_layerExtensionBaseCreatedListeners.remove(l);
        }
    }

    static void fireLayerExtensionBaseCreated(LayerExtensionBaseCreatedEvent event) {
        if (g_layerExtensionBaseCreatedListeners != null) {
            Vector vector = g_layerExtensionBaseCreatedListeners;
            int n = vector.size();
            for (int i = n - 1; i >= 0; --i) {
                ((LayerExtensionBaseCreatedListener)vector.elementAt(i)).layerExtensionBaseCreated(event);
            }
        }
    }

    @Override
    public boolean hitTest(Point2D pt, double tolerance, String resultExpression, ArrayList<GeoText> testResult) {
        return false;
    }

    protected boolean selectWithGeoRgn(GeoRegion selectRgn) {
        return false;
    }

    protected boolean highLight(MapPainter painter) {
        return true;
    }

    protected int GetSelectedGeometryCount() {
        return 0;
    }

    protected void removeAllSelectedObj() {
    }

    static void layerHitTestCallBack(LayerExtensionBase layer, double[] hitPoint, double dTolerance, long resultHandle) {
        if (layer != null) {
            Point2D point2D = new Point2D(hitPoint[0], hitPoint[1]);
            boolean bl = layer.hitTest(point2D, dTolerance, null, null);
            InternalToolkitMapping.setHandleBooleanValue(resultHandle, bl);
        }
    }

    static void layerSelectWithGeoRgnCallBack(LayerExtensionBase layer, long selectRgnHandle, long resultHandle) {
        if (layer != null) {
            GeoRegion geoRegion = (GeoRegion)InternalGeometry.createInstance(selectRgnHandle);
            boolean bl = layer.selectWithGeoRgn(geoRegion);
            InternalGeometry.clearHandle((Geometry)geoRegion);
            InternalToolkitMapping.setHandleBooleanValue(resultHandle, bl);
        }
    }

    static void highLightCallBack(LayerExtensionBase layer, long graphicsHandle, long drawingHandle) {
        MapPainter mapPainter = new MapPainter(drawingHandle, graphicsHandle);
        layer.highLight(mapPainter);
        mapPainter.copyBufferImageToUGC();
        mapPainter.realeaseGraphics();
    }

    static void getSelectedGeometryCountCallBack(LayerExtensionBase layer, long selectCountHandle) {
        int n = layer.GetSelectedGeometryCount();
        InternalToolkitMapping.setHandleIntValue(selectCountHandle, n);
    }

    static void removeAllSelectedObjCallBack(LayerExtensionBase layer) {
        if (layer != null) {
            layer.removeAllSelectedObj();
        }
    }
}

