/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.mapping;

import com.supermap.mapping.InternalResource;
import com.supermap.mapping.Layer;
import com.supermap.mapping.LayerCacheNative;
import com.supermap.mapping.Layers;
import com.supermap.mapping.Map;
import java.util.ArrayList;
import java.util.List;

public class LayerCache
extends Layer {
    protected LayerCache(long handle, Layers layers, Map map) {
        super(handle, layers, map);
    }

    public String getConnectionInfo() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getConnectionInfo()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        return LayerCacheNative.jni_GetConnectionInfo(this.getHandle());
    }

    public void setConnectionInfo(String info) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setConnectionInfo(String info)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        if (info == null || info.isEmpty()) {
            String string = InternalResource.loadString("info", "Global_ArgumentNull", "mapping_resources");
            throw new IllegalArgumentException(string);
        }
        LayerCacheNative.jni_SetConnectionInfo(this.getHandle(), info);
    }

    public List<String> getVersions() {
        String[] stringArray;
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getVersions()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        for (String string : stringArray = LayerCacheNative.jni_GetVersions(this.getHandle())) {
            arrayList.add(string);
        }
        return arrayList;
    }

    public List<String> getDescriptions() {
        String[] stringArray;
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getVersions()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        for (String string : stringArray = LayerCacheNative.jni_GetDescriptions(this.getHandle())) {
            arrayList.add(string);
        }
        return arrayList;
    }

    public String getCurrentVersion() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getCurrentVersion()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        return LayerCacheNative.jni_GetCurrentVersion(this.getHandle());
    }

    public void setCurrentVersion(String version) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setCurrentVersion()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        if (version == null || version.isEmpty()) {
            String string = InternalResource.loadString("version", "Global_ArgumentNull", "mapping_resources");
            throw new IllegalArgumentException(string);
        }
        LayerCacheNative.jni_SetCurrentVersion(this.getHandle(), version);
    }

    public void setEffectsEnable(boolean effectsEnable) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setEffectsEnable()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        LayerCacheNative.jni_SetEffectsEnable(this.getHandle(), effectsEnable);
    }

    public boolean isEffectsEnable() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("isEffectsEnable()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        return LayerCacheNative.jni_GetEffectsEnable(this.getHandle());
    }

    public void setEffectsTime(int time) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setEffectsTime()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        if (time < 0) {
            String string = InternalResource.loadString("time", "GlobalArgument_OutOfBounds", "mapping_resources");
            throw new IllegalArgumentException(string);
        }
        LayerCacheNative.jni_SetEffectsTime(this.getHandle(), time);
    }

    public int getEffectsTime() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getEffectsTime()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        return LayerCacheNative.jni_GetEffectsTime(this.getHandle());
    }
}

