/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.data;

import com.supermap.data.InternalHandleDisposable;
import com.supermap.data.InternalResource;
import com.supermap.data.SymbolFillMarkerNative;
import java.awt.Point;
import java.util.ArrayList;

public class SymbolFillMarker
extends InternalHandleDisposable {
    SymbolFillMarker(long handle) {
        this.setHandle(handle, false);
    }

    public SymbolFillMarker() {
        long l = SymbolFillMarkerNative.jni_New();
        this.setHandle(l, true);
    }

    public int getWidth() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getWidth()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return SymbolFillMarkerNative.jni_GetWidth(this.getHandle());
    }

    public void setWidth(int width) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setWidth(int width)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        SymbolFillMarkerNative.jni_SetWidth(this.getHandle(), width);
    }

    public int getHeight() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getHeight()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return SymbolFillMarkerNative.jni_GetHeight(this.getHandle());
    }

    public void setHeight(int height) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setHight(int hight)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        SymbolFillMarkerNative.jni_SetHeight(this.getHandle(), height);
    }

    public int getMarkerID() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getMarkerID()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return SymbolFillMarkerNative.jni_GetMarkerID(this.getHandle());
    }

    public void setMarkerID(int markerID) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setMarkerID(int markerID)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        SymbolFillMarkerNative.jni_SetMarkerID(this.getHandle(), markerID);
    }

    public int getMarkerSize() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getMarkerSize()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return SymbolFillMarkerNative.jni_GetMarkerSize(this.getHandle());
    }

    public void setMarkerSize(int markerSize) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setMarkerSize(int markerSize)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        SymbolFillMarkerNative.jni_SetMarkerSize(this.getHandle(), markerSize);
    }

    public int getMarkerAngle() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getMarkerAngle()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return SymbolFillMarkerNative.jni_GetMarkerAngle(this.getHandle());
    }

    public void setMarkerAngle(int markerAngle) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setMarkerAngle(int markerAngle)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        SymbolFillMarkerNative.jni_SetMarkerAngle(this.getHandle(), markerAngle);
    }

    public ArrayList<Point> getMarkerPoints() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getMarkerPoints()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        int[] nArray = SymbolFillMarkerNative.jni_GetMarkerPoints(this.getHandle());
        int n = nArray.length;
        ArrayList<Point> arrayList = new ArrayList<Point>();
        for (int i = 0; i < n; i += 2) {
            Point point = new Point(nArray[i], nArray[i + 1]);
            arrayList.add(point);
        }
        return arrayList;
    }

    public void setMarkerPoints(ArrayList<Point> markerPoints) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setMarkerPoints(ArrayList<Point> markerPoints)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        int n = markerPoints.size();
        int[] nArray = new int[n * 2];
        for (int i = 0; i < n; ++i) {
            Point point = markerPoints.get(i);
            nArray[i * 2] = point.x;
            nArray[i * 2 + 1] = point.y;
        }
        SymbolFillMarkerNative.jni_SetMarkerPoints(this.getHandle(), nArray);
    }

    public String toString() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("toString()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        String string = "";
        string = string + "{Width=";
        string = string + String.valueOf(this.getWidth());
        string = string + ",Hight=";
        string = string + String.valueOf(this.getHeight());
        string = string + ",MarkerID=";
        string = string + String.valueOf(this.getMarkerID());
        string = string + ",MarkerSize=";
        string = string + String.valueOf(this.getMarkerSize());
        string = string + ",MarkerAngle=";
        string = string + String.valueOf(this.getMarkerAngle());
        string = string + ",MarkerPoints={";
        int[] nArray = SymbolFillMarkerNative.jni_GetMarkerPoints(this.getHandle());
        int n = nArray.length;
        for (int i = 0; i < n; i += 2) {
            string = string + "{";
            string = string + String.valueOf(nArray[i]);
            string = string + ",";
            string = string + String.valueOf(nArray[i + 1]);
            string = string + "},";
        }
        if (n > 0) {
            string = string.substring(0, string.length() - 1);
        }
        string = string + "}}";
        return string;
    }

    @Override
    public void dispose() {
        if (!this.getIsDisposable()) {
            String string = InternalResource.loadString("dispose()", "Handle_UndisposableObject", "data_resources");
            throw new UnsupportedOperationException(string);
        }
        if (this.getHandle() != 0L) {
            SymbolFillMarkerNative.jni_Delete(this.getHandle());
            this.clearHandle();
        }
    }
}

