/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.data;

import com.supermap.data.Enum;
import com.supermap.data.FillResolutionType;
import com.supermap.data.InternalHandleDisposable;
import com.supermap.data.InternalResource;
import com.supermap.data.SymbolFillBaseNative;
import com.supermap.data.SymbolFillBaseType;
import com.supermap.data.SymbolFillMarker;
import java.awt.Color;
import java.awt.image.BufferedImage;
import java.io.File;

public class SymbolFillBase
extends InternalHandleDisposable {
    SymbolFillBase(long handle) {
        this.setHandle(handle, false);
    }

    public SymbolFillBase() {
        long l = SymbolFillBaseNative.jni_New();
        this.setHandle(l, true);
    }

    public FillResolutionType getResolution() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getResolution", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        int n = SymbolFillBaseNative.jni_GetResolution(this.getHandle());
        return (FillResolutionType)Enum.parseUGCValue(FillResolutionType.class, n);
    }

    public void setResolution(FillResolutionType resolutionType) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setResolution", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (resolutionType == null) {
            String string = InternalResource.loadString("resolutionType", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        SymbolFillBaseNative.jni_SetResolution(this.getHandle(), resolutionType.getUGCValue());
    }

    public SymbolFillBaseType getType() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getType", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        SymbolFillBaseType symbolFillBaseType = SymbolFillBaseType.None;
        int n = SymbolFillBaseNative.jni_GetType(this.getHandle());
        symbolFillBaseType = (SymbolFillBaseType)Enum.parseUGCValue(SymbolFillBaseType.class, n);
        return symbolFillBaseType;
    }

    public Color getForeColor() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getForeColor", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        Color color = null;
        int n = SymbolFillBaseNative.jni_GetForeColor(this.getHandle());
        color = new Color(n, true);
        return color;
    }

    public void setForeColor(Color foreColor) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setForeColor", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (foreColor == null) {
            String string = InternalResource.loadString("foreColor", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        SymbolFillBaseNative.jni_SetForeColor(this.getHandle(), foreColor.getRGB());
    }

    public Color getBackColor() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getBackColor", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        Color color = null;
        int n = SymbolFillBaseNative.jni_GetBackColor(this.getHandle());
        color = new Color(n, true);
        return color;
    }

    public void setBackColor(Color backColor) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setForeColor", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (backColor == null) {
            String string = InternalResource.loadString("backColor", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        SymbolFillBaseNative.jni_SetBackColor(this.getHandle(), backColor.getRGB());
    }

    public boolean isBackColorFixed() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("IsBackColorFixed", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return SymbolFillBaseNative.jni_IsBackColorFixed(this.getHandle());
    }

    public void setIsBackColorFixed(boolean value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setIsBackColorFixed", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        SymbolFillBaseNative.jni_SetIsBackColorFixed(this.getHandle(), value);
    }

    public boolean outputToBMP(String fileName, Color frontColor, Color backColor) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("outputToBMP", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (fileName == null || fileName.isEmpty()) {
            String string = InternalResource.loadString("fileName", "Global_StringIsNullOrEmpty", "data_resources");
            throw new IllegalArgumentException(string);
        }
        return SymbolFillBaseNative.jni_OutputToBitmap(this.getHandle(), fileName, frontColor.getRGB(), backColor.getRGB());
    }

    public boolean loadFromBMP(String fileName) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("loadFromBMP", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (fileName == null || fileName.isEmpty()) {
            String string = InternalResource.loadString("fileName", "Global_StringIsNullOrEmpty", "data_resources");
            throw new IllegalArgumentException(string);
        }
        File file = new File(fileName);
        if (!file.exists()) {
            String string = InternalResource.loadString("fileName", "Global_FileNotExists", "data_resources");
            throw new IllegalArgumentException(string);
        }
        return SymbolFillBaseNative.jni_LoadFromBMP(this.getHandle(), fileName);
    }

    public void setBitmap(BufferedImage image) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setBitmap", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (image == null) {
            String string = InternalResource.loadString("image", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        int n = image.getWidth();
        int n2 = image.getHeight();
        int[] nArray = new int[n * n2];
        for (int i = 0; i < n2; ++i) {
            for (int j = 0; j < n; ++j) {
                nArray[i * n + j] = image.getRGB(j, i);
            }
        }
        SymbolFillBaseNative.jni_SetImage(this.getHandle(), nArray, n, n2);
    }

    public BufferedImage getBitmap() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setBitmap", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        int[] nArray = new int[2];
        int[] nArray2 = SymbolFillBaseNative.jni_GetImage(this.getHandle(), nArray);
        BufferedImage bufferedImage = null;
        int n = nArray[0];
        int n2 = nArray[1];
        if (nArray2 != null && n > 0 && n2 > 0) {
            bufferedImage = new BufferedImage(n, n2, 4);
            for (int i = 0; i < n2; ++i) {
                for (int j = 0; j < n; ++j) {
                    bufferedImage.setRGB(j, i, nArray2[i * n + j]);
                }
            }
        }
        return bufferedImage;
    }

    public void setFillMarker(SymbolFillMarker fillMarker) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setFillMarker", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        long l = 0L;
        if (fillMarker != null) {
            l = fillMarker.getHandle();
        }
        SymbolFillBaseNative.jni_SetFillMarker(this.getHandle(), l);
    }

    public SymbolFillMarker getFillMarker() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getFillMarker", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        long l = SymbolFillBaseNative.jni_GetFillMarker(this.getHandle());
        SymbolFillMarker symbolFillMarker = null;
        if (l != 0L) {
            symbolFillMarker = new SymbolFillMarker(l);
        }
        return symbolFillMarker;
    }

    @Override
    public void dispose() {
        if (!this.getIsDisposable()) {
            String string = InternalResource.loadString("dispose()", "Handle_UndisposableObject", "data_resources");
            throw new UnsupportedOperationException(string);
        }
        if (this.getHandle() != 0L) {
            SymbolFillBaseNative.jni_Delete(this.getHandle());
            this.clearHandle();
        }
    }
}

