/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.realspace.spatialanalyst;

import com.supermap.License;
import com.supermap.ProductType;
import com.supermap.data.Dataset;
import com.supermap.data.DatasetVector;
import com.supermap.data.Datasource;
import com.supermap.data.InternalHandleDisposable;
import com.supermap.data.Point3D;
import com.supermap.realspace.Scene;
import com.supermap.realspace.spatialanalyst.InternalDatasetVector;
import com.supermap.realspace.spatialanalyst.InternalDatasets;
import com.supermap.realspace.spatialanalyst.InternalHandle;
import com.supermap.realspace.spatialanalyst.InternalResource;
import com.supermap.realspace.spatialanalyst.InternalToolkitSpatialAnalyst3D;
import com.supermap.realspace.spatialanalyst.ProfileNative;
import com.supermap.ui.InternalBufferImage;
import java.awt.Point;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.HashMap;

public class Profile
extends InternalHandleDisposable {
    private static License m_license;
    private Scene m_scene;
    private Point3D m_startPoint = new Point3D(0.0, 0.0, 0.0);
    private Point3D m_endPoint = new Point3D(0.0, 0.0, 0.0);
    private double m_extendHeight = 0.0;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void verifyLicense() {
        int n = -1;
        Object object = m_license;
        synchronized (object) {
            n = m_license.verify();
        }
        if (n != 0) {
            object = License.getErrorMessage((int)n);
            throw new IllegalStateException((String)object);
        }
    }

    public Profile(Scene scene) {
        Profile.verifyLicense();
        this.m_scene = scene;
        long l = ProfileNative.jni_New("");
        this.setHandle(l, true);
    }

    public void dispose() {
        if (this.getHandle() != 0L) {
            ProfileNative.jni_Delete(this.getHandle());
        }
        this.setHandle(0L);
    }

    public Point3D getStartPoint() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getStartPoint()", "Handle_ObjectHasBeenDisposed", "spatialanalyst3d_resources");
            throw new IllegalStateException(string);
        }
        return this.m_startPoint;
    }

    public void setStartPoint(Point3D point) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setStartPoint()", "Handle_ObjectHasBeenDisposed", "spatialanalyst3d_resources");
            throw new IllegalStateException(string);
        }
        ProfileNative.jni_SetStartPoint(this.getHandle(), point.getX(), point.getY(), point.getZ());
        this.m_startPoint = point;
    }

    public Point3D getEndPoint() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getEndPoint()", "Handle_ObjectHasBeenDisposed", "spatialanalyst3d_resources");
            throw new IllegalStateException(string);
        }
        return this.m_endPoint;
    }

    public void setEndPoint(Point3D point) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setEndPoint()", "Handle_ObjectHasBeenDisposed", "spatialanalyst3d_resources");
            throw new IllegalStateException(string);
        }
        ProfileNative.jni_SetEndPoint(this.getHandle(), point.getX(), point.getY(), point.getZ());
        this.m_endPoint = point;
    }

    public double getExtendHeight() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getExtendHeight()", "Handle_ObjectHasBeenDisposed", "spatialanalyst3d_resources");
            throw new IllegalStateException(string);
        }
        return this.m_extendHeight;
    }

    public void setExtendHeight(double height) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setExtendHeight()", "Handle_ObjectHasBeenDisposed", "spatialanalyst3d_resources");
            throw new IllegalStateException(string);
        }
        ProfileNative.jni_setExtendHeight(this.getHandle(), height);
        this.m_extendHeight = height;
    }

    public BufferedImage outputProfileToBitMap() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("outputMapToBitmap()", "Handle_ObjectHasBeenDisposed", "spatialanalyst3d_resources");
            throw new IllegalStateException(string);
        }
        int[] nArray = new int[2];
        ProfileNative.jni_GetImageBounds(this.getHandle(), nArray);
        int n = nArray[0];
        int n2 = nArray[1];
        InternalBufferImage internalBufferImage = new InternalBufferImage(n, n2);
        ProfileNative.jni_OutputSceneToBitmap(this.getHandle(), InternalHandleDisposable.getHandle((com.supermap.data.InternalHandle)internalBufferImage));
        BufferedImage bufferedImage = new BufferedImage(n, n2, 5);
        bufferedImage.getGraphics().drawImage(internalBufferImage.getMemoryImage(), 0, 0, null);
        internalBufferImage.dispose();
        return bufferedImage;
    }

    public Point3D getLeftTopPosition() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getLeftTopPosition()", "Handle_ObjectHasBeenDisposed", "spatialanalyst3d_resources");
            throw new IllegalStateException(string);
        }
        double[] dArray = new double[3];
        ProfileNative.jni_GetLeftTopPosition(this.getHandle(), dArray);
        return new Point3D(dArray[0], dArray[1], dArray[2]);
    }

    public Point3D getRightBottomPosition() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getRightBottomPosition()", "Handle_ObjectHasBeenDisposed", "spatialanalyst3d_resources");
            throw new IllegalStateException(string);
        }
        double[] dArray = new double[3];
        ProfileNative.jni_GetRightBottomPosition(this.getHandle(), dArray);
        return new Point3D(dArray[0], dArray[1], dArray[2]);
    }

    public boolean build() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("build()", "Handle_ObjectHasBeenDisposed", "spatialanalyst3d_resources");
            throw new IllegalStateException(string);
        }
        return ProfileNative.jni_Build(this.getHandle(), InternalHandle.getHandle((com.supermap.data.InternalHandle)this.m_scene));
    }

    public void clear() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("clear()", "Handle_ObjectHasBeenDisposed", "spatialanalyst3d_resources");
            throw new IllegalStateException(string);
        }
        ProfileNative.jni_Clear(this.getHandle(), InternalHandle.getHandle((com.supermap.data.InternalHandle)this.m_scene));
    }

    public Point getModelIDAndLayerIndex(Point point) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getModelIDAndLayerIndex()", "Handle_ObjectHasBeenDisposed", "spatialanalyst3d_resources");
            throw new IllegalStateException(string);
        }
        int[] nArray = new int[2];
        ProfileNative.jni_GetModelIDAndLayerIndex(this.getHandle(), InternalHandle.getHandle((com.supermap.data.InternalHandle)this.m_scene), point.getX(), point.getY(), nArray);
        return new Point(nArray[0], nArray[1]);
    }

    public void getObjsVisible(HashMap<String, int[]> value) {
        if (this.m_scene == null || InternalHandle.getHandle((com.supermap.data.InternalHandle)this.m_scene) == 0L || this.getHandle() == 0L) {
            String string = InternalResource.loadString("Profile", "Handle_ObjectHasBeenDisposed", "spatialanalyst3d_resources");
            throw new IllegalStateException(string);
        }
        boolean bl = false;
        if (this.m_scene.getTrackingLayer() != null) {
            bl = this.m_scene.getTrackingLayer().isVisible();
            this.m_scene.getTrackingLayer().setVisible(false);
        }
        if (value == null) {
            String string = InternalResource.loadString("value", "Global_ArgumentNull", "spatialanalyst3d_resources");
            throw new IllegalStateException(string);
        }
        int[] nArray = new int[1];
        long l = ProfileNative.jni_GetObjsVisible(this.getHandle(), InternalHandle.getHandle((com.supermap.data.InternalHandle)this.m_scene), nArray);
        if (this.m_scene.getTrackingLayer() != null) {
            this.m_scene.getTrackingLayer().setVisible(bl);
        }
        if (nArray[0] == 0) {
            return;
        }
        String[] stringArray = new String[nArray[0]];
        Object[] objectArray = new Object[nArray[0]];
        ProfileNative.jni_ReadObjsVisibleResult(l, InternalHandle.getHandle((com.supermap.data.InternalHandle)this.m_scene), stringArray, objectArray);
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i] == null || stringArray[i].isEmpty()) continue;
            value.put(stringArray[i], (int[])objectArray[i]);
        }
    }

    public boolean getPoint3Ds(Datasource targetDatasource, String dtName, String filedLayerName, String fieldIDName) {
        if (this.m_scene == null || InternalHandle.getHandle((com.supermap.data.InternalHandle)this.m_scene) == 0L || this.getHandle() == 0L) {
            String string = InternalResource.loadString("Profile", "Handle_ObjectHasBeenDisposed", "spatialanalyst3d_resources");
            throw new IllegalStateException(string);
        }
        if (targetDatasource == null || InternalHandle.getHandle((com.supermap.data.InternalHandle)targetDatasource) == 0L) {
            String string = InternalResource.loadString("targetDatasource", "Handle_ObjectHasBeenDisposed", "spatialanalyst3d_resources");
            throw new IllegalStateException(string);
        }
        if (!targetDatasource.isOpened()) {
            return false;
        }
        boolean bl = false;
        long l = ProfileNative.jni_GetPoint3Ds(this.getHandle(), InternalHandle.getHandle((com.supermap.data.InternalHandle)this.m_scene), InternalHandle.getHandle((com.supermap.data.InternalHandle)targetDatasource), dtName, filedLayerName, fieldIDName);
        if (l != 0L) {
            DatasetVector datasetVector = InternalDatasetVector.createInstance(l, targetDatasource);
            InternalDatasets.add(targetDatasource.getDatasets(), (Dataset)datasetVector);
            bl = true;
        }
        return bl;
    }

    public Point3D measurePoint3D(Point value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("Profile", "Handle_ObjectHasBeenDisposed", "spatialanalyst3d_resources");
            throw new IllegalStateException(string);
        }
        double[] dArray = ProfileNative.jni_MeasurePoint3D(this.getHandle(), value.x, value.y);
        return new Point3D(dArray[0], dArray[1], dArray[2]);
    }

    static {
        ArrayList<ProductType> arrayList = InternalToolkitSpatialAnalyst3D.managerProducts(InternalToolkitSpatialAnalyst3D.getRealspaceSpatialAnalystProducts());
        m_license = InternalToolkitSpatialAnalyst3D.verifyLicense(arrayList);
    }
}

