/*
 * Decompiled with CFR 0.152.
 */
package com.supermap;

import SafeNet.AdminApi;
import com.supermap.InterfaceAdmin;
import com.supermap.KeyInfo;
import com.supermap.License;
import com.supermap.LicenseFeatureInfo;
import com.supermap.LicenseRemoteManagersInfo;
import com.supermap.SessionInfo;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class HaspAdmin
implements InterfaceAdmin {
    private static AdminApi m_adminApi;
    private int rc = 0;
    private static final String SCOPE = "<?xml version=\"1.0\" encoding=\"UTF-8\" ?><haspscope><vendor id=\"99235\" /></haspscope>";
    private static final String REPLACE_CODE = "@_@";
    private static final String Delete_Session = "<admin><deletesession><session id=\"0x@_@\" /></deletesession></admin>";

    public void init(String ip, int port, String password) {
        if (ip == null || ip.length() == 0) {
            ip = "localhost";
        }
        m_adminApi = new AdminApi(ip, port, password);
        this.rc = m_adminApi.connect();
    }

    public String getLastApiError() {
        return HaspAdmin.getErrorText(this.rc);
    }

    public void deleteSession(String sessionID) {
        m_adminApi.getConfig(SCOPE, Delete_Session.replace(REPLACE_CODE, sessionID.trim()));
        this.rc = m_adminApi.getLastApiError();
    }

    public List<SessionInfo> getSessionInfo(String keyId, String featureId) {
        ArrayList<SessionInfo> sessionInfoList = new ArrayList<SessionInfo>();
        String info = "";
        String format = "<admin> <session> <element  name=\"haspid\" /><element  name=\"sessionaccid\" /><element  name=\"productid\" /><element  name=\"featureid\" /><element  name=\"processid\" /><element  name=\"client\" /><element  name=\"machine\" /><element  name=\"user\" /><element  name=\"logintime\" /></session> </admin>";
        String tmp = "";
        String key = "<?xml version=\"1.0\" encoding=\"UTF-8\" ?><haspscope>";
        if (keyId != null && !"".equals(keyId)) {
            tmp = tmp + "<hasp id=\"" + keyId + "\" />";
        }
        if (featureId != null && !"".equals(featureId)) {
            tmp = tmp + "<feature id=\"" + featureId + "\" />";
        }
        if (tmp == null || "".equals(tmp)) {
            tmp = " <vendor id=\"99235\" />";
        }
        key = key + tmp + "</haspscope>";
        info = m_adminApi.getConfig(key, format);
        this.rc = m_adminApi.getLastApiError();
        if (info != null && !"".equals(info)) {
            Document doc = this.getDoc(info);
            Element root = doc.getDocumentElement();
            NodeList haspNodes = root.getElementsByTagName("session");
            Element haspNode = null;
            Element tempNode = null;
            String temp = "";
            for (int i = 0; i < haspNodes.getLength(); ++i) {
                SessionInfo sessionInfotmp = new SessionInfo();
                haspNode = (Element)haspNodes.item(i);
                tempNode = License.getFirstElementByName((Element)haspNode, (String)"haspid");
                temp = tempNode.getFirstChild().getNodeValue();
                sessionInfotmp.m_keyid = Long.valueOf(temp);
                tempNode = License.getFirstElementByName((Element)haspNode, (String)"productid");
                temp = tempNode.getFirstChild().getNodeValue();
                sessionInfotmp.m_productid = Long.valueOf(temp);
                tempNode = License.getFirstElementByName((Element)haspNode, (String)"featureid");
                temp = null == tempNode.getFirstChild() ? "" : tempNode.getFirstChild().getNodeValue();
                temp = tempNode.getFirstChild().getNodeValue();
                sessionInfotmp.m_featureid = Long.valueOf(temp);
                tempNode = License.getFirstElementByName((Element)haspNode, (String)"processid");
                temp = tempNode.getFirstChild().getNodeValue();
                sessionInfotmp.m_processid = Long.valueOf(temp);
                tempNode = License.getFirstElementByName((Element)haspNode, (String)"client");
                sessionInfotmp.m_address = temp = tempNode.getFirstChild().getNodeValue();
                tempNode = License.getFirstElementByName((Element)haspNode, (String)"machine");
                sessionInfotmp.m_hostname = temp = tempNode.getFirstChild().getNodeValue();
                tempNode = License.getFirstElementByName((Element)haspNode, (String)"user");
                sessionInfotmp.m_user = temp = tempNode.getFirstChild().getNodeValue();
                tempNode = License.getFirstElementByName((Element)haspNode, (String)"logintime");
                sessionInfotmp.m_startTime = temp = tempNode.getFirstChild().getNodeValue();
                tempNode = License.getFirstElementByName((Element)haspNode, (String)"sessionaccid");
                sessionInfotmp.m_sessionid = temp = tempNode.getFirstChild().getNodeValue();
                sessionInfoList.add(sessionInfotmp);
            }
        }
        return sessionInfoList;
    }

    public List<LicenseFeatureInfo> getFeatureInfo(String keyId) {
        ArrayList<LicenseFeatureInfo> featureInfoList = new ArrayList<LicenseFeatureInfo>();
        String info = "";
        String format = "<admin> <feature> <attribute name=\"locked\" /><element  name=\"haspid\" /><element  name=\"featureid\" /><element  name=\"featurename\" /><element  name=\"locked\" /><element  name=\"loginlimit\" /><element  name=\"licenserestrictions\" /><element  name=\"logincount\" /></feature> </admin>";
        if (keyId != null && !"".equals(keyId)) {
            String key = "<?xml version=\"1.0\" encoding=\"UTF-8\" ?><haspscope><hasp id=\"" + keyId + "\" /></haspscope>";
            info = m_adminApi.getConfig(key, format);
        } else {
            info = m_adminApi.getConfig(SCOPE, format);
        }
        this.rc = m_adminApi.getLastApiError();
        if (info != null && !"".equals(info)) {
            Document doc = this.getDoc(info);
            Element root = doc.getDocumentElement();
            NodeList haspNodes = root.getElementsByTagName("feature");
            Element haspNode = null;
            Element tempNode = null;
            String temp = "";
            for (int i = 0; i < haspNodes.getLength(); ++i) {
                boolean istrial;
                LicenseFeatureInfo featureinfotmp = new LicenseFeatureInfo();
                haspNode = (Element)haspNodes.item(i);
                tempNode = License.getFirstElementByName((Element)haspNode, (String)"haspid");
                temp = tempNode.getFirstChild().getNodeValue();
                featureinfotmp.m_keyid = Long.parseLong(temp);
                tempNode = License.getFirstElementByName((Element)haspNode, (String)"featureid");
                temp = tempNode.getFirstChild().getNodeValue();
                if (temp.equalsIgnoreCase("0")) continue;
                featureinfotmp.m_id = Long.valueOf(temp);
                tempNode = License.getFirstElementByName((Element)haspNode, (String)"featurename");
                temp = null == tempNode.getFirstChild() ? "" : tempNode.getFirstChild().getNodeValue();
                featureinfotmp.m_name = temp;
                tempNode = License.getFirstElementByName((Element)haspNode, (String)"locked");
                temp = tempNode.getFirstChild().getNodeValue();
                boolean locked = Boolean.parseBoolean(temp);
                Element licenseNode = License.getFirstElementByName((Element)haspNode, (String)"licenserestrictions");
                Element element = License.getFirstElementByName((Element)licenseNode, (String)"license_type");
                temp = element.getFirstChild().getNodeValue();
                featureinfotmp.m_isTrial = istrial = locked ? false : temp.equals("trial");
                tempNode = License.getFirstElementByName((Element)haspNode, (String)"logincount");
                temp = tempNode.getFirstChild().getNodeValue();
                featureinfotmp.m_Logins = Integer.valueOf(temp);
                tempNode = License.getFirstElementByName((Element)haspNode, (String)"loginlimit");
                temp = tempNode.getFirstChild().getNodeValue();
                featureinfotmp.m_maxlogins = Integer.valueOf(temp);
                featureInfoList.add(featureinfotmp);
            }
        }
        return featureInfoList;
    }

    public List<KeyInfo> getKeyInfo() {
        ArrayList<KeyInfo> keyInfoList = new ArrayList<KeyInfo>();
        String info = "";
        String format = "<admin> <hasp> <element  name=\"index\" /><element  name=\"haspid\" /><element  name=\"hostname\" /><element  name=\"addresses\" /><element  name=\"typename\" /><element  name=\"detachable\" /><element  name=\"sessioncount\" /></hasp> </admin>";
        info = m_adminApi.getConfig(SCOPE, format);
        this.rc = m_adminApi.getLastApiError();
        if (info != null && !"".equals(info)) {
            Document doc = this.getDoc(info);
            Element root = doc.getDocumentElement();
            NodeList haspNodes = root.getElementsByTagName("hasp");
            Element haspNode = null;
            Element tempNode = null;
            String temp = "";
            for (int i = 0; i < haspNodes.getLength(); ++i) {
                KeyInfo keyinfotmp = new KeyInfo();
                haspNode = (Element)haspNodes.item(i);
                tempNode = License.getFirstElementByName((Element)haspNode, (String)"haspid");
                keyinfotmp.m_keyid = temp = tempNode.getFirstChild().getNodeValue();
                tempNode = License.getFirstElementByName((Element)haspNode, (String)"hostname");
                keyinfotmp.m_hostname = temp = tempNode.getFirstChild().getNodeValue();
                tempNode = License.getFirstElementByName((Element)haspNode, (String)"addresses");
                keyinfotmp.m_address = temp = tempNode.getFirstChild().getNodeValue();
                tempNode = License.getFirstElementByName((Element)haspNode, (String)"typename");
                keyinfotmp.m_typename = temp = tempNode.getFirstChild().getNodeValue();
                tempNode = License.getFirstElementByName((Element)haspNode, (String)"sessioncount");
                temp = tempNode.getFirstChild().getNodeValue();
                keyinfotmp.m_sessioncount = Long.valueOf(temp);
                tempNode = License.getFirstElementByName((Element)haspNode, (String)"detachable");
                temp = tempNode.getFirstChild().getNodeValue();
                keyinfotmp.m_detachable = false;
                if ("1".equals(temp)) {
                    keyinfotmp.m_detachable = true;
                }
                keyInfoList.add(keyinfotmp);
            }
        }
        return keyInfoList;
    }

    public void update(String str) {
        m_adminApi.setConfig(str);
        this.rc = m_adminApi.getLastApiError();
    }

    public void update(LicenseRemoteManagersInfo licenseSeverInfo) {
        StringBuilder strBuilder = new StringBuilder();
        strBuilder.append("<config>");
        int value = licenseSeverInfo.getAccesstoRemote() ? 1 : 0;
        strBuilder.append(String.format("<accesstoremote>%s</accesstoremote>", value));
        value = licenseSeverInfo.getBroadcastSearch() ? 1 : 0;
        strBuilder.append(String.format("<broadcastsearch>%s</broadcastsearch>", value));
        strBuilder.append("<access_restrictions_clear/>");
        value = licenseSeverInfo.getAccessfromRemote() ? 1 : 0;
        strBuilder.append(String.format("<accessfromremote>%s</accessfromremote>", value));
        strBuilder.append("<serveraddrs_clear/>");
        List serveraddrs = licenseSeverInfo.getServeraddrs();
        if (serveraddrs != null && serveraddrs.size() > 0) {
            for (int i = 0; i < serveraddrs.size(); ++i) {
                strBuilder.append(String.format("<serveraddr>%s</serveraddr>", serveraddrs.get(i)));
            }
        }
        strBuilder.append("<writeconfig />");
        strBuilder.append("</config>");
        this.update(strBuilder.toString());
    }

    public LicenseRemoteManagersInfo getRemoteManagersInfo() {
        String format = "<admin><config><element name=\"*\" /></config></admin>";
        String info = m_adminApi.getConfig(SCOPE, format);
        this.rc = m_adminApi.getLastApiError();
        LicenseRemoteManagersInfo serverInfo = new LicenseRemoteManagersInfo();
        if (info != null && !"".equals(info)) {
            Document doc = this.getDoc(info);
            Element root = doc.getDocumentElement();
            NodeList haspNodes = root.getElementsByTagName("config");
            Element haspNode = null;
            Element tempNode = null;
            String temp = "";
            haspNode = (Element)haspNodes.item(0);
            tempNode = License.getFirstElementByName((Element)haspNode, (String)"accessfromremote");
            temp = tempNode.getFirstChild().getNodeValue();
            serverInfo.setAccessfromRemote(temp.endsWith("1"));
            tempNode = License.getFirstElementByName((Element)haspNode, (String)"broadcastsearch");
            temp = tempNode.getFirstChild().getNodeValue();
            serverInfo.setBroadcastSearch(temp.endsWith("1"));
            tempNode = License.getFirstElementByName((Element)haspNode, (String)"accesstoremote");
            temp = tempNode.getFirstChild().getNodeValue();
            serverInfo.setAccesstoRemote(temp.endsWith("1"));
            NodeList serverlist = haspNode.getElementsByTagName("serveraddr");
            if (serverlist != null && serverlist.getLength() > 0) {
                ArrayList<String> serveraddrs = new ArrayList<String>();
                for (int i = 0; i < serverlist.getLength(); ++i) {
                    serveraddrs.add(serverlist.item(i).getFirstChild().getNodeValue());
                }
                serverInfo.setServeraddrs(serveraddrs);
            }
        }
        return serverInfo;
    }

    public void dispose() {
        if (m_adminApi != null) {
            m_adminApi.dispose();
        }
    }

    private Document getDoc(String info) {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = null;
        try {
            builder = factory.newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            e.printStackTrace();
        }
        Document doc = null;
        try {
            ByteArrayInputStream stream = new ByteArrayInputStream(info.getBytes());
            doc = builder.parse(stream);
        }
        catch (SAXException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return doc;
    }

    private static String getErrorText(int status) {
        switch (status) {
            case 0: {
                return "StatusOk";
            }
            case 3: {
                return "InsufMem";
            }
            case 6001: {
                return "InvalidContext";
            }
            case 6002: {
                return "LmNotFound";
            }
            case 6003: {
                return "LmTooOld";
            }
            case 6004: {
                return "BadParameters";
            }
            case 6006: {
                return "CannotReadFile";
            }
            case 6007: {
                return "ScopeError";
            }
            case 6008: {
                return "PasswordRequired";
            }
            case 6009: {
                return "CannotSetPassword";
            }
            case 6010: {
                return "UpdateError";
            }
            case 6011: {
                return "LocalOnly";
            }
            case 6012: {
                return "BadValue";
            }
            case 6013: {
                return "ReadOnly";
            }
            case 6014: {
                return "ElementUndefined";
            }
            case 6015: {
                return "InvalidPtr";
            }
            case 6016: {
                return "IntegratedLm";
            }
            case 6017: {
                return "ResultTooBig";
            }
            case 6019: {
                return "ResultEmpty";
            }
            case 6022: {
                return "InvVcode";
            }
            case 6034: {
                return "UnkonwVcode";
            }
            case 6051: {
                return "ConnectMissing";
            }
            case 6005: {
                return "LocalNetworkErr";
            }
            case 6052: {
                return "DllBroken";
            }
            case 6053: {
                return "DllLoadInAnotherClassloader";
            }
        }
        return String.valueOf(status);
    }
}

