/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.mapping.benchmark;

import com.supermap.data.Point2D;
import com.supermap.data.Rectangle2D;
import com.supermap.data.Workspace;
import com.supermap.mapping.Map;
import com.supermap.mapping.benchmark.DefaultRunner;
import com.supermap.mapping.benchmark.LogWriter;
import java.awt.image.BufferedImage;
import java.util.Random;
import java.util.concurrent.CountDownLatch;

public class RandomCenterRunner
extends DefaultRunner {
    private int timesPerThread;
    private Rectangle2D bounds;
    private String threadName;
    private String output = "./output";
    private Map map;
    private CountDownLatch finishedLatch;
    private String format;
    private int tileSize;
    private Random random = new Random();

    public RandomCenterRunner(Workspace workspace, String mapName, int timesPerThread, Rectangle2D bounds, String threadName, String format, int tileSize, CountDownLatch finishedLatch) {
        super(workspace, mapName, timesPerThread, bounds, threadName, format, tileSize, finishedLatch);
    }

    @Override
    public void run() {
        LogWriter logWriter = LogWriter.getInstance();
        long l = System.currentTimeMillis();
        for (int i = 0; i < this.timesPerThread; ++i) {
            double d = this.random.nextDouble() * this.bounds.getWidth() + this.bounds.getLeft();
            double d2 = this.random.nextDouble() * this.bounds.getHeight() + this.bounds.getBottom();
            this.map.setCenter(new Point2D(d, d2));
            String string = this.output + "/" + this.threadName + i;
            long l2 = System.currentTimeMillis();
            if (this.format.equals("png")) {
                this.map.outputMapToPNG(string + ".png", true);
            } else if (this.format.equals("jpg")) {
                this.map.outputMapToJPG(string + ".jpg");
            } else {
                BufferedImage bufferedImage = this.map.outputMapToBitmap(true);
            }
            long l3 = System.currentTimeMillis() - l2;
            logWriter.writelog(String.format("%s x %f y %f scale %f output to %s cost %d", this.threadName, d, d2, this.map.getScale(), this.output, l3));
        }
        logWriter.writelog(this.threadName + " output finished, used " + (System.currentTimeMillis() - l) / (long)this.timesPerThread + " ms");
        logWriter.flush();
        this.finishedLatch.countDown();
    }
}

