/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.mapping;

import com.supermap.data.CursorType;
import com.supermap.data.Dataset;
import com.supermap.data.DatasetVector;
import com.supermap.data.Datasource;
import com.supermap.data.GeoStyle;
import com.supermap.data.Recordset;
import com.supermap.mapping.InternalDatasetVector;
import com.supermap.mapping.InternalGeoStyle;
import com.supermap.mapping.InternalHandle;
import com.supermap.mapping.InternalHandleDisposable;
import com.supermap.mapping.InternalRecordset;
import com.supermap.mapping.InternalResource;
import com.supermap.mapping.Layer;
import com.supermap.mapping.SelectionNative;
import com.supermap.mapping.StyleOptions;
import java.util.concurrent.locks.ReentrantLock;

public class Selection
extends com.supermap.data.InternalHandleDisposable {
    private GeoStyle m_geoStyle = null;
    private Datasource m_datasource = null;
    private DatasetVector m_datasetVector = null;
    private boolean isUserLayer = false;
    private Layer m_layer = null;
    private ReentrantLock m_lock;

    public Selection() {
        long l = SelectionNative.jni_New();
        this.setHandle(l, true);
        this.isUserLayer = false;
        this.m_lock = new ReentrantLock();
    }

    public Selection(DatasetVector dataset) {
        if (dataset == null) {
            String string = InternalResource.loadString("dataset", "Global_ArgumentNull", "mapping_resources");
            throw new IllegalArgumentException(string);
        }
        long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)dataset);
        if (l == 0L) {
            String string = InternalResource.loadString("dataset", "Global_ArgumentObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalArgumentException(string);
        }
        this.m_lock = new ReentrantLock();
        long l2 = SelectionNative.jni_New();
        this.setHandle(l2, true);
        this.setDataset(dataset);
        this.isUserLayer = false;
    }

    public Selection(Selection selection) {
        if (selection == null) {
            String string = InternalResource.loadString("selection", "Global_ArgumentNull", "mapping_resources");
            throw new IllegalArgumentException(string);
        }
        if (selection.getHandle() == 0L) {
            String string = InternalResource.loadString("selection", "Global_ArgumentObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalArgumentException(string);
        }
        this.m_lock = new ReentrantLock();
        long l = SelectionNative.jni_Clone(selection.getHandle());
        this.setHandle(l, true);
        this.isUserLayer = false;
        DatasetVector datasetVector = selection.getDataset();
        if (datasetVector != null) {
            this.setDataset(datasetVector);
        }
        InternalHandleDisposable.makeSureNativeObjectLive((Object)((Object)selection));
    }

    Selection(long handle, Layer layer) {
        this.setHandle(handle, false);
        this.m_lock = layer.m_lock;
        this.m_layer = layer;
        this.setDataset((DatasetVector)layer.getDataset());
        this.isUserLayer = true;
    }

    public int getCount() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getCount()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        if (this.isUserLayer) {
            if (this.m_layer == null) {
                String string = InternalResource.loadString("getCount()", "Global_OwnerHasBeenDisposed", "mapping_resources");
                throw new IllegalStateException(string);
            }
            long l = InternalHandle.getHandle(this.m_layer);
            if (l == 0L) {
                String string = InternalResource.loadString("getCount()", "Global_OwnerHasBeenDisposed", "mapping_resources");
                throw new IllegalStateException(string);
            }
            Dataset dataset = this.m_layer.getDataset();
            if (dataset == null) {
                String string = InternalResource.loadString("getCount()", "Selection_DatasetOfOwnerLayerHasBeenDisposed", "mapping_resources");
                throw new IllegalStateException(string);
            }
            long l2 = InternalHandle.getHandle((com.supermap.data.InternalHandle)dataset);
            if (l2 == 0L) {
                String string = InternalResource.loadString("getCount()", "Selection_DatasetOfOwnerLayerHasBeenDisposed", "mapping_resources");
                throw new IllegalStateException(string);
            }
        }
        return SelectionNative.jni_GetCount(this.getHandle());
    }

    public DatasetVector getDataset() {
        long l;
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getDataset()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        if (this.isUserLayer) {
            if (this.m_layer == null) {
                String string = InternalResource.loadString("getDataset()", "Global_OwnerHasBeenDisposed", "mapping_resources");
                throw new IllegalStateException(string);
            }
            long l2 = InternalHandle.getHandle(this.m_layer);
            if (l2 == 0L) {
                String string = InternalResource.loadString("getDataset()", "Global_OwnerHasBeenDisposed", "mapping_resources");
                throw new IllegalStateException(string);
            }
            if (this.m_datasetVector == null) {
                this.m_datasetVector = (DatasetVector)this.m_layer.getDataset();
            }
        } else if (this.m_datasetVector == null && this.m_datasource != null && (l = SelectionNative.jni_GetDataset(this.getHandle())) != 0L) {
            this.m_datasetVector = InternalDatasetVector.createInstanc(l, this.m_datasource);
        }
        return this.m_datasetVector;
    }

    public void setDataset(DatasetVector dataset) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setDataset(DatasetVector dataset)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        if (this.isUserLayer) {
            if (this.m_layer == null) {
                String string = InternalResource.loadString("setDataset(DatasetVector dataset)", "Global_OwnerHasBeenDisposed", "mapping_resources");
                throw new IllegalStateException(string);
            }
            long l = InternalHandle.getHandle(this.m_layer);
            if (l == 0L) {
                String string = InternalResource.loadString("setDataset(DatasetVector dataset)", "Global_OwnerHasBeenDisposed", "mapping_resources");
                throw new IllegalStateException(string);
            }
            String string = InternalResource.loadString("setDataset(DatasetVector dataset)", "Selection_TheOperationOfSetDatasteIsUnsupported", "mapping_resources");
            throw new UnsupportedOperationException(string);
        }
        if (dataset == null) {
            String string = InternalResource.loadString("dataset", "Global_ArgumentNull", "mapping_resources");
            throw new IllegalArgumentException(string);
        }
        long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)dataset);
        if (l == 0L) {
            String string = InternalResource.loadString("dataset", "Global_ArgumentObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalArgumentException(string);
        }
        SelectionNative.jni_SetDataset(this.getHandle(), l);
        this.m_datasetVector = dataset;
        this.m_datasource = dataset.getDatasource();
    }

    public int get(int index) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getItem(int index)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        if (this.isUserLayer) {
            if (this.m_layer == null) {
                String string = InternalResource.loadString("getItem(int index)", "Global_OwnerHasBeenDisposed", "mapping_resources");
                throw new IllegalStateException(string);
            }
            long l = InternalHandle.getHandle(this.m_layer);
            if (l == 0L) {
                String string = InternalResource.loadString("getItem(int index)", "Global_OwnerHasBeenDisposed", "mapping_resources");
                throw new IllegalStateException(string);
            }
            Dataset dataset = this.m_layer.getDataset();
            if (dataset == null) {
                String string = InternalResource.loadString("getItem(int index)", "Selection_DatasetOfOwnerLayerHasBeenDisposed", "mapping_resources");
                throw new IllegalStateException(string);
            }
            long l2 = InternalHandle.getHandle((com.supermap.data.InternalHandle)dataset);
            if (l2 == 0L) {
                String string = InternalResource.loadString("getItem(int index)", "Selection_DatasetOfOwnerLayerHasBeenDisposed", "mapping_resources");
                throw new IllegalStateException(string);
            }
        }
        if (index < 0 || index >= this.getCount()) {
            String string = InternalResource.loadString("index", "Global_IndexOutOfBounds", "mapping_resources");
            throw new IllegalArgumentException(string);
        }
        return SelectionNative.jni_GetItem(this.getHandle(), index);
    }

    public GeoStyle getStyle() {
        long l;
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getStyle()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        if (this.isUserLayer) {
            if (this.m_layer == null) {
                String string = InternalResource.loadString("getStyle()", "Global_OwnerHasBeenDisposed", "mapping_resources");
                throw new IllegalStateException(string);
            }
            l = InternalHandle.getHandle(this.m_layer);
            if (l == 0L) {
                String string = InternalResource.loadString("getStyle()", "Global_OwnerHasBeenDisposed", "mapping_resources");
                throw new IllegalStateException(string);
            }
            Dataset dataset = this.m_layer.getDataset();
            if (dataset == null) {
                String string = InternalResource.loadString("getStyle()", "Selection_DatasetOfOwnerLayerHasBeenDisposed", "mapping_resources");
                throw new IllegalStateException(string);
            }
            long l2 = InternalHandle.getHandle((com.supermap.data.InternalHandle)dataset);
            if (l2 == 0L) {
                String string = InternalResource.loadString("getStyle()", "Selection_DatasetOfOwnerLayerHasBeenDisposed", "mapping_resources");
                throw new IllegalStateException(string);
            }
        }
        if (this.m_geoStyle == null && (l = SelectionNative.jni_GetStyle(this.getHandle())) != 0L) {
            this.m_geoStyle = InternalGeoStyle.createInstance(l);
        }
        return this.m_geoStyle;
    }

    public void setStyle(GeoStyle style) {
        long l;
        Object object;
        long l2;
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setStyle(GeoStyle style)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        if (this.isUserLayer) {
            if (this.m_layer == null) {
                String string = InternalResource.loadString("setStyle(GeoStyle style)", "Global_OwnerHasBeenDisposed", "mapping_resources");
                throw new IllegalStateException(string);
            }
            l2 = InternalHandle.getHandle(this.m_layer);
            if (l2 == 0L) {
                String string = InternalResource.loadString("setStyle(GeoStyle style)", "Global_OwnerHasBeenDisposed", "mapping_resources");
                throw new IllegalStateException(string);
            }
            object = this.m_layer.getDataset();
            if (object == null) {
                String string = InternalResource.loadString("setStyle(GeoStyle style)", "Selection_DatasetOfOwnerLayerHasBeenDisposed", "mapping_resources");
                throw new IllegalStateException(string);
            }
            l = InternalHandle.getHandle((com.supermap.data.InternalHandle)object);
            if (l == 0L) {
                String string = InternalResource.loadString("setStyle(GeoStyle style)", "Selection_DatasetOfOwnerLayerHasBeenDisposed", "mapping_resources");
                throw new IllegalStateException(string);
            }
        }
        if (style == null) {
            String string = InternalResource.loadString("style", "Global_ArgumentNull", "mapping_resources");
            throw new IllegalArgumentException(string);
        }
        l2 = com.supermap.data.InternalHandle.getHandle((com.supermap.data.InternalHandle)style);
        if (l2 == 0L) {
            object = InternalResource.loadString("style", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalArgumentException((String)object);
        }
        object = style.clone();
        l = com.supermap.data.InternalHandle.getHandle((com.supermap.data.InternalHandle)object);
        SelectionNative.jni_SetStyle(this.getHandle(), l);
        InternalHandleDisposable.makeSureNativeObjectLive((Object)object);
        InternalHandleDisposable.makeSureNativeObjectLive((Object)style);
    }

    public boolean isDefaultStyleEnabled() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("isUseDefaultStyle()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        if (this.isUserLayer) {
            if (this.m_layer == null) {
                String string = InternalResource.loadString("isUseDefaultStyle()", "Global_OwnerHasBeenDisposed", "mapping_resources");
                throw new IllegalStateException(string);
            }
            long l = InternalHandle.getHandle(this.m_layer);
            if (l == 0L) {
                String string = InternalResource.loadString("isUseDefaultStyle()", "Global_OwnerHasBeenDisposed", "mapping_resources");
                throw new IllegalStateException(string);
            }
            Dataset dataset = this.m_layer.getDataset();
            if (dataset == null) {
                String string = InternalResource.loadString("isUseDefaultStyle()", "Selection_DatasetOfOwnerLayerHasBeenDisposed", "mapping_resources");
                throw new IllegalStateException(string);
            }
            long l2 = InternalHandle.getHandle((com.supermap.data.InternalHandle)dataset);
            if (l2 == 0L) {
                String string = InternalResource.loadString("isUseDefaultStyle()", "Selection_DatasetOfOwnerLayerHasBeenDisposed", "mapping_resources");
                throw new IllegalStateException(string);
            }
        }
        return SelectionNative.jni_IsUseDefaultStyle(this.getHandle());
    }

    public void setDefaultStyleEnabled(boolean value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setUseDefaultStyle(boolean value)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        if (this.isUserLayer) {
            if (this.m_layer == null) {
                String string = InternalResource.loadString("setUseDefaultStyle(boolean value)", "Global_OwnerHasBeenDisposed", "mapping_resources");
                throw new IllegalStateException(string);
            }
            long l = InternalHandle.getHandle(this.m_layer);
            if (l == 0L) {
                String string = InternalResource.loadString("setUseDefaultStyle(boolean value)", "Global_OwnerHasBeenDisposed", "mapping_resources");
                throw new IllegalStateException(string);
            }
            Dataset dataset = this.m_layer.getDataset();
            if (dataset == null) {
                String string = InternalResource.loadString("setUseDefaultStyle(boolean value)", "Selection_DatasetOfOwnerLayerHasBeenDisposed", "mapping_resources");
                throw new IllegalStateException(string);
            }
            long l2 = InternalHandle.getHandle((com.supermap.data.InternalHandle)dataset);
            if (l2 == 0L) {
                String string = InternalResource.loadString("setUseDefaultStyle(boolean value)", "Selection_DatasetOfOwnerLayerHasBeenDisposed", "mapping_resources");
                throw new IllegalStateException(string);
            }
        }
        SelectionNative.jni_SetUseDefaultStyle(this.getHandle(), value);
    }

    public int add(int geometryID) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("add(int geometryID)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        if (this.isUserLayer) {
            if (this.m_layer == null) {
                String string = InternalResource.loadString("add(int geometryID)", "Global_OwnerHasBeenDisposed", "mapping_resources");
                throw new IllegalStateException(string);
            }
            long l = InternalHandle.getHandle(this.m_layer);
            if (l == 0L) {
                String string = InternalResource.loadString("add(int geometryID)", "Global_OwnerHasBeenDisposed", "mapping_resources");
                throw new IllegalStateException(string);
            }
            Dataset dataset = this.m_layer.getDataset();
            if (dataset == null) {
                String string = InternalResource.loadString("add(int geometryID)", "Selection_DatasetOfOwnerLayerHasBeenDisposed", "mapping_resources");
                throw new IllegalStateException(string);
            }
            long l2 = InternalHandle.getHandle((com.supermap.data.InternalHandle)dataset);
            if (l2 == 0L) {
                String string = InternalResource.loadString("add(int geometryID)", "Selection_DatasetOfOwnerLayerHasBeenDisposed", "mapping_resources");
                throw new IllegalStateException(string);
            }
        }
        if (geometryID <= 0) {
            String string = InternalResource.loadString("geometryID", "Selection_TheArgumentOfGeometryIDShouldBePositive", "mapping_resources");
            throw new IllegalArgumentException(string);
        }
        this.m_lock.lock();
        int n = SelectionNative.jni_Add(this.getHandle(), geometryID);
        this.m_lock.unlock();
        return n;
    }

    public int addRange(int[] geometryIDs) {
        int n;
        Object object;
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("addRange(int[] geometryIDs)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        if (this.isUserLayer) {
            if (this.m_layer == null) {
                String string = InternalResource.loadString("addRange(int[] geometryIDs)", "Global_OwnerHasBeenDisposed", "mapping_resources");
                throw new IllegalStateException(string);
            }
            long l = InternalHandle.getHandle(this.m_layer);
            if (l == 0L) {
                String string = InternalResource.loadString("addRange(int[] geometryIDs)", "Global_OwnerHasBeenDisposed", "mapping_resources");
                throw new IllegalStateException(string);
            }
            object = this.m_layer.getDataset();
            if (object == null) {
                String string = InternalResource.loadString("addRange(int[] geometryIDs)", "Selection_DatasetOfOwnerLayerHasBeenDisposed", "mapping_resources");
                throw new IllegalStateException(string);
            }
            long l2 = InternalHandle.getHandle((com.supermap.data.InternalHandle)object);
            if (l2 == 0L) {
                String string = InternalResource.loadString("addRange(int[] geometryIDs)", "Selection_DatasetOfOwnerLayerHasBeenDisposed", "mapping_resources");
                throw new IllegalStateException(string);
            }
        }
        if (geometryIDs == null) {
            String string = InternalResource.loadString("geometryIDs", "Global_ArgumentNull", "mapping_resources");
            throw new IllegalArgumentException(string);
        }
        int n2 = geometryIDs.length;
        for (n = 0; n < n2; ++n) {
            if (geometryIDs[n] > 0) continue;
            object = InternalResource.loadString("geometryIDs", "Selection_TheArgumentOfGeometryIDShouldBePositive", "mapping_resources");
            throw new IllegalArgumentException((String)object);
        }
        this.m_lock.lock();
        n = SelectionNative.jni_AddRange(this.getHandle(), geometryIDs);
        this.m_lock.unlock();
        return n;
    }

    public boolean remove(int geometryID) {
        int n;
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("remove(int geometryID)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        if (this.isUserLayer) {
            if (this.m_layer == null) {
                String string = InternalResource.loadString("remove(int geometryID)", "Global_OwnerHasBeenDisposed", "mapping_resources");
                throw new IllegalStateException(string);
            }
            long l = InternalHandle.getHandle(this.m_layer);
            if (l == 0L) {
                String string = InternalResource.loadString("remove(int geometryID)", "Global_OwnerHasBeenDisposed", "mapping_resources");
                throw new IllegalStateException(string);
            }
            Dataset dataset = this.m_layer.getDataset();
            if (dataset == null) {
                String string = InternalResource.loadString("remove(int geometryID)", "Selection_DatasetOfOwnerLayerHasBeenDisposed", "mapping_resources");
                throw new IllegalStateException(string);
            }
            long l2 = InternalHandle.getHandle((com.supermap.data.InternalHandle)dataset);
            if (l2 == 0L) {
                String string = InternalResource.loadString("remove(int geometryID)", "Selection_DatasetOfOwnerLayerHasBeenDisposed", "mapping_resources");
                throw new IllegalStateException(string);
            }
        }
        if ((n = SelectionNative.jni_IndexOf(this.getHandle(), geometryID)) == -1) {
            String string = InternalResource.loadString("geometryID", "Selection_TheGeometryIDIsNotInSelection", "mapping_resources");
            throw new IllegalArgumentException(string);
        }
        this.m_lock.lock();
        boolean bl = SelectionNative.jni_Remove(this.getHandle(), n);
        this.m_lock.unlock();
        return bl;
    }

    public int removeRange(int index, int count) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("removeRange(int index, int count)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        if (this.isUserLayer) {
            if (this.m_layer == null) {
                String string = InternalResource.loadString("removeRange(int index, int count)", "Global_OwnerHasBeenDisposed", "mapping_resources");
                throw new IllegalStateException(string);
            }
            long l = InternalHandle.getHandle(this.m_layer);
            if (l == 0L) {
                String string = InternalResource.loadString("removeRange(int index, int count)", "Global_OwnerHasBeenDisposed", "mapping_resources");
                throw new IllegalStateException(string);
            }
            Dataset dataset = this.m_layer.getDataset();
            if (dataset == null) {
                String string = InternalResource.loadString("removeRange(int index, int count)", "Selection_DatasetOfOwnerLayerHasBeenDisposed", "mapping_resources");
                throw new IllegalStateException(string);
            }
            long l2 = InternalHandle.getHandle((com.supermap.data.InternalHandle)dataset);
            if (l2 == 0L) {
                String string = InternalResource.loadString("removeRange(int index, int count)", "Selection_DatasetOfOwnerLayerHasBeenDisposed", "mapping_resources");
                throw new IllegalStateException(string);
            }
        }
        int n = this.getCount();
        if (index < 0 || index >= this.getCount()) {
            String string = InternalResource.loadString("index", "Global_IndexOutOfBounds", "mapping_resources");
            throw new IllegalArgumentException(string);
        }
        if (index + count < index || index + count > n) {
            String string = InternalResource.loadString("count", "Selection_TheArgumentOfCountIsInvalid", "mapping_resources");
            throw new IllegalArgumentException(string);
        }
        this.m_lock.lock();
        int n2 = SelectionNative.jni_RemoveRange(this.getHandle(), index, count);
        this.m_lock.unlock();
        return n2;
    }

    public void clear() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("clear()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        if (this.isUserLayer) {
            if (this.m_layer == null) {
                String string = InternalResource.loadString("clear()", "Global_OwnerHasBeenDisposed", "mapping_resources");
                throw new IllegalStateException(string);
            }
            long l = InternalHandle.getHandle(this.m_layer);
            if (l == 0L) {
                String string = InternalResource.loadString("clear()", "Global_OwnerHasBeenDisposed", "mapping_resources");
                throw new IllegalStateException(string);
            }
            Dataset dataset = this.m_layer.getDataset();
            if (dataset == null) {
                String string = InternalResource.loadString("clear()", "Selection_DatasetOfOwnerLayerHasBeenDisposed", "mapping_resources");
                throw new IllegalStateException(string);
            }
            long l2 = InternalHandle.getHandle((com.supermap.data.InternalHandle)dataset);
            if (l2 == 0L) {
                String string = InternalResource.loadString("clear()", "Selection_DatasetOfOwnerLayerHasBeenDisposed", "mapping_resources");
                throw new IllegalStateException(string);
            }
        }
        this.m_lock.lock();
        SelectionNative.jni_Clear(this.getHandle());
        this.m_lock.unlock();
    }

    public boolean fromRecordset(Recordset recordset) {
        long l;
        long l2;
        String string;
        long l3;
        if (this.getHandle() == 0L) {
            String string2 = InternalResource.loadString("fromRecordset(Recordset recordset)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string2);
        }
        if (this.isUserLayer) {
            if (this.m_layer == null) {
                String string3 = InternalResource.loadString("fromRecordset(Recordset recordset)", "Global_OwnerHasBeenDisposed", "mapping_resources");
                throw new IllegalStateException(string3);
            }
            l3 = InternalHandle.getHandle(this.m_layer);
            if (l3 == 0L) {
                String string4 = InternalResource.loadString("fromRecordset(Recordset recordset)", "Global_OwnerHasBeenDisposed", "mapping_resources");
                throw new IllegalStateException(string4);
            }
            string = this.m_layer.getDataset();
            if (string == null) {
                String string5 = InternalResource.loadString("fromRecordset(Recordset recordset)", "Selection_DatasetOfOwnerLayerHasBeenDisposed", "mapping_resources");
                throw new IllegalStateException(string5);
            }
            long l4 = InternalHandle.getHandle((com.supermap.data.InternalHandle)string);
            if (l4 == 0L) {
                String string6 = InternalResource.loadString("fromRecordset(Recordset recordset)", "Selection_DatasetOfOwnerLayerHasBeenDisposed", "mapping_resources");
                throw new IllegalStateException(string6);
            }
        }
        if (recordset == null) {
            String string7 = InternalResource.loadString("recordset", "Global_ArgumentNull", "mapping_resources");
            throw new IllegalArgumentException(string7);
        }
        l3 = com.supermap.data.InternalHandle.getHandle((com.supermap.data.InternalHandle)recordset);
        if (l3 == 0L) {
            string = InternalResource.loadString("recordset", "Global_ArgumentObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalArgumentException(string);
        }
        if (recordset.isClosed()) {
            string = InternalResource.loadString("recordset", "Selection_RecordsetHasBeenClosed", "mapping_resources");
            throw new IllegalArgumentException(string);
        }
        if (this.isUserLayer && (l2 = InternalHandle.getHandle((com.supermap.data.InternalHandle)this.m_layer.getDataset())) != (l = InternalHandle.getHandle((com.supermap.data.InternalHandle)recordset.getDataset()))) {
            String string8 = InternalResource.loadString("recoreset", "Selection_TheDatasetShouldBeIdentical", "mapping_resources");
            throw new IllegalArgumentException(string8);
        }
        this.m_lock.lock();
        boolean bl = SelectionNative.jni_FromRecordset(this.getHandle(), l3);
        if (bl) {
            if (this.m_geoStyle != null) {
                InternalGeoStyle.clearHandle(this.m_geoStyle);
                this.m_geoStyle = null;
            }
            this.m_datasetVector = recordset.getDataset();
            this.m_datasource = recordset.getDataset().getDatasource();
        }
        InternalHandleDisposable.makeSureNativeObjectLive((Object)recordset);
        this.m_lock.unlock();
        return bl;
    }

    public Recordset toRecordset() {
        DatasetVector datasetVector;
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("toRecordset(boolean geometryOnly)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        if (this.isUserLayer) {
            if (this.m_layer == null) {
                String string = InternalResource.loadString("toRecordset(boolean geometryOnly)", "Global_OwnerHasBeenDisposed", "mapping_resources");
                throw new IllegalStateException(string);
            }
            long l = InternalHandle.getHandle(this.m_layer);
            if (l == 0L) {
                String string = InternalResource.loadString("toRecordset(boolean geometryOnly)", "Global_OwnerHasBeenDisposed", "mapping_resources");
                throw new IllegalStateException(string);
            }
            Dataset dataset = this.m_layer.getDataset();
            if (dataset == null) {
                String string = InternalResource.loadString("toRecordset(boolean geometryOnly)", "Selection_DatasetOfOwnerLayerHasBeenDisposed", "mapping_resources");
                throw new IllegalStateException(string);
            }
            long l2 = InternalHandle.getHandle((com.supermap.data.InternalHandle)dataset);
            if (l2 == 0L) {
                String string = InternalResource.loadString("toRecordset(boolean geometryOnly)", "Selection_DatasetOfOwnerLayerHasBeenDisposed", "mapping_resources");
                throw new IllegalStateException(string);
            }
        }
        if ((datasetVector = this.getDataset()) == null || InternalHandle.getHandle((com.supermap.data.InternalHandle)datasetVector) == 0L) {
            String string = InternalResource.loadString("Dataset", "Selection_TheDatasetVectorNotHasBeenSetted", "mapping_resources");
            throw new IllegalStateException(string);
        }
        this.m_lock.lock();
        Recordset recordset = null;
        long l = SelectionNative.jni_ToRecordset(this.getHandle(), false);
        recordset = l != 0L ? InternalRecordset.createInstance(l, datasetVector) : this.m_datasetVector.getRecordset(true, CursorType.DYNAMIC);
        this.m_lock.unlock();
        return recordset;
    }

    public void dispose() {
        if (!this.getIsDisposable()) {
            String string = InternalResource.loadString("dispose()", "Handle_UndisposableObject", "mapping_resources");
            throw new UnsupportedOperationException(string);
        }
        if (this.getHandle() != 0L) {
            SelectionNative.jni_Delete(this.getHandle());
            this.clearHandle();
        }
    }

    protected void clearHandle() {
        if (this.m_geoStyle != null) {
            InternalGeoStyle.clearHandle(this.m_geoStyle);
            this.m_geoStyle = null;
        }
        this.m_datasource = null;
        this.m_datasetVector = null;
        this.setHandle(0L);
    }

    public void setStyleOptions(StyleOptions styleOptions, boolean isEnable) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setStyleOptions(StyleOptions styleOptions, boolean isEnable)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        if (styleOptions == null) {
            String string = InternalResource.loadString("styleOptions", "Global_ArgumentNull", "mapping_resources");
            throw new IllegalStateException(string);
        }
        SelectionNative.jni_SetStyleOptions(this.getHandle(), styleOptions.value(), isEnable);
    }

    public boolean getStyleOptions(StyleOptions styleOptions) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setStyleOptions(StyleOptions styleOptions, boolean isEnable)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        if (styleOptions == null) {
            String string = InternalResource.loadString("styleOptions", "Global_ArgumentNull", "mapping_resources");
            throw new IllegalStateException(string);
        }
        boolean bl = SelectionNative.jni_GetStyleOptions(this.getHandle(), styleOptions.value());
        return bl;
    }
}

