/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.analyst.addressmatching;

import com.supermap.analyst.addressmatching.InternalGeoRegion;
import com.supermap.analyst.addressmatching.InternalHandle;
import com.supermap.analyst.addressmatching.InternalHandleDisposable;
import com.supermap.analyst.addressmatching.InternalResource;
import com.supermap.data.Dataset;
import com.supermap.data.DatasetVector;
import com.supermap.data.GeoRegion;
import java.util.ArrayList;

public class AddressMatchParameter {
    private ArrayList<Dataset> m_datasets;
    private int m_resultCount;
    private String m_searchAddress;
    private GeoRegion m_geoRegion;
    private boolean m_isLocationReturn;
    private boolean m_isAddressSegmented;

    public AddressMatchParameter() {
        this.m_geoRegion = null;
        this.m_isLocationReturn = false;
        this.m_isAddressSegmented = false;
        this.m_datasets = new ArrayList();
        this.m_resultCount = 0;
    }

    public AddressMatchParameter(AddressMatchParameter addressMatchParameter) {
        if (addressMatchParameter == null) {
            String string = InternalResource.loadString("addressMatchParameter", "Global_ArgumentNull", "addressmatching_resources");
            throw new NullPointerException(string);
        }
        this.m_datasets = new ArrayList();
        int n = addressMatchParameter.m_datasets.size();
        for (int i = 0; i < n; ++i) {
            this.m_datasets.add(addressMatchParameter.m_datasets.get(i));
        }
        this.m_resultCount = addressMatchParameter.m_resultCount;
        this.m_searchAddress = addressMatchParameter.m_searchAddress;
        this.m_isLocationReturn = addressMatchParameter.m_isLocationReturn;
        this.m_isAddressSegmented = addressMatchParameter.m_isAddressSegmented;
        GeoRegion geoRegion = addressMatchParameter.getSearchRegion().clone();
        InternalHandleDisposable.setIsDisposable((com.supermap.data.InternalHandleDisposable)geoRegion, false);
        this.m_geoRegion = geoRegion;
    }

    public DatasetVector[] getSearchDatasets() {
        int n = this.m_datasets.size();
        DatasetVector[] datasetVectorArray = new DatasetVector[n];
        for (int i = 0; i < n; ++i) {
            datasetVectorArray[i] = (DatasetVector)this.m_datasets.get(i);
        }
        return datasetVectorArray;
    }

    public int getResultCount() {
        return this.m_resultCount;
    }

    public void setResultCount(int value) {
        if (value < 0) {
            String string = InternalResource.loadString("value", "Global_ShouldGreaterThanZero", "addressmatching_resources");
            throw new IllegalArgumentException(string);
        }
        this.m_resultCount = value;
    }

    public String getSearchAddress() {
        return this.m_searchAddress;
    }

    public void setSearchAddress(String value) {
        if (value == null || value.trim().length() == 0) {
            String string = InternalResource.loadString("value", "Global_StringIsNullOrEmpty", "addressmatching_resources");
            throw new IllegalArgumentException(string);
        }
        this.m_searchAddress = value;
    }

    public GeoRegion getSearchRegion() {
        return this.m_geoRegion;
    }

    public void setSearchRegion(GeoRegion geoRegion) {
        if (geoRegion != null) {
            if (InternalHandle.getHandle((com.supermap.data.InternalHandle)geoRegion) == 0L) {
                String string = InternalResource.loadString("geoRegion", "Global_ArgumentObjectHasBeenDisposed", "addressmatching_resources");
                throw new IllegalArgumentException(string);
            }
            GeoRegion geoRegion2 = geoRegion.clone();
            InternalHandleDisposable.setIsDisposable((com.supermap.data.InternalHandleDisposable)geoRegion2, false);
            long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)geoRegion2);
            if (this.m_geoRegion != null) {
                InternalGeoRegion.changeHandle(this.m_geoRegion, l);
            } else {
                this.m_geoRegion = geoRegion2;
            }
        } else {
            if (this.m_geoRegion != null) {
                this.m_geoRegion.dispose();
            }
            this.m_geoRegion = null;
        }
    }

    public boolean isLocationReturn() {
        return this.m_isLocationReturn;
    }

    public void setLocationReturn(boolean value) {
        this.m_isLocationReturn = value;
    }

    public boolean isAddressSegmented() {
        return this.m_isAddressSegmented;
    }

    public void setAddressSegmented(boolean value) {
        this.m_isAddressSegmented = value;
    }

    public int addSearchDataset(DatasetVector dataset) {
        if (dataset == null || InternalHandle.getHandle((com.supermap.data.InternalHandle)dataset) == 0L) {
            String string = InternalResource.loadString("dataset", "Global_ArgumentNull", "addressmatching_resources");
            throw new NullPointerException(string);
        }
        this.m_datasets.add((Dataset)dataset);
        return this.m_datasets.size() - 1;
    }

    public boolean setSearchDataset(int index, DatasetVector dataset) {
        if (index >= this.m_datasets.size() || index < 0) {
            String string = InternalResource.loadString("index", "Global_IndexOutOfBounds", "addressmatching_resources");
            throw new ArrayIndexOutOfBoundsException(string);
        }
        if (dataset == null || InternalHandle.getHandle((com.supermap.data.InternalHandle)dataset) == 0L) {
            String string = InternalResource.loadString("dataset", "Global_ArgumentNull", "addressmatching_resources");
            throw new NullPointerException(string);
        }
        this.m_datasets.set(index, (Dataset)dataset);
        return this.m_datasets.get(index).equals(dataset);
    }

    public boolean removeSearchDataset(int index) {
        if (index >= this.m_datasets.size() || index < 0) {
            String string = InternalResource.loadString("index", "Global_IndexOutOfBounds", "addressmatching_resources");
            throw new ArrayIndexOutOfBoundsException(string);
        }
        int n = this.m_datasets.size();
        this.m_datasets.remove(index);
        return this.m_datasets.size() == n - 1;
    }

    public void clearSearchDataset() {
        this.m_datasets.clear();
    }

    protected void finalize() {
        if (this.m_geoRegion != null) {
            InternalHandleDisposable.setIsDisposable((com.supermap.data.InternalHandleDisposable)this.m_geoRegion, true);
            this.m_geoRegion.dispose();
        }
    }
}

