/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.jsuperpy.serializer.impl;

import com.supermap.data.Enum;
import com.supermap.data.PixelFormat;
import com.supermap.jsuperpy.Tile;
import com.supermap.jsuperpy.protos.TileMessages;
import com.supermap.jsuperpy.serializer.DataSerializer;
import java.util.List;
import supermap.shaded.com.google.protobuf.InvalidProtocolBufferException;

public class TileSerializer
extends DataSerializer {
    @Override
    public String getTypeName() {
        return "TI";
    }

    @Override
    public Class getValueClass() {
        return Tile.class;
    }

    @Override
    public byte[] encode(Object value) {
        if (value instanceof Tile) {
            Tile tile = (Tile)value;
            return TileMessages.ProtoTile.newBuilder().setRows(tile.getRows()).setCols(tile.getCols()).setNoValue(tile.getNoValue()).setBands(tile.getMeta().getBands()).setPixelFormat(tile.getMeta().getPixelFormat().value()).addAllValues(tile.getValuesAsList()).build().toByteArray();
        }
        return new byte[0];
    }

    @Override
    public Tile decode(byte[] bys) {
        if (bys != null && bys.length > 0) {
            try {
                TileMessages.ProtoTile protoTile = TileMessages.ProtoTile.parseFrom(bys);
                int rows = protoTile.getRows();
                int cols = protoTile.getCols();
                double noValue = protoTile.getNoValue();
                PixelFormat pixelFormat = (PixelFormat)Enum.parse(PixelFormat.class, (int)protoTile.getPixelFormat());
                int bands = protoTile.getBands();
                List<Double> values = protoTile.getValuesList();
                return new Tile(rows, cols, noValue, pixelFormat, bands).addAllValues(values);
            }
            catch (InvalidProtocolBufferException e) {
                e.printStackTrace();
                return null;
            }
        }
        return null;
    }
}

