/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.jsuperpy.serializer.impl;

import com.supermap.data.Point2D;
import com.supermap.jsuperpy.serializer.DataSerializer;
import com.supermap.jsuperpy.serializer.SerializerUtil;
import java.util.Arrays;

public class Point2DSerializer
extends DataSerializer {
    @Override
    public String getTypeName() {
        return "P2";
    }

    @Override
    public Class getValueClass() {
        return Point2D.class;
    }

    @Override
    public byte[] encode(Object value) {
        if (value instanceof Point2D) {
            Point2D p = (Point2D)value;
            byte[] xb = SerializerUtil.encodeDouble(p.x);
            byte[] yb = SerializerUtil.encodeDouble(p.y);
            byte[] bytes = new byte[16];
            for (int i = 0; i < 8; ++i) {
                bytes[i] = xb[i];
                bytes[i + 8] = yb[i];
            }
            return bytes;
        }
        return new byte[0];
    }

    public Point2D decode(byte[] bys) {
        byte[] xb = Arrays.copyOfRange(bys, 0, 8);
        byte[] yb = Arrays.copyOfRange(bys, 8, 16);
        return new Point2D(SerializerUtil.decodeDouble(xb).doubleValue(), SerializerUtil.decodeDouble(yb).doubleValue());
    }
}

