/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.jsuperpy;

import com.supermap.data.PixelFormat;
import com.supermap.jsuperpy.TileMeta;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class Tile {
    private ArrayList<Double> m_allValues;
    private TileMeta m_meta;

    public Tile(int rows, int cols, double noValue, PixelFormat pixelFormat, int bands) {
        this.m_meta = new TileMeta(rows, cols, noValue, pixelFormat);
        this.m_meta.setBands(bands);
        this.m_allValues = new ArrayList(rows * cols);
    }

    public Tile(TileMeta meta) {
        this.m_meta = new TileMeta(meta);
        this.m_allValues = new ArrayList(meta.getRows() * meta.getCols());
    }

    public Tile addAllValues(double[] values) {
        if (values == null) {
            throw new NullPointerException("values");
        }
        this.m_allValues = new ArrayList(values.length);
        this.init();
        for (int i = 0; i < values.length; ++i) {
            this.m_allValues.add(values[i]);
        }
        return this;
    }

    private void init() {
        for (int i = 0; i < this.m_allValues.size(); ++i) {
            this.m_allValues.set(i, this.m_meta.getNoValue());
        }
    }

    public Tile addAllValues(double[] values, int count) {
        if (values == null) {
            throw new NullPointerException("values");
        }
        if (count != this.getRows() * this.getCols()) {
            throw new IllegalArgumentException("invalid count");
        }
        this.m_allValues = new ArrayList(count);
        this.init();
        for (int i = 0; i < count && i < values.length; ++i) {
            this.m_allValues.add(values[i]);
        }
        return this;
    }

    public Tile addAllValues(Collection<Double> values) {
        if (values == null) {
            throw new NullPointerException("values");
        }
        this.m_allValues.clear();
        this.m_allValues.addAll(values);
        return this;
    }

    public double[] getValues() {
        double[] values = new double[this.m_allValues.size()];
        for (int i = 0; i < this.m_allValues.size(); ++i) {
            values[i] = this.m_allValues.get(i);
        }
        return values;
    }

    public List<Double> getValuesAsList() {
        return this.m_allValues;
    }

    public int getRows() {
        return this.m_meta.getRows();
    }

    public int getCols() {
        return this.m_meta.getCols();
    }

    public double getNoValue() {
        return this.m_meta.getNoValue();
    }

    public TileMeta getMeta() {
        return new TileMeta(this.m_meta);
    }
}

