/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.analyst.networkanalyst;

import com.supermap.analyst.networkanalyst.InternalHandle;
import com.supermap.analyst.networkanalyst.InternalResource;
import com.supermap.analyst.networkanalyst.PathAnalystSetting;
import com.supermap.analyst.networkanalyst.TransportationAnalyst;
import com.supermap.analyst.networkanalyst.TransportationAnalystSetting;
import com.supermap.analyst.networkanalyst.TransportationPathAnalystSettingNative;
import com.supermap.analyst.networkanalyst.WeightFieldInfos;
import com.supermap.data.DatasetType;
import com.supermap.data.DatasetVector;
import com.supermap.data.Toolkit;

public class TransportationPathAnalystSetting
extends PathAnalystSetting {
    private TransportationAnalystSetting m_analystSetting = null;
    private boolean m_bLoadModel = false;

    public TransportationPathAnalystSetting(TransportationAnalystSetting setting) {
        this.m_analystSetting = setting;
    }

    public TransportationAnalystSetting getAnalystSetting() {
        return this.m_analystSetting;
    }

    @Override
    public DatasetVector getNetworkDataset() {
        if (this.m_analystSetting != null) {
            return this.m_analystSetting.getNetworkDataset();
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    boolean load() {
        if (this.m_analystSetting == null) {
            return false;
        }
        long l = TransportationPathAnalystSettingNative.jni_New();
        if (l == 0L) {
            return false;
        }
        this.setHandle(l, true);
        boolean bl = false;
        boolean bl2 = false;
        if (this.m_analystSetting.getNeedSet()) {
            this.setAnalystSettingToUGC();
        }
        boolean bl3 = this.m_analystSetting.getNeedLoadModel();
        boolean bl4 = this.m_analystSetting.getNeedLoadTurnModel();
        if (bl3) {
            if (this.m_analystSetting.isBoundsSet()) {
                if (!this.m_analystSetting.getNetworkDataset().getBounds().hasIntersection(this.m_analystSetting.getBounds())) {
                    String string = InternalResource.loadString("getBounds()", "BoundsInvalid", "networkanalyst_resources");
                    throw new IllegalStateException(string);
                }
                bl = TransportationPathAnalystSettingNative.jni_LoadModelByBounds(this.getHandle(), this.m_analystSetting.getBounds().getTop(), this.m_analystSetting.getBounds().getBottom(), this.m_analystSetting.getBounds().getLeft(), this.m_analystSetting.getBounds().getRight());
            } else {
                bl = TransportationPathAnalystSettingNative.jni_LoadModel(this.getHandle());
            }
            if (!bl) {
                this.m_analystSetting.setNeedLoadModel(true);
                String string = Toolkit.getLastError();
                throw new IllegalArgumentException(string);
            }
            this.m_analystSetting.setNeedLoadModel(false);
        } else {
            bl = true;
        }
        if (bl4) {
            DatasetVector datasetVector = this.m_analystSetting.getTurnDataset();
            if (datasetVector != null && InternalHandle.getHandle((com.supermap.data.InternalHandle)datasetVector) != 0L) {
                bl2 = TransportationPathAnalystSettingNative.jni_LoadTurnModel(this.getHandle());
            } else {
                TransportationPathAnalystSettingNative.jni_UnLoadTurnModel(this.getHandle());
                bl2 = true;
            }
            if (bl2) {
                this.m_analystSetting.setNeedLoadTurnModel(false);
            } else {
                this.m_analystSetting.setNeedLoadTurnModel(true);
            }
        } else {
            bl2 = true;
        }
        this.m_bLoadModel = bl && bl2;
        if (!bl) return false;
        if (!bl2) return false;
        return true;
    }

    private void setAnalystSettingToUGC() {
        String[] stringArray;
        WeightFieldInfos weightFieldInfos;
        if (!this.m_analystSetting.getNeedSet()) {
            return;
        }
        DatasetVector datasetVector = this.m_analystSetting.getNetworkDataset();
        if (datasetVector == null || InternalHandle.getHandle((com.supermap.data.InternalHandle)datasetVector) == 0L) {
            String string = InternalResource.loadString("m_analystSetting.getNetworkDataset()", "TransportationAnalyst_NetworkDatasetHasNotBeenSet", "networkanalyst_resources");
            throw new IllegalStateException(string);
        }
        DatasetType datasetType = datasetVector.getType();
        if (datasetType != DatasetType.NETWORK) {
            String string = InternalResource.loadString("m_analystSetting.getNetworkDataset().getType()", "TransportationAnalyst_DatasetTypeMustBeNetwork", "networkanalyst_resources");
            throw new IllegalStateException(string);
        }
        long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)datasetVector);
        String[] stringArray2 = new String[]{this.m_analystSetting.getNodeIDField(), this.m_analystSetting.getEdgeIDField(), this.m_analystSetting.getFNodeIDField(), this.m_analystSetting.getTNodeIDField(), this.m_analystSetting.getTurnNodeIDField(), this.m_analystSetting.getTurnFEdgeIDField(), this.m_analystSetting.getTurnTEdgeIDField(), this.m_analystSetting.getNodeNameField(), this.m_analystSetting.getEdgeNameField(), this.m_analystSetting.getRuleField()};
        DatasetVector datasetVector2 = this.m_analystSetting.getTurnDataset();
        if (datasetVector2 != null && !datasetVector2.isOpen()) {
            datasetVector2.open();
        }
        String[] stringArray3 = this.m_analystSetting.getTurnWeightFields();
        String[] stringArray4 = this.m_analystSetting.getFTSingleWayRuleValues();
        String[] stringArray5 = this.m_analystSetting.getTFSingleWayRuleValues();
        String[] stringArray6 = this.m_analystSetting.getProhibitedWayRuleValues();
        String[] stringArray7 = this.m_analystSetting.getTwoWayRuleValues();
        String[] stringArray8 = new String[]{stringArray2[0], stringArray2[1], stringArray2[2], stringArray2[3]};
        if (!TransportationAnalyst.isNetworkFieldsAllRight(stringArray8, datasetVector)) {
            String string = InternalResource.loadString("fields", "TransportationAnalystSetting_FieldIsNotInNetworkDataset", "networkanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        long l2 = 0L;
        if (datasetVector2 != null) {
            l2 = InternalHandle.getHandle((com.supermap.data.InternalHandle)datasetVector2);
            weightFieldInfos = datasetVector2.getType();
            if (weightFieldInfos != DatasetType.TABULAR) {
                String string = InternalResource.loadString("m_analystSetting.getTurnDataset().getType()", "TransportationAnalyst_DatasetTypeMustBeTabular", "networkanalyst_resources");
                throw new IllegalStateException(string);
            }
            if (stringArray2[4] == null || stringArray2[4].trim().length() == 0) {
                String string = InternalResource.loadString("m_analystSetting.getTurnNodeIDField()", "Global_StringIsNullOrEmpty", "networkanalyst_resources");
                throw new IllegalStateException(string);
            }
            if (stringArray2[5] == null || stringArray2[5].trim().length() == 0) {
                String string = InternalResource.loadString("m_analystSetting.getTurnFEdgeIDField()", "Global_StringIsNullOrEmpty", "networkanalyst_resources");
                throw new IllegalStateException(string);
            }
            if (stringArray2[6] == null || stringArray2[6].trim().length() == 0) {
                String string = InternalResource.loadString("m_analystSetting.getTurnTEdgeIDField()", "Global_StringIsNullOrEmpty", "networkanalyst_resources");
                throw new IllegalStateException(string);
            }
            stringArray = new String[]{stringArray2[4], stringArray2[5], stringArray2[6]};
            if (!TransportationAnalyst.isTurnFieldsAllRight(stringArray, datasetVector2)) {
                String string = InternalResource.loadString("fields", "TransportationAnalystSetting_FieldIsNotInTurnDataset", "networkanalyst_resources");
                throw new IllegalArgumentException(string);
            }
            if (!TransportationAnalyst.isTurnFieldsAllRight(stringArray3, datasetVector2)) {
                String string = InternalResource.loadString("turnWeightFields", "TransportationAnalystSetting_FieldIsNotInTurnDataset", "networkanalyst_resources");
                throw new IllegalArgumentException(string);
            }
        }
        if ((weightFieldInfos = this.m_analystSetting.getWeightFieldInfos()) == null || weightFieldInfos.getCount() <= 0) {
            stringArray = InternalResource.loadString("m_analystSetting.getWeightFieldInfos()", "TransportationAnalyst_WeightFieldInfoCountShouldGreaterThanZero", "networkanalyst_resources");
            throw new IllegalArgumentException((String)stringArray);
        }
        stringArray = null;
        String[] stringArray9 = null;
        String[] stringArray10 = null;
        int n = weightFieldInfos.getCount();
        stringArray = new String[n];
        stringArray9 = new String[n];
        stringArray10 = new String[n];
        for (int i = 0; i < n; ++i) {
            stringArray[i] = weightFieldInfos.get(i).getName();
            stringArray9[i] = weightFieldInfos.get(i).getFTWeightField();
            stringArray10[i] = weightFieldInfos.get(i).getTFWeightField();
        }
        int[] nArray = this.m_analystSetting.getBarrierNodes();
        int[] nArray2 = this.m_analystSetting.getBarrierEdges();
        double d = this.m_analystSetting.getTolerance();
        String string = this.m_analystSetting.getEdgeFilter();
        boolean bl = this.m_analystSetting.getUseBasicLoad();
        TransportationPathAnalystSettingNative.jni_SetAnalystSettingToUGC(this.getHandle(), l, l2, stringArray2, stringArray, stringArray9, stringArray10, stringArray3, nArray, nArray2, stringArray4, stringArray5, stringArray6, stringArray7, d, string, bl);
        this.m_analystSetting.setNeedSet(false);
    }

    public void dispose() {
        if (this.getHandle() != 0L) {
            TransportationPathAnalystSettingNative.jni_Delete(this.getHandle());
            this.setHandle(0L);
        }
    }
}

