/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.analyst.networkanalyst;

import com.supermap.License;
import com.supermap.ProductType;
import com.supermap.analyst.networkanalyst.BurstAnalyseResult;
import com.supermap.analyst.networkanalyst.FacilityAnalystNative;
import com.supermap.analyst.networkanalyst.FacilityAnalystResult;
import com.supermap.analyst.networkanalyst.FacilityAnalystSetting;
import com.supermap.analyst.networkanalyst.InternalHandle;
import com.supermap.analyst.networkanalyst.InternalHandleDisposable;
import com.supermap.analyst.networkanalyst.InternalResource;
import com.supermap.analyst.networkanalyst.InternalToolkitNetworkAnalyst;
import com.supermap.analyst.networkanalyst.WeightFieldInfos;
import com.supermap.data.CursorType;
import com.supermap.data.DatasetType;
import com.supermap.data.DatasetVector;
import com.supermap.data.FieldInfos;
import com.supermap.data.QueryParameter;
import com.supermap.data.Recordset;
import com.supermap.data.Toolkit;
import java.util.ArrayList;

public class FacilityAnalyst
extends InternalHandleDisposable {
    private FacilityAnalystSetting m_analystSetting = null;
    private License m_license;
    private boolean m_modelLoaded = false;

    public FacilityAnalyst() {
        this.checkLicense();
        long l = FacilityAnalystNative.jni_New();
        this.setHandle(l, true);
        this.m_analystSetting = new FacilityAnalystSetting();
        this.m_modelLoaded = false;
    }

    public FacilityAnalystSetting getAnalystSetting() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getAnalystSetting()", "Handle_ObjectHasBeenDisposed", "networkanalyst_resources");
            throw new IllegalStateException(string);
        }
        return this.m_analystSetting;
    }

    public void setAnalystSetting(FacilityAnalystSetting value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setAnalystSetting(FacilityAnalystSetting value)", "Handle_ObjectHasBeenDisposed", "networkanalyst_resources");
            throw new IllegalStateException(string);
        }
        if (value == null) {
            String string = InternalResource.loadString("setAnalystSetting(FacilityAnalystSetting value)", "Global_ArgumentNull", "networkanalyst_resources");
            throw new NullPointerException(string);
        }
        if (!this.getAnalystSetting().equals(value)) {
            this.m_analystSetting.copyFrom(value);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public boolean load() {
        boolean bl;
        this.verifyLicense();
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("load()", "Handle_ObjectHasBeenDisposed", "networkanalyst_resources");
            throw new IllegalStateException(string);
        }
        boolean bl2 = false;
        if (this.m_analystSetting.getNeedSet()) {
            this.setAnalsytSettingToUGC();
        }
        if (bl = this.m_analystSetting.getNeedLoadModel()) {
            Toolkit.clearErrors();
            bl2 = FacilityAnalystNative.jni_LoadModel(this.getHandle());
            if (!bl2) {
                this.m_analystSetting.setNeedLoadModel(true);
                String string = Toolkit.getLastError();
                throw new IllegalArgumentException(string);
            }
            this.m_analystSetting.setNeedLoadModel(false);
        } else {
            bl2 = true;
        }
        this.m_modelLoaded = true;
        return bl2;
    }

    public int[] findLoopsFromNodes(int[] nodeIDs) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("findLoopsFromNodes(int[] nodeIDs)", "Handle_ObjectHasBeenDisposed", "networkanalyst_resources");
            throw new IllegalStateException(string);
        }
        if (this.isLoadModelNeeded()) {
            String string = InternalResource.loadString("", "FacilityAnalyst_LoadModelNeeded", "networkanalyst_resources");
            throw new IllegalStateException(string);
        }
        if (nodeIDs == null) {
            String string = InternalResource.loadString("nodeIDs", "Global_ArgumentNull", "networkanalyst_resources");
            throw new NullPointerException(string);
        }
        for (int i = 0; i < nodeIDs.length; ++i) {
            if (nodeIDs[i] > 0) continue;
            String string = InternalResource.loadString("nodeIDs[" + i + "]", "Global_IDShouldGreaterThanZero", "networkanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        return FacilityAnalystNative.jni_FindLoopsFromNodes(this.getHandle(), nodeIDs, this.m_analystSetting.getBarrierEdges(), this.m_analystSetting.getBarrierNodes());
    }

    public int[] findLoopsFromEdges(int[] edgeIDs) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("findLoopsFromEdgeIDs(int[] edgeIDs)", "Handle_ObjectHasBeenDisposed", "networkanalyst_resources");
            throw new IllegalStateException(string);
        }
        if (this.isLoadModelNeeded()) {
            String string = InternalResource.loadString("", "FacilityAnalyst_LoadModelNeeded", "networkanalyst_resources");
            throw new IllegalStateException(string);
        }
        if (edgeIDs == null) {
            String string = InternalResource.loadString("edgeIDs", "Global_ArgumentNull", "networkanalyst_resources");
            throw new NullPointerException(string);
        }
        for (int i = 0; i < edgeIDs.length; ++i) {
            if (edgeIDs[i] > 0) continue;
            String string = InternalResource.loadString("edgeIDs[" + i + "]", "Global_IDShouldGreaterThanZero", "networkanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        return FacilityAnalystNative.jni_FindLoopsFromEdges(this.getHandle(), edgeIDs, this.m_analystSetting.getBarrierEdges(), this.m_analystSetting.getBarrierNodes());
    }

    public int[] findConnectedEdgesFromNodes(int[] nodeIDs) {
        boolean bl;
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("findConnectedEdgesFromNodes(int[] nodeIDs)", "Handle_ObjectHasBeenDisposed", "networkanalyst_resources");
            throw new IllegalStateException(string);
        }
        if (this.isLoadModelNeeded()) {
            String string = InternalResource.loadString("", "FacilityAnalyst_LoadModelNeeded", "networkanalyst_resources");
            throw new IllegalStateException(string);
        }
        if (nodeIDs == null) {
            String string = InternalResource.loadString("nodeIDs", "Global_ArgumentNull", "networkanalyst_resources");
            throw new NullPointerException(string);
        }
        for (bl = false; bl < nodeIDs.length; bl += 1) {
            if (nodeIDs[bl] > 0) continue;
            String string = InternalResource.loadString("nodeIDs[" + (int)(bl ? 1 : 0) + "]", "Global_IDShouldGreaterThanZero", "networkanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        bl = true;
        return FacilityAnalystNative.jni_FindConnectedEdgesFromNodes(this.getHandle(), nodeIDs, bl, this.m_analystSetting.getBarrierEdges(), this.m_analystSetting.getBarrierNodes());
    }

    public int[] findConnectedEdgesFromEdges(int[] edgeIDs) {
        boolean bl;
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("findConnectedEdgesFromEdges(int[] edgeIDs)", "Handle_ObjectHasBeenDisposed", "networkanalyst_resources");
            throw new IllegalStateException(string);
        }
        if (this.isLoadModelNeeded()) {
            String string = InternalResource.loadString("", "FacilityAnalyst_LoadModelNeeded", "networkanalyst_resources");
            throw new IllegalStateException(string);
        }
        if (edgeIDs == null) {
            String string = InternalResource.loadString("edgeIDs", "Global_ArgumentNull", "networkanalyst_resources");
            throw new NullPointerException(string);
        }
        for (bl = false; bl < edgeIDs.length; bl += 1) {
            if (edgeIDs[bl] > 0) continue;
            String string = InternalResource.loadString("edgeIDs[" + (int)(bl ? 1 : 0) + "]", "Global_IDShouldGreaterThanZero", "networkanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        bl = true;
        return FacilityAnalystNative.jni_FindConnectedEdgesFromEdges(this.getHandle(), edgeIDs, bl, this.m_analystSetting.getBarrierEdges(), this.m_analystSetting.getBarrierNodes());
    }

    public int[] findUnconnectedEdgesFromNodes(int[] nodeIDs) {
        boolean bl;
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("findUnconnectedEdgesFromNodes(int[] nodeIDs)", "Handle_ObjectHasBeenDisposed", "networkanalyst_resources");
            throw new IllegalStateException(string);
        }
        if (this.isLoadModelNeeded()) {
            String string = InternalResource.loadString("", "FacilityAnalyst_LoadModelNeeded", "networkanalyst_resources");
            throw new IllegalStateException(string);
        }
        if (nodeIDs == null) {
            String string = InternalResource.loadString("nodeIDs", "Global_ArgumentNull", "networkanalyst_resources");
            throw new NullPointerException(string);
        }
        for (bl = false; bl < nodeIDs.length; bl += 1) {
            if (nodeIDs[bl] > 0) continue;
            String string = InternalResource.loadString("nodeIDs[" + (int)(bl ? 1 : 0) + "]", "Global_IDShouldGreaterThanZero", "networkanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        bl = false;
        return FacilityAnalystNative.jni_FindConnectedEdgesFromNodes(this.getHandle(), nodeIDs, bl, this.m_analystSetting.getBarrierEdges(), this.m_analystSetting.getBarrierNodes());
    }

    public int[] findUnconnectedEdgesFromEdges(int[] edgeIDs) {
        boolean bl;
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("findUnconnectedEdgesFromEdges(int[] edgeIDs)", "Handle_ObjectHasBeenDisposed", "networkanalyst_resources");
            throw new IllegalStateException(string);
        }
        if (this.isLoadModelNeeded()) {
            String string = InternalResource.loadString("", "FacilityAnalyst_LoadModelNeeded", "networkanalyst_resources");
            throw new IllegalStateException(string);
        }
        if (edgeIDs == null) {
            String string = InternalResource.loadString("edgeIDs", "Global_ArgumentNull", "networkanalyst_resources");
            throw new NullPointerException(string);
        }
        for (bl = false; bl < edgeIDs.length; bl += 1) {
            if (edgeIDs[bl] > 0) continue;
            String string = InternalResource.loadString("edgeIDs[" + (int)(bl ? 1 : 0) + "]", "Global_IDShouldGreaterThanZero", "networkanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        bl = false;
        return FacilityAnalystNative.jni_FindConnectedEdgesFromEdges(this.getHandle(), edgeIDs, bl, this.m_analystSetting.getBarrierEdges(), this.m_analystSetting.getBarrierNodes());
    }

    public int[] findCommonAncestorsFromNodes(int[] nodeIDs, boolean isUncertainDirectionValid) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("findCommonAncestorsFromNodes(int[] nodeIDs, String weightName, boolean isUncertainDirectionValid)", "Handle_ObjectHasBeenDisposed", "networkanalyst_resources");
            throw new IllegalStateException(string);
        }
        if (this.isLoadModelNeeded()) {
            String string = InternalResource.loadString("", "FacilityAnalyst_LoadModelNeeded", "networkanalyst_resources");
            throw new IllegalStateException(string);
        }
        if (nodeIDs == null) {
            String string = InternalResource.loadString("nodeIDs", "Global_ArgumentNull", "networkanalyst_resources");
            throw new NullPointerException(string);
        }
        for (int i = 0; i < nodeIDs.length; ++i) {
            if (nodeIDs[i] > 0) continue;
            String string = InternalResource.loadString("nodeIDs[" + i + "]", "Global_IDShouldGreaterThanZero", "networkanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        String string = this.m_analystSetting.getWeightFieldInfos().get(0).getName();
        int n = 0;
        return FacilityAnalystNative.jni_FindCommonAncestorsFromNodes(this.getHandle(), nodeIDs, string, isUncertainDirectionValid, n, this.m_analystSetting.getBarrierEdges(), this.m_analystSetting.getBarrierNodes());
    }

    public int[] findCommonAncestorsFromEdges(int[] edgeIDs, boolean isUncertainDirectionValid) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("findCommonAncestorsFromEdges(int[] edgeIDs, String weightName, boolean isUncertainDirectionValid)", "Handle_ObjectHasBeenDisposed", "networkanalyst_resources");
            throw new IllegalStateException(string);
        }
        if (this.isLoadModelNeeded()) {
            String string = InternalResource.loadString("", "FacilityAnalyst_LoadModelNeeded", "networkanalyst_resources");
            throw new IllegalStateException(string);
        }
        if (edgeIDs == null) {
            String string = InternalResource.loadString("edgeIDs", "Global_ArgumentNull", "networkanalyst_resources");
            throw new NullPointerException(string);
        }
        for (int i = 0; i < edgeIDs.length; ++i) {
            if (edgeIDs[i] > 0) continue;
            String string = InternalResource.loadString("edgeIDs[" + i + "]", "Global_IDShouldGreaterThanZero", "networkanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        String string = this.m_analystSetting.getWeightFieldInfos().get(0).getName();
        int n = 0;
        return FacilityAnalystNative.jni_FindCommonAncestorsFromEdges(this.getHandle(), edgeIDs, string, isUncertainDirectionValid, n, this.m_analystSetting.getBarrierEdges(), this.m_analystSetting.getBarrierNodes());
    }

    public int[] findCommonCatchmentsFromNodes(int[] nodeIDs, boolean isUncertainDirectionValid) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("findCommonCatchementsFromNodes(int[] nodeIDs, String weightName, boolean isUncertainDirectionValid)", "Handle_ObjectHasBeenDisposed", "networkanalyst_resources");
            throw new IllegalStateException(string);
        }
        if (this.isLoadModelNeeded()) {
            String string = InternalResource.loadString("", "FacilityAnalyst_LoadModelNeeded", "networkanalyst_resources");
            throw new IllegalStateException(string);
        }
        if (nodeIDs == null) {
            String string = InternalResource.loadString("nodeIDs", "Global_ArgumentNull", "networkanalyst_resources");
            throw new NullPointerException(string);
        }
        for (int i = 0; i < nodeIDs.length; ++i) {
            if (nodeIDs[i] > 0) continue;
            String string = InternalResource.loadString("nodeIDs[" + i + "]", "Global_IDShouldGreaterThanZero", "networkanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        String string = this.m_analystSetting.getWeightFieldInfos().get(0).getName();
        int n = 1;
        return FacilityAnalystNative.jni_FindCommonAncestorsFromNodes(this.getHandle(), nodeIDs, string, isUncertainDirectionValid, n, this.m_analystSetting.getBarrierEdges(), this.m_analystSetting.getBarrierNodes());
    }

    public int[] findCommonCatchmentsFromEdges(int[] edgeIDs, boolean isUncertainDirectionValid) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("findCommonCatchmentsFromEdges(int[] edgeIDs, String weightName, boolean isUncertainDirectionValid)", "Handle_ObjectHasBeenDisposed", "networkanalyst_resources");
            throw new IllegalStateException(string);
        }
        if (this.isLoadModelNeeded()) {
            String string = InternalResource.loadString("", "FacilityAnalyst_LoadModelNeeded", "networkanalyst_resources");
            throw new IllegalStateException(string);
        }
        if (edgeIDs == null) {
            String string = InternalResource.loadString("edgeIDs", "Global_ArgumentNull", "networkanalyst_resources");
            throw new NullPointerException(string);
        }
        for (int i = 0; i < edgeIDs.length; ++i) {
            if (edgeIDs[i] > 0) continue;
            String string = InternalResource.loadString("edgeIDs[" + i + "]", "Global_IDShouldGreaterThanZero", "networkanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        String string = this.m_analystSetting.getWeightFieldInfos().get(0).getName();
        int n = 1;
        return FacilityAnalystNative.jni_FindCommonAncestorsFromEdges(this.getHandle(), edgeIDs, string, isUncertainDirectionValid, n, this.m_analystSetting.getBarrierEdges(), this.m_analystSetting.getBarrierNodes());
    }

    public FacilityAnalystResult findSourceFromNode(int nodeID, String weightName, boolean isUncertainDirectionValid) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("findSourceFromNode(int nodeID, String weightName, boolean isUncertainDirectionValid)", "Handle_ObjectHasBeenDisposed", "networkanalyst_resources");
            throw new IllegalStateException(string);
        }
        if (this.isLoadModelNeeded()) {
            String string = InternalResource.loadString("", "FacilityAnalyst_LoadModelNeeded", "networkanalyst_resources");
            throw new IllegalStateException(string);
        }
        if (nodeID <= 0) {
            String string = InternalResource.loadString("nodeID", "Global_IDShouldGreaterThanZero", "networkanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        if (weightName == null || weightName.trim().length() == 0) {
            weightName = this.m_analystSetting.getWeightFieldInfos().get(0).getName();
        } else if (this.m_analystSetting.getWeightFieldInfos().indexOf(weightName) == -1) {
            String string = InternalResource.loadString("weightName", "FacilityAnalyst_SpecifiedWeightNameNotExist", "networkanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        int n = 0;
        int[][] nArray = FacilityAnalystNative.jni_FindSourceFromNode(this.getHandle(), nodeID, weightName, isUncertainDirectionValid, n, this.m_analystSetting.getBarrierEdges(), this.m_analystSetting.getBarrierNodes());
        int[] nArray2 = nArray[0];
        int[] nArray3 = nArray[1];
        double d = FacilityAnalystNative.jni_GetCost(this.getHandle());
        if (nArray2.length != 0 && nArray3.length != 0) {
            FacilityAnalystResult facilityAnalystResult = new FacilityAnalystResult(nArray2, nArray3, d);
            return facilityAnalystResult;
        }
        return null;
    }

    public FacilityAnalystResult findSourceFromEdge(int edgeID, String weightName, boolean isUncertainDirectionValid) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("findSourceFromEdge(int edgeID, String weightName, boolean isUncertainDirectionValid)", "Handle_ObjectHasBeenDisposed", "networkanalyst_resources");
            throw new IllegalStateException(string);
        }
        if (this.isLoadModelNeeded()) {
            String string = InternalResource.loadString("", "FacilityAnalyst_LoadModelNeeded", "networkanalyst_resources");
            throw new IllegalStateException(string);
        }
        if (edgeID <= 0) {
            String string = InternalResource.loadString("edgeID", "Global_IDShouldGreaterThanZero", "networkanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        if (weightName == null || weightName.trim().length() == 0) {
            weightName = this.m_analystSetting.getWeightFieldInfos().get(0).getName();
        } else if (this.m_analystSetting.getWeightFieldInfos().indexOf(weightName) == -1) {
            String string = InternalResource.loadString("weightName", "FacilityAnalyst_SpecifiedWeightNameNotExist", "networkanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        int n = 0;
        int[][] nArray = FacilityAnalystNative.jni_FindSourceFromEdge(this.getHandle(), edgeID, weightName, isUncertainDirectionValid, n, this.m_analystSetting.getBarrierEdges(), this.m_analystSetting.getBarrierNodes());
        int[] nArray2 = nArray[0];
        int[] nArray3 = nArray[1];
        double d = FacilityAnalystNative.jni_GetCost(this.getHandle());
        if (nArray2.length != 0 && nArray3.length != 0) {
            FacilityAnalystResult facilityAnalystResult = new FacilityAnalystResult(nArray2, nArray3, d);
            return facilityAnalystResult;
        }
        return null;
    }

    public FacilityAnalystResult findSinkFromNode(int nodeID, String weightName, boolean isUncertainDirectionValid) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("findSinkFromNode(int nodeID, String weightName, boolean isUncertainDirectionValid)", "Handle_ObjectHasBeenDisposed", "networkanalyst_resources");
            throw new IllegalStateException(string);
        }
        if (this.isLoadModelNeeded()) {
            String string = InternalResource.loadString("", "FacilityAnalyst_LoadModelNeeded", "networkanalyst_resources");
            throw new IllegalStateException(string);
        }
        if (nodeID <= 0) {
            String string = InternalResource.loadString("nodeID", "Global_IDShouldGreaterThanZero", "networkanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        if (weightName == null || weightName.trim().length() == 0) {
            weightName = this.m_analystSetting.getWeightFieldInfos().get(0).getName();
        } else if (this.m_analystSetting.getWeightFieldInfos().indexOf(weightName) == -1) {
            String string = InternalResource.loadString("weightName", "FacilityAnalyst_SpecifiedWeightNameNotExist", "networkanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        int n = 1;
        int[][] nArray = FacilityAnalystNative.jni_FindSourceFromNode(this.getHandle(), nodeID, weightName, isUncertainDirectionValid, n, this.m_analystSetting.getBarrierEdges(), this.m_analystSetting.getBarrierNodes());
        int[] nArray2 = nArray[0];
        int[] nArray3 = nArray[1];
        double d = FacilityAnalystNative.jni_GetCost(this.getHandle());
        if (nArray2.length != 0 && nArray3.length != 0) {
            FacilityAnalystResult facilityAnalystResult = new FacilityAnalystResult(nArray2, nArray3, d);
            return facilityAnalystResult;
        }
        return null;
    }

    public FacilityAnalystResult findSinkFromEdge(int edgeID, String weightName, boolean isUncertainDirectionValid) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("findSinkFromEdge(int edgeID, String weightName, boolean isUncertainDirectionValid)", "Handle_ObjectHasBeenDisposed", "networkanalyst_resources");
            throw new IllegalStateException(string);
        }
        if (this.isLoadModelNeeded()) {
            String string = InternalResource.loadString("", "FacilityAnalyst_LoadModelNeeded", "networkanalyst_resources");
            throw new IllegalStateException(string);
        }
        if (edgeID <= 0) {
            String string = InternalResource.loadString("edgeID", "Global_IDShouldGreaterThanZero", "networkanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        if (weightName == null || weightName.trim().length() == 0) {
            weightName = this.m_analystSetting.getWeightFieldInfos().get(0).getName();
        } else if (this.m_analystSetting.getWeightFieldInfos().indexOf(weightName) == -1) {
            String string = InternalResource.loadString("weightName", "FacilityAnalyst_SpecifiedWeightNameNotExist", "networkanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        int n = 1;
        int[][] nArray = FacilityAnalystNative.jni_FindSourceFromEdge(this.getHandle(), edgeID, weightName, isUncertainDirectionValid, n, this.m_analystSetting.getBarrierEdges(), this.m_analystSetting.getBarrierNodes());
        int[] nArray2 = nArray[0];
        int[] nArray3 = nArray[1];
        double d = FacilityAnalystNative.jni_GetCost(this.getHandle());
        if (nArray2.length != 0 && nArray3.length != 0) {
            FacilityAnalystResult facilityAnalystResult = new FacilityAnalystResult(nArray2, nArray3, d);
            return facilityAnalystResult;
        }
        return null;
    }

    public FacilityAnalystResult traceUpFromNode(int nodeID, String weightName, boolean isUncertainDirectionValid) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("traceUpFromNode(int nodeID, String weightName, boolean isUncertainDirectionValid)", "Handle_ObjectHasBeenDisposed", "networkanalyst_resources");
            throw new IllegalStateException(string);
        }
        if (this.isLoadModelNeeded()) {
            String string = InternalResource.loadString("", "FacilityAnalyst_LoadModelNeeded", "networkanalyst_resources");
            throw new IllegalStateException(string);
        }
        if (nodeID <= 0) {
            String string = InternalResource.loadString("nodeID", "Global_IDShouldGreaterThanZero", "networkanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        if (weightName == null || weightName.trim().length() == 0) {
            weightName = this.m_analystSetting.getWeightFieldInfos().get(0).getName();
        } else if (this.m_analystSetting.getWeightFieldInfos().indexOf(weightName) == -1) {
            String string = InternalResource.loadString("weightName", "FacilityAnalyst_SpecifiedWeightNameNotExist", "networkanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        int n = 0;
        int[][] nArray = FacilityAnalystNative.jni_TraceUpFromNode(this.getHandle(), nodeID, weightName, isUncertainDirectionValid, n, this.m_analystSetting.getBarrierEdges(), this.m_analystSetting.getBarrierNodes());
        int[] nArray2 = nArray[0];
        int[] nArray3 = nArray[1];
        double d = FacilityAnalystNative.jni_GetCost(this.getHandle());
        FacilityAnalystResult facilityAnalystResult = new FacilityAnalystResult(nArray2, nArray3, d);
        return facilityAnalystResult;
    }

    public FacilityAnalystResult traceUpFromEdge(int edgeID, String weightName, boolean isUncertainDirectionValid) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("traceUpFromEdge(int edgeID, String weightName, boolean isUncertainDirectionValid)", "Handle_ObjectHasBeenDisposed", "networkanalyst_resources");
            throw new IllegalStateException(string);
        }
        if (this.isLoadModelNeeded()) {
            String string = InternalResource.loadString("", "FacilityAnalyst_LoadModelNeeded", "networkanalyst_resources");
            throw new IllegalStateException(string);
        }
        if (edgeID <= 0) {
            String string = InternalResource.loadString("edgeID", "Global_IDShouldGreaterThanZero", "networkanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        if (weightName == null || weightName.trim().length() == 0) {
            weightName = this.m_analystSetting.getWeightFieldInfos().get(0).getName();
        } else if (this.m_analystSetting.getWeightFieldInfos().indexOf(weightName) == -1) {
            String string = InternalResource.loadString("weightName", "FacilityAnalyst_SpecifiedWeightNameNotExist", "networkanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        int n = 0;
        int[][] nArray = FacilityAnalystNative.jni_TraceUpFromEdge(this.getHandle(), edgeID, weightName, isUncertainDirectionValid, n, this.m_analystSetting.getBarrierEdges(), this.m_analystSetting.getBarrierNodes());
        int[] nArray2 = nArray[0];
        int[] nArray3 = nArray[1];
        double d = FacilityAnalystNative.jni_GetCost(this.getHandle());
        FacilityAnalystResult facilityAnalystResult = new FacilityAnalystResult(nArray2, nArray3, d);
        return facilityAnalystResult;
    }

    public FacilityAnalystResult traceDownFromNode(int nodeID, String weightName, boolean isUncertainDirectionValid) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("traceDownFromNode(int nodeID, String weightName, boolean isUncertainDirectionValid)", "Handle_ObjectHasBeenDisposed", "networkanalyst_resources");
            throw new IllegalStateException(string);
        }
        if (this.isLoadModelNeeded()) {
            String string = InternalResource.loadString("", "FacilityAnalyst_LoadModelNeeded", "networkanalyst_resources");
            throw new IllegalStateException(string);
        }
        if (nodeID <= 0) {
            String string = InternalResource.loadString("nodeID", "Global_IDShouldGreaterThanZero", "networkanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        if (weightName == null || weightName.trim().length() == 0) {
            weightName = this.m_analystSetting.getWeightFieldInfos().get(0).getName();
        } else if (this.m_analystSetting.getWeightFieldInfos().indexOf(weightName) == -1) {
            String string = InternalResource.loadString("weightName", "FacilityAnalyst_SpecifiedWeightNameNotExist", "networkanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        int n = 1;
        int[][] nArray = FacilityAnalystNative.jni_TraceUpFromNode(this.getHandle(), nodeID, weightName, isUncertainDirectionValid, n, this.m_analystSetting.getBarrierEdges(), this.m_analystSetting.getBarrierNodes());
        int[] nArray2 = nArray[0];
        int[] nArray3 = nArray[1];
        double d = FacilityAnalystNative.jni_GetCost(this.getHandle());
        FacilityAnalystResult facilityAnalystResult = new FacilityAnalystResult(nArray2, nArray3, d);
        return facilityAnalystResult;
    }

    public FacilityAnalystResult traceDownFromEdge(int edgeID, String weightName, boolean isUncertainDirectionValid) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("traceDownFromEdge(int edgeID, String weightName, boolean isUncertainDirectionValid)", "Handle_ObjectHasBeenDisposed", "networkanalyst_resources");
            throw new IllegalStateException(string);
        }
        if (this.isLoadModelNeeded()) {
            String string = InternalResource.loadString("", "FacilityAnalyst_LoadModelNeeded", "networkanalyst_resources");
            throw new IllegalStateException(string);
        }
        if (edgeID <= 0) {
            String string = InternalResource.loadString("edgeID", "Global_IDShouldGreaterThanZero", "networkanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        if (weightName == null || weightName.trim().length() == 0) {
            weightName = this.m_analystSetting.getWeightFieldInfos().get(0).getName();
        } else if (this.m_analystSetting.getWeightFieldInfos().indexOf(weightName) == -1) {
            String string = InternalResource.loadString("weightName", "FacilityAnalyst_SpecifiedWeightNameNotExist", "networkanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        int n = 1;
        int[][] nArray = FacilityAnalystNative.jni_TraceUpFromEdge(this.getHandle(), edgeID, weightName, isUncertainDirectionValid, n, this.m_analystSetting.getBarrierEdges(), this.m_analystSetting.getBarrierNodes());
        int[] nArray2 = nArray[0];
        int[] nArray3 = nArray[1];
        double d = FacilityAnalystNative.jni_GetCost(this.getHandle());
        FacilityAnalystResult facilityAnalystResult = new FacilityAnalystResult(nArray2, nArray3, d);
        return facilityAnalystResult;
    }

    public int[] checkLoops() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("checkLoops()", "Handle_ObjectHasBeenDisposed", "networkanalyst_resources");
            throw new IllegalStateException(string);
        }
        if (this.isLoadModelNeeded()) {
            String string = InternalResource.loadString("", "FacilityAnalyst_LoadModelNeeded", "networkanalyst_resources");
            throw new IllegalStateException(string);
        }
        return FacilityAnalystNative.jni_CheckLoops(this.getHandle(), this.m_analystSetting.getBarrierEdges(), this.m_analystSetting.getBarrierNodes());
    }

    public FacilityAnalystResult findPathFromNodes(int startNodeID, int endNodeID, String weightName, boolean isUncertainDirectionValid) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("findPathFromNodes(int startNodeID,int endNodeID,String weightName,boolean hasLeastEdgeCount)", "Handle_ObjectHasBeenDisposed", "networkanalyst_resources");
            throw new IllegalStateException(string);
        }
        if (this.isLoadModelNeeded()) {
            String string = InternalResource.loadString("", "FacilityAnalyst_LoadModelNeeded", "networkanalyst_resources");
            throw new IllegalStateException(string);
        }
        if (startNodeID <= 0) {
            String string = InternalResource.loadString("startNodeID", "Global_IDShouldGreaterThanZero", "networkanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        if (endNodeID <= 0) {
            String string = InternalResource.loadString("endNodeID", "Global_IDShouldGreaterThanZero", "networkanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        if (weightName == null || weightName.trim().length() == 0) {
            weightName = this.m_analystSetting.getWeightFieldInfos().get(0).getName();
        } else if (this.m_analystSetting.getWeightFieldInfos().indexOf(weightName) == -1) {
            String string = InternalResource.loadString("weightName", "FacilityAnalyst_SpecifiedWeightNameNotExist", "networkanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        int[][] nArray = FacilityAnalystNative.jni_FindPathFromNodes(this.getHandle(), startNodeID, endNodeID, weightName, true, this.m_analystSetting.getBarrierEdges(), this.m_analystSetting.getBarrierNodes(), isUncertainDirectionValid);
        int[] nArray2 = nArray[0];
        int[] nArray3 = nArray[1];
        double d = FacilityAnalystNative.jni_GetCost(this.getHandle());
        if (nArray2.length != 0 && nArray3.length != 0) {
            FacilityAnalystResult facilityAnalystResult = new FacilityAnalystResult(nArray2, nArray3, d);
            return facilityAnalystResult;
        }
        return null;
    }

    public FacilityAnalystResult findPathFromEdges(int startEdgeID, int endEdgeID, String weightName, boolean isUncertainDirectionValid) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("findPathFromEdges(int startEdgeID,int endEdgeID,String weightName,boolean hasLeastEdgeCount)", "Handle_ObjectHasBeenDisposed", "networkanalyst_resources");
            throw new IllegalStateException(string);
        }
        if (this.isLoadModelNeeded()) {
            String string = InternalResource.loadString("", "FacilityAnalyst_LoadModelNeeded", "networkanalyst_resources");
            throw new IllegalStateException(string);
        }
        if (startEdgeID <= 0) {
            String string = InternalResource.loadString("startEdgeID", "Global_IDShouldGreaterThanZero", "networkanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        if (endEdgeID <= 0) {
            String string = InternalResource.loadString("endEdgeID", "Global_IDShouldGreaterThanZero", "networkanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        if (weightName == null || weightName.trim().length() == 0) {
            weightName = this.m_analystSetting.getWeightFieldInfos().get(0).getName();
        } else if (this.m_analystSetting.getWeightFieldInfos().indexOf(weightName) == -1) {
            String string = InternalResource.loadString("weightName", "FacilityAnalyst_SpecifiedWeightNameNotExist", "networkanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        int[][] nArray = FacilityAnalystNative.jni_FindPathFromEdges(this.getHandle(), startEdgeID, endEdgeID, weightName, true, this.m_analystSetting.getBarrierEdges(), this.m_analystSetting.getBarrierNodes(), isUncertainDirectionValid);
        int[] nArray2 = nArray[0];
        int[] nArray3 = nArray[1];
        double d = FacilityAnalystNative.jni_GetCost(this.getHandle());
        if (nArray2.length != 0 && nArray3.length != 0) {
            FacilityAnalystResult facilityAnalystResult = new FacilityAnalystResult(nArray2, nArray3, d);
            return facilityAnalystResult;
        }
        return null;
    }

    public FacilityAnalystResult findPathUpFromNode(int nodeID, String weightName, boolean isUncertainDirectionValid) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("findPathUpFromNode(int nodeID,String weightName,boolean hasLeastEdgeCount)", "Handle_ObjectHasBeenDisposed", "networkanalyst_resources");
            throw new IllegalStateException(string);
        }
        if (this.isLoadModelNeeded()) {
            String string = InternalResource.loadString("", "FacilityAnalyst_LoadModelNeeded", "networkanalyst_resources");
            throw new IllegalStateException(string);
        }
        if (nodeID <= 0) {
            String string = InternalResource.loadString("nodeID", "Global_IDShouldGreaterThanZero", "networkanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        if (weightName == null || weightName.trim().length() == 0) {
            weightName = this.m_analystSetting.getWeightFieldInfos().get(0).getName();
        } else if (this.m_analystSetting.getWeightFieldInfos().indexOf(weightName) == -1) {
            String string = InternalResource.loadString("weightName", "FacilityAnalyst_SpecifiedWeightNameNotExist", "networkanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        int n = 0;
        int[][] nArray = FacilityAnalystNative.jni_FindPathUpFromNode(this.getHandle(), nodeID, weightName, true, n, this.m_analystSetting.getBarrierEdges(), this.m_analystSetting.getBarrierNodes(), isUncertainDirectionValid);
        int[] nArray2 = nArray[0];
        int[] nArray3 = nArray[1];
        double d = FacilityAnalystNative.jni_GetCost(this.getHandle());
        if (nArray2.length != 0 && nArray3.length != 0) {
            FacilityAnalystResult facilityAnalystResult = new FacilityAnalystResult(nArray2, nArray3, d);
            return facilityAnalystResult;
        }
        return null;
    }

    public FacilityAnalystResult findPathUpFromEdge(int edgeID, String weightName, boolean isUncertainDirectionValid) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("findPathUpFromEdge(int edgeID,String weightName,boolean hasLeastEdgeCount)", "Handle_ObjectHasBeenDisposed", "networkanalyst_resources");
            throw new IllegalStateException(string);
        }
        if (this.isLoadModelNeeded()) {
            String string = InternalResource.loadString("", "FacilityAnalyst_LoadModelNeeded", "networkanalyst_resources");
            throw new IllegalStateException(string);
        }
        if (edgeID <= 0) {
            String string = InternalResource.loadString("edgeID", "Global_IDShouldGreaterThanZero", "networkanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        if (weightName == null || weightName.trim().length() == 0) {
            weightName = this.m_analystSetting.getWeightFieldInfos().get(0).getName();
        } else if (this.m_analystSetting.getWeightFieldInfos().indexOf(weightName) == -1) {
            String string = InternalResource.loadString("weightName", "FacilityAnalyst_SpecifiedWeightNameNotExist", "networkanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        int n = 0;
        int[][] nArray = FacilityAnalystNative.jni_FindPathUpFromEdge(this.getHandle(), edgeID, weightName, true, n, this.m_analystSetting.getBarrierEdges(), this.m_analystSetting.getBarrierNodes(), isUncertainDirectionValid);
        int[] nArray2 = nArray[0];
        int[] nArray3 = nArray[1];
        double d = FacilityAnalystNative.jni_GetCost(this.getHandle());
        if (nArray2.length != 0 && nArray3.length != 0) {
            FacilityAnalystResult facilityAnalystResult = new FacilityAnalystResult(nArray2, nArray3, d);
            return facilityAnalystResult;
        }
        return null;
    }

    public FacilityAnalystResult findPathDownFromNode(int nodeID, String weightName, boolean isUncertainDirectionValid) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("findPathDownFromNode(int nodeID,String weightName,boolean hasLeastEdgeCount)", "Handle_ObjectHasBeenDisposed", "networkanalyst_resources");
            throw new IllegalStateException(string);
        }
        if (this.isLoadModelNeeded()) {
            String string = InternalResource.loadString("", "FacilityAnalyst_LoadModelNeeded", "networkanalyst_resources");
            throw new IllegalStateException(string);
        }
        if (nodeID <= 0) {
            String string = InternalResource.loadString("nodeID", "Global_IDShouldGreaterThanZero", "networkanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        if (weightName == null || weightName.trim().length() == 0) {
            weightName = this.m_analystSetting.getWeightFieldInfos().get(0).getName();
        } else if (this.m_analystSetting.getWeightFieldInfos().indexOf(weightName) == -1) {
            String string = InternalResource.loadString("weightName", "FacilityAnalyst_SpecifiedWeightNameNotExist", "networkanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        int n = 1;
        int[][] nArray = FacilityAnalystNative.jni_FindPathUpFromNode(this.getHandle(), nodeID, weightName, true, n, this.m_analystSetting.getBarrierEdges(), this.m_analystSetting.getBarrierNodes(), isUncertainDirectionValid);
        int[] nArray2 = nArray[0];
        int[] nArray3 = nArray[1];
        double d = FacilityAnalystNative.jni_GetCost(this.getHandle());
        if (nArray2.length != 0 && nArray3.length != 0) {
            FacilityAnalystResult facilityAnalystResult = new FacilityAnalystResult(nArray2, nArray3, d);
            return facilityAnalystResult;
        }
        return null;
    }

    public FacilityAnalystResult findPathDownFromEdge(int edgeID, String weightName, boolean isUncertainDirectionValid) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("findPathUpFromEdge(int edgeID,String weightName,boolean hasLeastEdgeCount)", "Handle_ObjectHasBeenDisposed", "networkanalyst_resources");
            throw new IllegalStateException(string);
        }
        if (this.isLoadModelNeeded()) {
            String string = InternalResource.loadString("", "FacilityAnalyst_LoadModelNeeded", "networkanalyst_resources");
            throw new IllegalStateException(string);
        }
        if (edgeID <= 0) {
            String string = InternalResource.loadString("edgeID", "Global_IDShouldGreaterThanZero", "networkanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        if (weightName == null || weightName.trim().length() == 0) {
            weightName = this.m_analystSetting.getWeightFieldInfos().get(0).getName();
        } else if (this.m_analystSetting.getWeightFieldInfos().indexOf(weightName) == -1) {
            String string = InternalResource.loadString("weightName", "FacilityAnalyst_SpecifiedWeightNameNotExist", "networkanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        int n = 1;
        int[][] nArray = FacilityAnalystNative.jni_FindPathUpFromEdge(this.getHandle(), edgeID, weightName, true, n, this.m_analystSetting.getBarrierEdges(), this.m_analystSetting.getBarrierNodes(), isUncertainDirectionValid);
        int[] nArray2 = nArray[0];
        int[] nArray3 = nArray[1];
        double d = FacilityAnalystNative.jni_GetCost(this.getHandle());
        if (nArray2.length != 0 && nArray3.length != 0) {
            FacilityAnalystResult facilityAnalystResult = new FacilityAnalystResult(nArray2, nArray3, d);
            return facilityAnalystResult;
        }
        return null;
    }

    public void dispose() {
        if (!this.getIsDisposable()) {
            String string = InternalResource.loadString("dispose()", "Handle_UndisposableObject", "networkanalyst_resources");
            throw new UnsupportedOperationException(string);
        }
        if (this.getHandle() != 0L) {
            FacilityAnalystNative.jni_Delete(this.getHandle());
            this.clearHandle();
        }
        this.unLoadLicense();
    }

    void setAnalsytSettingToUGC() {
        DatasetType datasetType;
        if (!this.m_analystSetting.getNeedSet()) {
            return;
        }
        DatasetVector datasetVector = this.m_analystSetting.getNetworkDataset();
        if (datasetVector == null || InternalHandle.getHandle((com.supermap.data.InternalHandle)datasetVector) == 0L) {
            String string = InternalResource.loadString("m_analystSetting.getNetworkDataset()", "FacilityAnalyst_NetworkDatasetHasNotBeenSet", "networkanalyst_resources");
            throw new IllegalStateException(string);
        }
        if (!datasetVector.isOpen()) {
            datasetVector.open();
        }
        if ((datasetType = datasetVector.getType()) != DatasetType.NETWORK) {
            String string = InternalResource.loadString("m_analystSetting.getNetworkDataset().getType()", "FacilityAnalyst_DatasetTypeMustBeNetwork", "networkanalyst_resources");
            throw new IllegalStateException(string);
        }
        long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)datasetVector);
        String[] stringArray = new String[]{this.m_analystSetting.getNodeIDField(), this.m_analystSetting.getEdgeIDField(), this.m_analystSetting.getFNodeIDField(), this.m_analystSetting.getTNodeIDField(), this.m_analystSetting.getDirectionField()};
        if (!FacilityAnalyst.isNetworkFieldsAllRight(stringArray, datasetVector)) {
            String string = InternalResource.loadString("fields", "FacilityAnalystSetting_FieldIsNotInNetworkDataset", "networkanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        WeightFieldInfos weightFieldInfos = this.m_analystSetting.getWeightFieldInfos();
        if (weightFieldInfos == null || weightFieldInfos.getCount() <= 0) {
            String string = InternalResource.loadString("m_analystSetting.getWeightFieldInfos()", "FacilityAnalystSetting_WeightFieldInfoCountShouldGreaterThanZero", "networkanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        String[] stringArray2 = null;
        String[] stringArray3 = null;
        String[] stringArray4 = null;
        int n = weightFieldInfos.getCount();
        stringArray2 = new String[n];
        stringArray3 = new String[n];
        stringArray4 = new String[n];
        for (int i = 0; i < n; ++i) {
            stringArray2[i] = weightFieldInfos.get(i).getName();
            stringArray3[i] = weightFieldInfos.get(i).getFTWeightField();
            stringArray4[i] = weightFieldInfos.get(i).getTFWeightField();
        }
        int[] nArray = this.m_analystSetting.getBarrierEdges();
        int[] nArray2 = this.m_analystSetting.getBarrierNodes();
        double d = this.m_analystSetting.getTolerance();
        FacilityAnalystNative.jni_SetAnalystSettingToUGC(this.getHandle(), l, stringArray, stringArray2, stringArray3, stringArray4, nArray2, nArray, d);
        this.m_analystSetting.setNeedSet(false);
    }

    protected void clearHandle() {
        this.setHandle(0L);
    }

    private boolean isLoadModelNeeded() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("isLoadModelNeeded()", "Handle_ObjectHasBeenDisposed", "networkanalyst_resources");
            throw new IllegalStateException(string);
        }
        return this.m_analystSetting.getNeedSet() || !this.m_modelLoaded;
    }

    private static boolean isNetworkFieldsAllRight(String[] fields, DatasetVector networkDataset) {
        int n;
        boolean bl = true;
        if (!networkDataset.open()) {
            networkDataset.open();
        }
        FieldInfos fieldInfos = networkDataset.getChildDataset().getFieldInfos();
        boolean bl2 = false;
        for (n = 0; n < fieldInfos.getCount(); ++n) {
            if (fieldInfos.get(n).getName().compareToIgnoreCase(fields[0]) != 0) continue;
            bl2 = true;
            break;
        }
        if (!bl2) {
            return bl2;
        }
        fieldInfos = networkDataset.getFieldInfos();
        n = fields.length;
        for (int i = 1; i < n; ++i) {
            bl2 = false;
            if (fields[i].trim().equals("") || fields[i] == null) {
                return bl2;
            }
            for (int j = 0; j < fieldInfos.getCount(); ++j) {
                if (fieldInfos.get(j).getName().compareToIgnoreCase(fields[i]) != 0) continue;
                bl2 = true;
                break;
            }
            if (bl2) continue;
            return bl2;
        }
        return bl;
    }

    private void checkLicense() {
        ArrayList<ProductType> arrayList = InternalToolkitNetworkAnalyst.managerProducts(InternalToolkitNetworkAnalyst.getNetworkAnalystProducts());
        this.m_license = InternalToolkitNetworkAnalyst.verifyLicense(arrayList);
    }

    private void unLoadLicense() {
        if (this.m_license != null) {
            this.m_license.disconnect();
            this.m_license.dispose();
            this.m_license = null;
        }
    }

    private void verifyLicense() {
        int n = this.m_license.verify();
        if (n != 0) {
            String string = License.getErrorMessage((int)n);
            throw new IllegalStateException(string);
        }
    }

    boolean checkWeightField() {
        QueryParameter queryParameter = new QueryParameter();
        queryParameter.setCursorType(CursorType.STATIC);
        queryParameter.setHasGeometry(false);
        queryParameter.setAttributeFilter("1<0");
        DatasetVector datasetVector = this.m_analystSetting.getNetworkDataset();
        if (datasetVector == null) {
            return false;
        }
        for (int i = 0; i < this.m_analystSetting.getWeightFieldInfos().getCount(); ++i) {
            int n;
            String string = this.m_analystSetting.getWeightFieldInfos().get(i).getFTWeightField();
            String string2 = this.m_analystSetting.getWeightFieldInfos().get(i).getTFWeightField();
            queryParameter.setResultFields(new String[]{string});
            Recordset recordset = datasetVector.query(queryParameter);
            FieldInfos fieldInfos = recordset.getFieldInfos();
            int n2 = fieldInfos.getCount();
            boolean bl = false;
            for (n = 0; n < n2; ++n) {
                String string3 = fieldInfos.get(n).getName();
                if (!string3.equalsIgnoreCase(string)) continue;
                bl = true;
            }
            if (!bl) {
                String string4 = InternalResource.loadString(string, "Global_EnumValueIsError", "networkanalyst_resources");
                throw new IllegalArgumentException(string4);
            }
            recordset.dispose();
            queryParameter.setResultFields(new String[]{string2});
            recordset = this.m_analystSetting.getNetworkDataset().query(queryParameter);
            fieldInfos = recordset.getFieldInfos();
            n2 = fieldInfos.getCount();
            n = 0;
            for (int j = 0; j < n2; ++j) {
                String string5 = fieldInfos.get(j).getName();
                if (!string5.equalsIgnoreCase(string2)) continue;
                n = 1;
            }
            if (n == 0) {
                String string6 = InternalResource.loadString(string2, "Global_EnumValueIsError", "networkanalyst_resources");
                throw new IllegalArgumentException(string6);
            }
            recordset.dispose();
        }
        if (this.m_analystSetting.getDirectionField() == null || this.m_analystSetting.getDirectionField().trim().equals("")) {
            String string = InternalResource.loadString("DirectionField", "Global_ArgumentNull", "networkanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        return true;
    }

    public FacilityAnalystResult findCriticalFacilitiesUpFromNode(int[] sourceNodeIDs, int nodeID, boolean isUncertainDirectionValid) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("findCriticalFacilitiesUpFromNode(int[] nodeIDs, int nodeID, boolean isUncertainDirectionValid)", "Handle_ObjectHasBeenDisposed", "networkanalyst_resources");
            throw new IllegalStateException(string);
        }
        if (sourceNodeIDs == null) {
            String string = InternalResource.loadString("sourceNodeIDs", "Global_ArgumentNull", "networkanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        if (sourceNodeIDs.length == 0) {
            String string = InternalResource.loadString("sourceNodeIDs", "Global_ArrayLengthShouldGreaterThanZero", "networkanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        if (this.isLoadModelNeeded()) {
            String string = InternalResource.loadString("", "FacilityAnalyst_LoadModelNeeded", "networkanalyst_resources");
            throw new IllegalStateException(string);
        }
        if (nodeID <= 0) {
            String string = InternalResource.loadString("nodeID", "Global_IDShouldGreaterThanZero", "networkanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        boolean bl = true;
        int[] nArray = FacilityAnalystNative.jni_FindCriticalFacilities(this.getHandle(), nodeID, sourceNodeIDs, this.m_analystSetting.getBarrierEdges(), this.m_analystSetting.getBarrierNodes(), isUncertainDirectionValid, bl, 0);
        if (nArray.length > 2) {
            int n = nArray[0];
            int n2 = nArray[1];
            int n3 = 0;
            int[] nArray2 = new int[n];
            int[] nArray3 = new int[n2];
            int n4 = n + 2;
            for (n3 = 2; n3 < n4; ++n3) {
                nArray2[n3 - 2] = nArray[n3];
            }
            n4 = n + n2 + 2;
            while (n3 < n4) {
                nArray3[n3 - 2 - n] = nArray[n3];
                ++n3;
            }
            FacilityAnalystResult facilityAnalystResult = new FacilityAnalystResult(nArray2, nArray3, 0.0);
            return facilityAnalystResult;
        }
        return null;
    }

    public FacilityAnalystResult findCriticalFacilitiesUpFromEdge(int[] sourceNodeIDs, int edgeID, boolean isUncertainDirectionValid) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("findCriticalFacilitiesUpFromEdge(int[] nodeIDs, int nodeID, boolean isUncertainDirectionValid)", "Handle_ObjectHasBeenDisposed", "networkanalyst_resources");
            throw new IllegalStateException(string);
        }
        if (sourceNodeIDs == null) {
            String string = InternalResource.loadString("nodeIDs", "Global_ArgumentNull", "networkanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        if (sourceNodeIDs.length == 0) {
            String string = InternalResource.loadString("nodeIDs", "Global_ArrayLengthShouldGreaterThanZero", "networkanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        if (this.isLoadModelNeeded()) {
            String string = InternalResource.loadString("", "FacilityAnalyst_LoadModelNeeded", "networkanalyst_resources");
            throw new IllegalStateException(string);
        }
        if (edgeID <= 0) {
            String string = InternalResource.loadString("edgeID", "Global_IDShouldGreaterThanZero", "networkanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        boolean bl = false;
        int[] nArray = FacilityAnalystNative.jni_FindCriticalFacilities(this.getHandle(), edgeID, sourceNodeIDs, this.m_analystSetting.getBarrierEdges(), this.m_analystSetting.getBarrierNodes(), isUncertainDirectionValid, bl, 0);
        if (nArray.length > 2) {
            int n = nArray[0];
            int n2 = nArray[1];
            int n3 = 0;
            int[] nArray2 = new int[n];
            int[] nArray3 = new int[n2];
            int n4 = n + 2;
            for (n3 = 2; n3 < n4; ++n3) {
                nArray2[n3 - 2] = nArray[n3];
            }
            n4 = n + n2 + 2;
            while (n3 < n4) {
                nArray3[n3 - 2 - n] = nArray[n3];
                ++n3;
            }
            FacilityAnalystResult facilityAnalystResult = new FacilityAnalystResult(nArray2, nArray3, 0.0);
            return facilityAnalystResult;
        }
        return null;
    }

    public FacilityAnalystResult findCriticalFacilitiesDownFromNode(int[] sourceNodeIDs, int nodeID, boolean isUncertainDirectionValid) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("findCriticalFacilitiesUpFromNode(int[] nodeIDs, int nodeID, boolean isUncertainDirectionValid)", "Handle_ObjectHasBeenDisposed", "networkanalyst_resources");
            throw new IllegalStateException(string);
        }
        if (sourceNodeIDs == null) {
            String string = InternalResource.loadString("sourceNodeIDs", "Global_ArgumentNull", "networkanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        if (sourceNodeIDs.length == 0) {
            String string = InternalResource.loadString("sourceNodeIDs", "Global_ArrayLengthShouldGreaterThanZero", "networkanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        if (this.isLoadModelNeeded()) {
            String string = InternalResource.loadString("", "FacilityAnalyst_LoadModelNeeded", "networkanalyst_resources");
            throw new IllegalStateException(string);
        }
        if (nodeID <= 0) {
            String string = InternalResource.loadString("nodeID", "Global_IDShouldGreaterThanZero", "networkanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        boolean bl = true;
        int[] nArray = FacilityAnalystNative.jni_FindCriticalFacilities(this.getHandle(), nodeID, sourceNodeIDs, this.m_analystSetting.getBarrierEdges(), this.m_analystSetting.getBarrierNodes(), isUncertainDirectionValid, bl, 1);
        if (nArray.length > 2) {
            int n = nArray[0];
            int n2 = nArray[1];
            int n3 = 0;
            int[] nArray2 = new int[n];
            int[] nArray3 = new int[n2];
            int n4 = n + 2;
            for (n3 = 2; n3 < n4; ++n3) {
                nArray2[n3 - 2] = nArray[n3];
            }
            n4 = n + n2 + 2;
            while (n3 < n4) {
                nArray3[n3 - 2 - n] = nArray[n3];
                ++n3;
            }
            FacilityAnalystResult facilityAnalystResult = new FacilityAnalystResult(nArray2, nArray3, 0.0);
            return facilityAnalystResult;
        }
        return null;
    }

    public FacilityAnalystResult findCriticalFacilitiesDownFromEdge(int[] sourceNodeIDs, int edgeID, boolean isUncertainDirectionValid) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("findCriticalFacilitiesUpFromEdge(int[] nodeIDs, int nodeID, boolean isUncertainDirectionValid)", "Handle_ObjectHasBeenDisposed", "networkanalyst_resources");
            throw new IllegalStateException(string);
        }
        if (sourceNodeIDs == null) {
            String string = InternalResource.loadString("nodeIDs", "Global_ArgumentNull", "networkanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        if (sourceNodeIDs.length == 0) {
            String string = InternalResource.loadString("nodeIDs", "Global_ArrayLengthShouldGreaterThanZero", "networkanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        if (this.isLoadModelNeeded()) {
            String string = InternalResource.loadString("", "FacilityAnalyst_LoadModelNeeded", "networkanalyst_resources");
            throw new IllegalStateException(string);
        }
        if (edgeID <= 0) {
            String string = InternalResource.loadString("edgeID", "Global_IDShouldGreaterThanZero", "networkanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        boolean bl = false;
        int[] nArray = FacilityAnalystNative.jni_FindCriticalFacilities(this.getHandle(), edgeID, sourceNodeIDs, this.m_analystSetting.getBarrierEdges(), this.m_analystSetting.getBarrierNodes(), isUncertainDirectionValid, bl, 1);
        if (nArray.length > 2) {
            int n = nArray[0];
            int n2 = nArray[1];
            int n3 = 0;
            int[] nArray2 = new int[n];
            int[] nArray3 = new int[n2];
            int n4 = n + 2;
            for (n3 = 2; n3 < n4; ++n3) {
                nArray2[n3 - 2] = nArray[n3];
            }
            n4 = n + n2 + 2;
            while (n3 < n4) {
                nArray3[n3 - 2 - n] = nArray[n3];
                ++n3;
            }
            FacilityAnalystResult facilityAnalystResult = new FacilityAnalystResult(nArray2, nArray3, 0.0);
            return facilityAnalystResult;
        }
        return null;
    }

    public BurstAnalyseResult burstAnalyseFromNode(int[] sourceNodeIDs, int nodeID, boolean isUncertainDirectionValid) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("findCriticalFacilitiesUpFromNode(int[] nodeIDs, int nodeID, boolean isUncertainDirectionValid)", "Handle_ObjectHasBeenDisposed", "networkanalyst_resources");
            throw new IllegalStateException(string);
        }
        if (sourceNodeIDs == null) {
            String string = InternalResource.loadString("sourceNodeIDs", "Global_ArgumentNull", "networkanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        if (sourceNodeIDs.length == 0) {
            String string = InternalResource.loadString("sourceNodeIDs", "Global_ArrayLengthShouldGreaterThanZero", "networkanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        if (this.isLoadModelNeeded()) {
            String string = InternalResource.loadString("", "FacilityAnalyst_LoadModelNeeded", "networkanalyst_resources");
            throw new IllegalStateException(string);
        }
        if (nodeID <= 0) {
            String string = InternalResource.loadString("nodeID", "Global_IDShouldGreaterThanZero", "networkanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        boolean bl = true;
        int[] nArray = FacilityAnalystNative.jni_BurstAnalyse(this.getHandle(), nodeID, sourceNodeIDs, this.m_analystSetting.getBarrierEdges(), this.m_analystSetting.getBarrierNodes(), isUncertainDirectionValid, bl);
        if (nArray.length > 2) {
            int n = nArray[0];
            int n2 = nArray[1];
            int n3 = nArray[2];
            int n4 = 0;
            int[] nArray2 = new int[n];
            int[] nArray3 = new int[n2];
            int[] nArray4 = new int[n3];
            int n5 = n + 3;
            int n6 = 0;
            for (n4 = 3; n4 < n5; ++n4) {
                nArray2[n6++] = nArray[n4];
            }
            n5 += n2;
            n6 = 0;
            while (n4 < n5) {
                nArray3[n6++] = nArray[n4];
                ++n4;
            }
            n5 += n3;
            n6 = 0;
            while (n4 < n5) {
                nArray4[n6++] = nArray[n4];
                ++n4;
            }
            BurstAnalyseResult burstAnalyseResult = new BurstAnalyseResult(nArray2, nArray3, nArray4);
            return burstAnalyseResult;
        }
        return null;
    }

    public BurstAnalyseResult burstAnalyseFromEdge(int[] sourceNodeIDs, int edgeID, boolean isUncertainDirectionValid) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("findCriticalFacilitiesUpFromEdge(int[] nodeIDs, int nodeID, boolean isUncertainDirectionValid)", "Handle_ObjectHasBeenDisposed", "networkanalyst_resources");
            throw new IllegalStateException(string);
        }
        if (sourceNodeIDs == null) {
            String string = InternalResource.loadString("nodeIDs", "Global_ArgumentNull", "networkanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        if (sourceNodeIDs.length == 0) {
            String string = InternalResource.loadString("nodeIDs", "Global_ArrayLengthShouldGreaterThanZero", "networkanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        if (this.isLoadModelNeeded()) {
            String string = InternalResource.loadString("", "FacilityAnalyst_LoadModelNeeded", "networkanalyst_resources");
            throw new IllegalStateException(string);
        }
        if (edgeID <= 0) {
            String string = InternalResource.loadString("edgeID", "Global_IDShouldGreaterThanZero", "networkanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        boolean bl = false;
        int[] nArray = FacilityAnalystNative.jni_BurstAnalyse(this.getHandle(), edgeID, sourceNodeIDs, this.m_analystSetting.getBarrierEdges(), this.m_analystSetting.getBarrierNodes(), isUncertainDirectionValid, bl);
        if (nArray.length > 3) {
            int n = nArray[0];
            int n2 = nArray[1];
            int n3 = nArray[2];
            int n4 = 0;
            int[] nArray2 = new int[n];
            int[] nArray3 = new int[n2];
            int[] nArray4 = new int[n3];
            int n5 = n + 3;
            int n6 = 0;
            for (n4 = 3; n4 < n5; ++n4) {
                nArray2[n6++] = nArray[n4];
            }
            n5 += n2;
            n6 = 0;
            while (n4 < n5) {
                nArray3[n6++] = nArray[n4];
                ++n4;
            }
            n5 += n3;
            n6 = 0;
            while (n4 < n5) {
                nArray4[n6++] = nArray[n4];
                ++n4;
            }
            BurstAnalyseResult burstAnalyseResult = new BurstAnalyseResult(nArray2, nArray3, nArray4);
            return burstAnalyseResult;
        }
        return null;
    }
}

