/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.data.conversion;

import com.supermap.data.Datasource;
import com.supermap.data.DatasourceConnectionInfo;
import com.supermap.data.InternalHandle;
import com.supermap.data.SpatialIndexInfo;
import com.supermap.data.conversion.DataType;
import com.supermap.data.conversion.ImportSetting;
import com.supermap.data.conversion.ImportSettingMIFNative;
import com.supermap.data.conversion.InternalHandleDisposable;
import com.supermap.data.conversion.InternalResource;
import com.supermap.data.conversion.InternalSpatialIndexInfo;

public class ImportSettingMIF
extends ImportSetting {
    private SpatialIndexInfo m_spatialIndexInfo;

    public ImportSettingMIF() {
        long l = ImportSettingMIFNative.jni_New();
        this.setHandle(l, true);
        this.setSpatialIndex(null);
        super.setDataType(DataType.VECTOR);
    }

    public ImportSettingMIF(ImportSettingMIF importSettingMIF) {
        if (importSettingMIF == null) {
            String string = InternalResource.loadString("importSettingMIF", "Global_ArgumentNull", "conversion_resources");
            throw new IllegalArgumentException(string);
        }
        long l = com.supermap.data.conversion.InternalHandle.getHandle((InternalHandle)importSettingMIF);
        if (l == 0L) {
            String string = InternalResource.loadString("importSettingMIF", "Handle_ObjectHasBeenDisposed", "conversion_resources");
            throw new IllegalArgumentException(string);
        }
        long l2 = ImportSettingMIFNative.jni_Clone(l);
        this.setHandle(l2, true);
        this.setTargetDatasourceConnectionInfo(importSettingMIF.getTargetDatasourceConnectionInfo());
        this.setTargetDatasource(importSettingMIF.getTargetDatasource());
        this.setTargetPrjCoordSys(importSettingMIF.getTargetPrjCoordSys());
        super.setDataType(DataType.VECTOR);
        this.setSpatialIndex(importSettingMIF.getSpatialIndex());
        InternalHandleDisposable.makeSureNativeObjectLive((Object)((Object)importSettingMIF));
    }

    public ImportSettingMIF(String sourceFilePath, DatasourceConnectionInfo targetConnectionInfo) {
        this();
        this.setSourceFilePath(sourceFilePath);
        this.setTargetDatasourceConnectionInfo(targetConnectionInfo);
        InternalHandleDisposable.makeSureNativeObjectLive((Object)targetConnectionInfo);
    }

    public ImportSettingMIF(String sourceFilePath, Datasource targetDatasource) {
        this();
        this.setSourceFilePath(sourceFilePath);
        this.setTargetDatasource(targetDatasource);
    }

    public boolean isImportingAsCAD() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("isImportingAsCAD()", "Handle_ObjectHasBeenDisposed", "conversion_resources");
            throw new IllegalArgumentException(string);
        }
        return ImportSettingMIFNative.jni_IsImportingAsCAD(this.getHandle());
    }

    public void setImportingAsCAD(boolean value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setImportingAsCAD(boolean value)", "Handle_ObjectHasBeenDisposed", "conversion_resources");
            throw new IllegalArgumentException(string);
        }
        ImportSettingMIFNative.jni_SetImportingAsCAD(this.getHandle(), value);
    }

    public SpatialIndexInfo getSpatialIndex() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getSpatialIndex()", "Handle_ObjectHasBeenDisposed", "conversion_resources");
            throw new IllegalArgumentException(string);
        }
        if (this.m_spatialIndexInfo == null) {
            long l = ImportSettingMIFNative.jni_GetSpatialIndex(this.getHandle());
            this.m_spatialIndexInfo = InternalSpatialIndexInfo.createInstance(l);
        }
        return this.m_spatialIndexInfo;
    }

    public void setSpatialIndex(SpatialIndexInfo value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setSpatialIndex(SpatialIndexType value)", "Handle_ObjectHasBeenDisposed", "conversion_resources");
            throw new IllegalArgumentException(string);
        }
        long l = value == null ? 0L : com.supermap.data.conversion.InternalHandle.getHandle((InternalHandle)value);
        ImportSettingMIFNative.jni_SetSpatialIndex(this.getHandle(), l);
        this.m_spatialIndexInfo = null;
        InternalHandleDisposable.makeSureNativeObjectLive((Object)value);
    }

    public boolean isAttributeIgnored() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("IsAttributeIgnored()", "Handle_ObjectHasBeenDisposed", "conversion_resources");
            throw new IllegalArgumentException(string);
        }
        return ImportSettingMIFNative.jni_IsAttributeIgnored(this.getHandle());
    }

    public void setAttributeIgnored(boolean value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setAttributeIgnored(boolean value)", "Handle_ObjectHasBeenDisposed", "conversion_resources");
            throw new IllegalArgumentException(string);
        }
        ImportSettingMIFNative.jni_SetAttributeIgnored(this.getHandle(), value);
    }

    public String getStyleMapFilePath() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getStyleMapFilePath()", "Handle_ObjectHasBeenDisposed", "conversion_resources");
            throw new IllegalArgumentException(string);
        }
        return ImportSettingMIFNative.jni_GetStyleMapFilePath(this.getHandle());
    }

    public void setStyleMapFilePath(String value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setStyleMapFilePath(String value)()", "Handle_ObjectHasBeenDisposed", "conversion_resources");
            throw new IllegalArgumentException(string);
        }
        ImportSettingMIFNative.jni_SetStyleMapFilePath(this.getHandle(), value);
    }

    public void dispose() {
        if (!this.getIsDisposable()) {
            String string = InternalResource.loadString("dispose()", "Handle_UndisposableObject", "conversion_resources");
            throw new UnsupportedOperationException(string);
        }
        if (this.getHandle() != 0L) {
            ImportSettingMIFNative.jni_Delete(this.getHandle());
            this.setHandle(0L);
            this.clearHandle();
        }
    }
}

