/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.data.conversion;

import com.supermap.data.Datasource;
import com.supermap.data.DatasourceConnectionInfo;
import com.supermap.data.InternalHandle;
import com.supermap.data.SpatialIndexInfo;
import com.supermap.data.conversion.DataType;
import com.supermap.data.conversion.ImportSetting;
import com.supermap.data.conversion.ImportSettingGMLNative;
import com.supermap.data.conversion.InternalHandleDisposable;
import com.supermap.data.conversion.InternalResource;
import com.supermap.data.conversion.InternalSpatialIndexInfo;

public class ImportSettingGML
extends ImportSetting {
    private SpatialIndexInfo m_spatialIndexInfo;

    public ImportSettingGML() {
        long l = ImportSettingGMLNative.jni_New();
        this.setHandle(l, true);
        super.setDataType(DataType.VECTOR);
        this.setSpatialIndex(null);
    }

    public ImportSettingGML(ImportSettingGML importSettingGML) {
        if (null == importSettingGML) {
            String string = InternalResource.loadString("importSettingGML", "Global_ArgumentNull", "conversion_resources");
            throw new IllegalArgumentException(string);
        }
        long l = com.supermap.data.conversion.InternalHandle.getHandle((InternalHandle)importSettingGML);
        if (l == 0L) {
            String string = InternalResource.loadString("handle", "Handle_ObjectHasBeenDisposed", "conversion_resources");
            throw new IllegalArgumentException(string);
        }
        long l2 = ImportSettingGMLNative.jni_Clone(l);
        this.setHandle(l2, true);
        super.setDataType(DataType.VECTOR);
        this.setSpatialIndex(null);
        this.setTargetDatasourceConnectionInfo(importSettingGML.getTargetDatasourceConnectionInfo());
        this.setTargetDatasource(importSettingGML.getTargetDatasource());
        this.setTargetPrjCoordSys(importSettingGML.getSourcePrjCoordSys());
        InternalHandleDisposable.makeSureNativeObjectLive((Object)((Object)importSettingGML));
    }

    public ImportSettingGML(String sourceFilePath, Datasource targerDatasource) {
        this();
        this.setSourceFilePath(sourceFilePath);
        this.setTargetDatasource(targerDatasource);
    }

    public ImportSettingGML(String sourceFieldPath, DatasourceConnectionInfo targetConnectionInfo) {
        this();
        this.setSourceFilePath(sourceFieldPath);
        this.setTargetDatasourceConnectionInfo(targetConnectionInfo);
        InternalHandleDisposable.makeSureNativeObjectLive((Object)targetConnectionInfo);
    }

    public ImportSettingGML(String sourceFilePath, DatasourceConnectionInfo targetConnectionInfo, boolean importingAsCAD) {
        this();
        this.setTargetDatasourceConnectionInfo(targetConnectionInfo);
        this.setSourceFilePath(sourceFilePath);
        this.setImportingAsCAD(importingAsCAD);
        InternalHandleDisposable.makeSureNativeObjectLive((Object)targetConnectionInfo);
    }

    public SpatialIndexInfo getSpatialIndex() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getSpatialIndex()", "Handle_ObjectHasBeenDisposed", "conversion_resources");
            throw new IllegalArgumentException(string);
        }
        if (null == this.m_spatialIndexInfo) {
            long l = ImportSettingGMLNative.jni_GetSpatialIndex(this.getHandle());
            this.m_spatialIndexInfo = InternalSpatialIndexInfo.createInstance(l);
        }
        return this.m_spatialIndexInfo;
    }

    public void setSpatialIndex(SpatialIndexInfo value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setSpatialIndex(SpatialIndexInfo value)", "Handle_ObjectHasBeenDisposed", "conversion_resources");
            throw new IllegalArgumentException(string);
        }
        long l = null == value ? 0L : com.supermap.data.conversion.InternalHandle.getHandle((InternalHandle)value);
        ImportSettingGMLNative.jni_SetSpatialIndex(this.getHandle(), l);
        InternalHandleDisposable.makeSureNativeObjectLive((Object)value);
    }

    public boolean isImportingAsCAD() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("isImportingAsCAD()", "Handle_ObjectHasBeenDisposed", "conversion_resources");
            throw new IllegalArgumentException(string);
        }
        return ImportSettingGMLNative.jni_IsImportingAsCAD(this.getHandle());
    }

    public void setImportingAsCAD(boolean value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setImportingAsCAD(boolean value)", "Global_ArgumentNull", "conversion_resources");
            throw new IllegalArgumentException(string);
        }
        ImportSettingGMLNative.jni_SetImportingAsCAD(this.getHandle(), value);
    }

    public boolean isAttributeIgnored() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("isAttributeIgnored()", "Handle_ObjectHasBeenDisposed", "conversion_resources");
            throw new IllegalArgumentException(string);
        }
        return ImportSettingGMLNative.jni_IsAttributeIgnored(this.getHandle());
    }

    public void setAttributeIgnored(boolean value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("isAttributeIgnored()", "Handle_ObjectHasBeenDisposed", "conversion_resources");
            throw new IllegalArgumentException(string);
        }
        ImportSettingGMLNative.jni_SetAttributeIgnored(this.getHandle(), value);
    }

    public boolean isImportingByLayer() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("isImportingByLayer()", "Handle_ObjectHasBeenDisposed", "conversion_resources");
            throw new IllegalArgumentException(string);
        }
        return ImportSettingGMLNative.jni_IsImportingByLayer(this.getHandle());
    }

    public void setImportingByLayer(boolean value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setImportingByLayer(boolean value)", "Handle_ObjectHasBeenDisposed", "conversion_resources");
            throw new IllegalArgumentException(string);
        }
        ImportSettingGMLNative.jni_SetImportingByLayer(this.getHandle(), value);
    }

    public void dispose() {
        if (!this.getIsDisposable()) {
            String string = InternalResource.loadString("dispose()", "Handle_UndisposableObject", "conversion_resources");
            throw new IllegalArgumentException(string);
        }
        if (this.getHandle() != 0L) {
            ImportSettingGMLNative.jni_Delete(this.getHandle());
            this.clearHandle();
        }
    }

    @Override
    protected void clearHandle() {
        super.clearHandle();
    }

    public void setImportEmptyDataset(boolean bImportEmptyDT) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setImportEmptyDataset()", "Global_ArgumentNull", "conversion_resources");
            throw new IllegalArgumentException(string);
        }
        ImportSettingGMLNative.jni_SetImportEmptyDT(this.getHandle(), bImportEmptyDT);
    }

    public boolean isImportEmptyDataset() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getImportEmptyDataset()", "Global_ArgumentNull", "conversion_resources");
            throw new IllegalArgumentException(string);
        }
        return ImportSettingGMLNative.jni_IsImportEmptyDT(this.getHandle());
    }
}

