/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.bslicense;

import com.google.gson.Gson;
import com.supermap.bslicense.Feature;
import com.supermap.bslicense.FeatureResult;
import com.supermap.bslicense.GetAllFeaturesEvent;
import com.supermap.bslicense.GetAllFeaturesListener;
import com.supermap.bslicense.ImportLicenseEvent;
import com.supermap.bslicense.ImportLicenseListener;
import com.supermap.bslicense.LicenseChangeEvent;
import com.supermap.bslicense.LicenseChangeListener;
import com.supermap.bslicense.LicenseChangeParam;
import com.supermap.bslicense.LicenseChangeResult;
import com.supermap.bslicense.LicenseChangeType;
import com.supermap.bslicense.LicenseCloseEvent;
import com.supermap.bslicense.LicenseCloseListener;
import com.supermap.bslicense.LicenseNumberChangeListener;
import com.supermap.bslicense.LicenseOpenEvent;
import com.supermap.bslicense.LicenseOpenListener;
import com.supermap.bslicense.util.AesUtil;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import org.java_websocket.client.WebSocketClient;
import org.java_websocket.handshake.ServerHandshake;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BsWebSocketClient
extends WebSocketClient {
    private Gson gson = new Gson();
    private LicenseOpenListener messageOpenListener;
    private LicenseChangeListener messageChangeListener;
    private LicenseNumberChangeListener messageLicenseNumberChangeListener;
    private LicenseCloseListener messageCloseListener;
    private GetAllFeaturesListener messageGetListener;
    private ImportLicenseListener messageImportListener;
    private LicenseChangeParam licenseChangeParam;
    private Logger logger = LoggerFactory.getLogger(BsWebSocketClient.class);

    public void setLicenseChangeParam(LicenseChangeParam licenseChangeParam) {
        this.licenseChangeParam = licenseChangeParam;
    }

    public BsWebSocketClient(String url) throws URISyntaxException {
        super(new URI(url));
    }

    public void onOpen(ServerHandshake serverHandshake) {
        this.fireMessageOpenListener();
        this.getLicense();
    }

    public void getLicense() {
        if (this.licenseChangeParam != null) {
            this.send("APPLYLICENSE____" + this.gson.toJson((Object)this.licenseChangeParam));
        }
    }

    public void getAllFeatures(int productId) {
        this.send("GETALLFEATURES____{'productId':" + productId + "}");
    }

    public void onMessage(String msg) {
        this.logger.debug("onMessage {}", (Object)msg);
        if (msg == null || msg.isEmpty()) {
            return;
        }
        String[] msgs = msg.split("____");
        if (msgs.length != 2) {
            return;
        }
        if (msgs[0].equals("APPLYLICENSE")) {
            LicenseChangeResult result = (LicenseChangeResult)this.gson.fromJson(msgs[1], LicenseChangeResult.class);
            String[] featureIds = null;
            int[] features = null;
            if (result.getFeatureIds() != null && !result.getFeatureIds().isEmpty()) {
                featureIds = result.getFeatureIds().split(",");
                features = new int[featureIds.length];
                for (int i = 0; i < featureIds.length; ++i) {
                    features[i] = Integer.parseInt(featureIds[i]);
                }
            }
            String licenseXmlString = "";
            if (result.getLicenseXml() != null && !result.getLicenseXml().isEmpty()) {
                String key = "";
                String licenseXml = result.getLicenseXml();
                if (licenseXml.length() > 16) {
                    key = licenseXml.substring(licenseXml.length() - 16, licenseXml.length());
                    licenseXmlString = licenseXml.substring(0, licenseXml.length() - 16);
                }
                licenseXmlString = AesUtil.decoder(key, licenseXmlString);
            }
            String[] ips = null;
            if (result.getIps() != null && !result.getIps().isEmpty()) {
                ips = result.getIps().split(",");
            }
            if (licenseXmlString != null && licenseXmlString.length() > 0) {
                this.fireMessageChangeListener(features, licenseXmlString, ips, result.getCpuQuotaNumber(), LicenseChangeType.ALLOCATION);
            } else {
                this.fireMessageChangeListener(features, licenseXmlString, ips, result.getCpuQuotaNumber(), LicenseChangeType.RECOVER);
            }
        } else if (msgs[0].equals("GETALLFEATURES")) {
            FeatureResult result = (FeatureResult)this.gson.fromJson(msgs[1], FeatureResult.class);
            this.fireMessageGetListener(result.getFeatures());
        } else if (msgs[0].equals("IMPORTLICENSE")) {
            FeatureResult result = (FeatureResult)this.gson.fromJson(msgs[1], FeatureResult.class);
            this.fireMessageImportListener(result.getFeatures());
        } else if (msgs[0].equals("LICENSENUMBERCHANGE")) {
            FeatureResult result = (FeatureResult)this.gson.fromJson(msgs[1], FeatureResult.class);
            this.fireMessageLicenseNumberChangeListener(result.getFeatures());
        }
    }

    public void onClose(int code, String reason, boolean remote) {
        this.logger.debug("code:" + code + ";reason:" + reason + ";remote:" + remote);
        this.fireMessageCloseListener();
    }

    public void onError(Exception ex) {
    }

    public void addMessageOpenListener(LicenseOpenListener messageOpenListener) {
        this.messageOpenListener = messageOpenListener;
    }

    public void addMessageChangeListener(LicenseChangeListener messageChangeListener) {
        this.messageChangeListener = messageChangeListener;
    }

    public void addMessageCloseListener(LicenseCloseListener messageCloseListener) {
        this.messageCloseListener = messageCloseListener;
    }

    public void addMessageGetListener(GetAllFeaturesListener messageGetListener) {
        this.messageGetListener = messageGetListener;
    }

    public void addMessageLicenseNumberChangeListener(LicenseNumberChangeListener messageLicenseNumberChangeListener) {
        this.messageLicenseNumberChangeListener = messageLicenseNumberChangeListener;
    }

    public void addMessageImportListener(ImportLicenseListener messageImportListener) {
        this.messageImportListener = messageImportListener;
    }

    public void removeMessageOpenListener() {
        this.messageOpenListener = null;
    }

    public void removeMessageChangeListener() {
        this.messageChangeListener = null;
    }

    public void removeMessageCloseListener() {
        this.messageCloseListener = null;
    }

    public void removeMessageGetListener() {
        this.messageGetListener = null;
    }

    public void removeMessageLicenseNumberChangeListener() {
        this.messageLicenseNumberChangeListener = null;
    }

    public void removeMessageImportListener() {
        this.messageImportListener = null;
    }

    public void fireMessageOpenListener() {
        if (this.messageOpenListener == null) {
            return;
        }
        LicenseOpenEvent event = new LicenseOpenEvent((Object)this);
        this.messageOpenListener.licenseOpen(event);
    }

    public void fireMessageChangeListener(int[] featureIds, String licenseXml, String[] ips, double cpuQuotaNumber, LicenseChangeType licenseChangeType) {
        if (this.messageChangeListener == null) {
            return;
        }
        LicenseChangeEvent event = new LicenseChangeEvent((Object)this, featureIds, licenseXml, ips, cpuQuotaNumber, licenseChangeType);
        this.messageChangeListener.licenseChange(event);
    }

    public void fireMessageCloseListener() {
        if (this.messageCloseListener == null) {
            return;
        }
        LicenseCloseEvent event = new LicenseCloseEvent((Object)this);
        this.messageCloseListener.licenseClose(event);
    }

    public void fireMessageGetListener(List<Feature> features) {
        if (this.messageGetListener == null) {
            return;
        }
        GetAllFeaturesEvent event = new GetAllFeaturesEvent((Object)this, features);
        this.messageGetListener.getAllFeatures(event);
    }

    public void fireMessageLicenseNumberChangeListener(List<Feature> features) {
        if (this.messageLicenseNumberChangeListener == null) {
            return;
        }
        GetAllFeaturesEvent event = new GetAllFeaturesEvent((Object)this, features);
        this.messageLicenseNumberChangeListener.getAllFeatures(event);
    }

    public void fireMessageImportListener(List<Feature> features) {
        if (this.messageImportListener == null) {
            return;
        }
        ImportLicenseEvent event = new ImportLicenseEvent((Object)this, features);
        this.messageImportListener.importLicense(event);
    }
}

