/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.analyst.navigation;

import com.supermap.License;
import com.supermap.ProductType;
import com.supermap.analyst.navigation.InternalHandle;
import com.supermap.analyst.navigation.InternalHandleDisposable;
import com.supermap.analyst.navigation.InternalResource;
import com.supermap.analyst.navigation.InternalToolkitNavigation;
import com.supermap.analyst.navigation.SSCDataEnvironmentNative;
import com.supermap.data.DatasetType;
import com.supermap.data.DatasetVector;
import com.supermap.data.SteppedEvent;
import com.supermap.data.SteppedListener;
import java.util.ArrayList;
import java.util.Vector;

@Deprecated
public class SSCDataEnvironment
extends InternalHandleDisposable {
    private static License m_license;
    private static transient Vector m_steppedListeners;
    private boolean isConnectData;

    public SSCDataEnvironment() {
        this.setHandle(0L);
        ArrayList<ProductType> arrayList = InternalToolkitNavigation.managerProducts(InternalToolkitNavigation.getNavigationProducts());
        m_license = InternalToolkitNavigation.verifyLicense(arrayList);
        long l = SSCDataEnvironmentNative.jni_New();
        this.setHandle(l, true);
        this.isConnectData = false;
    }

    public void dispose() {
        if (this.getHandle() != 0L) {
            SSCDataEnvironmentNative.jni_Delete(this.getHandle());
            this.setHandle(0L);
        }
    }

    public boolean connectData(String sscFilePath, DatasetVector networkDataset) {
        SSCDataEnvironment.verifyLicense();
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("SSCDataEnvironment", "Global_ArgumentObjectHasBeenDisposed", "navigation_resources");
            throw new IllegalStateException(string);
        }
        if (networkDataset == null) {
            String string = InternalResource.loadString("networkDataset", "Global_ArgumentNull", "navigation_resources");
            throw new IllegalStateException(string);
        }
        long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)networkDataset);
        if (l == 0L) {
            String string = InternalResource.loadString("networkDataset", "Global_ArgumentObjectHasBeenDisposed", "navigation_resources");
            throw new IllegalStateException(string);
        }
        DatasetType datasetType = networkDataset.getType();
        if (datasetType != DatasetType.NETWORK) {
            String string = InternalResource.loadString("networkDataset", "DatasetTypeMustBeNetwork", "navigation_resources");
            throw new IllegalStateException(string);
        }
        if (sscFilePath == null || sscFilePath.isEmpty()) {
            String string = InternalResource.loadString("sscFilePath", "Global_ArgumentNull", "navigation_resources");
            throw new IllegalStateException(string);
        }
        this.isConnectData = SSCDataEnvironmentNative.jni_connectData(this.getHandle(), sscFilePath, l);
        return this.isConnectData;
    }

    public void setTolerance(double tolerance) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("SSCDataEnvironment", "Global_ArgumentObjectHasBeenDisposed", "navigation_resources");
            throw new IllegalStateException(string);
        }
        if (tolerance < 0.0) {
            String string = InternalResource.loadString("tolerance", "ToleranceMustEqualsOrGreaterThanZero", "navigation_resources");
            throw new IllegalArgumentException(string);
        }
        if (this.isConnectData) {
            String string = InternalResource.loadString("tolerance", "SSCEnvironmentConnectedDataCannotChangeTolerance", "navigation_resources");
            throw new IllegalArgumentException(string);
        }
        SSCDataEnvironmentNative.jni_setTolerance(this.getHandle(), tolerance);
    }

    public double getTolerance() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("SSCDataEnvironment", "Global_ArgumentObjectHasBeenDisposed", "navigation_resources");
            throw new IllegalStateException(string);
        }
        return SSCDataEnvironmentNative.jni_getTolerance(this.getHandle());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void verifyLicense() {
        int n = -1;
        Object object = m_license;
        synchronized (object) {
            n = m_license.verify();
        }
        if (n != 0) {
            object = License.getErrorMessage((int)n);
            throw new IllegalStateException((String)object);
        }
    }

    public synchronized void addSteppedListener(SteppedListener l) {
        if (m_steppedListeners == null) {
            m_steppedListeners = new Vector();
        }
        if (!m_steppedListeners.contains(l)) {
            m_steppedListeners.add(l);
        }
    }

    public synchronized void removeSteppedListener(SteppedListener l) {
        if (m_steppedListeners != null && m_steppedListeners.contains(l)) {
            m_steppedListeners.remove(l);
        }
    }

    protected static void fireStepped(SteppedEvent event) {
        if (m_steppedListeners != null) {
            Vector vector = m_steppedListeners;
            int n = vector.size();
            for (int i = 0; i < n; ++i) {
                ((SteppedListener)vector.elementAt(i)).stepped(event);
            }
        }
    }

    static void steppedCallBack(int percent, long remainTime, String title, String message, long cancelHandle) {
        String string = "SSCDataEnvironment";
        boolean bl = InternalToolkitNavigation.getHandleBooleanValue(cancelHandle);
        Object object = new Object();
        SteppedEvent steppedEvent = new SteppedEvent(object, percent, remainTime, title, message, string, bl);
        SSCDataEnvironment.fireStepped(steppedEvent);
        InternalToolkitNavigation.setHandleBooleanValue(cancelHandle, steppedEvent.getCancel());
    }
}

