/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.analyst.trafficanalyst;

import com.supermap.analyst.trafficanalyst.InternalResource;
import com.supermap.analyst.trafficanalyst.LineSetting;
import com.supermap.analyst.trafficanalyst.LineSettings;
import com.supermap.analyst.trafficanalyst.RelationSetting;
import com.supermap.analyst.trafficanalyst.RelationSettings;
import com.supermap.analyst.trafficanalyst.StopSetting;
import com.supermap.analyst.trafficanalyst.StopSettings;
import com.supermap.analyst.trafficanalyst.TransferAnalystSettingNative;
import com.supermap.data.DatasetVector;
import com.supermap.data.Datasource;
import com.supermap.data.Unit;

public class TransferAnalystSetting {
    private LineSettings m_transferLineSettings;
    private StopSettings m_transferStopSettings;
    private double m_walkingTolerance;
    private double m_snapTolerance;
    private double m_mergeTolerance;
    private RelationSettings m_transferRelationSettings;
    private Unit m_unitType;
    private double m_ratio;
    private long m_networkHandle = 0L;
    private long m_buildHanlde = 0L;

    public TransferAnalystSetting() {
        this.m_walkingTolerance = 1000.0;
        this.m_snapTolerance = 10.0;
        this.m_mergeTolerance = 100.0;
        this.m_transferStopSettings = new StopSettings();
        this.m_transferLineSettings = new LineSettings();
        this.m_unitType = Unit.METER;
        this.m_transferRelationSettings = new RelationSettings();
    }

    public TransferAnalystSetting(TransferAnalystSetting TransferAnalystSetting2) {
        this.setWalkingTolerance(TransferAnalystSetting2.getWalkingTolerance());
        this.setSnapTolerance(TransferAnalystSetting2.getSnapTolerance());
        this.setMergeTolerance(TransferAnalystSetting2.getMergeTolerance());
        this.m_transferStopSettings = new StopSettings(TransferAnalystSetting2.getStopSettings());
        this.m_transferLineSettings = new LineSettings(TransferAnalystSetting2.getLineSettings());
        this.m_transferRelationSettings = new RelationSettings(TransferAnalystSetting2.getRelationSettings());
        this.setUnit(TransferAnalystSetting2.getUnit());
    }

    protected void dispose() {
        if (this.m_buildHanlde != 0L) {
            TransferAnalystSettingNative.jni_Delete(this.m_buildHanlde);
            this.m_buildHanlde = 0L;
        }
    }

    LineSettings getLineSettings() {
        return this.m_transferLineSettings;
    }

    public LineSetting getLineSetting() {
        return this.m_transferLineSettings.get(0);
    }

    void setLineSettings(LineSettings value) {
        if (value == null) {
            String string = InternalResource.loadString("lineSettings", "Global_ArgumentNull", "trafficanalyst_resources");
            throw new NullPointerException(string);
        }
        this.m_transferLineSettings = value;
    }

    public void setLineSetting(LineSetting value) {
        if (value == null) {
            String string = InternalResource.loadString("lineSetting", "Global_ArgumentNull", "trafficanalyst_resources");
            throw new NullPointerException(string);
        }
        this.m_transferLineSettings.add(value);
    }

    StopSettings getStopSettings() {
        return this.m_transferStopSettings;
    }

    public StopSetting getStopSetting() {
        return this.m_transferStopSettings.get(0);
    }

    void setStopSettings(StopSettings value) {
        if (value == null) {
            String string = InternalResource.loadString("stopSettings", "Global_ArgumentNull", "trafficanalyst_resources");
            throw new NullPointerException(string);
        }
        this.m_transferStopSettings = value;
    }

    public void setStopSetting(StopSetting value) {
        if (value == null) {
            String string = InternalResource.loadString("stopSettings", "Global_ArgumentNull", "trafficanalyst_resources");
            throw new NullPointerException(string);
        }
        this.m_transferStopSettings.add(value);
    }

    RelationSettings getRelationSettings() {
        return this.m_transferRelationSettings;
    }

    public RelationSetting getRelationSetting() {
        return this.m_transferRelationSettings.get(0);
    }

    void setRelationSettings(RelationSettings value) {
        if (value == null) {
            String string = InternalResource.loadString("relationSettings", "Global_ArgumentNull", "trafficanalyst_resources");
            throw new NullPointerException(string);
        }
        this.m_transferRelationSettings = value;
    }

    public void setRelationSetting(RelationSetting value) {
        if (value == null) {
            String string = InternalResource.loadString("relationSettings", "Global_ArgumentNull", "trafficanalyst_resources");
            throw new NullPointerException(string);
        }
        this.m_transferRelationSettings.add(value);
    }

    public double getSnapTolerance() {
        return this.m_snapTolerance;
    }

    public void setSnapTolerance(double value) {
        if (value < 0.0) {
            String string = InternalResource.loadString("value", "TransferAnalystSetting_SnapToleranceShouldNotBeNegative", "trafficanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        this.m_snapTolerance = value;
    }

    @Deprecated
    public double getMergeTolerance() {
        return this.m_mergeTolerance;
    }

    @Deprecated
    public void setMergeTolerance(double value) {
        if (value < 0.0) {
            String string = InternalResource.loadString("value", "TransferAnalystSetting_MergeToleranceShouldNotBeNegative", "trafficanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        this.m_mergeTolerance = value;
    }

    public double getWalkingTolerance() {
        return this.m_walkingTolerance;
    }

    public void setWalkingTolerance(double value) {
        if (value < 0.0) {
            String string = InternalResource.loadString("value", "TransferAnalystSetting_WalkingToleranceShouldNotBeNegative", "trafficanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        this.m_walkingTolerance = value;
    }

    public void setUnit(Unit value) {
        if (this.m_unitType == Unit.DEGREE || this.m_unitType == Unit.MINUTE || this.m_unitType == Unit.SECOND || this.m_unitType == Unit.RADIAN) {
            String string = InternalResource.loadString("value", "UnitType_UnSupport", "trafficanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        this.m_unitType = value;
    }

    public Unit getUnit() {
        return this.m_unitType;
    }

    long setToUGC() {
        long l;
        this.m_buildHanlde = l = TransferAnalystSettingNative.jni_New();
        long l2 = this.m_transferLineSettings.setToUGC();
        long l3 = this.m_transferStopSettings.setToUGC();
        long l4 = 0L;
        long l5 = 0L;
        long l6 = 0L;
        if (this.m_transferRelationSettings != null) {
            l4 = this.m_transferRelationSettings.setRelationToUGC();
            if (this.m_transferRelationSettings.get(0).getDatasetPath() != null) {
                l5 = this.m_transferRelationSettings.setStopExitToUGC();
            }
            if (this.m_transferRelationSettings.get(0).getDatasetNetwork() != null) {
                l6 = this.m_transferRelationSettings.setNetworkToUGC();
            }
            this.m_networkHandle = l6;
        }
        this.m_ratio = (double)this.m_unitType.value() / (double)Unit.METER.value();
        double d = this.m_walkingTolerance * this.m_ratio;
        double d2 = this.m_snapTolerance * this.m_ratio;
        double d3 = this.m_mergeTolerance * this.m_ratio;
        TransferAnalystSettingNative.jni_SetAllToUGC(l, l2, l3, l4, l5, l6, d, d2, d3);
        TransferAnalystSettingNative.jni_DeleteLinesInfoHandle(l2);
        TransferAnalystSettingNative.jni_DeleteStopsInfoHandle(l3);
        TransferAnalystSettingNative.jni_DeleteRelationsHandle(l4);
        TransferAnalystSettingNative.jni_DeleteStopExitRelationsHandle(l5);
        TransferAnalystSettingNative.jni_DeleteNetworksHandle(l6);
        return l;
    }

    void getFromUGC(Datasource ds, long handle) {
        double[] dArray = new double[3];
        long[] lArray = new long[5];
        TransferAnalystSettingNative.jni_GetAllFromUGC(handle, lArray, dArray);
        this.m_transferLineSettings = new LineSettings();
        this.m_transferLineSettings.getFromUGC(ds, lArray[0]);
        TransferAnalystSettingNative.jni_DeleteLinesInfoHandle(lArray[0]);
        this.m_transferStopSettings = new StopSettings();
        this.m_transferStopSettings.getFromUGC(ds, lArray[1]);
        TransferAnalystSettingNative.jni_DeleteStopsInfoHandle(lArray[1]);
        this.m_transferRelationSettings = new RelationSettings();
        this.m_transferRelationSettings.getRelationFromUGC(ds, lArray[2]);
        TransferAnalystSettingNative.jni_DeleteRelationsHandle(lArray[2]);
        this.m_transferRelationSettings.getStopExitFromUGC(ds, lArray[3]);
        TransferAnalystSettingNative.jni_DeleteStopExitRelationsHandle(lArray[3]);
        this.m_transferRelationSettings.getNetworkFromUGC(ds, lArray[4]);
        TransferAnalystSettingNative.jni_DeleteNetworksHandle(lArray[4]);
        this.m_ratio = (double)this.m_unitType.value() / (double)Unit.METER.value();
        this.setWalkingTolerance(dArray[0] / this.m_ratio);
        this.setSnapTolerance(dArray[1] / this.m_ratio);
        this.setMergeTolerance(dArray[2] / this.m_ratio);
    }

    private static boolean isNetworkFieldsAllRight(String[] fields, DatasetVector networkDataset) {
        boolean bl = true;
        if (!networkDataset.open()) {
            networkDataset.open();
        }
        if (networkDataset.getChildDataset().isAvailableFieldName(fields[0])) {
            return false;
        }
        int n = fields.length;
        for (int i = 1; i < n; ++i) {
            if (!networkDataset.isAvailableFieldName(fields[i])) continue;
            bl = false;
            break;
        }
        return bl;
    }
}

