/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.ui;

import com.supermap.License;
import com.supermap.ProductType;
import com.supermap.data.ActionGraphicObject;
import com.supermap.data.Enum;
import com.supermap.data.Geometry3D;
import com.supermap.data.IDisposable;
import com.supermap.realspace.Layer3D;
import com.supermap.realspace.Layer3DGroup;
import com.supermap.realspace.Layer3DType;
import com.supermap.realspace.Layer3Ds;
import com.supermap.realspace.Scene;
import com.supermap.realspace.SceneType;
import com.supermap.realspace.SnapMode3D;
import com.supermap.ui.Action3D;
import com.supermap.ui.Action3DChangedEvent;
import com.supermap.ui.Action3DChangedListener;
import com.supermap.ui.InteractionMode3D;
import com.supermap.ui.InternalEnum;
import com.supermap.ui.InternalHandle;
import com.supermap.ui.InternalHandleDisposable;
import com.supermap.ui.InternalRealspaceEnvironment;
import com.supermap.ui.InternalRealspaceGeometry;
import com.supermap.ui.InternalRealspaceResource;
import com.supermap.ui.InternalScene;
import com.supermap.ui.InternalToolkitSpaceUI;
import com.supermap.ui.NavigationControl;
import com.supermap.ui.ObjectAddedEvent;
import com.supermap.ui.ObjectAddedListener;
import com.supermap.ui.ObjectDeletedEvent;
import com.supermap.ui.ObjectDeletedListener;
import com.supermap.ui.ObjectDeletingEvent;
import com.supermap.ui.ObjectDeletingListener;
import com.supermap.ui.ObjectModifiedEvent;
import com.supermap.ui.ObjectModifiedListener;
import com.supermap.ui.ObjectModifyingEvent;
import com.supermap.ui.ObjectModifyingListener;
import com.supermap.ui.ObjectSelectChangedEvent;
import com.supermap.ui.ObjectSelectChangedListener;
import com.supermap.ui.ObjectSelectedEvent;
import com.supermap.ui.ObjectSelectedListener;
import com.supermap.ui.SceneControlNative;
import com.supermap.ui.SceneControl_this_ActionAdapter;
import com.supermap.ui.SceneControl_this_FocusAdapter;
import com.supermap.ui.SceneControl_this_componentAdapter;
import com.supermap.ui.SceneControl_this_keyAdapter;
import com.supermap.ui.SceneControl_this_mouseAdapter;
import com.supermap.ui.SceneControl_this_mouseMotionAdapter;
import com.supermap.ui.SceneControl_this_mouseWheelListener;
import com.supermap.ui.SceneLoadedEvent;
import com.supermap.ui.SceneLoadedListener;
import com.supermap.ui.Tracked3DEvent;
import com.supermap.ui.Tracked3DListener;
import com.supermap.ui.Tracking3DEvent;
import com.supermap.ui.Tracking3DListener;
import java.awt.Canvas;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.IllegalComponentStateException;
import java.awt.Image;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ComponentEvent;
import java.awt.event.FocusEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.beans.Beans;
import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.Vector;
import javax.swing.Timer;

public class SceneControl
extends Canvas
implements IDisposable {
    private static final long serialVersionUID = 1L;
    private static final int TIMER_SECONDS = 20;
    private long m_handle = 0L;
    private Scene m_scene;
    private SceneType m_sceneType;
    private NavigationControl m_navigationControl;
    private String imageTargetPath = System.getProperty("java.io.tmpdir");
    private SceneControl_this_keyAdapter m_keyAdapter;
    private SceneControl_this_mouseWheelListener m_mouseWheel;
    private SceneControl_this_mouseAdapter m_mouseAdapter;
    private SceneControl_this_mouseMotionAdapter m_mouseMotion;
    private SceneControl_this_FocusAdapter m_focusAdapter;
    transient Vector m_trackingListeners;
    transient Vector m_trackedListeners;
    transient Vector m_actionChangedListeners;
    transient Vector m_objectSelectedListeners;
    transient Vector m_objectSelectChangedListeners;
    transient Vector m_objectModifiedListeners;
    transient Vector m_objectModifyingListeners;
    transient Vector m_objectAddedListeners;
    transient Vector m_objectDeletingListeners;
    transient Vector m_objectDeletedListeners;
    transient Vector m_sceneLoadedListeners;
    private boolean isNewFlag = false;
    private boolean m_mouse;
    private boolean m_Key;
    private boolean m_notify;
    private License m_license;
    private InteractionMode3D m_interactionMode = InteractionMode3D.DEFAULT;
    private boolean m_waitCursorEnabled = false;
    private boolean m_cursorCustomized = false;
    private boolean m_isAlwaysUpdate = false;
    private Timer m_timer;
    private static boolean isDeleting;
    private static long lastTime;
    private final Object lock = new Object();

    public SceneControl() {
        this.checkLicense();
        this.setSize(256, 256);
        if (!Beans.isDesignTime()) {
            this.initialize();
        }
    }

    public SceneControl(SceneType sceneType) {
        this.checkLicense();
        this.m_sceneType = sceneType;
        this.setSize(256, 256);
        if (!Beans.isDesignTime()) {
            this.initialize();
        }
    }

    public long get_mHandle() {
        return this.getHandle();
    }

    protected void checkLicense() {
        ArrayList<ProductType> arrayList = InternalToolkitSpaceUI.managerProducts(InternalToolkitSpaceUI.getSpaceProducts());
        this.m_license = InternalToolkitSpaceUI.verifyLicense(arrayList);
    }

    private void unLoadLicense() {
        if (this.m_license != null) {
            this.m_license.disconnect();
            this.m_license.dispose();
            this.m_license = null;
        }
    }

    private void initialize() {
        this.m_keyAdapter = new SceneControl_this_keyAdapter(this);
        this.m_mouseWheel = new SceneControl_this_mouseWheelListener(this);
        this.m_mouseAdapter = new SceneControl_this_mouseAdapter(this);
        this.m_mouseMotion = new SceneControl_this_mouseMotionAdapter(this);
        this.m_focusAdapter = new SceneControl_this_FocusAdapter(this);
        this.addComponentListener(new SceneControl_this_componentAdapter(this));
        this.addFocusListener(this.m_focusAdapter);
        this.addMouseWheelListener(this.m_mouseWheel);
        this.addKeyListener(this.m_keyAdapter);
        this.addMouseListener(this.m_mouseAdapter);
        this.addMouseMotionListener(this.m_mouseMotion);
        this.m_mouse = true;
        this.m_Key = true;
        this.setVisible(true);
    }

    public boolean isKeyboardNavigationEnabled() {
        this.makeSureNewFromJNI();
        if (!Beans.isDesignTime()) {
            if (this.m_handle == 0L) {
                String string = InternalRealspaceResource.loadString("isKeyboardNavigationEnabled()", "Handle_ObjectHasBeenDisposed", "ui_realspace_resources");
                throw new IllegalStateException(string);
            }
            return this.m_Key;
        }
        return false;
    }

    public void setKeyboardNavigationEnabled(boolean value) {
        this.makeSureNewFromJNI();
        if (!Beans.isDesignTime()) {
            if (this.m_handle == 0L) {
                String string = InternalRealspaceResource.loadString("setKeyboardNavigationEnabled(boolean value)", "Handle_ObjectHasBeenDisposed", "ui_realspace_resources");
                throw new IllegalStateException(string);
            }
            this.m_Key = value;
        }
    }

    public boolean isMouseNavigationEnabled() {
        this.makeSureNewFromJNI();
        if (!Beans.isDesignTime()) {
            if (this.m_handle == 0L) {
                String string = InternalRealspaceResource.loadString("isMouseNavigationEnabled()", "Handle_ObjectHasBeenDisposed", "ui_realspace_resources");
                throw new IllegalStateException(string);
            }
            return this.m_mouse;
        }
        return false;
    }

    public void setMouseNavigationEnabled(boolean value) {
        this.makeSureNewFromJNI();
        if (!Beans.isDesignTime()) {
            if (this.m_handle == 0L) {
                String string = InternalRealspaceResource.loadString("setMouseNavigationEnabled(boolean value)", "Handle_ObjectHasBeenDisposed", "ui_realspace_resources");
                throw new IllegalStateException(string);
            }
            this.m_mouse = value;
        }
    }

    public void setInteractionMode(InteractionMode3D value) {
        this.makeSureNewFromJNI();
        if (!Beans.isDesignTime() && this.m_handle == 0L) {
            String string = InternalRealspaceResource.loadString("setInteractionMode(InteractionMode3D value)", "Handle_ObjectHasBeenDisposed", "ui_realspace_resources");
            throw new IllegalStateException(string);
        }
        this.m_interactionMode = value;
    }

    public InteractionMode3D getInteractionMode() {
        this.makeSureNewFromJNI();
        if (!Beans.isDesignTime() && this.m_handle == 0L) {
            String string = InternalRealspaceResource.loadString("getInteractionMode()", "Handle_ObjectHasBeenDisposed", "ui_realspace_resources");
            throw new IllegalStateException(string);
        }
        return this.m_interactionMode;
    }

    public boolean isWaitCursorEnabled() {
        this.makeSureNewFromJNI();
        if (!Beans.isDesignTime() && this.m_handle == 0L) {
            String string = InternalRealspaceResource.loadString("", "Handle_ObjectHasBeenDisposed", "ui_realspace_resources");
            throw new IllegalStateException(string);
        }
        return this.m_waitCursorEnabled;
    }

    public void setWaitCursorEnabled(boolean waitCursorEnabled) {
        this.makeSureNewFromJNI();
        if (!Beans.isDesignTime() && this.m_handle == 0L) {
            String string = InternalRealspaceResource.loadString("", "Handle_ObjectHasBeenDisposed", "ui_realspace_resources");
            throw new IllegalStateException(string);
        }
        this.m_waitCursorEnabled = waitCursorEnabled;
    }

    public boolean isCursorCustomized() {
        this.makeSureNewFromJNI();
        if (!Beans.isDesignTime() && this.m_handle == 0L) {
            String string = InternalRealspaceResource.loadString("", "Handle_ObjectHasBeenDisposed", "ui_realspace_resources");
            throw new IllegalStateException(string);
        }
        return this.m_cursorCustomized;
    }

    public void setCursorCustomized(boolean cursorCustomized) {
        this.makeSureNewFromJNI();
        if (!Beans.isDesignTime() && this.m_handle == 0L) {
            String string = InternalRealspaceResource.loadString("", "Handle_ObjectHasBeenDisposed", "ui_realspace_resources");
            throw new IllegalStateException(string);
        }
        this.m_cursorCustomized = cursorCustomized;
    }

    public boolean isAlwaysUpdate() {
        this.makeSureNewFromJNI();
        if (!Beans.isDesignTime() && this.m_handle == 0L) {
            String string = InternalRealspaceResource.loadString("", "Handle_ObjectHasBeenDisposed", "ui_realspace_resources");
            throw new IllegalStateException(string);
        }
        return this.m_isAlwaysUpdate;
    }

    public void setAlwaysUpdate(boolean value) {
        this.makeSureNewFromJNI();
        if (!Beans.isDesignTime() && this.m_handle == 0L) {
            String string = InternalRealspaceResource.loadString("", "Handle_ObjectHasBeenDisposed", "ui_realspace_resources");
            throw new IllegalStateException(string);
        }
        this.m_isAlwaysUpdate = value;
    }

    public boolean isStatusBarVisible() {
        this.makeSureNewFromJNI();
        if (!Beans.isDesignTime()) {
            if (this.m_handle == 0L) {
                String string = InternalRealspaceResource.loadString("isStatusBarVisible()", "Handle_ObjectHasBeenDisposed", "ui_realspace_resources");
                throw new IllegalStateException(string);
            }
            return SceneControlNative.jni_GetIsStatusBarVisible(this.m_handle);
        }
        return false;
    }

    public void setStatusBarVisible(boolean value) {
        this.makeSureNewFromJNI();
        if (!Beans.isDesignTime()) {
            if (this.m_handle == 0L) {
                String string = InternalRealspaceResource.loadString("setStatusBarVisible(boolean value)", "Handle_ObjectHasBeenDisposed", "ui_realspace_resources");
                throw new IllegalStateException(string);
            }
            SceneControlNative.jni_SetIsStatusBarVisible(this.m_handle, value);
        }
    }

    public boolean isFPSVisible() {
        this.makeSureNewFromJNI();
        if (!Beans.isDesignTime()) {
            if (this.m_handle == 0L) {
                String string = InternalRealspaceResource.loadString("isPFSVisible()", "Handle_ObjectHasBeenDisposed", "ui_realspace_resources");
                throw new IllegalStateException(string);
            }
            return SceneControlNative.jni_GetIsFPSVisible(this.m_handle);
        }
        return false;
    }

    public void setFPSVisible(boolean value) {
        this.makeSureNewFromJNI();
        if (!Beans.isDesignTime()) {
            if (this.m_handle == 0L) {
                String string = InternalRealspaceResource.loadString("setPFSVisible(boolean value)", "Handle_ObjectHasBeenDisposed", "ui_realspace_resources");
                throw new IllegalStateException(string);
            }
            SceneControlNative.jni_SetIsFPSVisible(this.m_handle, value);
        }
    }

    public Action3D getAction() {
        this.makeSureNewFromJNI();
        if (!Beans.isDesignTime()) {
            if (this.m_handle == 0L) {
                String string = InternalRealspaceResource.loadString("getAction()", "Handle_ObjectHasBeenDisposed", "ui_realspace_resources");
                throw new IllegalStateException(string);
            }
            int n = SceneControlNative.jni_GetAction(this.m_handle);
            return (Action3D)InternalEnum.parseUGCValue(Action3D.class, n);
        }
        return null;
    }

    public void setAction(Action3D value) {
        this.makeSureNewFromJNI();
        if (!Beans.isDesignTime()) {
            if (this.m_handle == 0L) {
                String string = InternalRealspaceResource.loadString("setAction(Action3D value)", "Handle_ObjectHasBeenDisposed", "ui_realspace_resources");
                throw new IllegalStateException(string);
            }
            int n = InternalEnum.getUGCValue(value);
            SceneControlNative.jni_SetAction(this.m_handle, n);
            this.setCursor(false);
        }
    }

    public NavigationControl getNavigationControl() {
        this.makeSureNewFromJNI();
        if (!Beans.isDesignTime()) {
            if (this.m_handle == 0L) {
                String string = InternalRealspaceResource.loadString("getNavigationControl()", "Handle_ObjectHasBeenDisposed", "ui_realspace_resources");
                throw new IllegalStateException(string);
            }
            if (this.m_navigationControl == null) {
                this.m_navigationControl = new NavigationControl(this);
            }
            return this.m_navigationControl;
        }
        return null;
    }

    public Scene getScene() {
        this.makeSureNewFromJNI();
        if (this.m_scene == null) {
            long l = SceneControlNative.jni_GetScene(this.m_handle, this.imageTargetPath);
            if (this.m_handle != 0L) {
                this.m_scene = InternalScene.createInstance(l, this, this.m_timer);
            } else {
                return null;
            }
        }
        if (!Beans.isDesignTime()) {
            if (this.m_handle == 0L) {
                String string = InternalRealspaceResource.loadString("getScene()", "Handle_ObjectHasBeenDisposed", "ui_realspace_resources");
                throw new IllegalStateException(string);
            }
            return this.m_scene;
        }
        return null;
    }

    public Layer3D[] getEditableLayers() {
        this.makeSureNewFromJNI();
        if (!Beans.isDesignTime()) {
            int n;
            if (this.m_handle == 0L) {
                String string = InternalRealspaceResource.loadString("getEditableLayers()", "Handle_ObjectHasBeenDisposed", "ui_realspace_resources");
                throw new IllegalStateException(string);
            }
            ArrayList arrayList = new ArrayList();
            Layer3Ds layer3Ds = this.getScene().getLayers();
            ArrayList<Layer3D> arrayList2 = new ArrayList<Layer3D>();
            for (n = 0; n < layer3Ds.getCount(); ++n) {
                if (layer3Ds.get(n).getType() != Layer3DType.GROUP3D) {
                    arrayList2.add(layer3Ds.get(n));
                    continue;
                }
                arrayList2.addAll(this.recursionLayer3DGroup((Layer3DGroup)layer3Ds.get(n)));
            }
            for (n = 0; n < arrayList2.size(); ++n) {
                if (!((Layer3D)((Object)arrayList2.get(n))).isEditable()) continue;
                arrayList.add(arrayList2.get(n));
            }
            arrayList2.clear();
            Layer3D[] layer3DArray = new Layer3D[arrayList.size()];
            arrayList.toArray(layer3DArray);
            return layer3DArray;
        }
        return null;
    }

    private ArrayList<Layer3D> recursionLayer3DGroup(Layer3DGroup layer3dgroup) {
        ArrayList<Layer3D> arrayList = new ArrayList<Layer3D>();
        for (int i = 0; i < layer3dgroup.getCount(); ++i) {
            if (layer3dgroup.get(i).getType() != Layer3DType.GROUP3D) {
                arrayList.add(layer3dgroup.get(i));
                continue;
            }
            arrayList.addAll(this.recursionLayer3DGroup((Layer3DGroup)layer3dgroup.get(i)));
        }
        return arrayList;
    }

    public Layer3D getActiveEditableLayer() {
        this.makeSureNewFromJNI();
        if (!Beans.isDesignTime()) {
            if (this.m_handle == 0L) {
                String string = InternalRealspaceResource.loadString("getActiveEditableLayer()", "Handle_ObjectHasBeenDisposed", "ui_realspace_resources");
                throw new IllegalStateException(string);
            }
            String string = SceneControlNative.jni_GetActiveEditableLayer(this.getHandle());
            Layer3D layer3D = null;
            if (!string.equals("")) {
                int n;
                Layer3Ds layer3Ds = this.getScene().getLayers();
                ArrayList<Layer3D> arrayList = new ArrayList<Layer3D>();
                for (n = 0; n < layer3Ds.getCount(); ++n) {
                    ArrayList<Layer3D> arrayList2 = SceneControl.getInnerDataLayer(layer3Ds.get(n));
                    arrayList.addAll(arrayList2);
                    if (arrayList2 == null) continue;
                    arrayList2.clear();
                }
                for (n = 0; n < arrayList.size(); ++n) {
                    if (!((Layer3D)((Object)arrayList.get(n))).getName().equals(string)) continue;
                    return (Layer3D)((Object)arrayList.get(n));
                }
            }
            return layer3D;
        }
        return null;
    }

    protected static ArrayList<Layer3D> getInnerDataLayer(Layer3D layer) {
        if (layer == null) {
            return null;
        }
        ArrayList<Layer3D> arrayList = new ArrayList<Layer3D>();
        if (layer.getType() == Layer3DType.GROUP3D) {
            Layer3DGroup layer3DGroup = (Layer3DGroup)layer;
            for (int i = 0; i < layer3DGroup.getCount(); ++i) {
                arrayList.addAll(SceneControl.getInnerDataLayer(layer3DGroup.get(i)));
            }
        } else {
            arrayList.add(layer);
        }
        return arrayList;
    }

    public void setActiveEditableLayer(Layer3D layer3D) {
        this.makeSureNewFromJNI();
        if (!Beans.isDesignTime()) {
            if (this.m_handle == 0L) {
                String string = InternalRealspaceResource.loadString("setActiveEditableLayer(Layer3D layer3D)", "Handle_ObjectHasBeenDisposed", "ui_realspace_resources");
                throw new IllegalStateException(string);
            }
            if (this.getScene().getLayers().indexOf(layer3D.getName()) == -1) {
                String string = InternalRealspaceResource.loadString("layer3D", "Layer3D_IsNotInScene", "ui_realspace_resources");
                throw new IllegalStateException(string);
            }
            SceneControlNative.jni_SetActiveEditableLayer(this.getHandle(), InternalHandle.getHandle(layer3D));
        }
    }

    public double getPanDatumPlane() {
        this.makeSureNewFromJNI();
        if (!Beans.isDesignTime() && this.m_handle == 0L) {
            String string = InternalRealspaceResource.loadString("getActiveEditableLayer()", "Handle_ObjectHasBeenDisposed", "ui_realspace_resources");
            throw new IllegalStateException(string);
        }
        return SceneControlNative.jni_GetPanDatumPlane(this.getHandle());
    }

    public void setPanDatumPlane(double value) {
        this.makeSureNewFromJNI();
        if (!Beans.isDesignTime() && this.m_handle == 0L) {
            String string = InternalRealspaceResource.loadString("setActiveEditableLayer(Layer3D layer3D)", "Handle_ObjectHasBeenDisposed", "ui_realspace_resources");
            throw new IllegalStateException(string);
        }
        SceneControlNative.jni_SetPanDatumPlane(this.getHandle(), value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        Object object = this.lock;
        synchronized (object) {
            isDeleting = true;
            lastTime = System.currentTimeMillis() + 500L;
        }
        this.clearHandle();
        if (this.m_handle != 0L) {
            if (this.m_timer != null) {
                this.m_timer.stop();
            }
            this.m_timer = null;
            SceneControlNative.jni_Delete(this.m_handle);
            this.m_handle = 0L;
        }
        this.unLoadLicense();
        new Thread(){

            @Override
            public void run() {
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException interruptedException) {
                    interruptedException.printStackTrace();
                }
                if (System.currentTimeMillis() > lastTime) {
                    isDeleting = false;
                }
            }
        }.start();
    }

    @Override
    public void addNotify() {
        super.addNotify();
        this.m_notify = true;
        if (!Beans.isDesignTime()) {
            this.setSize(this.getWidth() + 1, this.getHeight() + 1);
            this.setSize(this.getWidth() - 1, this.getHeight() - 1);
            if (this.m_timer == null) {
                this.m_timer = new Timer(20, new SceneControl_this_ActionAdapter(this));
                this.m_timer.start();
            }
        }
    }

    @Override
    public void paint(Graphics g) {
        this.checkLicense();
        if (!Beans.isDesignTime()) {
            if (this.m_handle != 0L) {
                this.setCursor(true);
                this.m_scene.refresh();
                this.setCursor(false);
            }
        } else {
            g.drawString("SceneControl", this.getWidth() / 2 - 30, this.getHeight() / 2);
        }
    }

    @Override
    public void update(Graphics g) {
        int n = this.getWidth();
        int n2 = this.getHeight();
        Image image = this.createImage(n, n2);
        Graphics graphics = image.getGraphics();
        this.paint(graphics);
        graphics.dispose();
        g.drawImage(image, 0, 0, null);
    }

    void focusGained(FocusEvent e) {
        if (!Beans.isDesignTime() && this.m_handle != 0L) {
            SceneControlNative.jni_GetFocus(this.m_handle);
        }
    }

    void focusLost(FocusEvent e) {
        if (!Beans.isDesignTime() && this.m_handle != 0L && !this.m_isAlwaysUpdate) {
            SceneControlNative.jni_LostFocus(this.m_handle);
        }
    }

    int getSubAction() {
        if (this.m_handle != 0L) {
            return SceneControlNative.jni_GetSubAction(this.m_handle);
        }
        return 0;
    }

    void setSubAction(int value) {
        if (this.m_handle != 0L) {
            SceneControlNative.jni_SetSubAction(this.m_handle, value);
        }
    }

    void clearHandle() {
        if (this.m_scene != null) {
            InternalScene.clearHandle(this.m_scene);
            this.m_scene = null;
        }
        this.m_navigationControl = null;
    }

    private synchronized void makeSureNewFromJNI() {
        if (!this.isNewFlag) {
            if (!this.isDisplayable()) {
                String string = InternalRealspaceResource.loadString("", "SceneControl_ShouldBeShowingOnTheScreen", "ui_realspace_resources");
                throw new IllegalComponentStateException(string);
            }
            this.m_handle = this.m_sceneType == null ? SceneControlNative.jni_New(this) : SceneControlNative.jni_New(this, this.m_sceneType.value());
            this.reset(this.imageTargetPath);
            this.m_navigationControl = new NavigationControl(this);
            this.isNewFlag = true;
            SceneLoadedEvent sceneLoadedEvent = new SceneLoadedEvent(this, this.getScene());
            this.fireSceneLoaded(sceneLoadedEvent);
        }
    }

    void reset(String path) {
        String[] stringArray = new String[]{InternalRealspaceResource.loadString("", "North_Latitude", "ui_realspace_resources"), InternalRealspaceResource.loadString("", "South_Latitude", "ui_realspace_resources"), InternalRealspaceResource.loadString("", "East_Longtitude", "ui_realspace_resources"), InternalRealspaceResource.loadString("", "West_Latitude", "ui_realspace_resources"), InternalRealspaceResource.loadString("", "Altitude", "ui_realspace_resources"), InternalRealspaceResource.loadString("", "Camera_Altitude", "ui_realspace_resources"), InternalRealspaceResource.loadString("", "Arctic_Circle", "ui_realspace_resources"), InternalRealspaceResource.loadString("", "Tropic_OfCancer", "ui_realspace_resources"), InternalRealspaceResource.loadString("", "Equator", "ui_realspace_resources"), InternalRealspaceResource.loadString("", "Tropic_OfCapricorn", "ui_realspace_resources"), InternalRealspaceResource.loadString("", "Antarctic_Circle", "ui_realspace_resources"), InternalRealspaceResource.loadString("", "PrimeMeridian", "ui_realspace_resources"), InternalRealspaceResource.loadString("", "Antimeridian", "ui_realspace_resources")};
        SceneControlNative.jni_Reset(this.m_handle, path, stringArray);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void render() {
        Object object = this.lock;
        synchronized (object) {
            if (this.m_handle != 0L && !isDeleting) {
                SceneControlNative.jni_Render(this, this.m_handle);
            }
        }
    }

    private void onSize(int width, int height) {
        SceneControlNative.jni_ReSetHWND(this, this.m_handle);
        if (this.m_handle != 0L) {
            SceneControlNative.jni_OnSize(this.m_handle, width, height);
            if (this.m_scene == null) {
                long l = SceneControlNative.jni_GetScene(this.m_handle, this.imageTargetPath);
                this.m_scene = InternalScene.createInstance(l, this, this.m_timer);
            }
            if (this.m_scene != null) {
                this.m_scene.refresh();
            }
        }
    }

    public void doKeyDown(KeyEvent e) {
        this.makeSureNewFromJNI();
        if (!Beans.isDesignTime() && this.m_handle != 0L) {
            int n = 0;
            if (e.isShiftDown()) {
                n |= 1;
            }
            if (e.isControlDown()) {
                n |= 2;
            }
            if (e.isAltDown()) {
                n |= 4;
            }
            if (this.m_Key || e.getKeyCode() == 90 || e.getKeyCode() == 78 || e.getKeyCode() == 127 || e.getKeyCode() == 107 || e.getKeyCode() == 109 || e.getKeyCode() == 189 || e.getKeyCode() == 187) {
                SceneControlNative.jni_OnKeyDown(this.m_handle, this.getKey(e), n);
            }
            this.setCursor(false);
        }
    }

    public void doKeyUp(KeyEvent e) {
        this.makeSureNewFromJNI();
        if (!Beans.isDesignTime() && this.m_handle != 0L) {
            int n = 0;
            if (e.isShiftDown()) {
                n |= 1;
            }
            if (e.isControlDown()) {
                n |= 2;
            }
            if (e.isAltDown()) {
                n |= 4;
            }
            if (this.m_Key || e.getKeyCode() == 90 || e.getKeyCode() == 78 || e.getKeyCode() == 127) {
                SceneControlNative.jni_OnKeyUp(this.m_handle, this.getKey(e), n);
            }
            this.setCursor(false);
        }
    }

    void componentResized(ComponentEvent e) {
        if (!Beans.isDesignTime() && this.m_notify) {
            this.makeSureNewFromJNI();
            this.onSize(this.getWidth(), this.getHeight());
        }
    }

    public void doMouseDown(MouseEvent e) {
        this.makeSureNewFromJNI();
        if (!Beans.isDesignTime() && this.m_handle != 0L) {
            if (this.m_mouse || this.getAction().equals((Object)Action3D.MeasureAltitude) || this.getAction().equals((Object)Action3D.INTERVISIBILITY) || this.getAction().equals((Object)Action3D.MeasureArea) || this.getAction().equals((Object)Action3D.MeasureDistance) || this.getAction().equals((Object)Action3D.MEASURE_TERRAIN_DISTANCE)) {
                int n = 0;
                if (e.isShiftDown()) {
                    n |= 1;
                }
                if (e.isControlDown()) {
                    n |= 2;
                }
                if (e.getButton() == 1) {
                    SceneControlNative.jni_OnLButtonDown(this.m_handle, e.getX(), e.getY(), n);
                }
                if (e.getButton() == 1 && e.getClickCount() == 2) {
                    SceneControlNative.jni_OnLButtonDblClick(this.m_handle, e.getX(), e.getY());
                }
                if (e.getButton() == 3) {
                    SceneControlNative.jni_OnRButtonDown(this.m_handle, e.getX(), e.getY(), n);
                }
                if (e.getButton() == 3 && e.getClickCount() == 2) {
                    SceneControlNative.jni_OnRButtonDblClick(this.m_handle, e.getX(), e.getY());
                }
                if (e.getButton() == 2 && this.m_mouse) {
                    SceneControlNative.jni_OnMiddleMouseDown(this.m_handle, e.getX(), e.getY());
                }
            }
            this.setCursor(false);
        }
    }

    public void doMouseUp(MouseEvent e) {
        this.makeSureNewFromJNI();
        if (!Beans.isDesignTime() && this.m_handle != 0L) {
            if (this.m_mouse || this.getAction().equals((Object)Action3D.MeasureAltitude) || this.getAction().equals((Object)Action3D.INTERVISIBILITY) || this.getAction().equals((Object)Action3D.MeasureArea) || this.getAction().equals((Object)Action3D.MeasureDistance) || this.getAction().equals((Object)Action3D.MEASURE_TERRAIN_DISTANCE)) {
                int n = 0;
                if (e.isShiftDown()) {
                    n |= 1;
                }
                if (e.isControlDown()) {
                    n |= 2;
                }
                if (e.getButton() == 1) {
                    SceneControlNative.jni_OnLButtonUp(this.m_handle, e.getX(), e.getY(), n);
                } else if (e.getButton() == 3) {
                    SceneControlNative.jni_OnRButtonUp(this.m_handle, e.getX(), e.getY(), n);
                } else if (e.getButton() == 2 && this.m_mouse) {
                    SceneControlNative.jni_OnMiddleMouseUp(this.m_handle, e.getX(), e.getY());
                }
            }
            this.setCursor(false);
        }
    }

    public void doMouseMove(MouseEvent e) {
        this.makeSureNewFromJNI();
        if (!Beans.isDesignTime() && this.m_handle != 0L) {
            if (this.m_mouse || this.getAction().equals((Object)Action3D.MeasureAltitude) || this.getAction().equals((Object)Action3D.INTERVISIBILITY) || this.getAction().equals((Object)Action3D.MeasureArea) || this.getAction().equals((Object)Action3D.MeasureDistance) || this.getAction().equals((Object)Action3D.MEASURE_TERRAIN_DISTANCE)) {
                int n = 0;
                if (e.isShiftDown()) {
                    n |= 1;
                }
                if (e.isControlDown()) {
                    n |= 2;
                }
                SceneControlNative.jni_OnMouseMove(this.m_handle, e.getX(), e.getY(), n);
                this.getScene().refresh();
            }
            this.setCursor(false);
        }
    }

    public void doMouseWheel(MouseWheelEvent e) {
        this.makeSureNewFromJNI();
        if (!Beans.isDesignTime() && this.m_handle != 0L && this.m_mouse) {
            SceneControlNative.jni_OnMouseWheelMoved(this.m_handle, -e.getUnitsToScroll() * 15, e.getX(), e.getY());
        }
    }

    void actionPerformed(ActionEvent e) {
        this.render();
    }

    long getHandle() {
        return this.m_handle;
    }

    protected static long getHandle(SceneControl sceneControl) {
        return sceneControl.m_handle;
    }

    private void setCursor(boolean wait) {
        if (this.m_handle == 0L) {
            return;
        }
        if (this.m_cursorCustomized) {
            return;
        }
        if (wait && !this.m_waitCursorEnabled) {
            return;
        }
        Cursor cursor = null;
        cursor = wait ? Cursors.getBusy() : this.getDefaultCursor();
        try {
            this.setCursor(cursor);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public boolean isDynamicSelection() {
        this.makeSureNewFromJNI();
        if (!Beans.isDesignTime()) {
            if (this.m_handle == 0L) {
                String string = InternalRealspaceResource.loadString("SceneControl", "Handle_ObjectHasBeenDisposed", "ui_realspace_resources");
                throw new IllegalStateException(string);
            }
            return SceneControlNative.jni_IsDynamicSelection(this.m_handle);
        }
        return false;
    }

    public void setDynamicSelection(boolean value) {
        this.makeSureNewFromJNI();
        if (!Beans.isDesignTime()) {
            if (this.m_handle == 0L) {
                String string = InternalRealspaceResource.loadString("SceneControl", "Handle_ObjectHasBeenDisposed", "ui_realspace_resources");
                throw new IllegalStateException(string);
            }
            SceneControlNative.jni_SetDynamicSelection(this.m_handle, value);
        }
    }

    public boolean isStatusBarShowAltitude() {
        this.makeSureNewFromJNI();
        if (!Beans.isDesignTime()) {
            if (this.m_handle == 0L) {
                String string = InternalRealspaceResource.loadString("SceneControl", "Handle_ObjectHasBeenDisposed", "ui_realspace_resources");
                throw new IllegalStateException(string);
            }
            return SceneControlNative.jni_IsStatusBarShowAltitude(this.m_handle);
        }
        return false;
    }

    public void setStatusBarShowAltitude(boolean value) {
        this.makeSureNewFromJNI();
        if (!Beans.isDesignTime()) {
            if (this.m_handle == 0L) {
                String string = InternalRealspaceResource.loadString("SceneControl", "Handle_ObjectHasBeenDisposed", "ui_realspace_resources");
                throw new IllegalStateException(string);
            }
            SceneControlNative.jni_SetStatusBarShowAltitude(this.m_handle, value);
        }
    }

    private Cursor getDefaultCursor() {
        Cursor cursor = Cursors.getArrow();
        switch (this.getSubAction()) {
            case 1: {
                cursor = Cursors.getBusy();
                break;
            }
            case 2: {
                cursor = Cursors.getArrow();
                break;
            }
            case 4: {
                cursor = Cursors.getPan();
                break;
            }
            case 5: {
                cursor = Cursors.getHold();
                break;
            }
            case 7: {
                cursor = Cursors.getSelect();
                break;
            }
            case 29: {
                cursor = Cursors.getMeasureAltitude();
                break;
            }
            case 30: {
                cursor = Cursors.getMeasureArea();
                break;
            }
            case 31: {
                cursor = Cursors.getMeasureDistance();
                break;
            }
            case 34: {
                cursor = Cursors.getIntervisibility();
                break;
            }
            case 36: {
                cursor = Cursors.getViewSheds();
                break;
            }
            case 23: {
                cursor = Cursors.getMove();
                break;
            }
            case 27: {
                cursor = Cursors.getNortheastSouthwest();
                break;
            }
            case 26: {
                cursor = Cursors.getNorthwestSoutheast();
                break;
            }
            case 25: {
                cursor = Cursors.getWestEast();
                break;
            }
            case 24: {
                cursor = Cursors.getNorthSouth();
                break;
            }
            case 21: {
                cursor = Cursors.getRotation();
                break;
            }
            case 48: {
                cursor = Cursors.getHSplit();
                break;
            }
            case 49: {
                cursor = Cursors.getVSplit();
                break;
            }
            case 50: {
                cursor = Cursors.getHand();
                break;
            }
        }
        return cursor;
    }

    public SnapMode3D getSnapMode() {
        this.makeSureNewFromJNI();
        if (!Beans.isDesignTime()) {
            if (this.m_handle == 0L) {
                String string = InternalRealspaceResource.loadString("SceneControl", "Handle_ObjectHasBeenDisposed", "ui_realspace_resources");
                throw new IllegalStateException(string);
            }
            int n = SceneControlNative.jni_GetSnapMode(this.m_handle);
            return (SnapMode3D)InternalEnum.parseUGCValue(SnapMode3D.class, n);
        }
        return null;
    }

    public void setSnapMode(SnapMode3D value) {
        this.makeSureNewFromJNI();
        if (!Beans.isDesignTime()) {
            if (this.m_handle == 0L) {
                String string = InternalRealspaceResource.loadString("SceneControl", "Handle_ObjectHasBeenDisposed", "ui_realspace_resources");
                throw new IllegalStateException(string);
            }
            SceneControlNative.jni_SetSnapMode(this.m_handle, value.value(), this.m_scene != null);
            if (this.m_scene != null) {
                for (int i = 0; i < this.m_scene.getLayers().getCount(); ++i) {
                    Layer3D layer3D = this.m_scene.getLayers().get(i);
                    if (layer3D.getType() != Layer3DType.DATASET && layer3D.getType() != Layer3DType.MODEL && layer3D.getType() != Layer3DType.VECTORFILE && layer3D.getType() != Layer3DType.OSGB) continue;
                    layer3D.updateData();
                }
                this.m_scene.refresh();
            }
        }
    }

    public synchronized void addTrackingListener(Tracking3DListener l) {
        if (this.m_trackingListeners == null) {
            this.m_trackingListeners = new Vector();
        }
        if (!this.m_trackingListeners.contains(l)) {
            this.m_trackingListeners.add(l);
        }
    }

    public synchronized void removeTrackingListener(Tracking3DListener l) {
        if (this.m_trackingListeners != null && this.m_trackingListeners.contains(l)) {
            this.m_trackingListeners.remove(l);
        }
    }

    protected void fireTracking(Tracking3DEvent event) {
        if (this.m_trackingListeners != null) {
            Vector vector = this.m_trackingListeners;
            int n = vector.size();
            for (int i = 0; i < n; ++i) {
                ((Tracking3DListener)vector.elementAt(i)).tracking(event);
            }
        }
    }

    static void trackingCallBack(SceneControl sceneControl, double x, double y, long zHandle, double height, double currentlength, double currentangle, double totalArea, double totalLength, long geometryHandle) {
        if (sceneControl != null) {
            Geometry3D geometry3D = null;
            if (geometryHandle != 0L) {
                geometry3D = (Geometry3D)InternalRealspaceGeometry.createInstance2(geometryHandle);
                InternalHandleDisposable.setIsDisposable((com.supermap.data.InternalHandleDisposable)geometry3D, false);
            }
            double d = InternalToolkitSpaceUI.getHandleDoubleValue(zHandle);
            Tracking3DEvent tracking3DEvent = new Tracking3DEvent(sceneControl, x, y, d, currentlength, currentangle, totalArea, totalLength, height, geometry3D);
            sceneControl.fireTracking(tracking3DEvent);
            InternalToolkitSpaceUI.setHandleDoubleValue(zHandle, tracking3DEvent.getZ());
        }
    }

    public synchronized void addTrackedListener(Tracked3DListener l) {
        if (this.m_trackedListeners == null) {
            this.m_trackedListeners = new Vector();
        }
        if (!this.m_trackedListeners.contains(l)) {
            this.m_trackedListeners.add(l);
        }
    }

    public synchronized void removeTrackedListener(Tracked3DListener l) {
        if (this.m_trackedListeners != null && this.m_trackedListeners.contains(l)) {
            this.m_trackedListeners.remove(l);
        }
    }

    protected void fireTracked(Tracked3DEvent event) {
        if (this.m_trackedListeners != null) {
            Vector vector = this.m_trackedListeners;
            int n = vector.size();
            for (int i = 0; i < n; ++i) {
                ((Tracked3DListener)vector.elementAt(i)).tracked(event);
            }
        }
    }

    static void trackedCallBack(SceneControl sceneControl, long geometryHandle, double length, double area, double height) {
        if (sceneControl != null) {
            Geometry3D geometry3D = null;
            if (geometryHandle != 0L) {
                geometry3D = (Geometry3D)InternalRealspaceGeometry.createInstance2(geometryHandle);
                InternalHandleDisposable.setIsDisposable((com.supermap.data.InternalHandleDisposable)geometry3D, false);
            }
            Tracked3DEvent tracked3DEvent = new Tracked3DEvent(sceneControl, geometry3D, length, area, height);
            sceneControl.fireTracked(tracked3DEvent);
        }
    }

    public synchronized void addActionChangedListener(Action3DChangedListener l) {
        if (this.m_actionChangedListeners == null) {
            this.m_actionChangedListeners = new Vector();
        }
        if (!this.m_actionChangedListeners.contains(l)) {
            this.m_actionChangedListeners.add(l);
        }
    }

    public synchronized void removeActionChangedListener(Action3DChangedListener l) {
        if (this.m_actionChangedListeners != null && this.m_actionChangedListeners.contains(l)) {
            this.m_actionChangedListeners.remove(l);
        }
    }

    protected void fireActionChanged(Action3DChangedEvent event) {
        if (this.m_actionChangedListeners != null) {
            Vector vector = this.m_actionChangedListeners;
            int n = vector.size();
            for (int i = 0; i < n; ++i) {
                ((Action3DChangedListener)vector.elementAt(i)).actionChanged(event);
            }
        }
    }

    static void actionChangedCallBack(SceneControl sceneControl, int oldAction, int newAction) {
        if (sceneControl != null) {
            Action3D action3D = (Action3D)Enum.parse(Action3D.class, (int)oldAction);
            Action3D action3D2 = (Action3D)Enum.parse(Action3D.class, (int)newAction);
            Action3DChangedEvent action3DChangedEvent = new Action3DChangedEvent(sceneControl, action3D, action3D2);
            sceneControl.fireActionChanged(action3DChangedEvent);
        }
    }

    public synchronized void addObjectSelectedListener(ObjectSelectedListener l) {
        if (this.m_objectSelectedListeners == null) {
            this.m_objectSelectedListeners = new Vector();
        }
        if (!this.m_objectSelectedListeners.contains(l)) {
            this.m_objectSelectedListeners.add(l);
        }
    }

    public synchronized void removeObjectSelectedListener(ObjectSelectedListener l) {
        if (this.m_objectSelectedListeners != null && this.m_objectSelectedListeners.contains(l)) {
            this.m_objectSelectedListeners.remove(l);
        }
    }

    protected void fireObjectSelected(ObjectSelectedEvent event) {
        if (this.m_objectSelectedListeners != null) {
            Vector vector = this.m_objectSelectedListeners;
            int n = vector.size();
            for (int i = 0; i < n; ++i) {
                ((ObjectSelectedListener)vector.elementAt(i)).objectSelected(event);
            }
        }
    }

    static void objectSelectedCallBack(SceneControl sceneControl, int selectedGeometryCount) {
        if (sceneControl != null) {
            ObjectSelectedEvent objectSelectedEvent = new ObjectSelectedEvent(sceneControl, selectedGeometryCount);
            sceneControl.fireObjectSelected(objectSelectedEvent);
        }
    }

    public synchronized void addLoadSceneListener(SceneLoadedListener l) {
        if (this.m_sceneLoadedListeners == null) {
            this.m_sceneLoadedListeners = new Vector();
        }
        if (!this.m_sceneLoadedListeners.contains(l)) {
            this.m_sceneLoadedListeners.add(l);
        }
    }

    public synchronized void removeLoadSceneListener(SceneLoadedListener l) {
        if (this.m_sceneLoadedListeners != null && this.m_sceneLoadedListeners.contains(l)) {
            this.m_sceneLoadedListeners.remove(l);
        }
    }

    protected void fireSceneLoaded(SceneLoadedEvent event) {
        if (this.m_sceneLoadedListeners != null) {
            Vector vector = this.m_sceneLoadedListeners;
            int n = vector.size();
            for (int i = 0; i < n; ++i) {
                ((SceneLoadedListener)vector.elementAt(i)).sceneLoaded(event);
            }
        }
    }

    public synchronized void addObjectSelectChangedListener(ObjectSelectChangedListener l) {
        if (this.m_objectSelectChangedListeners == null) {
            this.m_objectSelectChangedListeners = new Vector();
        }
        if (!this.m_objectSelectChangedListeners.contains(l)) {
            this.m_objectSelectChangedListeners.add(l);
        }
    }

    public synchronized void removeObjectSelectChangedListener(ObjectSelectChangedListener l) {
        if (this.m_objectSelectChangedListeners != null && this.m_objectSelectChangedListeners.contains(l)) {
            this.m_objectSelectChangedListeners.remove(l);
        }
    }

    static void objectSelectChangedCallBack(SceneControl sceneControl, int selectedGeometryCount) {
        if (sceneControl != null) {
            ObjectSelectChangedEvent objectSelectChangedEvent = new ObjectSelectChangedEvent(sceneControl, selectedGeometryCount);
            sceneControl.fireObjectSelectChanged(objectSelectChangedEvent);
        }
    }

    protected void fireObjectSelectChanged(ObjectSelectChangedEvent event) {
        if (this.m_objectSelectChangedListeners != null) {
            Vector vector = this.m_objectSelectChangedListeners;
            int n = vector.size();
            for (int i = 0; i < n; ++i) {
                ((ObjectSelectChangedListener)vector.elementAt(i)).objectSelectChanged(event);
            }
        }
    }

    public synchronized void addObjectModifiedListener(ObjectModifiedListener l) {
        if (this.m_objectModifiedListeners == null) {
            this.m_objectModifiedListeners = new Vector();
        }
        if (!this.m_objectModifiedListeners.contains(l)) {
            this.m_objectModifiedListeners.add(l);
        }
    }

    public synchronized void removeObjectModifiedListener(ObjectModifiedListener l) {
        if (this.m_objectModifiedListeners != null && this.m_objectModifiedListeners.contains(l)) {
            this.m_objectModifiedListeners.remove(l);
        }
    }

    public synchronized void addObjectAddedListener(ObjectAddedListener l) {
        if (this.m_objectAddedListeners == null) {
            this.m_objectAddedListeners = new Vector();
        }
        if (!this.m_objectAddedListeners.contains(l)) {
            this.m_objectAddedListeners.add(l);
        }
    }

    public synchronized void removeObjectAddedListener(ObjectAddedListener l) {
        if (this.m_objectAddedListeners != null && this.m_objectAddedListeners.contains(l)) {
            this.m_objectAddedListeners.remove(l);
        }
    }

    public synchronized void addObjectDeletingListener(ObjectDeletingListener l) {
        if (this.m_objectDeletingListeners == null) {
            this.m_objectDeletingListeners = new Vector();
        }
        if (!this.m_objectDeletingListeners.contains(l)) {
            this.m_objectDeletingListeners.add(l);
        }
    }

    public synchronized void addObjectDeletedListener(ObjectDeletedListener l) {
        if (this.m_objectDeletedListeners == null) {
            this.m_objectDeletedListeners = new Vector();
        }
        if (!this.m_objectDeletedListeners.contains(l)) {
            this.m_objectDeletedListeners.add(l);
        }
    }

    public synchronized void removeObjectDeletingListener(ObjectDeletingListener l) {
        if (this.m_objectDeletingListeners != null && this.m_objectDeletingListeners.contains(l)) {
            this.m_objectDeletingListeners.remove(l);
        }
    }

    public synchronized void removeObjectDeletedListener(ObjectDeletedListener l) {
        if (this.m_objectDeletedListeners != null && this.m_objectDeletedListeners.contains(l)) {
            this.m_objectDeletedListeners.remove(l);
        }
    }

    public synchronized void addObjectModifyingListener(ObjectModifyingListener l) {
        if (this.m_objectModifyingListeners == null) {
            this.m_objectModifyingListeners = new Vector();
        }
        if (!this.m_objectModifyingListeners.contains(l)) {
            this.m_objectModifyingListeners.add(l);
        }
    }

    public synchronized void removeObjectModifyingListener(ObjectModifyingListener l) {
        if (this.m_objectModifyingListeners != null && this.m_objectModifyingListeners.contains(l)) {
            this.m_objectModifyingListeners.remove(l);
        }
    }

    static void objectModifiedCallBack(SceneControl sceneControl, int selectedGeometryID, long layer3DHandle) {
        if (sceneControl != null) {
            int n;
            Layer3D layer3D = null;
            Layer3Ds layer3Ds = sceneControl.getScene().getLayers();
            ArrayList<Layer3D> arrayList = new ArrayList<Layer3D>();
            for (n = 0; n < layer3Ds.getCount(); ++n) {
                ArrayList<Layer3D> arrayList2 = SceneControl.getInnerDataLayer(layer3Ds.get(n));
                arrayList.addAll(arrayList2);
                if (arrayList2 == null) continue;
                arrayList2.clear();
            }
            n = arrayList.size();
            for (int i = 0; i < n; ++i) {
                Layer3D layer3D2 = (Layer3D)((Object)arrayList.get(i));
                long l = InternalHandle.getHandle(layer3D2);
                if (l == layer3DHandle) {
                    layer3D = layer3D2;
                    break;
                }
                if (i != n - 1) continue;
                return;
            }
            ObjectModifiedEvent objectModifiedEvent = new ObjectModifiedEvent(sceneControl, selectedGeometryID, layer3D);
            sceneControl.fireObjectModified(objectModifiedEvent);
        }
    }

    protected void fireObjectModified(ObjectModifiedEvent event) {
        if (this.m_objectModifiedListeners != null) {
            Vector vector = this.m_objectModifiedListeners;
            int n = vector.size();
            for (int i = 0; i < n; ++i) {
                ((ObjectModifiedListener)vector.elementAt(i)).objectModifiedChanged(event);
            }
        }
    }

    static void objectAddedCallBack(SceneControl sceneControl, int geometryID, long layer3DHandle) {
        if (sceneControl != null) {
            Layer3D layer3D = sceneControl.getCallBackLayer3D(sceneControl, layer3DHandle);
            if (layer3D == null) {
                return;
            }
            ObjectAddedEvent objectAddedEvent = new ObjectAddedEvent(sceneControl, geometryID, layer3D);
            sceneControl.fireObjectAdded(objectAddedEvent);
        }
    }

    protected void fireObjectAdded(ObjectAddedEvent event) {
        if (this.m_objectAddedListeners != null) {
            Vector vector = this.m_objectAddedListeners;
            int n = vector.size();
            for (int i = 0; i < n; ++i) {
                ((ObjectAddedListener)vector.elementAt(i)).objectAdded(event);
            }
        }
    }

    static void objectDeletingCallBack(SceneControl sceneControl, int geometryID, long layer3DHandle) {
        if (sceneControl != null) {
            Layer3D layer3D = sceneControl.getCallBackLayer3D(sceneControl, layer3DHandle);
            if (layer3D == null) {
                return;
            }
            ObjectDeletingEvent objectDeletingEvent = new ObjectDeletingEvent(sceneControl, geometryID, layer3D);
            sceneControl.fireObjectDeleting(objectDeletingEvent);
        }
    }

    protected void fireObjectDeleting(ObjectDeletingEvent event) {
        if (this.m_objectDeletingListeners != null) {
            Vector vector = this.m_objectDeletingListeners;
            int n = vector.size();
            for (int i = 0; i < n; ++i) {
                ((ObjectDeletingListener)vector.elementAt(i)).objectDeleting(event);
            }
        }
    }

    static void objectDeletedCallBack(SceneControl sceneControl, int geometryID, long layer3DHandle) {
        if (sceneControl != null) {
            Layer3D layer3D = sceneControl.getCallBackLayer3D(sceneControl, layer3DHandle);
            if (layer3D == null) {
                return;
            }
            ObjectDeletedEvent objectDeletedEvent = new ObjectDeletedEvent(sceneControl, geometryID, layer3D);
            sceneControl.fireObjectDeleted(objectDeletedEvent);
        }
    }

    protected void fireObjectDeleted(ObjectDeletedEvent event) {
        if (this.m_objectDeletedListeners != null) {
            Vector vector = this.m_objectDeletedListeners;
            int n = vector.size();
            for (int i = 0; i < n; ++i) {
                ((ObjectDeletedListener)vector.elementAt(i)).objectDeleted(event);
            }
        }
    }

    static void objectModifyingCallBack(SceneControl sceneControl, int selectedGeometryID, long layer3DHandle) {
        if (sceneControl != null) {
            Layer3D layer3D = sceneControl.getCallBackLayer3D(sceneControl, layer3DHandle);
            if (layer3D == null) {
                return;
            }
            ObjectModifyingEvent objectModifyingEvent = new ObjectModifyingEvent(sceneControl, selectedGeometryID, layer3D);
            sceneControl.fireObjectModifying(objectModifyingEvent);
        }
    }

    protected void fireObjectModifying(ObjectModifyingEvent event) {
        if (this.m_objectModifyingListeners != null) {
            Vector vector = this.m_objectModifyingListeners;
            int n = vector.size();
            for (int i = 0; i < n; ++i) {
                ((ObjectModifyingListener)vector.elementAt(i)).objectModifying(event);
            }
        }
    }

    private Layer3D getCallBackLayer3D(SceneControl sceneControl, long layer3DHandle) {
        Layer3D layer3D = null;
        int n = sceneControl.getScene().getLayers().getCount();
        for (int i = 0; i < n; ++i) {
            Layer3D layer3D2 = sceneControl.getScene().getLayers().get(i);
            long l = InternalHandle.getHandle(layer3D2);
            if (l == layer3DHandle) {
                layer3D = layer3D2;
                break;
            }
            if (layer3D2 instanceof Layer3DGroup && (layer3D = this.getCallBackLayer3DFromGroup((Layer3DGroup)layer3D2, layer3DHandle)) != null) break;
        }
        return layer3D;
    }

    private Layer3D getCallBackLayer3DFromGroup(Layer3DGroup group, long layer3DHandle) {
        Layer3D layer3D = null;
        for (int i = 0; i < group.getCount(); ++i) {
            Layer3D layer3D2 = group.get(i);
            long l = InternalHandle.getHandle(layer3D2);
            if (l == layer3DHandle) {
                layer3D = layer3D2;
                break;
            }
            if (layer3D2 instanceof Layer3DGroup && (layer3D = this.getCallBackLayer3DFromGroup((Layer3DGroup)layer3D2, layer3DHandle)) != null) break;
        }
        return layer3D;
    }

    int getKey(KeyEvent e) {
        int n = 0;
        switch (e.getKeyCode()) {
            case 127: {
                n = 46;
                break;
            }
            case 27: {
                n = 27;
                break;
            }
            case 36: {
                n = 36;
                break;
            }
            case 35: {
                n = 35;
                break;
            }
            case 33: {
                n = 33;
                break;
            }
            case 34: {
                n = 34;
                break;
            }
            case 38: {
                n = 38;
                break;
            }
            case 40: {
                n = 40;
                break;
            }
            case 37: {
                n = 37;
                break;
            }
            case 39: {
                n = 39;
                break;
            }
            default: {
                n = e.getKeyCode();
            }
        }
        return n;
    }

    public void mouseWheelMoved(MouseWheelEvent e) {
        if (this.m_interactionMode == InteractionMode3D.DEFAULT || this.m_interactionMode == InteractionMode3D.CUSTOMKEYBOARD) {
            this.doMouseWheel(e);
        }
    }

    public void keyPressed(KeyEvent e) {
        if (this.m_interactionMode == InteractionMode3D.DEFAULT || this.m_interactionMode == InteractionMode3D.CUSTOMMOUSE) {
            this.doKeyDown(e);
        }
    }

    public void keyReleased(KeyEvent e) {
        if (this.m_interactionMode == InteractionMode3D.DEFAULT || this.m_interactionMode == InteractionMode3D.CUSTOMMOUSE) {
            this.doKeyUp(e);
        }
    }

    public void mouseDragged(MouseEvent e) {
        if (this.m_interactionMode == InteractionMode3D.DEFAULT || this.m_interactionMode == InteractionMode3D.CUSTOMKEYBOARD) {
            this.doMouseMove(e);
        }
    }

    public void mousePressed(MouseEvent e) {
        if (this.m_interactionMode == InteractionMode3D.DEFAULT || this.m_interactionMode == InteractionMode3D.CUSTOMKEYBOARD) {
            this.doMouseDown(e);
        }
    }

    public void mouseReleased(MouseEvent e) {
        if (this.m_interactionMode == InteractionMode3D.DEFAULT || this.m_interactionMode == InteractionMode3D.CUSTOMKEYBOARD) {
            this.doMouseUp(e);
        }
    }

    @Deprecated
    public void SetActionGraphicObject3D(ActionGraphicObject action3D) {
        SceneControlNative.jni_SetActionGraphicObject3D(this.m_handle, action3D.action, action3D.param1, action3D.param2, action3D.param3, action3D.param4);
    }

    public void setActionGraphicObject3D(ActionGraphicObject action3D) {
        SceneControlNative.jni_SetActionGraphicObject3D(this.m_handle, action3D.action, action3D.param1, action3D.param2, action3D.param3, action3D.param4);
    }

    public ActionGraphicObject getActionGraphicObject3D() {
        long[] lArray = new long[3];
        String string = SceneControlNative.jni_GetActionGraphicObject3D(this.m_handle, lArray);
        return new ActionGraphicObject(-1, lArray[0], lArray[1], lArray[2], string);
    }

    static {
        InternalRealspaceEnvironment.LoadWrapJ();
        isDeleting = false;
        lastTime = 0L;
    }

    public static class Cursors {
        private static Cursor m_busy = null;
        private static Cursor m_arrow = null;
        private static Cursor m_pan = null;
        private static Cursor m_select = null;
        private static Cursor m_Rotation = null;
        private static Cursor m_Move = null;
        private static Cursor m_NorthSouth = null;
        private static Cursor m_WestEast = null;
        private static Cursor m_NorthwestSoutheast = null;
        private static Cursor m_NortheastSouthwest = null;
        private static Cursor m_MeasureArea = null;
        private static Cursor m_MeasureDistance = null;
        private static Cursor m_Intervisibility = null;
        private static Cursor m_ViewSheds = null;
        private static Cursor m_MeasureAltitude = null;
        private static Cursor m_Hold = null;
        private static Cursor m_Hand = null;
        private static Cursor m_HSplit = null;
        private static Cursor m_VSplit = null;

        private Cursors() {
        }

        private static Cursor setCursorFromFile(String fileName) {
            Toolkit toolkit = Toolkit.getDefaultToolkit();
            Cursor cursor = null;
            URL uRL = Cursors.class.getResource("/com/supermap/ui/SceneControl.class");
            String string = uRL.getFile();
            int n = string.indexOf("com/supermap/ui/SceneControl.class");
            String string2 = string.substring(0, n);
            Image image = null;
            String string3 = string2 + "RealSpace/Resources/" + fileName;
            File file = new File(string3);
            if (file.exists()) {
                image = toolkit.createImage(string3);
            } else {
                uRL = Cursors.class.getResource("/com/supermap/ui/image/realspaceImage/" + fileName);
                if (uRL != null) {
                    image = toolkit.createImage(uRL);
                }
            }
            if (image != null) {
                cursor = toolkit.createCustomCursor(image, new Point(9, 8), "");
            }
            return cursor;
        }

        private static Cursor setCursorFromFile(String fileName, int x, int y) {
            Toolkit toolkit = Toolkit.getDefaultToolkit();
            Cursor cursor = null;
            URL uRL = Cursors.class.getResource("/com/supermap/ui/SceneControl.class");
            String string = uRL.getFile();
            int n = string.indexOf("com/supermap/ui/SceneControl.class");
            String string2 = string.substring(0, n);
            Image image = null;
            String string3 = string2 + "RealSpace/Resources/" + fileName;
            File file = new File(string3);
            if (file.exists()) {
                image = toolkit.createImage(string3);
            } else {
                uRL = Cursors.class.getResource("/com/supermap/ui/image/realspaceImage/" + fileName);
                if (uRL != null) {
                    image = toolkit.createImage(uRL);
                }
            }
            if (image != null) {
                cursor = toolkit.createCustomCursor(image, new Point(x, y), "");
            }
            return cursor;
        }

        public static Cursor getBusy() {
            if (m_busy == null) {
                m_busy = Cursors.setCursorFromFile("busy.gif");
            }
            return m_busy;
        }

        public static void setBusy(Cursor cursor) {
            if (cursor == null) {
                String string = InternalRealspaceResource.loadString("cursor", "Global_ArgumentNull", "ui_realspace_resources");
                throw new IllegalArgumentException(string);
            }
            m_busy = cursor;
        }

        public static Cursor getArrow() {
            if (m_arrow == null) {
                m_arrow = Cursors.setCursorFromFile("arrow.gif", 0, 0);
            }
            return m_arrow;
        }

        public static void setArrow(Cursor cursor) {
            if (cursor == null) {
                String string = InternalRealspaceResource.loadString("cursor", "Global_ArgumentNull", "ui_realspace_resources");
                throw new IllegalArgumentException(string);
            }
            m_arrow = cursor;
        }

        public static Cursor getPan() {
            if (m_pan == null) {
                m_pan = Cursors.setCursorFromFile("pan.gif");
            }
            return m_pan;
        }

        public static void setPan(Cursor cursor) {
            if (cursor == null) {
                String string = InternalRealspaceResource.loadString("cursor", "Global_ArgumentNull", "ui_realspace_resources");
                throw new IllegalArgumentException(string);
            }
            m_pan = cursor;
        }

        public static Cursor getSelect() {
            if (m_select == null) {
                m_select = Cursors.setCursorFromFile("select.gif", 1, 1);
            }
            return m_select;
        }

        public static void setSelect(Cursor cursor) {
            if (cursor == null) {
                String string = InternalRealspaceResource.loadString("cursor", "Global_ArgumentNull", "ui_realspace_resources");
                throw new IllegalArgumentException(string);
            }
            m_select = cursor;
        }

        public static Cursor getRotation() {
            if (m_Rotation == null) {
                m_Rotation = Cursors.setCursorFromFile("rotation.gif");
            }
            return m_Rotation;
        }

        public static Cursor getHSplit() {
            if (m_HSplit == null) {
                m_HSplit = Cursors.setCursorFromFile("HSplit.gif");
            }
            return m_HSplit;
        }

        public static Cursor getVSplit() {
            if (m_VSplit == null) {
                m_VSplit = Cursors.setCursorFromFile("VSplit.gif");
            }
            return m_VSplit;
        }

        public static Cursor getHand() {
            if (m_Hand == null) {
                m_Hand = Cursors.setCursorFromFile("Hand.gif");
            }
            return m_Hand;
        }

        public static void setRotation(Cursor cursor) {
            if (cursor == null) {
                String string = InternalRealspaceResource.loadString("cursor", "Global_ArgumentNull", "ui_realspace_resources");
                throw new IllegalArgumentException(string);
            }
            m_Rotation = cursor;
        }

        public static Cursor getMove() {
            if (m_Move == null) {
                m_Move = Cursors.setCursorFromFile("move.gif");
            }
            return m_Move;
        }

        public static void setMove(Cursor cursor) {
            if (cursor == null) {
                String string = InternalRealspaceResource.loadString("cursor", "Global_ArgumentNull", "ui_realspace_resources");
                throw new IllegalArgumentException(string);
            }
            m_Move = cursor;
        }

        public static Cursor getNorthSouth() {
            if (m_NorthSouth == null) {
                m_NorthSouth = Cursors.setCursorFromFile("northSouth.gif");
            }
            return m_NorthSouth;
        }

        public static void setNorthSouth(Cursor cursor) {
            if (cursor == null) {
                String string = InternalRealspaceResource.loadString("cursor", "Global_ArgumentNull", "ui_realspace_resources");
                throw new IllegalArgumentException(string);
            }
            m_NorthSouth = cursor;
        }

        public static Cursor getWestEast() {
            if (m_WestEast == null) {
                m_WestEast = Cursors.setCursorFromFile("westEast.gif");
            }
            return m_WestEast;
        }

        public static void setWestEast(Cursor cursor) {
            if (cursor == null) {
                String string = InternalRealspaceResource.loadString("cursor", "Global_ArgumentNull", "ui_realspace_resources");
                throw new IllegalArgumentException(string);
            }
            m_WestEast = cursor;
        }

        public static Cursor getNortheastSouthwest() {
            if (m_NortheastSouthwest == null) {
                m_NortheastSouthwest = Cursors.setCursorFromFile("northeastSouthwest.gif");
            }
            return m_NortheastSouthwest;
        }

        public static void setNortheastSouthwest(Cursor cursor) {
            if (cursor == null) {
                String string = InternalRealspaceResource.loadString("cursor", "Global_ArgumentNull", "ui_realspace_resources");
                throw new IllegalArgumentException(string);
            }
            m_NortheastSouthwest = cursor;
        }

        public static Cursor getHold() {
            if (m_Hold == null) {
                m_Hold = Cursors.setCursorFromFile("pan2.gif");
            }
            return m_Hold;
        }

        public static void setHold(Cursor cursor) {
            if (cursor == null) {
                String string = InternalRealspaceResource.loadString("cursor", "Global_ArgumentNull", "ui_realspace_resources");
                throw new IllegalArgumentException(string);
            }
            m_Hold = cursor;
        }

        public static Cursor getNorthwestSoutheast() {
            if (m_NorthwestSoutheast == null) {
                m_NorthwestSoutheast = Cursors.setCursorFromFile("northwestSoutheast.gif");
            }
            return m_NorthwestSoutheast;
        }

        public static void setNorthwestSoutheast(Cursor cursor) {
            if (cursor == null) {
                String string = InternalRealspaceResource.loadString("cursor", "Global_ArgumentNull", "ui_realspace_resources");
                throw new IllegalArgumentException(string);
            }
            m_NorthwestSoutheast = cursor;
        }

        public static Cursor getMeasureArea() {
            if (m_MeasureArea == null) {
                m_MeasureArea = Cursors.setCursorFromFile("measureArea.gif");
            }
            return m_MeasureArea;
        }

        public static void setMeasureArea(Cursor cursor) {
            if (cursor == null) {
                String string = InternalRealspaceResource.loadString("cursor", "Global_ArgumentNull", "ui_realspace_resources");
                throw new IllegalArgumentException(string);
            }
            m_MeasureArea = cursor;
        }

        public static Cursor getMeasureDistance() {
            if (m_MeasureDistance == null) {
                m_MeasureDistance = Cursors.setCursorFromFile("measureDistance.gif");
            }
            return m_MeasureDistance;
        }

        public static void setMeasureDistance(Cursor cursor) {
            if (cursor == null) {
                String string = InternalRealspaceResource.loadString("cursor", "Global_ArgumentNull", "ui_realspace_resources");
                throw new IllegalArgumentException(string);
            }
            m_MeasureDistance = cursor;
        }

        public static Cursor getIntervisibility() {
            if (m_Intervisibility == null) {
                m_Intervisibility = Cursors.setCursorFromFile("intervisibility.gif");
            }
            return m_Intervisibility;
        }

        public static void setIntervisibility(Cursor cursor) {
            if (cursor == null) {
                String string = InternalRealspaceResource.loadString("cursor", "Global_ArgumentNull", "ui_realspace_resources");
                throw new IllegalArgumentException(string);
            }
            m_Intervisibility = cursor;
        }

        public static Cursor getViewSheds() {
            if (m_ViewSheds == null) {
                m_ViewSheds = Cursors.setCursorFromFile("viewSheds.gif");
            }
            return m_ViewSheds;
        }

        public static void setViewSheds(Cursor cursor) {
            if (cursor == null) {
                String string = InternalRealspaceResource.loadString("cursor", "Global_ArgumentNull", "ui_realspace_resources");
                throw new IllegalArgumentException(string);
            }
            m_ViewSheds = cursor;
        }

        public static Cursor getMeasureAltitude() {
            if (m_MeasureAltitude == null) {
                m_MeasureAltitude = Cursors.setCursorFromFile("measureAltitude.gif");
            }
            return m_MeasureAltitude;
        }

        public static void setMeasureAltitude(Cursor cursor) {
            if (cursor == null) {
                String string = InternalRealspaceResource.loadString("cursor", "Global_ArgumentNull", "ui_realspace_resources");
                throw new IllegalArgumentException(string);
            }
            m_MeasureAltitude = cursor;
        }
    }
}

