/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.realspace;

import com.supermap.realspace.InternalHandle;
import com.supermap.realspace.InternalResource;
import com.supermap.realspace.RotationItem;
import com.supermap.realspace.RouteStopNative;

public class RotationItems
extends InternalHandle {
    static double RTOD = 57.29577951308232;
    static double DTOR = Math.PI / 180;

    protected RotationItems(long routeStopHandle) {
        this.setHandle(routeStopHandle);
    }

    public int getCount() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getCount()", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        return RouteStopNative.jni_GetRotationCount(this.getHandle());
    }

    public void add(RotationItem rotationItem) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("add(RotationItem rotationItem)", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        RouteStopNative.jni_AddRotationItem(this.getHandle(), rotationItem.getHeading() * DTOR, rotationItem.getAltitude(), rotationItem.getTilt() * DTOR, rotationItem.isClockWise());
    }

    public void remove(int index) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("remove(int index)", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        RouteStopNative.jni_RemoveRotationItem(this.getHandle(), index);
    }

    public void clear() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("clear()", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        RouteStopNative.jni_ClearRotationItems(this.getHandle());
    }

    public RotationItem get(int index) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("get(int index)", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        double[] dArray = new double[4];
        RouteStopNative.jni_GetRotationItem(this.getHandle(), index, dArray);
        RotationItem rotationItem = new RotationItem(dArray[0] * RTOD, dArray[1], dArray[2] * RTOD, false);
        if (dArray[3] >= 1.0) {
            rotationItem.setClockWise(true);
        }
        return rotationItem;
    }

    public void set(int index, RotationItem item) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("set(int index, RotationItem item)", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        RouteStopNative.jni_SetRotationItem(this.getHandle(), index, item.getHeading() * DTOR, item.getAltitude(), item.getTilt() * DTOR, item.isClockWise());
    }

    protected void clearHandle() {
        this.setHandle(0L);
    }
}

