/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.realspace;

import com.supermap.realspace.InternalHandle;
import com.supermap.realspace.InternalResource;
import com.supermap.realspace.Layer3D;
import com.supermap.realspace.Layer3DAddedEvent;
import com.supermap.realspace.Layer3DGroupNative;
import com.supermap.realspace.Layer3DRemovedEvent;
import com.supermap.realspace.Layer3DType;
import com.supermap.realspace.Layer3Ds;
import java.util.ArrayList;

public class Layer3DGroup
extends Layer3D {
    ArrayList<Layer3D> m_listLayer3D;

    Layer3DGroup(long handle, Layer3Ds layer3Ds) {
        super(handle, layer3Ds);
        this.m_listLayer3D = new ArrayList();
        this.m_listLayer3D.clear();
        if (handle == 0L || layer3Ds == null) {
            return;
        }
        if (handle != 0L) {
            int n = Layer3DGroupNative.jni_GetCount(handle);
            for (int i = 0; i < n; ++i) {
                long l = Layer3DGroupNative.jni_GetLayer(handle, i);
                if (l == 0L) continue;
                Layer3D layer3D = Layer3D.createInstance(l, layer3Ds, layer3Ds.getScene().getWorkspace());
                layer3D.setParentGroup(this);
                this.m_listLayer3D.add(layer3D);
            }
        }
    }

    public Layer3DGroup(String groupName) {
        super(groupName);
        long l = Layer3DGroupNative.jni_New(groupName);
        this.setHandle(l);
        this.m_listLayer3D = new ArrayList();
    }

    @Override
    protected void clearHandle() {
        super.clearHandle();
        this.setHandle(0L);
        if (this.m_listLayer3D != null && this.m_listLayer3D.size() > 0) {
            for (Layer3D layer3D : this.m_listLayer3D) {
                layer3D.clearHandle();
            }
            this.m_listLayer3D.clear();
        }
    }

    protected boolean moveout(Layer3D layer, boolean deleteLayer) {
        int n = this.m_listLayer3D.indexOf((Object)layer);
        if (n < 0) {
            return false;
        }
        String string = layer.getName();
        boolean bl = false;
        bl = deleteLayer ? Layer3DGroupNative.jni_Delete(this.getHandle(), InternalHandle.getHandle(layer)) : Layer3DGroupNative.jni_Remove(this.getHandle(), InternalHandle.getHandle(layer));
        if (bl) {
            if (deleteLayer) {
                layer.clearHandle();
            }
            this.m_listLayer3D.remove((Object)layer);
            layer.setParentGroup(null);
            boolean bl2 = layer instanceof Layer3DGroup;
            if (this.m_layer3Ds != null) {
                Layer3DRemovedEvent layer3DRemovedEvent = new Layer3DRemovedEvent((Object)this, layer, string, n, this, bl2);
                this.m_layer3Ds.fireLayer3DRemoved(layer3DRemovedEvent);
            }
        }
        return bl;
    }

    protected void moveBackToParent(int indexOfGroup, int indexOfParent) {
        Layer3D layer3D = this.m_listLayer3D.get(indexOfGroup);
        this.moveout(layer3D, false);
        if (this.getParentGroup() != null) {
            this.getParentGroup().insert(indexOfParent, layer3D);
        } else if (this.getLayer3Ds() != null) {
            this.getLayer3Ds().moveBackLayerFromGroup(indexOfParent, layer3D);
        }
    }

    protected ArrayList<Layer3D> getInnerDataLayer(Layer3D layer) {
        if (layer == null) {
            String string = InternalResource.loadString("layer", "Global_ArgumentNull", "realspace_resources");
            throw new IllegalStateException(string);
        }
        ArrayList<Layer3D> arrayList = new ArrayList<Layer3D>();
        if (layer.getType() == Layer3DType.GROUP3D) {
            Layer3DGroup layer3DGroup = (Layer3DGroup)layer;
            for (int i = 0; i < layer3DGroup.getCount(); ++i) {
                arrayList.addAll(this.getInnerDataLayer(layer3DGroup.get(i)));
            }
        } else {
            arrayList.add(layer);
        }
        return arrayList;
    }

    public int getCount() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("Layer3DGroup", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        return Layer3DGroupNative.jni_GetCount(this.getHandle());
    }

    public Layer3D get(int index) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("Layer3DGroup", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        if (index < 0 || index > this.m_listLayer3D.size() - 1) {
            return null;
        }
        return this.m_listLayer3D.get(index);
    }

    public void add(Layer3D layer) {
        this.insert(-1, layer);
    }

    public void insert(int index, Layer3D layer) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("Layer3DGroup", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        if (layer == null) {
            String string = InternalResource.loadString("Layer3D", "Global_ArgumentNull", "realspace_resources");
            throw new IllegalStateException(string);
        }
        long l = InternalHandle.getHandle(layer);
        if (l == 0L) {
            String string = InternalResource.loadString("Layer3D", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        if (layer.getParentGroup() != null) {
            Layer3DGroup layer3DGroup = layer.getParentGroup();
            layer3DGroup.moveout(layer, false);
        } else if (layer.getLayer3Ds() != null) {
            layer.getLayer3Ds().removeLayerForMove(layer);
        }
        if (index < 0 || index >= this.getCount()) {
            Layer3DGroupNative.jni_Add(this.getHandle(), l);
            this.m_listLayer3D.add(layer);
        } else {
            Layer3DGroupNative.jni_Insert(this.getHandle(), index, l);
            this.m_listLayer3D.add(index, layer);
        }
        if (layer.m_layer3Ds == null) {
            layer.setLayers(this.m_layer3Ds);
        }
        boolean bl = layer instanceof Layer3DGroup;
        layer.setParentGroup(this);
        if (this.m_layer3Ds != null) {
            Layer3DAddedEvent layer3DAddedEvent = new Layer3DAddedEvent((Object)this, layer, index, this, bl);
            this.m_layer3Ds.fireLayer3DAdded(layer3DAddedEvent);
        }
    }

    public boolean remove(Layer3D layer) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("Layer3DGroup", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        if (layer == null) {
            String string = InternalResource.loadString("Layer3D", "Global_ArgumentNull", "realspace_resources");
            throw new IllegalStateException(string);
        }
        long l = InternalHandle.getHandle(layer);
        if (l == 0L) {
            String string = InternalResource.loadString("Layer3D", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        return this.moveout(layer, true);
    }

    public boolean remove(int index) {
        if (index < 0 || index >= this.m_listLayer3D.size()) {
            String string = InternalResource.loadString("index", "Global_InvalidConstructorArgument", "realspace_resources");
            throw new IllegalStateException(string);
        }
        Layer3D layer3D = this.m_listLayer3D.get(index);
        return this.remove(layer3D);
    }

    public void unGroup() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("Layer3DGroup", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        int n = -1;
        if (this.getParentGroup() != null) {
            n = this.getParentGroup().indexOf(this);
        } else if (this.getLayer3Ds() != null) {
            n = this.getLayer3Ds().indexOf(this.getName());
        }
        int n2 = this.getCount();
        if (n2 > 0) {
            for (int i = n2 - 1; i >= 0; --i) {
                this.moveBackToParent(i, n);
            }
        }
        if (this.getParentGroup() != null) {
            this.getParentGroup().remove(this);
        } else if (this.getLayer3Ds() != null) {
            this.getLayer3Ds().remove(this.getName());
        }
    }

    public int indexOf(Layer3D layer) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("Layer3DGroup", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        if (layer == null) {
            String string = InternalResource.loadString("Layer3D", "Global_ArgumentNull", "realspace_resources");
            throw new IllegalStateException(string);
        }
        long l = InternalHandle.getHandle(layer);
        if (l == 0L) {
            String string = InternalResource.loadString("Layer3D", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        return this.m_listLayer3D.indexOf((Object)layer);
    }

    public boolean contains(Layer3D layer) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("Layer3DGroup", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        if (layer == null) {
            String string = InternalResource.loadString("Layer3D", "Global_ArgumentNull", "realspace_resources");
            throw new IllegalStateException(string);
        }
        long l = InternalHandle.getHandle(layer);
        if (l == 0L) {
            String string = InternalResource.loadString("Layer3D", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        return this.m_listLayer3D.contains((Object)layer);
    }

    public String getAvailableCaption(String layerCaption) {
        if (this.isDisposed()) {
            String string = InternalResource.loadString("Layer3DGroup", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        if (layerCaption == null || layerCaption.equals("")) {
            String string = InternalResource.loadString("layerCaption", "Global_ArgumentNull", "realspace_resources");
            throw new IllegalStateException(string);
        }
        return Layer3DGroupNative.jni_FindAvailableCaption(this.getHandle(), layerCaption);
    }

    public ArrayList<Layer3D> getDataLayers() {
        ArrayList<Layer3D> arrayList = new ArrayList<Layer3D>();
        arrayList.addAll(this.getInnerDataLayer(this));
        return arrayList;
    }

    public void dispose() {
        this.clearHandle();
    }
}

