/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.realspace;

import com.supermap.data.Dataset;
import com.supermap.data.GeoBox;
import com.supermap.data.GeoRegion3D;
import com.supermap.data.Point2D;
import com.supermap.data.Point3D;
import com.supermap.data.Rectangle2D;
import com.supermap.data.Workspace;
import com.supermap.realspace.BoxClipPart;
import com.supermap.realspace.Feature3Ds;
import com.supermap.realspace.InternalEnum;
import com.supermap.realspace.InternalGeometry;
import com.supermap.realspace.InternalHandle;
import com.supermap.realspace.InternalHandleDisposable;
import com.supermap.realspace.InternalResource;
import com.supermap.realspace.InternalToolkitSpace;
import com.supermap.realspace.Layer3DAlwaysRenderChangedEvent;
import com.supermap.realspace.Layer3DCaptionChangedEvent;
import com.supermap.realspace.Layer3DDataset;
import com.supermap.realspace.Layer3DDynamicObject;
import com.supermap.realspace.Layer3DEditableChangedEvent;
import com.supermap.realspace.Layer3DGrid;
import com.supermap.realspace.Layer3DGroup;
import com.supermap.realspace.Layer3DImageFile;
import com.supermap.realspace.Layer3DKML;
import com.supermap.realspace.Layer3DMap;
import com.supermap.realspace.Layer3DModel;
import com.supermap.realspace.Layer3DNative;
import com.supermap.realspace.Layer3DOSGBFile;
import com.supermap.realspace.Layer3DOSGBGroup;
import com.supermap.realspace.Layer3DSelectableChangedEvent;
import com.supermap.realspace.Layer3DType;
import com.supermap.realspace.Layer3DVectorFile;
import com.supermap.realspace.Layer3DVisibleChangedEvent;
import com.supermap.realspace.Layer3DVolumeFile;
import com.supermap.realspace.Layer3DWMS;
import com.supermap.realspace.Layer3Ds;
import com.supermap.realspace.MapServiceType;
import com.supermap.realspace.MixColorType;
import com.supermap.realspace.Selection3D;
import com.supermap.realspace.ShadowType;
import java.awt.Color;
import java.util.ArrayList;

public class Layer3D
extends InternalHandle {
    protected Layer3Ds m_layer3Ds;
    private Feature3Ds m_feature3Ds;
    private Selection3D m_selection3D;
    private Layer3DGroup m_parentGroup;
    private String m_caption;
    private boolean m_isAlwaysRender;
    private boolean m_isEditable;
    private boolean m_isVisible;
    private boolean m_isSelectable;

    Layer3D(long handle, Layer3Ds layer3Ds) {
        this.setHandle(handle);
        this.m_layer3Ds = layer3Ds;
        this.m_isSelectable = Layer3DNative.jni_GetSelectable(this.getHandle());
        this.m_isVisible = Layer3DNative.jni_GetVisible(this.getHandle());
        this.m_isEditable = Layer3DNative.jni_GetEditable(this.getHandle());
        this.m_isAlwaysRender = Layer3DNative.jni_GetAlwaysRender(this.getHandle());
    }

    Layer3D(String strName) {
        this.setHandle(0L);
        this.m_layer3Ds = null;
        this.m_feature3Ds = null;
        this.m_selection3D = null;
        this.m_parentGroup = null;
    }

    protected void setLayers(Layer3Ds value) {
        this.m_layer3Ds = value;
    }

    public String getName() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getName()", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        return Layer3DNative.jni_GetName(this.getHandle());
    }

    public String getCaption() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getCaption()", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        this.m_caption = Layer3DNative.jni_GetCaption(this.getHandle());
        return this.m_caption;
    }

    public void setCaption(String value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setCaption(value)", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        String string = this.m_caption;
        if (!value.trim().equals(this.m_caption)) {
            Layer3DNative.jni_SetCaption(this.getHandle(), value);
            this.m_caption = value;
            Layer3DCaptionChangedEvent layer3DCaptionChangedEvent = new Layer3DCaptionChangedEvent((Object)this.getLayer3Ds(), this, string, value);
            this.getLayer3Ds().fireLyer3DCaptionChanged(layer3DCaptionChangedEvent);
        }
    }

    public String getDescription() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getDescription()", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        return Layer3DNative.jni_GetDescription(this.getHandle());
    }

    public void setDescription(String value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setDescription(value)", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        Layer3DNative.jni_SetDescription(this.getHandle(), value);
    }

    public Layer3DType getType() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getType()", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        int n = Layer3DNative.jni_GetType(this.getHandle());
        return (Layer3DType)InternalEnum.parse(Layer3DType.class, (int)n);
    }

    public Feature3Ds getFeatures() {
        long l;
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getFeatures()", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        int n = Layer3DNative.jni_GetType(this.getHandle());
        if (n == 2 && this.m_feature3Ds == null && (l = Layer3DNative.jni_GetFeatures(this.getHandle())) != 0L) {
            this.m_feature3Ds = new Feature3Ds(l, null);
        }
        return this.m_feature3Ds;
    }

    public boolean isSelectable() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("isSelectable()", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        this.m_isSelectable = Layer3DNative.jni_GetSelectable(this.getHandle());
        return this.m_isSelectable;
    }

    public void setSelectable(boolean value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setSelectable(boolean value)", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        if (value != this.m_isSelectable) {
            Layer3DNative.jni_SetSelectable(this.getHandle(), value);
            this.m_isSelectable = value;
            Layer3DSelectableChangedEvent layer3DSelectableChangedEvent = new Layer3DSelectableChangedEvent((Object)this.getLayer3Ds(), this, value);
            this.getLayer3Ds().fireLyer3DSelectableChanged(layer3DSelectableChangedEvent);
        }
    }

    public boolean isEditable() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("IsEditable()", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        this.m_isEditable = Layer3DNative.jni_GetEditable(this.getHandle());
        return this.m_isEditable;
    }

    public void setEditable(boolean value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setEditable(boolean value)", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        if (value != this.m_isEditable) {
            Layer3DNative.jni_SetEditable(InternalHandle.getHandle(this.m_layer3Ds), this.getHandle(), value);
            this.m_isEditable = value;
            Layer3DEditableChangedEvent layer3DEditableChangedEvent = new Layer3DEditableChangedEvent((Object)this.getLayer3Ds(), this, value);
            this.getLayer3Ds().fireLyer3DEditableChanged(layer3DEditableChangedEvent);
        }
    }

    public boolean isVisible() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("isVisible()", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        this.m_isVisible = Layer3DNative.jni_GetVisible(this.getHandle());
        return this.m_isVisible;
    }

    @Deprecated
    public void setAlwaysRender(boolean value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setAlwaysRender(boolean value)", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        if (value != this.m_isAlwaysRender) {
            Layer3DNative.jni_SetAlwaysRender(this.getHandle(), value);
            this.m_isAlwaysRender = value;
            Layer3DAlwaysRenderChangedEvent layer3DAlwaysRenderChangedEvent = new Layer3DAlwaysRenderChangedEvent((Object)this.getLayer3Ds(), this, value);
            this.getLayer3Ds().fireLayer3DAlwaysRenderChanged(layer3DAlwaysRenderChangedEvent);
        }
    }

    public boolean isSketchMode() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getSketchMode()", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        return Layer3DNative.jni_GetSketchMode(this.getHandle());
    }

    @Deprecated
    public void setSkecthMode(boolean value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setSkecthMode()", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        Layer3DNative.jni_SetSketchMode(this.getHandle(), value);
    }

    public void setSketchMode(boolean value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setSkecthMode()", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        Layer3DNative.jni_SetSketchMode(this.getHandle(), value);
    }

    @Deprecated
    public boolean isAlwaysRender() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("isAlwaysRender()", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        this.m_isAlwaysRender = Layer3DNative.jni_GetAlwaysRender(this.getHandle());
        return this.m_isAlwaysRender;
    }

    public void setVisible(boolean value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setVisible(boolean value)", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        if (value != this.m_isVisible) {
            Layer3DNative.jni_SetVisible(this.getHandle(), value);
            this.m_isVisible = value;
            Layer3DVisibleChangedEvent layer3DVisibleChangedEvent = new Layer3DVisibleChangedEvent((Object)this.getLayer3Ds(), this, value);
            this.getLayer3Ds().fireLyer3DVisibleChanged(layer3DVisibleChangedEvent);
        }
    }

    public int getFilterPixelSize() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("isVectorFiltrate()", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        return Layer3DNative.jni_GetFilterPixelSize(this.getHandle());
    }

    public void setFilterPixelSize(int value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setVectorFiltrate(boolean value)", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        Layer3DNative.jni_SetFilterPixelSize(this.getHandle(), value);
    }

    @Deprecated
    public void setChangedToLayerStyle(boolean value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setChangedToLayerStyle(boolean value)", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        boolean bl = !value;
        Layer3DNative.jni_SetUseGeoStyle(this.getHandle(), bl);
    }

    @Deprecated
    public boolean isChangedToLayerStyle() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("isChangedToLayerStyle()", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        return !Layer3DNative.jni_GetUseGeoStyle(this.getHandle());
    }

    public boolean isDisposed() {
        boolean bl = false;
        if (this.getHandle() == 0L) {
            bl = true;
        }
        return bl;
    }

    public Selection3D getSelection() {
        long l;
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getSelection()", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_selection3D == null && (l = Layer3DNative.jni_GetSelection(this.getHandle())) != 0L) {
            this.m_selection3D = new Selection3D(l, this, this.m_layer3Ds);
        }
        return this.m_selection3D;
    }

    public void setSelection(Selection3D selection3d) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setSelection(Selection3D selection3d)", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        if (((Object)((Object)this.getSelection())).equals((Object)selection3d)) {
            return;
        }
        if (selection3d == null) {
            String string = InternalResource.loadString("selection3d", "Global_ArgumentNull", "realspace_resources");
            throw new IllegalArgumentException(string);
        }
        long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)selection3d);
        if (l == 0L) {
            String string = InternalResource.loadString("selection3d", "Global_InvalidConstructorArgument", "realspace_resources");
            throw new IllegalArgumentException(string);
        }
        Layer3DNative.jni_SetSelection(this.getHandle(), l);
        InternalHandleDisposable.makeSureNativeObjectLive((Object)((Object)selection3d));
    }

    @Deprecated
    public double getVisibleDistance() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getVisibleDistance()", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        return Layer3DNative.jni_GetVisibleDistance(this.getHandle());
    }

    @Deprecated
    public void setVisibleDistance(double value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setVisibleDistance(double value)", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        Layer3DNative.jni_SetVisibleDistance(this.getHandle(), value);
    }

    public double getMaxVisibleAltitude() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getMaxVisibleAltitude()", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        return Layer3DNative.jni_GetMaxVisibleAltitude(this.getHandle());
    }

    public void setMaxVisibleAltitude(double value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setMaxVisibleAltitude(double value)", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        if (value < 0.0) {
            String string = InternalResource.loadString("value", "DistanceShouldMoreThanZERO", "realspace_resources");
            throw new IllegalStateException(string);
        }
        Layer3DNative.jni_SetMaxVisibleAltitude(this.getHandle(), value);
    }

    public double getMinVisibleAltitude() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getMinVisibleAltitude()", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        return Layer3DNative.jni_GetMinVisibleAltitude(this.getHandle());
    }

    public void setMinVisibleAltitude(double value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setMinVisibleAltitude(double value)", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        if (value < 0.0) {
            String string = InternalResource.loadString("value", "DistanceShouldMoreThanZERO", "realspace_resources");
            throw new IllegalStateException(string);
        }
        Layer3DNative.jni_SetMinVisibleAltitude(this.getHandle(), value);
    }

    public double getMaxObjectVisibleDistance() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getMaxObjectVisibleDistance()", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        return Layer3DNative.jni_GetMaxObjectVisibleDistance(this.getHandle());
    }

    public void setMaxObjectVisibleDistance(double value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setMaxObjectVisibleDistance(double value)", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        if (value < 0.0) {
            String string = InternalResource.loadString("value", "DistanceShouldMoreThanZERO", "realspace_resources");
            throw new IllegalStateException(string);
        }
        Layer3DNative.jni_SetMaxObjectVisibleDistance(this.getHandle(), value);
    }

    public double getMinObjectVisibleDistance() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getMinObjectVisibleDisatance()", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        return Layer3DNative.jni_GetMinObjectVisibleDistance(this.getHandle());
    }

    public void setMinObjectVisibleDistance(double value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setMinObjectVisibleDisatance(double value)", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        if (value < 0.0) {
            String string = InternalResource.loadString("value", "DistanceShouldMoreThanZERO", "realspace_resources");
            throw new IllegalStateException(string);
        }
        Layer3DNative.jni_SetMinObjectVisibleDistance(this.getHandle(), value);
    }

    public Rectangle2D getBounds() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getBounds()", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        double[] dArray = new double[4];
        Layer3DNative.jni_GetBounds(this.getHandle(), dArray);
        Rectangle2D rectangle2D = new Rectangle2D(dArray[0], dArray[3], dArray[2], dArray[1]);
        return rectangle2D;
    }

    public void updateData() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("updateData()", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        Layer3DNative.jni_UpdateData(this.getHandle(), InternalHandle.getHandle(this.m_layer3Ds));
    }

    public String getDataName() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getDataName()", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        return Layer3DNative.jni_GetDataName(this.getHandle());
    }

    public String getPassword() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getDataName()", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        return Layer3DNative.jni_GetPassword(this.getHandle());
    }

    protected void setName(String layerName) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setName(String layerName)", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        Layer3DNative.jni_SetName(this.getHandle(), layerName);
    }

    protected static Layer3D createInstance(long handle, Layer3Ds layer3Ds, Layer3DType layer3DType) {
        Layer3D layer3D = null;
        if (layer3DType.equals((Object)Layer3DType.IMAGEFILE) || layer3DType.equals((Object)Layer3DType.WMTS)) {
            layer3D = new Layer3DImageFile(handle, layer3Ds);
        } else if (layer3DType.equals((Object)Layer3DType.KML)) {
            layer3D = new Layer3DKML(handle, layer3Ds);
        } else if (layer3DType.equals((Object)Layer3DType.GRID)) {
            layer3D = new Layer3DGrid(handle, layer3Ds);
        } else if (layer3DType.equals((Object)Layer3DType.MODEL)) {
            layer3D = new Layer3DModel(handle, layer3Ds);
        } else if (layer3DType.equals((Object)Layer3DType.MAP)) {
            layer3D = new Layer3DMap(handle, layer3Ds);
        } else if (layer3DType.equals((Object)Layer3DType.VECTORFILE)) {
            layer3D = new Layer3DVectorFile(handle, layer3Ds);
        } else if (layer3DType.equals((Object)Layer3DType.WMS)) {
            layer3D = new Layer3DWMS(handle, layer3Ds);
        } else if (layer3DType.equals((Object)Layer3DType.OSGB)) {
            layer3D = new Layer3DOSGBFile(handle, layer3Ds);
        } else if (layer3DType.equals((Object)Layer3DType.OSGBGROUP)) {
            layer3D = new Layer3DOSGBGroup(handle, layer3Ds);
        } else if (layer3DType.equals((Object)Layer3DType.VOLUMEFILE)) {
            layer3D = new Layer3DVolumeFile(handle, layer3Ds);
        } else if (layer3DType.equals((Object)Layer3DType.GROUP3D)) {
            layer3D = new Layer3DGroup(handle, layer3Ds);
        } else if (layer3DType.equals((Object)Layer3DType.DYNAMICMODEL)) {
            layer3D = new Layer3DDynamicObject(handle, layer3Ds);
        } else {
            throw new RuntimeException("$$$\u76f8\u5173\u7c7b\u578b\u8fd8\u672a\u5b9e\u73b0");
        }
        return layer3D;
    }

    protected static Layer3D createInstance(long handle, Layer3Ds layer3Ds, Workspace workspace) {
        Layer3D layer3D = null;
        int n = Layer3DNative.jni_GetType(handle);
        Layer3DType layer3DType = (Layer3DType)InternalEnum.parse(Layer3DType.class, (int)n);
        if (layer3DType.equals((Object)Layer3DType.DATASET)) {
            long l = Layer3DNative.jni_GetDataset(handle);
            Dataset dataset = InternalToolkitSpace.toMangedDataset(workspace, l);
            layer3D = new Layer3DDataset(handle, dataset, layer3Ds);
        } else if (layer3DType.equals((Object)Layer3DType.MAP)) {
            String string = Layer3DNative.jni_GetName(handle);
            layer3D = new Layer3DMap(handle, layer3Ds);
        } else {
            layer3D = Layer3D.createInstance(handle, layer3Ds, layer3DType);
        }
        return layer3D;
    }

    protected void clearHandle() {
        if (this.m_feature3Ds != null) {
            this.m_feature3Ds.clearHandle();
            this.m_feature3Ds = null;
        }
        if (this.m_selection3D != null) {
            this.m_selection3D.clearHandle();
            this.m_selection3D = null;
        }
        this.m_layer3Ds = null;
        this.setHandle(0L);
    }

    Layer3Ds getLayer3Ds() {
        return this.m_layer3Ds;
    }

    public boolean isShadowEnable() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("isShadowEnable()", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        return Layer3DNative.jni_IsShadowEnable(this.getHandle());
    }

    public void setShadowEnable(Boolean value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setShadowEnable()", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        Layer3DNative.jni_SetShadowEnable(this.getHandle(), value);
    }

    public boolean isWebDatasource() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("isWebDatasource()", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        return Layer3DNative.jni_IsWebDatasource(this.getHandle());
    }

    public MapServiceType getMapServiceType() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getMapServiceType()", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        int n = Layer3DNative.jni_GetMapServiceType(this.getHandle());
        return (MapServiceType)InternalEnum.parse(MapServiceType.class, (int)n);
    }

    public boolean fromXML(String xml) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("fromXML()", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        return Layer3DNative.jni_StyleFromXML(this.getHandle(), xml);
    }

    public String toXML() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("toXML()", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        return Layer3DNative.jni_StyleToXML(this.getHandle());
    }

    public String getExtendXML() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getExtendXML()", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        return Layer3DNative.jni_GetExtendXML(this.getHandle());
    }

    public void setReleaseWhenInvisible(boolean isRelease) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setReleaseWhenInvisible()", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        Layer3DNative.jni_SetReleaseWhenInvisible(this.getHandle(), isRelease);
    }

    public boolean getReleaseWhenInvisible() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getExtendXML()", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        return Layer3DNative.jni_GetReleaseWhenInvisible(this.getHandle());
    }

    public void setShadowType(ShadowType type) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setShadowType()", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        if (type == null) {
            String string = InternalResource.loadString("type", "Global_ArgumentNull", "realspace_resources");
            throw new IllegalArgumentException(string);
        }
        Layer3DNative.jni_SetShadowType(this.getHandle(), InternalEnum.getUGCValue(type));
    }

    public ShadowType getShdowType() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getShdowType()", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        int n = Layer3DNative.jni_getShadowType(this.getHandle());
        return (ShadowType)InternalEnum.parseUGCValue(ShadowType.class, n);
    }

    public boolean setParentLayer(Layer3D layer) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setParentLayer()", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        long l = 0L;
        if (layer != null) {
            l = layer.getHandle();
        }
        return Layer3DNative.jni_SetParentLayer(this.getHandle(), l);
    }

    public Layer3D getParentLayer() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setParentLayer()", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        String string = Layer3DNative.jni_GetParentLayerName(this.getHandle());
        if (string.isEmpty()) {
            return null;
        }
        return this.m_layer3Ds.get(string);
    }

    public void setVisibleInViewport(short index, boolean visible) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setVisibleInViewport()", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        Layer3DNative.jni_SetVisibleInViewport(this.getHandle(), index, visible);
    }

    public boolean getVisibleInViewport(short index) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getVisibleInViewport()", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        return Layer3DNative.jni_GetVisibleInViewport(this.getHandle(), index);
    }

    public void clipByBox(GeoBox box, BoxClipPart part) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getVisibleInViewport()", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        int n = InternalEnum.getUGCValue(part);
        long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)box);
        if (l == 0L) {
            String string = InternalResource.loadString("GeoBox", "GlobalArgument_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalArgumentException(string);
        }
        GeoBox geoBox = box.clone();
        InternalHandleDisposable.setIsDisposable((com.supermap.data.InternalHandleDisposable)geoBox, false);
        long l2 = InternalHandle.getHandle((com.supermap.data.InternalHandle)geoBox);
        Layer3DNative.jni_ClipByBox(this.getHandle(), l2, n);
    }

    public void clearCustomClipPlane() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getVisibleInViewport()", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        Layer3DNative.jni_ClearCustomClipPlane(this.getHandle());
    }

    public void setCustomClipPlane(Point3D firstPoint, Point3D secondPoint, Point3D thirdPoint) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getVisibleInViewport()", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        double d = firstPoint.getX();
        double d2 = firstPoint.getY();
        double d3 = firstPoint.getZ();
        double d4 = secondPoint.getX();
        double d5 = secondPoint.getY();
        double d6 = secondPoint.getZ();
        double d7 = thirdPoint.getX();
        double d8 = thirdPoint.getY();
        double d9 = thirdPoint.getZ();
        Layer3DNative.jni_SetCustomClipPlane(this.getHandle(), d, d2, d3, d4, d5, d6, d7, d8, d9);
    }

    public void setSwipeEnable(boolean enable) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setSwipeEnabled()", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        Layer3DNative.jni_SetSwipeEnable(this.getHandle(), enable);
    }

    public boolean isSwipeEnable() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("isSwipeEnable()", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        return Layer3DNative.jni_IsSwipeEnable(this.getHandle());
    }

    public Rectangle2D getSwipeRegion() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getSwipeRegion()", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        double[] dArray = new double[4];
        Layer3DNative.jni_GetSwipeRegion(this.getHandle(), dArray);
        Rectangle2D rectangle2D = new Rectangle2D(dArray[0], dArray[1], dArray[2], dArray[3]);
        return rectangle2D;
    }

    public void setSwipeRegion(Rectangle2D rec) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setSwipeRegion()", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        Layer3DNative.jni_SetSwipeRegion(this.getHandle(), rec.getLeft(), rec.getBottom(), rec.getRight(), rec.getTop());
    }

    public void setLocalCache(boolean enable) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setLocalCache()", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        Layer3DNative.jni_SetLocalCache(this.getHandle(), enable);
    }

    public boolean hasLocalCache() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("hasLocalCache()", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        return Layer3DNative.jni_HasLocalCache(this.getHandle());
    }

    public Layer3DGroup getParentGroup() {
        return this.m_parentGroup;
    }

    public void setParentGroup(Layer3DGroup parentGroup) {
        this.m_parentGroup = parentGroup;
    }

    public boolean getSnap() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("Layer3D", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        return Layer3DNative.jni_GetSnap(this.getHandle());
    }

    public void setSnap(boolean value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("Layer3D", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        Layer3DNative.jni_SetSnap(this.getHandle(), value);
    }

    public boolean getReceiveSunLight() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("Layer3D", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        return Layer3DNative.jni_GetReceiveSunLight(this.getHandle());
    }

    public void setReceiveSunLight(boolean value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("Layer3D", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        Layer3DNative.jni_SetReceiveSunLight(this.getHandle(), value);
    }

    public double getAlphaReject() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("Layer3D", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        return Layer3DNative.jni_GetAlphaReject(this.getHandle());
    }

    public void setAlphaReject(double value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("Layer3D", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        Layer3DNative.jni_SetAlphaReject(this.getHandle(), value);
    }

    public GeoBox getClipBox() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("Layer3D", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        long l = Layer3DNative.jni_GetClipBox(this.getHandle());
        GeoBox geoBox = null;
        if (l != 0L) {
            geoBox = (GeoBox)InternalGeometry.createInstance(l);
        }
        return geoBox;
    }

    public BoxClipPart getBoxClipPart() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("Layer3D", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        int n = Layer3DNative.jni_GetBoxClipPart(this.getHandle());
        return (BoxClipPart)InternalEnum.parseUGCValue(BoxClipPart.class, n);
    }

    public GeoRegion3D getCustomClipCross() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("Layer3D", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        long l = Layer3DNative.jni_GetCustomClipCross(this.getHandle());
        GeoRegion3D geoRegion3D = null;
        if (l != 0L) {
            geoRegion3D = (GeoRegion3D)InternalGeometry.createInstance(l);
        }
        return geoRegion3D;
    }

    public void setCustomClipCross(Point3D position, Point2D dimension, double rotX, double rotY, double rotZ, double extrudeDistance) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("Layer3D", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        if (position == null) {
            String string = InternalResource.loadString("position", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        if (dimension == null) {
            String string = InternalResource.loadString("dimension", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        Layer3DNative.jni_SetCustomClipCross(this.getHandle(), position.getX(), position.getY(), position.getZ(), dimension.getX(), dimension.getY(), rotX, rotY, rotZ, extrudeDistance);
    }

    public Color getClipLineColor() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("Layer3D", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        int[] nArray = Layer3DNative.jni_GetClipLineColor(this.getHandle());
        Color color = new Color(nArray[0], nArray[1], nArray[2], nArray[3]);
        return color;
    }

    public void setClipLineColor(Color value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("Layer3D", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        Layer3DNative.jni_SetClipLineColor(this.getHandle(), value.getRed(), value.getGreen(), value.getBlue(), value.getAlpha());
    }

    public ArrayList<Point3D> getCustomClipPlane() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("Layer3D", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        double[] dArray = Layer3DNative.jni_getCustomClipPlane(this.getHandle());
        ArrayList<Point3D> arrayList = new ArrayList<Point3D>();
        arrayList.add(new Point3D(dArray[0], dArray[1], dArray[2]));
        arrayList.add(new Point3D(dArray[3], dArray[4], dArray[5]));
        arrayList.add(new Point3D(dArray[6], dArray[7], dArray[8]));
        arrayList.add(new Point3D(dArray[9], dArray[10], dArray[11]));
        return arrayList;
    }

    public MixColorType getMixColorType() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("Layer3D", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        int n = Layer3DNative.jni_GetMixColorType(this.getHandle());
        return (MixColorType)InternalEnum.parseUGCValue(MixColorType.class, n);
    }

    public void setMixColorType(MixColorType value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("Layer3D", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        Layer3DNative.jni_SetMixColorType(this.getHandle(), value.value());
    }
}

