/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.realspace;

import com.supermap.realspace.FogMode;
import com.supermap.realspace.FogNative;
import com.supermap.realspace.InternalEnum;
import com.supermap.realspace.InternalHandleDisposable;
import com.supermap.realspace.InternalResource;
import java.awt.Color;

public class Fog
extends InternalHandleDisposable {
    private FogMode m_fogMode;

    public Fog() {
        long l = FogNative.jni_New();
        this.setHandle(l, true);
        this.m_fogMode = FogMode.EXP;
        this.setEnable(false);
        this.setDensity(1.0);
    }

    Fog(long handle) {
        int n = FogNative.jni_GetFogMode(handle);
        switch (n) {
            case 0: 
            case 1: {
                this.m_fogMode = FogMode.EXP;
                break;
            }
            case 2: {
                this.m_fogMode = FogMode.EXP2;
                break;
            }
            case 3: {
                this.m_fogMode = FogMode.LINEAR;
            }
        }
        this.setHandle(handle, false);
    }

    public FogMode getFogMode() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getFogMode()", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        return this.m_fogMode;
    }

    public void setFogMode(FogMode value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setFogMode(value)", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        if (value == null) {
            String string = InternalResource.loadString("value", "Global_ArgumentNull", "realspace_resources");
            throw new IllegalArgumentException(string);
        }
        this.m_fogMode = value;
        int n = InternalEnum.getUGCValue(value);
        FogNative.jni_SetFogMode(this.getHandle(), n);
    }

    public Color getColor() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getColor()", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        Color color = new Color(FogNative.jni_GetColor(this.getHandle()), true);
        return color;
    }

    public void setColor(Color value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setColor(Color value)", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        FogNative.jni_SetColor(this.getHandle(), value.getRGB());
    }

    public double getDensity() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getDensity()", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        return FogNative.jni_GetDensity(this.getHandle());
    }

    public void setDensity(double value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setDensity(double value)", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        if (value < 0.0) {
            value = 0.0;
        }
        if (value > 1.0) {
            value = 1.0;
        }
        FogNative.jni_SetDensity(this.getHandle(), value);
    }

    public double getStartDistance() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getStartDistance()", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        return FogNative.jni_GetStartDistance(this.getHandle());
    }

    public void setStartDistance(double value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setStartDistance(double value)", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        if (value < 0.0) {
            value = 0.0;
        }
        if (value > 1.0) {
            value = 1.0;
        }
        FogNative.jni_SetStartDistance(this.getHandle(), value);
    }

    public double getEndDistance() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getEndDistance()", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        return FogNative.jni_GetEndDistance(this.getHandle());
    }

    public void setEndDistance(double value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setEndDistance(double value)", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        if (value < 0.0) {
            value = 0.0;
        }
        if (value > 1.0) {
            value = 1.0;
        }
        FogNative.jni_SetEndDistance(this.getHandle(), value);
    }

    public boolean isEnable() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("isEnable()", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        return FogNative.jni_GetIsEnable(this.getHandle());
    }

    public void setEnable(boolean value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setEnable(boolean value)", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        int n = InternalEnum.getUGCValue(this.m_fogMode);
        FogNative.jni_SetIsEnable(this.getHandle(), n, value);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("{Color=");
        Color color = this.getColor();
        String string = color.getClass().getName() + "[r=" + color.getRed() + ",g=" + color.getGreen() + ",b=" + color.getBlue() + ",a=" + color.getAlpha() + "]";
        stringBuffer.append(string);
        stringBuffer.append(",Density=");
        stringBuffer.append(this.getDensity());
        stringBuffer.append(",EndDistance=");
        stringBuffer.append(this.getEndDistance());
        stringBuffer.append(",IsEnabled=");
        stringBuffer.append(this.isEnable());
        stringBuffer.append(",Mode=");
        stringBuffer.append((Object)this.getFogMode());
        stringBuffer.append(",StartDistance=");
        stringBuffer.append(this.getStartDistance());
        stringBuffer.append("}");
        return stringBuffer.toString();
    }

    public void dispose() {
        if (!this.getIsDisposable()) {
            String string = InternalResource.loadString("dispose()", "Handle_UndisposableObject", "realspace_resources");
            throw new UnsupportedOperationException(string);
        }
        if (this.getHandle() != 0L) {
            FogNative.jni_Delete(this.getHandle());
            this.clearHandle();
        }
    }

    static final Fog createInstance(long handle) {
        return new Fog(handle);
    }

    protected void clearHandle() {
        this.setHandle(0L);
    }
}

