#!/usr/bin/env python3
# @generated AUTOGENERATED file. Do not Change!

from dataclasses import dataclass, field as _field
from ...config import custom_scalars, datetime
from gql_client.runtime.variables import encode_variables
from gql import gql, Client
from gql.transport.exceptions import TransportQueryError
from functools import partial
from numbers import Number
from typing import Any, AsyncGenerator, Dict, List, Generator, Optional
from time import perf_counter
from dataclasses_json import DataClassJsonMixin, config

from gql_client.runtime.enum_utils import enum_field_metadata
from ..enum.resource_type_base_type_kind import ResourceTypeBaseTypeKind
from ..enum.resource_type_class_kind import ResourceTypeClassKind

from ..input.resource_type_filter_input import ResourceTypeFilterInput
from ..input.resource_type_order import ResourceTypeOrder


# fmt: off
QUERY: List[str] = ["""
query resourceTypes(
  $after: Cursor
  $first: Int
  $before: Cursor
  $last: Int
  $orderBy: ResourceTypeOrder
  $filterBy: [ResourceTypeFilterInput!]
) {
  resourceTypes(
    after: $after
    first: $first
    before: $before
    last: $last
    orderBy: $orderBy
    filterBy: $filterBy
  ) {
    totalCount
    edges {
      node {
        id
        name
        resourceTypeBaseType
        resourceTypeClass
      }
      cursor
    }
    pageInfo{
      hasNextPage
      hasPreviousPage
      startCursor
      endCursor
    }
  }
}
"""
]


class resourceTypes:
    @dataclass(frozen=True)
    class resourceTypesData(DataClassJsonMixin):
        @dataclass(frozen=True)
        class ResourceTypeConnection(DataClassJsonMixin):
            @dataclass(frozen=True)
            class ResourceTypeEdge(DataClassJsonMixin):
                @dataclass(frozen=True)
                class ResourceType(DataClassJsonMixin):
                    id: str
                    name: str
                    resourceTypeBaseType: ResourceTypeBaseTypeKind = _field(metadata=enum_field_metadata(ResourceTypeBaseTypeKind))
                    resourceTypeClass: ResourceTypeClassKind = _field(metadata=enum_field_metadata(ResourceTypeClassKind))

                node: Optional[ResourceType]
                cursor: str

            @dataclass(frozen=True)
            class PageInfo(DataClassJsonMixin):
                hasNextPage: bool
                hasPreviousPage: bool
                startCursor: Optional[str]
                endCursor: Optional[str]

            totalCount: int
            edges: List[ResourceTypeEdge]
            pageInfo: PageInfo

        resourceTypes: ResourceTypeConnection

    # fmt: off
    @classmethod
    def execute(cls, client: Client, after: Optional[str] = None, first: Optional[int] = None, before: Optional[str] = None, last: Optional[int] = None, orderBy: Optional[ResourceTypeOrder] = None, filterBy: List[ResourceTypeFilterInput] = []) -> resourceTypesData.ResourceTypeConnection:
        variables: Dict[str, Any] = {"after": after, "first": first, "before": before, "last": last, "orderBy": orderBy, "filterBy": filterBy}
        new_variables = encode_variables(variables, custom_scalars)
        response_text = client.execute(
            gql("".join(set(QUERY))), variable_values=new_variables
        )
        res = cls.resourceTypesData.from_dict(response_text)
        return res.resourceTypes

    # fmt: off
    @classmethod
    async def execute_async(cls, client: Client, after: Optional[str] = None, first: Optional[int] = None, before: Optional[str] = None, last: Optional[int] = None, orderBy: Optional[ResourceTypeOrder] = None, filterBy: List[ResourceTypeFilterInput] = []) -> resourceTypesData.ResourceTypeConnection:
        variables: Dict[str, Any] = {"after": after, "first": first, "before": before, "last": last, "orderBy": orderBy, "filterBy": filterBy}
        new_variables = encode_variables(variables, custom_scalars)
        response_text = await client.execute_async(
            gql("".join(set(QUERY))), variable_values=new_variables
        )
        res = cls.resourceTypesData.from_dict(response_text)
        return res.resourceTypes
