#!/usr/bin/env python3
# @generated AUTOGENERATED file. Do not Change!

from dataclasses import dataclass, field as _field
from ...config import custom_scalars, datetime
from gql_client.runtime.variables import encode_variables
from gql import gql, Client
from gql.transport.exceptions import TransportQueryError
from functools import partial
from numbers import Number
from typing import Any, AsyncGenerator, Dict, List, Generator, Optional
from time import perf_counter
from dataclasses_json import DataClassJsonMixin, config

from gql_client.runtime.enum_utils import enum_field_metadata
from ..enum.resource_relationship_multiplicity_kind import ResourceRelationshipMultiplicityKind
from ..enum.resource_relationship_type_kind import ResourceRelationshipTypeKind

from ..input.resource_type_relationship_filter_input import ResourceTypeRelationshipFilterInput
from ..input.resource_type_relationship_order import ResourceTypeRelationshipOrder


# fmt: off
QUERY: List[str] = ["""
query resourceTypeRelationships(
  $after: Cursor
  $first: Int
  $before: Cursor
  $last: Int
  $orderBy: ResourceTypeRelationshipOrder
  $filterBy: [ResourceTypeRelationshipFilterInput!]
) {
  resourceTypeRelationships(
    after: $after
    first: $first
    before: $before
    last: $last
    orderBy: $orderBy
    filterBy: $filterBy
  ) {
    totalCount
    edges {
      node {
        id
        locationType{
          id
          name
        }
        resourceRelationshipType
        resourceRelationshipMultiplicity
        resourceTypeA {
          id
          name
        }
        resourceTypeB {
          id
          name
        }
      }
      cursor
    }
    pageInfo {
      hasNextPage
      hasPreviousPage
      startCursor
      endCursor
    }
  }
}

"""
]


class resourceTypeRelationships:
    @dataclass(frozen=True)
    class resourceTypeRelationshipsData(DataClassJsonMixin):
        @dataclass(frozen=True)
        class ResourceTypeRelationshipConnection(DataClassJsonMixin):
            @dataclass(frozen=True)
            class ResourceTypeRelationshipEdge(DataClassJsonMixin):
                @dataclass(frozen=True)
                class ResourceTypeRelationship(DataClassJsonMixin):
                    @dataclass(frozen=True)
                    class LocationType(DataClassJsonMixin):
                        id: str
                        name: str

                    @dataclass(frozen=True)
                    class ResourceType(DataClassJsonMixin):
                        id: str
                        name: str

                    id: str
                    locationType: Optional[LocationType]
                    resourceRelationshipType: ResourceRelationshipTypeKind = _field(metadata=enum_field_metadata(ResourceRelationshipTypeKind))
                    resourceRelationshipMultiplicity: ResourceRelationshipMultiplicityKind = _field(metadata=enum_field_metadata(ResourceRelationshipMultiplicityKind))
                    resourceTypeA: ResourceType
                    resourceTypeB: Optional[ResourceType]

                node: Optional[ResourceTypeRelationship]
                cursor: str

            @dataclass(frozen=True)
            class PageInfo(DataClassJsonMixin):
                hasNextPage: bool
                hasPreviousPage: bool
                startCursor: Optional[str]
                endCursor: Optional[str]

            totalCount: int
            edges: List[ResourceTypeRelationshipEdge]
            pageInfo: PageInfo

        resourceTypeRelationships: ResourceTypeRelationshipConnection

    # fmt: off
    @classmethod
    def execute(cls, client: Client, after: Optional[str] = None, first: Optional[int] = None, before: Optional[str] = None, last: Optional[int] = None, orderBy: Optional[ResourceTypeRelationshipOrder] = None, filterBy: List[ResourceTypeRelationshipFilterInput] = []) -> resourceTypeRelationshipsData.ResourceTypeRelationshipConnection:
        variables: Dict[str, Any] = {"after": after, "first": first, "before": before, "last": last, "orderBy": orderBy, "filterBy": filterBy}
        new_variables = encode_variables(variables, custom_scalars)
        response_text = client.execute(
            gql("".join(set(QUERY))), variable_values=new_variables
        )
        res = cls.resourceTypeRelationshipsData.from_dict(response_text)
        return res.resourceTypeRelationships

    # fmt: off
    @classmethod
    async def execute_async(cls, client: Client, after: Optional[str] = None, first: Optional[int] = None, before: Optional[str] = None, last: Optional[int] = None, orderBy: Optional[ResourceTypeRelationshipOrder] = None, filterBy: List[ResourceTypeRelationshipFilterInput] = []) -> resourceTypeRelationshipsData.ResourceTypeRelationshipConnection:
        variables: Dict[str, Any] = {"after": after, "first": first, "before": before, "last": last, "orderBy": orderBy, "filterBy": filterBy}
        new_variables = encode_variables(variables, custom_scalars)
        response_text = await client.execute_async(
            gql("".join(set(QUERY))), variable_values=new_variables
        )
        res = cls.resourceTypeRelationshipsData.from_dict(response_text)
        return res.resourceTypeRelationships
