#!/usr/bin/env python3
# @generated AUTOGENERATED file. Do not Change!

from dataclasses import dataclass, field as _field
from ...config import custom_scalars, datetime
from gql_client.runtime.variables import encode_variables
from gql import gql, Client
from gql.transport.exceptions import TransportQueryError
from functools import partial
from numbers import Number
from typing import Any, AsyncGenerator, Dict, List, Generator, Optional
from time import perf_counter
from dataclasses_json import DataClassJsonMixin, config

from gql_client.runtime.enum_utils import enum_field_metadata
from ..enum.property_kind import PropertyKind

from ..input.resource_specification_filter_input import ResourceSpecificationFilterInput
from ..input.resource_specification_order import ResourceSpecificationOrder


# fmt: off
QUERY: List[str] = ["""
query resourceSpecifications(
  $after: Cursor
  $first: Int
  $before: Cursor
  $last: Int
  $orderBy: ResourceSpecificationOrder
  $filterBy: [ResourceSpecificationFilterInput!]
) {
  resourceSpecifications(
    after: $after
    first: $first
    before: $before
    last: $last
    orderBy: $orderBy
    filterBy: $filterBy
  ) {
    totalCount
    edges {
      node {
        id
        name
        resourceType{
          id
          name
        }
        propertyTypes{
          name
          index
          type
          externalId
          nodeType
          category
          rawValue
          stringValue
          stringValue
          intValue
          booleanValue
          floatValue
          latitudeValue
          longitudeValue
          rangeFromValue
          rangeToValue
          isEditable
          isInstanceProperty
          isMandatory
          isDeleted
          isListable
    }
      }
      cursor
    }
    pageInfo{
      hasNextPage
      hasPreviousPage
      startCursor
      endCursor
    }
  }
}
"""
]


class resourceSpecifications:
    @dataclass(frozen=True)
    class resourceSpecificationsData(DataClassJsonMixin):
        @dataclass(frozen=True)
        class ResourceSpecificationConnection(DataClassJsonMixin):
            @dataclass(frozen=True)
            class ResourceSpecificationEdge(DataClassJsonMixin):
                @dataclass(frozen=True)
                class ResourceSpecification(DataClassJsonMixin):
                    @dataclass(frozen=True)
                    class ResourceType(DataClassJsonMixin):
                        id: str
                        name: str

                    @dataclass(frozen=True)
                    class PropertyType(DataClassJsonMixin):
                        name: str
                        index: Optional[int]
                        type: PropertyKind = _field(metadata=enum_field_metadata(PropertyKind))
                        externalId: Optional[str]
                        nodeType: Optional[str]
                        category: Optional[str]
                        rawValue: Optional[str]
                        stringValue: Optional[str]
                        stringValue: Optional[str]
                        intValue: Optional[int]
                        booleanValue: Optional[bool]
                        floatValue: Optional[Number]
                        latitudeValue: Optional[Number]
                        longitudeValue: Optional[Number]
                        rangeFromValue: Optional[Number]
                        rangeToValue: Optional[Number]
                        isEditable: Optional[bool]
                        isInstanceProperty: Optional[bool]
                        isMandatory: Optional[bool]
                        isDeleted: Optional[bool]
                        isListable: Optional[bool]

                    id: str
                    name: str
                    resourceType: Optional[ResourceType]
                    propertyTypes: List[PropertyType]

                node: Optional[ResourceSpecification]
                cursor: str

            @dataclass(frozen=True)
            class PageInfo(DataClassJsonMixin):
                hasNextPage: bool
                hasPreviousPage: bool
                startCursor: Optional[str]
                endCursor: Optional[str]

            totalCount: int
            edges: List[ResourceSpecificationEdge]
            pageInfo: PageInfo

        resourceSpecifications: ResourceSpecificationConnection

    # fmt: off
    @classmethod
    def execute(cls, client: Client, after: Optional[str] = None, first: Optional[int] = None, before: Optional[str] = None, last: Optional[int] = None, orderBy: Optional[ResourceSpecificationOrder] = None, filterBy: List[ResourceSpecificationFilterInput] = []) -> resourceSpecificationsData.ResourceSpecificationConnection:
        variables: Dict[str, Any] = {"after": after, "first": first, "before": before, "last": last, "orderBy": orderBy, "filterBy": filterBy}
        new_variables = encode_variables(variables, custom_scalars)
        response_text = client.execute(
            gql("".join(set(QUERY))), variable_values=new_variables
        )
        res = cls.resourceSpecificationsData.from_dict(response_text)
        return res.resourceSpecifications

    # fmt: off
    @classmethod
    async def execute_async(cls, client: Client, after: Optional[str] = None, first: Optional[int] = None, before: Optional[str] = None, last: Optional[int] = None, orderBy: Optional[ResourceSpecificationOrder] = None, filterBy: List[ResourceSpecificationFilterInput] = []) -> resourceSpecificationsData.ResourceSpecificationConnection:
        variables: Dict[str, Any] = {"after": after, "first": first, "before": before, "last": last, "orderBy": orderBy, "filterBy": filterBy}
        new_variables = encode_variables(variables, custom_scalars)
        response_text = await client.execute_async(
            gql("".join(set(QUERY))), variable_values=new_variables
        )
        res = cls.resourceSpecificationsData.from_dict(response_text)
        return res.resourceSpecifications
