#!/usr/bin/env python3
# @generated AUTOGENERATED file. Do not Change!

from dataclasses import dataclass, field as _field
from ...config import custom_scalars, datetime
from gql_client.runtime.variables import encode_variables
from gql import gql, Client
from gql.transport.exceptions import TransportQueryError
from functools import partial
from numbers import Number
from typing import Any, AsyncGenerator, Dict, List, Generator, Optional
from time import perf_counter
from dataclasses_json import DataClassJsonMixin, config

from ..input.resource_specification_relationship_filter_input import ResourceSpecificationRelationshipFilterInput
from ..input.resource_specification_relationship_order import ResourceSpecificationRelationshipOrder


# fmt: off
QUERY: List[str] = ["""
query resourceSpecificationRelationships(
  $after: Cursor
  $first: Int
  $before: Cursor
  $last: Int
  $orderBy: ResourceSpecificationRelationshipOrder
  $filterBy: [ResourceSpecificationRelationshipFilterInput!]
) {
  resourceSpecificationRelationships(
    after: $after
    first: $first
    before: $before
    last: $last
    orderBy: $orderBy
    filterBy: $filterBy
  ) {
    totalCount
    edges {
      node {
        id
        name
        resourceSpecification{
          id
          name
        }
      }
      cursor
    }
    pageInfo {
      hasNextPage
      hasPreviousPage
      startCursor
      endCursor
    }
  }
}
"""
]


class resourceSpecificationRelationships:
    @dataclass(frozen=True)
    class resourceSpecificationRelationshipsData(DataClassJsonMixin):
        @dataclass(frozen=True)
        class ResourceSpecificationRelationshipConnection(DataClassJsonMixin):
            @dataclass(frozen=True)
            class ResourceSpecificationRelationshipEdge(DataClassJsonMixin):
                @dataclass(frozen=True)
                class ResourceSpecificationRelationship(DataClassJsonMixin):
                    @dataclass(frozen=True)
                    class ResourceSpecification(DataClassJsonMixin):
                        id: str
                        name: str

                    id: str
                    name: str
                    resourceSpecification: ResourceSpecification

                node: Optional[ResourceSpecificationRelationship]
                cursor: str

            @dataclass(frozen=True)
            class PageInfo(DataClassJsonMixin):
                hasNextPage: bool
                hasPreviousPage: bool
                startCursor: Optional[str]
                endCursor: Optional[str]

            totalCount: int
            edges: List[ResourceSpecificationRelationshipEdge]
            pageInfo: PageInfo

        resourceSpecificationRelationships: ResourceSpecificationRelationshipConnection

    # fmt: off
    @classmethod
    def execute(cls, client: Client, after: Optional[str] = None, first: Optional[int] = None, before: Optional[str] = None, last: Optional[int] = None, orderBy: Optional[ResourceSpecificationRelationshipOrder] = None, filterBy: List[ResourceSpecificationRelationshipFilterInput] = []) -> resourceSpecificationRelationshipsData.ResourceSpecificationRelationshipConnection:
        variables: Dict[str, Any] = {"after": after, "first": first, "before": before, "last": last, "orderBy": orderBy, "filterBy": filterBy}
        new_variables = encode_variables(variables, custom_scalars)
        response_text = client.execute(
            gql("".join(set(QUERY))), variable_values=new_variables
        )
        res = cls.resourceSpecificationRelationshipsData.from_dict(response_text)
        return res.resourceSpecificationRelationships

    # fmt: off
    @classmethod
    async def execute_async(cls, client: Client, after: Optional[str] = None, first: Optional[int] = None, before: Optional[str] = None, last: Optional[int] = None, orderBy: Optional[ResourceSpecificationRelationshipOrder] = None, filterBy: List[ResourceSpecificationRelationshipFilterInput] = []) -> resourceSpecificationRelationshipsData.ResourceSpecificationRelationshipConnection:
        variables: Dict[str, Any] = {"after": after, "first": first, "before": before, "last": last, "orderBy": orderBy, "filterBy": filterBy}
        new_variables = encode_variables(variables, custom_scalars)
        response_text = await client.execute_async(
            gql("".join(set(QUERY))), variable_values=new_variables
        )
        res = cls.resourceSpecificationRelationshipsData.from_dict(response_text)
        return res.resourceSpecificationRelationships
