#!/usr/bin/env python3
# @generated AUTOGENERATED file. Do not Change!

from dataclasses import dataclass, field as _field
from ...config import custom_scalars, datetime
from gql_client.runtime.variables import encode_variables
from gql import gql, Client
from gql.transport.exceptions import TransportQueryError
from functools import partial
from numbers import Number
from typing import Any, AsyncGenerator, Dict, List, Generator, Optional
from time import perf_counter
from dataclasses_json import DataClassJsonMixin, config

from ..fragment.property_type import PropertyTypeFragment, QUERY as PropertyTypeFragmentQuery

from ..input.edit_resource_specification_input import EditResourceSpecificationInput


# fmt: off
QUERY: List[str] = PropertyTypeFragmentQuery + ["""
mutation editResourceSpecification($input: EditResourceSpecificationInput!) {
  editResourceSpecification(input: $input) {
    id
    name
    propertyTypes {
      ...PropertyTypeFragment
    }
  }
}
"""
]


class editResourceSpecification:
    @dataclass(frozen=True)
    class editResourceSpecificationData(DataClassJsonMixin):
        @dataclass(frozen=True)
        class ResourceSpecification(DataClassJsonMixin):
            @dataclass(frozen=True)
            class PropertyType(PropertyTypeFragment):
                pass

            id: str
            name: str
            propertyTypes: List[PropertyType]

        editResourceSpecification: ResourceSpecification

    # fmt: off
    @classmethod
    def execute(cls, client: Client, input: EditResourceSpecificationInput) -> editResourceSpecificationData.ResourceSpecification:
        variables: Dict[str, Any] = {"input": input}
        new_variables = encode_variables(variables, custom_scalars)
        response_text = client.execute(
            gql("".join(set(QUERY))), variable_values=new_variables
        )
        res = cls.editResourceSpecificationData.from_dict(response_text)
        return res.editResourceSpecification

    # fmt: off
    @classmethod
    async def execute_async(cls, client: Client, input: EditResourceSpecificationInput) -> editResourceSpecificationData.ResourceSpecification:
        variables: Dict[str, Any] = {"input": input}
        new_variables = encode_variables(variables, custom_scalars)
        response_text = await client.execute_async(
            gql("".join(set(QUERY))), variable_values=new_variables
        )
        res = cls.editResourceSpecificationData.from_dict(response_text)
        return res.editResourceSpecification
