#!/usr/bin/env python3
# @generated AUTOGENERATED file. Do not Change!

from dataclasses import dataclass, field as _field
from ...config import custom_scalars, datetime
from gql_client.runtime.variables import encode_variables
from gql import gql, Client
from gql.transport.exceptions import TransportQueryError
from functools import partial
from numbers import Number
from typing import Any, AsyncGenerator, Dict, List, Generator, Optional
from time import perf_counter
from dataclasses_json import DataClassJsonMixin, config

from gql_client.runtime.enum_utils import enum_field_metadata
from ..enum.resource_type_base_type_kind import ResourceTypeBaseTypeKind
from ..enum.resource_type_class_kind import ResourceTypeClassKind

from ..input.add_resource_type_input import AddResourceTypeInput


# fmt: off
QUERY: List[str] = ["""
mutation addResourceType($input: AddResourceTypeInput!) {
  addResourceType(input: $input) {
    id
    name
    resourceTypeClass
    resourceTypeBaseType
  }
}

"""
]


class addResourceType:
    @dataclass(frozen=True)
    class addResourceTypeData(DataClassJsonMixin):
        @dataclass(frozen=True)
        class ResourceType(DataClassJsonMixin):
            id: str
            name: str
            resourceTypeClass: ResourceTypeClassKind = _field(metadata=enum_field_metadata(ResourceTypeClassKind))
            resourceTypeBaseType: ResourceTypeBaseTypeKind = _field(metadata=enum_field_metadata(ResourceTypeBaseTypeKind))

        addResourceType: ResourceType

    # fmt: off
    @classmethod
    def execute(cls, client: Client, input: AddResourceTypeInput) -> addResourceTypeData.ResourceType:
        variables: Dict[str, Any] = {"input": input}
        new_variables = encode_variables(variables, custom_scalars)
        response_text = client.execute(
            gql("".join(set(QUERY))), variable_values=new_variables
        )
        res = cls.addResourceTypeData.from_dict(response_text)
        return res.addResourceType

    # fmt: off
    @classmethod
    async def execute_async(cls, client: Client, input: AddResourceTypeInput) -> addResourceTypeData.ResourceType:
        variables: Dict[str, Any] = {"input": input}
        new_variables = encode_variables(variables, custom_scalars)
        response_text = await client.execute_async(
            gql("".join(set(QUERY))), variable_values=new_variables
        )
        res = cls.addResourceTypeData.from_dict(response_text)
        return res.addResourceType
