#!/usr/bin/env python3
# @generated AUTOGENERATED file. Do not Change!

from dataclasses import dataclass, field as _field
from ...config import custom_scalars, datetime
from gql_client.runtime.variables import encode_variables
from gql import gql, Client
from gql.transport.exceptions import TransportQueryError
from functools import partial
from numbers import Number
from typing import Any, AsyncGenerator, Dict, List, Generator, Optional
from time import perf_counter
from dataclasses_json import DataClassJsonMixin, config

from ..fragment.property_type import PropertyTypeFragment, QUERY as PropertyTypeFragmentQuery

from ..input.add_resource_specification_input import AddResourceSpecificationInput


# fmt: off
QUERY: List[str] = PropertyTypeFragmentQuery + ["""
mutation addResourceSpecification($input: AddResourceSpecificationInput!) {
  addResourceSpecification(input: $input) {
    id
    name
    resourceType{
      id
      name
    }
    propertyTypes {
      ...PropertyTypeFragment
    }

  }
}
"""
]


class addResourceSpecification:
    @dataclass(frozen=True)
    class addResourceSpecificationData(DataClassJsonMixin):
        @dataclass(frozen=True)
        class ResourceSpecification(DataClassJsonMixin):
            @dataclass(frozen=True)
            class ResourceType(DataClassJsonMixin):
                id: str
                name: str

            @dataclass(frozen=True)
            class PropertyType(PropertyTypeFragment):
                pass

            id: str
            name: str
            resourceType: Optional[ResourceType]
            propertyTypes: List[PropertyType]

        addResourceSpecification: ResourceSpecification

    # fmt: off
    @classmethod
    def execute(cls, client: Client, input: AddResourceSpecificationInput) -> addResourceSpecificationData.ResourceSpecification:
        variables: Dict[str, Any] = {"input": input}
        new_variables = encode_variables(variables, custom_scalars)
        response_text = client.execute(
            gql("".join(set(QUERY))), variable_values=new_variables
        )
        res = cls.addResourceSpecificationData.from_dict(response_text)
        return res.addResourceSpecification

    # fmt: off
    @classmethod
    async def execute_async(cls, client: Client, input: AddResourceSpecificationInput) -> addResourceSpecificationData.ResourceSpecification:
        variables: Dict[str, Any] = {"input": input}
        new_variables = encode_variables(variables, custom_scalars)
        response_text = await client.execute_async(
            gql("".join(set(QUERY))), variable_values=new_variables
        )
        res = cls.addResourceSpecificationData.from_dict(response_text)
        return res.addResourceSpecification
